# ./play.it strategy games collection

The codebase is maintained at [https://git.dotslashplay.it/games-strategy/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-strategy/]: https://git.dotslashplay.it/games-strategy/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only strategy games. These games rely on long-term planning. They often include military troops management, but can be more peaceful with a focus on resource gathering and logistics. Both turn-based and real-time games are included.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for this ./play.it collection, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-strategy play.it-strategy.git
cd play.it-strategy.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-strategy
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- Abandon Ship
- Afterlife
- Age of Wonders series:
    - Age of Wonders
    - Age of Wonders: Planetfall
- AI War 2
- Airline Tycoon Deluxe
- Anno series:
    - Anno 1503
    - Anno 1404
- Anomaly series:
    - Anomaly: Warzone Earth
    - Anomaly 2
    - Anomaly Defenders
- Aquamarine
- As Far As The Eye
- Ash of Gods
- Aven Colony
- Banished
- Battle Worlds: Kronos
- Battlefleet Gothic: Armada
- Bear and Breakfast
- Beholder series:
    - Beholder
    - Beholder 2
- Book of Hours
- Braveland series:
    - Braveland
    - Braveland Wizard
    - Braveland Pirate
- Breach & Clear series:
    - Breach & Clear
    - Breach & Clear: Deadline
- Caravan
- Cat Cafe Manager
- Chaos Reborn
- Charterstone
- Chroma Squad
- Civilization 4
- Coffee Noir - Business Detective Game
- Commandos 3: Destination Berlin
- Cultist Simulator
- Darwinia
- Dawnmaker
- Defender's Quest
- Democratic Socialism Simulator
- Door Kickers
- Dorfromantik
- Dungeons 2
- Empire Earth
- Endless Space
- Endzone: A World Apart
- Etherlords
- Europa Universalis 2
- Everything is Garbage
- Factory Town
- Fallout Tactics
- Fantasy General
- Farabel
- Fear Equation
- Fox & Flock
- Gangsters: Organized Crime
- GemCraft - Frostborn Wrath
- Giants: Citizen Kabuto
- Glittermitten Grove
- Gnomoria
- Godhood
- Graveyard Keeper
- GreedCorp
- Habitat
- Halcyon 6
- Hard West
- Helium Rain
- Help Will Come Tomorrow
- Heroes of Might and Magic series:
    - Heroes of Might and Magic
    - Heroes of Might and Magic 2
    - Heroes of Might and Magic 3
    - Heroes Chronicles
    - Heroes of Might and Magic 4, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
    - Heroes of Might and Magic 5, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
- Hive Time
- Homeseek
- Impossible Creatures
- Infinium Strike
- Inkulinati
- Into the Breach
- Invisible Inc.
- Iratus: Lord of the Dead
- Iris and the Giant
- Iron Harvest
- Ironclad Tactics
- Islanders
- Ixion
- Jars
- Kapital: Sparks of Revolution
- King's Bounty: The Legend
- Kingdom: New Lands
- Legend of Keepers
- Loria
- Marble Age
- Master of Magic
- Master of Orion 2
- Mesmer
- Möbius Front '83
- Multiwinia
- Nebuchadnezzar
- Niche - a genetics survival game
- No Pineapple Left Behind
- Nomads of Driftland
- Nowhere Prophet
- Old World
- Perimeter
- Political Animals
- Populous series:
    - Populous: Promised Lands
    - Populous 2
    - Populous: The Beginning
- Potion Craft: Alchemy Simulator
- Prison Architect
- Prophour23
- Ravenous Devils
- Reassembly
- Rimworld
- Robin Hood: The Legend of Sherwood
- Rymdkapsel
- Satellite Reign
- Sigma Theory
- Skyshine's Bedlam
- Slime Rancher
- Slipways
- Solar Flux
- Songs of Silence
- Space Pirates and Zombies
- Space Run
- Spacecom
- Spellforce
- Spore
- Star Vikings
- Star Wolves 3: Civil War
- Star-Twine
- Stardew Valley
- Sudden Strike 4
- Surviving Mars
- Symmetry
- Terra Nil
- The Fertile Crescent
- The Guild series:
    - The Guild 2
    - The Guild 2 Renaissance
- The Hive
- The Settlers series:
    - The Settlers 2, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
    - The Settlers 3
- The Westport Independent
- Thea 2: The Shattering
- Theme Hospital
- This War of Mine
- Tooth and Tail
- Total Annihilation: Kingdoms
- Triple Triad Gold
- Tzar: The Burden of the Crown
- Valhalla Hills
- Warcraft series:
    - Warcraft: Orcs & Humans
    - Warcraft 2, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
    - Warcraft 3, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
- Warhammer 40,000: Mechanicus
- We. The Revolution
- Windward
- Wingspan
- Worms series:
    - Worms United
    - Worms 2, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
    - Worms Armageddon, supported in another collection: [https://git.vv221.fr/play.it/games-vv221/about/]
- X-Morph: Defense
- Xenonauts

[https://git.vv221.fr/play.it/games-vv221/about/]: https://git.vv221.fr/play.it/games-vv221/about/

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.
