(in-package "M6")
(include-book "../M6/m6-type-value")
(include-book "../M6/m6-thread")
(acl2::set-verify-guards-eagerness 0)
(include-book "../M6-DJVM-shared/jvm-frame-manipulation-primitives")


;; (defun topStack (s)
;;   (top (operand-stack (current-frame s))))


;; (defun secondStack (s)
;;   (topStack (popStack s)))

(defun thirdStack (s)
  (topStack (popStack (popStack s))))


(defun fourthStack (s)
  (topStack (popStack (popStack (popStack s)))))


(defun fifthStack (s)
  (topStack (popStack (popStack (popStack (popStack s))))))


(defun popStackN (n s)
  (if (zp n)
      s
    (popStackN (- n 1) (popStack s))))


(defun pushLong (v s)
  (pushStack v (pushStack 'topx s)))

;; push 'topx then push v. :Thu Jan 15 21:17:00 2004
;; OK. 
;;
;; reverse the order of Long representation Thu Jan 15 21:23:47 2004
;;;
;;; does it comply with the current BCV representation?? No. Mon Jan 31
;;; 15:40:14 2005. 
;;; 
;;; BCV representation is fixed by StackMap generated by static checker.
;;; Mon Jan 31 15:42:27 2005

;; Decision, shall we just fix how the mapping from djvm-state to sig-state?
;; Yes. Let me do that. Mon Jan 31 15:43:05 2005
;;;
;; Fixed already in Dec. 2004. Mon Jan 31 15:44:56 2005
;;

(defun popLong (s)
  (popStack (popStack s)))

(defun topLong  (s)    
  (topStack s))


;-- primitives for executing the method.

;; FRAME operation

;; We will rely on guard verification! 


;; (defun pushFrame0 (new-frame s)
;;   (let* ((curthread-id     (current-thread s))
;;          (old-thread-table (thread-table s))
;;          (old-thread (thread-by-id curthread-id old-thread-table))
;;          (old-call-stack (thread-call-stack old-thread))
;;          (new-call-stack (push new-frame old-call-stack))
;;          (new-pc         0) ;; set new pc
;;          (new-thread    (thread-set-call-stack new-call-stack old-thread))
;;          (new-thread-table (replace-thread-table-entry old-thread 
;;                                                        new-thread 
;;                                                        old-thread-table)))
;;     (state-set-pc new-pc (state-set-thread-table new-thread-table s))))


;; (defun pushFrame (method-ptr initial-locals s)
;;  (let* ((new-operand-stack (make-init-operand-stack))
;;         (return-pc    (pc s))
;;         (new-frame    (make-frame return-pc new-operand-stack initial-locals
;;                                   method-ptr -1)))
;;    (pushFrame0 new-frame s)))





;; (defun popFrame (s)
;;  (let* ((curthread-id  (current-thread s))
;;         (old-thread-table (thread-table s))
;;         (old-thread     (thread-by-id curthread-id old-thread-table))
;;         (old-call-stack (thread-call-stack old-thread))
;;         (new-pc         (return-pc (top old-call-stack)))
;;         (new-call-stack (pop old-call-stack))
;;         (new-thread     (thread-set-call-stack new-call-stack old-thread))
;;         (new-thread-table (replace-thread-table-entry old-thread 
;;                                                       new-thread 
;;                                                       old-thread-table)))
;;    (state-set-pc new-pc (state-set-thread-table new-thread-table s))))

;; do nothing if invoked on illegal input. maybe I should add some
;; output to indicate guard violation.

(defun build-initial-local1 (rev-arg-types operand-stack)
  (if (endp rev-arg-types)
      nil
    (if (equal (type-size (car rev-arg-types)) 2)
        (cons 'topx (cons (top (pop operand-stack))  
           ;; assuming in locals, a Long value is stored in the first slot.
                         (build-initial-local1 (cdr rev-arg-types) (pop (pop
                                                                         operand-stack)))))
      (cons (top operand-stack) (build-initial-local1 (cdr rev-arg-types) (pop operand-stack))))))
      

(defun fill-top (n)
  (if (zp n) nil
    (cons 'topx (fill-top (- n 1)))))

(defun size-of-param (arg-types)
  (if (endp arg-types)
      0
    (if (equal (type-size (car arg-types)) 2)
        (+ 2 (size-of-param (cdr arg-types)))
      (+ 1 (size-of-param (cdr arg-types))))))
  

(defun build-initial-local (arg-types operand-stack length)
  (let* ((reversed-params (build-initial-local1 (reverse arg-types)
                                                operand-stack))
         (reversed-locals (app (fill-top (- length (len reversed-params)))
                               reversed-params)))
    (reverse reversed-locals)))

; need to fix this!! Mon Oct 25 16:30:21 2004
; We need all slot being preallocated!!



; primitives for how to get a method-ptr to store in the call frame
(defun method-rep-to-method-ptr (method-rep)
  (make-method-ptr (method-classname method-rep)
                   (method-methodname method-rep)
                   (method-args       method-rep)
                   (method-returntype method-rep)))



(defun pushFrameWithPop (obj-ref method-rep s)
  (let* ((args       (method-args method-rep))
         (method-ptr (method-rep-to-method-ptr method-rep))
         (locals     (build-initial-local (method-args method-rep)
                                          (operand-stack (current-frame s))
                                          (method-maxlocals method-rep)))
         (accessflags (method-accessflags method-rep)))
    (if (mem '*static* accessflags) ;; no this pointer
        (pushFrame method-ptr locals 
                   (popStackN (size-of-param args) s))
      (pushFrame method-ptr (cons obj-ref locals) (popStackN (+ (size-of-param
                                                                 args) 1) s)))))


;--- 








