import enum

# https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-fscc/4718fc40-e539-4014-8e33-b675af74e3e1
class FileInfoClass(enum.Enum):
	NONE = 0
	FileAccessInformation = 8 #Query
	FileAlignmentInformation = 17 #Query
	FileAllInformation = 18 #Query
	FileAllocationInformation = 19 #Set
	FileAlternateNameInformation = 21 #Query
	FileAttributeTagInformation = 35 #Query
	FileBasicInformation =4 #Query, Set
	FileBothDirectoryInformation = 3 #Query
	FileCompressionInformation = 28 #Query
	FileDirectoryInformation = 1 #Query
	FileDispositionInformation = 13 # Set
	FileEaInformation = 7 #Query
	FileEndOfFileInformation = 20 #Set
	FileFullDirectoryInformation = 2#Query
	FileFullEaInformation = 15 #Query, Set
	FileHardLinkInformation = 46 #LOCAL
	FileIdBothDirectoryInformation = 37 #Query
	FileIdFullDirectoryInformation = 38 #Query
	FileIdGlobalTxDirectoryInformation = 50 #LOCAL
	FileInternalInformation = 6 #Query
	FileLinkInformation = 11 #Set
	FileMailslotQueryInformation = 26 #LOCAL
	FileMailslotSetInformation = 27 #LOCAL
	FileModeInformation = 16 #Query, Set<78>
	FileMoveClusterInformation = 31 #<79>
	FileNameInformation = 9 #LOCAL
	FileNamesInformation = 12 #Query
	FileNetworkOpenInformation = 34 #Query
	FileNormalizedNameInformation = 48 #Query<80>
	FileObjectIdInformation = 29 #LOCAL
	FilePipeInformation = 23 #Query, Set
	FilePipeLocalInformation = 24 #Query
	FilePipeRemoteInformation = 25 #Query
	FilePositionInformation = 14 #Query, Set
	FileQuotaInformation = 32 #Query, Set<81>
	FileRenameInformation = 10 #Set
	FileReparsePointInformation = 33 #LOCAL
	FileSfioReserveInformation = 44 #LOCAL 
	FileSfioVolumeInformation = 45 #<82>
	FileShortNameInformation = 40 #Set
	FileStandardInformation = 5#Query
	FileStandardLinkInformation = 54 #LOCAL
	FileStreamInformation = 22 #Query
	FileTrackingInformation = 36 #LOCAL
	FileValidDataLengthInformation = 39 #Set