/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.bridges.Transliteration;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class BasicStrings
implements Loadable,
Predicate {
    static /* synthetic */ Class class$sleep$engine$types$DoubleValue;

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        hashtable.put("&left", new func_left());
        hashtable.put("&right", new func_right());
        hashtable.put("&charAt", new func_charAt());
        hashtable.put("&byteAt", hashtable.get("&charAt"));
        hashtable.put("&uc", new func_uc());
        hashtable.put("&lc", new func_lc());
        func_substr func_substr2 = new func_substr();
        hashtable.put("&substr", func_substr2);
        hashtable.put("&mid", func_substr2);
        hashtable.put("&indexOf", new func_indexOf());
        hashtable.put("&lindexOf", hashtable.get("&indexOf"));
        hashtable.put("&strlen", new func_strlen());
        hashtable.put("&strrep", new func_strrep());
        hashtable.put("&replaceAt", new func_replaceAt());
        hashtable.put("&tr", new func_tr());
        hashtable.put("&asc", new func_asc());
        hashtable.put("&chr", new func_chr());
        hashtable.put("&sort", new func_sort());
        func_sorters func_sorters2 = new func_sorters();
        hashtable.put("&sorta", func_sorters2);
        hashtable.put("&sortn", func_sorters2);
        hashtable.put("&sortd", func_sorters2);
        hashtable.put("eq", this);
        hashtable.put("ne", this);
        hashtable.put("lt", this);
        hashtable.put("gt", this);
        hashtable.put("-isletter", this);
        hashtable.put("-isnumber", this);
        hashtable.put("-isupper", this);
        hashtable.put("-islower", this);
        hashtable.put("isin", this);
        hashtable.put("iswm", new pred_iswm());
        hashtable.put(".", new oper_concat());
        hashtable.put("x", new oper_multiply());
        hashtable.put("cmp", new oper_compare());
        hashtable.put("<=>", new oper_spaceship());
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (stack.size() == 1) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (string.equals("-isupper")) {
                return string2.toUpperCase().equals(string2);
            }
            if (string.equals("-islower")) {
                return string2.toLowerCase().equals(string2);
            }
            if (string.equals("-isletter")) {
                if (string2.length() <= 0) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    if (Character.isLetter(string2.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            if (string.equals("-isnumber")) {
                if (string2.length() <= 0) {
                    return false;
                }
                if (string2.indexOf(46) > -1 && string2.indexOf(46) != string2.lastIndexOf(46)) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    if (Character.isDigit(string2.charAt(i)) || string2.charAt(i) == '.' && i + 1 < string2.length()) continue;
                    return false;
                }
                return true;
            }
        } else {
            String string3 = BridgeUtilities.getString(stack, "");
            String string4 = BridgeUtilities.getString(stack, "");
            if (string.equals("eq")) {
                return string4.equals(string3);
            }
            if (string.equals("ne")) {
                return !string4.equals(string3);
            }
            if (string.equals("isin")) {
                return string3.indexOf(string4) > -1;
            }
            if (string.equals("gt")) {
                return string4.compareTo(string3) > 0;
            }
            if (string.equals("lt")) {
                return string4.compareTo(string3) < 0;
            }
        }
        return false;
    }

    private static final String substring(String string, String string2, int n, int n2) {
        int n3 = string2.length();
        int n4 = BridgeUtilities.normalize(n, n3);
        int n5 = n2 < 0 ? n2 + n3 : n2;
        int n6 = n5 = n5 <= n3 ? n5 : n3;
        if (n4 == n5) {
            return "";
        }
        if (n4 > n5) {
            throw new IllegalArgumentException(string + ": illegal substring('" + string2 + "', " + n + " -> " + n4 + ", " + n2 + " -> " + n5 + ") indices");
        }
        return string2.substring(n4, n5);
    }

    private static final char charAt(String string, int n) {
        return string.charAt(BridgeUtilities.normalize(n, string.length()));
    }

    static {
        ParserConfig.addKeyword("x");
        ParserConfig.addKeyword("eq");
        ParserConfig.addKeyword("ne");
        ParserConfig.addKeyword("lt");
        ParserConfig.addKeyword("gt");
        ParserConfig.addKeyword("isin");
        ParserConfig.addKeyword("iswm");
        ParserConfig.addKeyword("cmp");
    }

    private static class oper_spaceship
    implements Operator {
        private oper_spaceship() {
        }

        public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
            ScalarType scalarType = BridgeUtilities.getScalar(stack).getActualValue();
            ScalarType scalarType2 = BridgeUtilities.getScalar(stack).getActualValue();
            if (scalarType.getType() == (class$sleep$engine$types$DoubleValue == null ? (class$sleep$engine$types$DoubleValue = BasicStrings.class$("sleep.engine.types.DoubleValue")) : class$sleep$engine$types$DoubleValue) || scalarType2.getType() == (class$sleep$engine$types$DoubleValue == null ? (class$sleep$engine$types$DoubleValue = BasicStrings.class$("sleep.engine.types.DoubleValue")) : class$sleep$engine$types$DoubleValue)) {
                if (scalarType.doubleValue() > scalarType2.doubleValue()) {
                    return SleepUtils.getScalar(1);
                }
                if (scalarType.doubleValue() < scalarType2.doubleValue()) {
                    return SleepUtils.getScalar(-1);
                }
            } else {
                if (scalarType.longValue() > scalarType2.longValue()) {
                    return SleepUtils.getScalar(1);
                }
                if (scalarType.longValue() < scalarType2.longValue()) {
                    return SleepUtils.getScalar(-1);
                }
            }
            return SleepUtils.getScalar(0);
        }
    }

    private static class oper_compare
    implements Operator {
        private oper_compare() {
        }

        public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = (Scalar)stack.pop();
            Scalar scalar2 = (Scalar)stack.pop();
            return SleepUtils.getScalar(scalar.toString().compareTo(scalar2.toString()));
        }
    }

    private static class oper_multiply
    implements Operator {
        private oper_multiply() {
        }

        public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = (Scalar)stack.pop();
            Scalar scalar2 = (Scalar)stack.pop();
            String string2 = scalar.toString();
            int n = scalar2.intValue();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2);
            }
            return SleepUtils.getScalar(stringBuffer);
        }
    }

    private static class oper_concat
    implements Operator {
        private oper_concat() {
        }

        public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = (Scalar)stack.pop();
            Scalar scalar2 = (Scalar)stack.pop();
            if (string.equals(".")) {
                return SleepUtils.getScalar(scalar.toString() + scalar2.toString());
            }
            return null;
        }
    }

    private static class CompareStrings
    implements Comparator {
        private CompareStrings() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    }

    private static class CompareDoubles
    implements Comparator {
        private CompareDoubles() {
        }

        public int compare(Object object, Object object2) {
            double d;
            double d2 = ((Scalar)object).doubleValue();
            if (d2 == (d = ((Scalar)object2).doubleValue())) {
                return 0;
            }
            if (d2 < d) {
                return -1;
            }
            return 1;
        }
    }

    private static class CompareNumbers
    implements Comparator {
        private CompareNumbers() {
        }

        public int compare(Object object, Object object2) {
            long l = ((Scalar)object).longValue();
            long l2 = ((Scalar)object2).longValue();
            return (int)(l - l2);
        }
    }

    private static class CompareFunction
    implements Comparator {
        protected SleepClosure func;
        protected ScriptInstance script;
        protected Stack locals;

        public CompareFunction(Function function2, ScriptInstance scriptInstance) {
            this.func = (SleepClosure)function2;
            this.script = scriptInstance;
            this.locals = new Stack();
        }

        public int compare(Object object, Object object2) {
            this.locals.push(object2);
            this.locals.push(object);
            Scalar scalar = this.func.callClosure("&sort", this.script, this.locals);
            return scalar.intValue();
        }
    }

    private static class func_sorters
    implements Function {
        private func_sorters() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ScalarArray scalarArray = BridgeUtilities.getWorkableArray(stack);
            if (string.equals("&sorta")) {
                scalarArray.sort(new CompareStrings());
            } else if (string.equals("&sortn")) {
                scalarArray.sort(new CompareNumbers());
            } else if (string.equals("&sortd")) {
                scalarArray.sort(new CompareDoubles());
            }
            return SleepUtils.getArrayScalar(scalarArray);
        }
    }

    private static class func_sort
    implements Function {
        private func_sort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() != 2) {
                throw new IllegalArgumentException("&sort requires a function to specify how to sort the data");
            }
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            ScalarArray scalarArray = BridgeUtilities.getWorkableArray(stack);
            if (sleepClosure == null) {
                return SleepUtils.getArrayScalar();
            }
            scalarArray.sort(new CompareFunction(sleepClosure, scriptInstance));
            return SleepUtils.getArrayScalar(scalarArray);
        }
    }

    private static class func_charAt
    implements Function {
        private func_charAt() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            int n = BridgeUtilities.getInt(stack);
            if (string.equals("&charAt")) {
                return SleepUtils.getScalar(BasicStrings.charAt(string2, n) + "");
            }
            return SleepUtils.getScalar(BasicStrings.charAt(string2, n));
        }
    }

    private static class func_indexOf
    implements Function {
        private func_indexOf() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n;
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            if (string.equals("&lindexOf")) {
                int n2 = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, string2.length()), string2.length());
                n = string2.lastIndexOf(string3, n2);
            } else {
                int n3 = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), string2.length());
                n = string2.indexOf(string3, n3);
            }
            if (n == -1) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(n);
        }
    }

    private static class func_substr
    implements Function {
        private func_substr() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            int n = BridgeUtilities.getInt(stack);
            int n2 = string.equals("&mid") ? BridgeUtilities.getInt(stack, string2.length() - n) + n : BridgeUtilities.getInt(stack, string2.length());
            return SleepUtils.getScalar(BasicStrings.substring(string, string2, n, n2));
        }
    }

    private static class func_replaceAt
    implements Function {
        private func_replaceAt() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            StringBuffer stringBuffer = new StringBuffer(BridgeUtilities.getString(stack, ""));
            String string2 = BridgeUtilities.getString(stack, "");
            int n = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), stringBuffer.length());
            int n2 = BridgeUtilities.getInt(stack, string2.length());
            stringBuffer.delete(n, n + n2);
            stringBuffer.insert(n, string2);
            return SleepUtils.getScalar(stringBuffer.toString());
        }
    }

    private static class func_strrep
    implements Function {
        private func_strrep() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            StringBuffer stringBuffer = new StringBuffer(BridgeUtilities.getString(stack, ""));
            while (!stack.isEmpty()) {
                String string2 = BridgeUtilities.getString(stack, "");
                String string3 = BridgeUtilities.getString(stack, "");
                if (string2.length() == 0) continue;
                int n = 0;
                int n2 = string2.length();
                int n3 = string3.length();
                while ((n = stringBuffer.indexOf(string2, n)) > -1) {
                    stringBuffer.replace(n, n + n2, string3);
                    n += string3.length();
                }
            }
            return SleepUtils.getScalar(stringBuffer.toString());
        }
    }

    private static class func_strlen
    implements Function {
        private func_strlen() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(stack.pop().toString().length());
        }
    }

    private static class func_lc
    implements Function {
        private func_lc() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(stack.pop().toString().toLowerCase());
        }
    }

    private static class func_uc
    implements Function {
        private func_uc() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(stack.pop().toString().toUpperCase());
        }
    }

    private static class func_chr
    implements Function {
        private func_chr() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar((char)BridgeUtilities.getInt(stack) + "");
        }
    }

    private static class func_asc
    implements Function {
        private func_asc() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(BridgeUtilities.getString(stack, "\u0000").charAt(0));
        }
    }

    private static class func_right
    implements Function {
        private func_right() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            int n = ((Scalar)stack.pop()).intValue();
            return SleepUtils.getScalar(BasicStrings.substring(string, string2, 0 - n, string2.length()));
        }
    }

    private static class func_tr
    implements Function {
        private func_tr() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            String string4 = BridgeUtilities.getString(stack, "");
            String string5 = BridgeUtilities.getString(stack, "");
            int n = 0;
            if (string5.indexOf(99) > -1) {
                n |= 2;
            }
            if (string5.indexOf(100) > -1) {
                n |= 1;
            }
            if (string5.indexOf(115) > -1) {
                n |= 4;
            }
            Transliteration transliteration = Transliteration.compile(string3, string4, n);
            return SleepUtils.getScalar(transliteration.translate(string2));
        }
    }

    private static class func_left
    implements Function {
        private func_left() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            int n = ((Scalar)stack.pop()).intValue();
            return SleepUtils.getScalar(BasicStrings.substring(string, string2, 0, n));
        }
    }

    private static class pred_iswm
    implements Predicate {
        private pred_iswm() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            try {
                if ((string3.length() == 0 || string2.length() == 0) && string3.length() != string2.length()) {
                    return false;
                }
                int n = 0;
                int n2 = 0;
                while (n < string3.length()) {
                    if (string3.charAt(n) == '*') {
                        int n3;
                        boolean bl;
                        boolean bl2 = bl = n + 1 < string3.length() && string3.charAt(n + 1) == '*';
                        while (string3.charAt(n) == '*') {
                            if (++n != string3.length()) continue;
                            return true;
                        }
                        for (n3 = n; n3 < string3.length() && string3.charAt(n3) != '?' && string3.charAt(n3) != '\\' && string3.charAt(n3) != '*'; ++n3) {
                        }
                        if (n3 != n) {
                            n3 = bl ? string2.lastIndexOf(string3.substring(n, n3)) : string2.indexOf(string3.substring(n, n3), n2);
                            if (n3 == -1 || n3 < n2) {
                                return false;
                            }
                            n2 = n3;
                        }
                        if (string3.charAt(n) == '?') {
                            --n;
                        }
                    } else {
                        if (n2 >= string2.length()) {
                            return false;
                        }
                        if (string3.charAt(n) == '\\' ? ++n < string3.length() && string3.charAt(n) != string2.charAt(n2) : string3.charAt(n) != '?' && string3.charAt(n) != string2.charAt(n2)) {
                            return false;
                        }
                    }
                    ++n;
                    ++n2;
                }
                return n2 == string2.length();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }
}

