/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Index
extends Step {
    String value;
    Block index;

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("[Scalar index]: " + this.value + "\n");
        if (this.index != null) {
            stringBuffer.append(this.index.toString(string + "   "));
        }
        return stringBuffer.toString();
    }

    public Index(String string, Block block) {
        this.value = string;
        this.index = block;
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        Scalar scalar = null;
        Scalar scalar2 = (Scalar)scriptEnvironment.getCurrentFrame().pop();
        if (SleepUtils.isEmptyScalar(scalar2)) {
            if (this.value.charAt(0) == '@') {
                scalar2.setValue(SleepUtils.getArrayScalar());
            } else if (this.value.charAt(0) == '%') {
                scalar2.setValue(SleepUtils.getHashScalar());
            }
        }
        this.index.evaluate(scriptEnvironment);
        Scalar scalar3 = (Scalar)scriptEnvironment.getCurrentFrame().pop();
        if (scalar2.getArray() != null) {
            int n = scalar3.getValue().intValue();
            if (n < 0) {
                int n2 = scalar2.getArray().size();
                while (n < 0) {
                    n += n2;
                }
            }
            scalar = scalar2.getArray().getAt(n);
        } else if (scalar2.getHash() != null) {
            scalar = scalar2.getHash().getAt(scalar3);
        } else if (scalar2.objectValue() != null && scalar2.objectValue() instanceof SleepClosure) {
            SleepClosure sleepClosure = (SleepClosure)scalar2.objectValue();
            if (!sleepClosure.getVariables().scalarExists(scalar3.toString())) {
                sleepClosure.getVariables().putScalar(scalar3.toString(), SleepUtils.getEmptyScalar());
            }
            scalar = sleepClosure.getVariables().getScalar(scalar3.toString());
        } else {
            scriptEnvironment.KillFrame();
            throw new IllegalArgumentException("invalid use of index operator: " + SleepUtils.describe(scalar2) + "[" + SleepUtils.describe(scalar3) + "]");
        }
        scriptEnvironment.FrameResult(scalar);
        return null;
    }
}

