/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import sleep.bridges.BasicIO;
import sleep.bridges.BasicNumbers;
import sleep.bridges.BasicStrings;
import sleep.bridges.BasicUtilities;
import sleep.bridges.DefaultEnvironment;
import sleep.bridges.DefaultVariable;
import sleep.bridges.FileSystemBridge;
import sleep.bridges.RegexBridge;
import sleep.bridges.TimeDateBridge;
import sleep.engine.Block;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Loadable;
import sleep.parser.Parser;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.taint.TaintModeGeneratedSteps;
import sleep.taint.TaintUtils;

public class ScriptLoader {
    protected static Map BLOCK_CACHE = null;
    protected LinkedList loadedScripts = new LinkedList();
    protected Map scripts = new HashMap();
    protected LinkedList bridgesg = new LinkedList();
    protected LinkedList bridgess = new LinkedList();
    protected LinkedList paths;
    protected boolean disableConversions = false;
    private static CharsetDecoder decoder = null;
    private String charset = null;

    private Block retrieveCacheEntry(String string) {
        if (BLOCK_CACHE != null && BLOCK_CACHE.containsKey(string)) {
            Object[] objectArray = (Object[])BLOCK_CACHE.get(string);
            return (Block)objectArray[0];
        }
        return null;
    }

    private static boolean isCacheHit(String string) {
        return BLOCK_CACHE != null && BLOCK_CACHE.containsKey(string);
    }

    public void touch(String string, long l) {
        Object[] objectArray;
        long l2;
        if (BLOCK_CACHE != null && BLOCK_CACHE.containsKey(string) && l > (l2 = ((Long)(objectArray = (Object[])BLOCK_CACHE.get(string))[1]).longValue())) {
            BLOCK_CACHE.remove(string);
        }
    }

    public ScriptLoader() {
        this.initDefaultBridges();
    }

    public Map setGlobalCache(boolean bl) {
        if (bl && BLOCK_CACHE == null) {
            BLOCK_CACHE = Collections.synchronizedMap(new HashMap());
        }
        if (!bl) {
            BLOCK_CACHE = null;
        }
        return BLOCK_CACHE;
    }

    protected void initDefaultBridges() {
        this.addGlobalBridge(new BasicNumbers());
        this.addGlobalBridge(new BasicStrings());
        this.addGlobalBridge(new BasicUtilities());
        this.addGlobalBridge(new BasicIO());
        this.addGlobalBridge(new FileSystemBridge());
        this.addGlobalBridge(new DefaultEnvironment());
        this.addGlobalBridge(new DefaultVariable());
        this.addGlobalBridge(new RegexBridge());
        this.addGlobalBridge(new TimeDateBridge());
    }

    public void addGlobalBridge(Loadable loadable) {
        this.bridgesg.add(loadable);
    }

    public void addSpecificBridge(Loadable loadable) {
        this.bridgess.add(loadable);
    }

    public Map getScriptsByKey() {
        return this.scripts;
    }

    public boolean isLoaded(String string) {
        return this.scripts.containsKey(string);
    }

    public ScriptEnvironment getFirstScriptEnvironment() {
        if (this.loadedScripts.size() > 0) {
            ScriptInstance scriptInstance = (ScriptInstance)this.loadedScripts.getFirst();
            return scriptInstance.getScriptEnvironment();
        }
        return null;
    }

    public LinkedList getScripts() {
        return this.loadedScripts;
    }

    protected void inProcessScript(String string, ScriptInstance scriptInstance) {
        scriptInstance.setName(string);
        Iterator iterator = this.bridgess.iterator();
        while (iterator.hasNext()) {
            ((Loadable)iterator.next()).scriptLoaded(scriptInstance);
        }
        if (scriptInstance.getScriptEnvironment().getEnvironment().get("(isloaded)") != this) {
            iterator = this.bridgesg.iterator();
            while (iterator.hasNext()) {
                ((Loadable)iterator.next()).scriptLoaded(scriptInstance);
            }
            scriptInstance.getScriptEnvironment().getEnvironment().put("(isloaded)", this);
        }
    }

    public ScriptInstance loadSerialized(File file, Hashtable hashtable) throws IOException, ClassNotFoundException {
        File file2 = new File(file.getAbsolutePath() + ".bin");
        if (file2.exists() && (!file.exists() || file.lastModified() < file2.lastModified())) {
            return this.loadSerialized(file.getName(), new FileInputStream(file2), hashtable);
        }
        ScriptInstance scriptInstance = this.loadScript(file, hashtable);
        ScriptLoader.saveSerialized(scriptInstance);
        return scriptInstance;
    }

    public ScriptInstance loadSerialized(String string, InputStream inputStream, Hashtable hashtable) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Block block = (Block)objectInputStream.readObject();
        return this.loadScript(string, block, hashtable);
    }

    public static void saveSerialized(ScriptInstance scriptInstance) throws IOException {
        ScriptLoader.saveSerialized(scriptInstance, new FileOutputStream(scriptInstance.getName() + ".bin"));
    }

    public static void saveSerialized(ScriptInstance scriptInstance, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(scriptInstance.getRunnableBlock());
    }

    public ScriptInstance loadScriptNoReference(String string, Block block, Hashtable hashtable) {
        ScriptInstance scriptInstance = new ScriptInstance(hashtable);
        scriptInstance.installBlock(block);
        this.inProcessScript(string, scriptInstance);
        return scriptInstance;
    }

    public ScriptInstance loadScript(String string, Block block, Hashtable hashtable) {
        ScriptInstance scriptInstance = this.loadScriptNoReference(string, block, hashtable);
        if (!string.equals("<interact mode>")) {
            this.loadedScripts.add(scriptInstance);
            this.scripts.put(string, scriptInstance);
        }
        return scriptInstance;
    }

    public ScriptInstance loadScript(String string, String string2, Hashtable hashtable) throws YourCodeSucksException {
        return this.loadScript(string, this.compileScript(string, string2), hashtable);
    }

    public Block compileScript(String string, InputStream inputStream) throws YourCodeSucksException, IOException {
        if (ScriptLoader.isCacheHit(string)) {
            inputStream.close();
            return this.retrieveCacheEntry(string);
        }
        StringBuffer stringBuffer = new StringBuffer(8192);
        BufferedReader bufferedReader = new BufferedReader(this.getInputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        inputStream.close();
        return this.compileScript(string, stringBuffer.toString());
    }

    public Block compileScript(File file) throws IOException, YourCodeSucksException {
        this.touch(file.getAbsolutePath(), file.lastModified());
        return this.compileScript(file.getAbsolutePath(), new FileInputStream(file));
    }

    public Block compileScript(String string) throws IOException, YourCodeSucksException {
        return this.compileScript(new File(string));
    }

    public Block compileScript(String string, String string2) throws YourCodeSucksException {
        if (ScriptLoader.isCacheHit(string)) {
            return this.retrieveCacheEntry(string);
        }
        Parser parser = new Parser(string, string2);
        if (TaintUtils.isTaintMode()) {
            parser.setCodeFactory(new TaintModeGeneratedSteps());
        }
        parser.parse();
        if (BLOCK_CACHE != null) {
            BLOCK_CACHE.put(string, new Object[]{parser.getRunnableBlock(), new Long(System.currentTimeMillis())});
        }
        return parser.getRunnableBlock();
    }

    public ScriptInstance loadScript(String string, InputStream inputStream) throws YourCodeSucksException, IOException {
        return this.loadScript(string, inputStream, null);
    }

    public ScriptInstance loadScript(String string, InputStream inputStream, Hashtable hashtable) throws YourCodeSucksException, IOException {
        return this.loadScript(string, this.compileScript(string, inputStream), hashtable);
    }

    public ScriptInstance loadScript(String string) throws IOException, YourCodeSucksException {
        return this.loadScript(new File(string), null);
    }

    public ScriptInstance loadScript(String string, Hashtable hashtable) throws IOException, YourCodeSucksException {
        return this.loadScript(new File(string), hashtable);
    }

    public ScriptInstance loadScript(File file, Hashtable hashtable) throws IOException, YourCodeSucksException {
        ScriptInstance scriptInstance = this.loadScript(file.getAbsolutePath(), new FileInputStream(file), hashtable);
        scriptInstance.associateFile(file);
        return scriptInstance;
    }

    public ScriptInstance loadScript(File file) throws IOException, YourCodeSucksException {
        return this.loadScript(file, null);
    }

    public void unloadScript(String string) {
        this.unloadScript((ScriptInstance)this.scripts.get(string));
    }

    public void unloadScript(ScriptInstance scriptInstance) {
        Loadable loadable;
        if (BLOCK_CACHE != null) {
            BLOCK_CACHE.remove(scriptInstance.getName());
        }
        this.loadedScripts.remove(scriptInstance);
        this.scripts.remove(scriptInstance.getName());
        scriptInstance.setUnloaded();
        Iterator iterator = this.bridgess.iterator();
        while (iterator.hasNext()) {
            loadable = (Loadable)iterator.next();
            loadable.scriptUnloaded(scriptInstance);
        }
        iterator = this.bridgesg.iterator();
        while (iterator.hasNext()) {
            loadable = (Loadable)iterator.next();
            loadable.scriptUnloaded(scriptInstance);
        }
    }

    public Set getScriptsToUnload(Set set) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Set set2 = this.scripts.keySet();
        linkedHashSet.addAll(set2);
        linkedHashSet.removeAll(set);
        return linkedHashSet;
    }

    public Set getScriptsToLoad(Set set) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Set set2 = this.scripts.keySet();
        linkedHashSet.addAll(set);
        linkedHashSet.removeAll(set2);
        return linkedHashSet;
    }

    public void setCharsetConversion(boolean bl) {
        this.disableConversions = !bl;
    }

    public boolean isCharsetConversions() {
        return !this.disableConversions;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    private InputStreamReader getInputStreamReader(InputStream inputStream) {
        if (this.disableConversions) {
            if (decoder == null) {
                decoder = new NoConversion();
            }
            return new InputStreamReader(inputStream, decoder);
        }
        if (this.charset != null) {
            try {
                return new InputStreamReader(inputStream, this.charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return new InputStreamReader(inputStream);
    }

    private static class NoConversion
    extends CharsetDecoder {
        public NoConversion() {
            super(null, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    int n2 = byteBuffer.get();
                    if (n2 >= 0) {
                        charBuffer.put((char)n2);
                    } else {
                        n2 = 256 + n2;
                        charBuffer.put((char)n2);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }
    }
}

