/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.engine.ProxyInterface;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.HashContainer;
import sleep.engine.types.IntValue;
import sleep.engine.types.ListContainer;
import sleep.engine.types.LongValue;
import sleep.engine.types.NullValue;
import sleep.engine.types.ObjectValue;
import sleep.engine.types.OrderedHashContainer;
import sleep.engine.types.StringValue;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.parser.Checkers;
import sleep.parser.Parser;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.MapWrapper;
import sleep.runtime.ProxyIterator;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;

public class SleepUtils {
    public static final int SLEEP_RELEASE = 20090430;
    public static final String SLEEP_VERSION = "Sleep 2.1";
    protected static ScalarType nullScalar = new NullValue();

    public static void addKeyword(String string) {
        Checkers.addKeyword(string);
    }

    public static Block ParseCode(String string) throws YourCodeSucksException {
        Parser parser = new Parser("eval", string);
        parser.parse();
        return parser.getRunnableBlock();
    }

    public static void removeScalar(Iterator iterator, Scalar scalar) {
        while (iterator.hasNext()) {
            Scalar scalar2 = (Scalar)iterator.next();
            if (!scalar.sameAs(scalar2)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scalar runCode(CallRequest callRequest, ScriptInstance scriptInstance, Stack stack) {
        ScriptEnvironment scriptEnvironment = scriptInstance.getScriptEnvironment();
        ScriptVariables scriptVariables = scriptEnvironment.getScriptVariables();
        synchronized (scriptVariables) {
            scriptEnvironment.pushSource(scriptInstance.getName());
            scriptEnvironment.CreateFrame();
            scriptEnvironment.CreateFrame(stack);
            callRequest.CallFunction();
            Scalar scalar = scriptEnvironment.getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)scriptEnvironment.getCurrentFrame().pop();
            scriptEnvironment.KillFrame();
            scriptEnvironment.popSource();
            scriptEnvironment.resetEnvironment();
            return scalar;
        }
    }

    public static Scalar runCode(Block block, ScriptEnvironment scriptEnvironment) {
        if (scriptEnvironment.getScriptVariables().getLocalVariables() == null) {
            scriptEnvironment.getScriptVariables().pushLocalLevel();
            CallRequest.InlineCallRequest inlineCallRequest = new CallRequest.InlineCallRequest(scriptEnvironment, Integer.MIN_VALUE, "eval", block);
            Scalar scalar = SleepUtils.runCode(inlineCallRequest, scriptEnvironment.getScriptInstance(), null);
            scriptEnvironment.getScriptVariables().popLocalLevel();
            return scalar;
        }
        CallRequest.InlineCallRequest inlineCallRequest = new CallRequest.InlineCallRequest(scriptEnvironment, Integer.MIN_VALUE, "eval", block);
        return SleepUtils.runCode(inlineCallRequest, scriptEnvironment.getScriptInstance(), null);
    }

    public static Scalar runCode(SleepClosure sleepClosure, String string, ScriptInstance scriptInstance, Stack stack) {
        if (scriptInstance == null) {
            scriptInstance = sleepClosure.getOwner();
        }
        CallRequest.ClosureCallRequest closureCallRequest = new CallRequest.ClosureCallRequest(scriptInstance.getScriptEnvironment(), Integer.MIN_VALUE, SleepUtils.getScalar(sleepClosure), string);
        return SleepUtils.runCode(closureCallRequest, scriptInstance, stack);
    }

    public static Scalar runCode(Function function2, String string, ScriptInstance scriptInstance, Stack stack) {
        CallRequest.FunctionCallRequest functionCallRequest = new CallRequest.FunctionCallRequest(scriptInstance.getScriptEnvironment(), Integer.MIN_VALUE, string, function2);
        return SleepUtils.runCode(functionCallRequest, scriptInstance, stack);
    }

    public static Scalar runCode(ScriptInstance scriptInstance, Block block, HashMap hashMap) {
        CallRequest.InlineCallRequest inlineCallRequest = new CallRequest.InlineCallRequest(scriptInstance.getScriptEnvironment(), Integer.MIN_VALUE, "eval", block);
        return SleepUtils.runCode(inlineCallRequest, scriptInstance, SleepUtils.getArgumentStack(hashMap));
    }

    public static Scalar runCode(ScriptInstance scriptInstance, Block block) {
        return SleepUtils.runCode(scriptInstance, block, null);
    }

    public static Scalar getArrayWrapper(Collection collection) {
        Scalar scalar = new Scalar();
        scalar.setValue(new CollectionWrapper(collection));
        return scalar;
    }

    public static Scalar getHashWrapper(Map map2) {
        Scalar scalar = new Scalar();
        scalar.setValue(new MapWrapper(map2));
        return scalar;
    }

    public static Scalar getHashScalar(ScalarHash scalarHash) {
        Scalar scalar = new Scalar();
        scalar.setValue(scalarHash);
        return scalar;
    }

    public static Scalar getArrayScalar(ScalarArray scalarArray) {
        Scalar scalar = new Scalar();
        scalar.setValue(scalarArray);
        return scalar;
    }

    public static Scalar getArrayScalar() {
        Scalar scalar = new Scalar();
        scalar.setValue(new ListContainer());
        return scalar;
    }

    public static Map getMapFromHash(Scalar scalar) {
        return SleepUtils.getMapFromHash(scalar.getHash());
    }

    public static Map getMapFromHash(ScalarHash scalarHash) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (scalarHash != null) {
            Iterator iterator = scalarHash.keys().scalarIterator();
            while (iterator.hasNext()) {
                Scalar scalar = (Scalar)iterator.next();
                Scalar scalar2 = scalarHash.getAt(scalar);
                if (scalar2.getHash() != null) {
                    hashMap.put(scalar.toString(), SleepUtils.getMapFromHash(scalar2.getHash()));
                    continue;
                }
                if (scalar2.getArray() != null) {
                    hashMap.put(scalar.toString(), SleepUtils.getListFromArray(scalar2.getArray()));
                    continue;
                }
                hashMap.put(scalar.toString(), scalar2.objectValue());
            }
        }
        return hashMap;
    }

    public static Stack getArgumentStack(Map map2) {
        Stack<Scalar> stack = new Stack<Scalar>();
        if (map2 != null) {
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stack.push(SleepUtils.getScalar(new KeyValuePair(SleepUtils.getScalar(entry.getKey().toString()), (Scalar)entry.getValue())));
            }
        }
        return stack;
    }

    public static Iterator getIterator(Scalar scalar, ScriptInstance scriptInstance) {
        if (scalar.getArray() != null) {
            return scalar.getArray().scalarIterator();
        }
        if (SleepUtils.isFunctionScalar(scalar)) {
            return SleepUtils.getFunctionFromScalar(scalar).scalarIterator();
        }
        if (ProxyIterator.isIterator(scalar)) {
            return new ProxyIterator((Iterator)scalar.objectValue(), true);
        }
        throw new IllegalArgumentException("expected iterator (@array or &closure)--received: " + SleepUtils.describe(scalar));
    }

    public static List getListFromArray(Scalar scalar) {
        return SleepUtils.getListFromArray(scalar.getArray());
    }

    public static List getListFromArray(ScalarArray scalarArray) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (scalarArray != null) {
            Iterator iterator = scalarArray.scalarIterator();
            while (iterator.hasNext()) {
                Scalar scalar = (Scalar)iterator.next();
                if (scalar.getHash() != null) {
                    linkedList.add(SleepUtils.getMapFromHash(scalar.getHash()));
                    continue;
                }
                if (scalar.getArray() != null) {
                    linkedList.add(SleepUtils.getListFromArray(scalar.getArray()));
                    continue;
                }
                linkedList.add(scalar.objectValue());
            }
        }
        return linkedList;
    }

    public static Scalar getEmptyScalar() {
        Scalar scalar = new Scalar();
        scalar.setValue(nullScalar);
        return scalar;
    }

    public static boolean isEmptyScalar(Scalar scalar) {
        return scalar == null || scalar.getActualValue() == nullScalar;
    }

    public static boolean isFunctionScalar(Scalar scalar) {
        return scalar.objectValue() != null && scalar.objectValue() instanceof SleepClosure;
    }

    public static SleepClosure getFunctionFromScalar(Scalar scalar) {
        if (scalar.objectValue() != null && scalar.objectValue() instanceof SleepClosure) {
            return (SleepClosure)scalar.objectValue();
        }
        return null;
    }

    public static SleepClosure getFunctionFromScalar(Scalar scalar, ScriptInstance scriptInstance) {
        if (scalar.objectValue() != null && scalar.objectValue() instanceof SleepClosure) {
            return (SleepClosure)scalar.objectValue();
        }
        return (SleepClosure)scriptInstance.getScriptEnvironment().getFunction(scalar.toString());
    }

    public static Scalar getIOHandleScalar(InputStream inputStream, OutputStream outputStream) {
        return SleepUtils.getScalar(SleepUtils.getIOHandle(inputStream, outputStream));
    }

    public static IOObject getIOHandle(InputStream inputStream, OutputStream outputStream) {
        IOObject iOObject = new IOObject();
        iOObject.openRead(inputStream);
        iOObject.openWrite(outputStream);
        return iOObject;
    }

    public static Object newInstance(Class clazz, SleepClosure sleepClosure, ScriptInstance scriptInstance) {
        return ProxyInterface.BuildInterface(clazz, (Function)sleepClosure, scriptInstance != null ? scriptInstance : sleepClosure.getOwner());
    }

    public static Object newInstance(Class clazz, Block block, ScriptInstance scriptInstance) {
        return ProxyInterface.BuildInterface(clazz, (Function)new SleepClosure(scriptInstance, block), scriptInstance);
    }

    public static String describe(Stack stack) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = (Scalar)iterator.next();
            stringBuffer.insert(0, SleepUtils.describe(scalar));
            if (!iterator.hasNext()) continue;
            stringBuffer.insert(0, ", ");
        }
        return stringBuffer.toString();
    }

    private static String describeEntries(List list, Scalar scalar) {
        if (scalar.getArray() != null) {
            if (list.contains(scalar.getArray())) {
                return "@" + list.indexOf(scalar.getArray());
            }
            list.add(scalar.getArray());
            StringBuffer stringBuffer = new StringBuffer("@(");
            Iterator iterator = scalar.getArray().scalarIterator();
            while (iterator.hasNext()) {
                Scalar scalar2 = (Scalar)iterator.next();
                stringBuffer.append(SleepUtils.describeEntries(list, scalar2));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        if (scalar.getHash() != null) {
            if (list.contains(scalar.getHash())) {
                return "%" + list.indexOf(scalar.getHash());
            }
            list.add(scalar.getHash());
            StringBuffer stringBuffer = new StringBuffer("%(");
            Iterator iterator = scalar.getHash().getData().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Scalar scalar3 = (Scalar)entry.getValue();
                if (SleepUtils.isEmptyScalar((Scalar)entry.getValue())) continue;
                if (stringBuffer.length() > 2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(entry.getKey());
                stringBuffer.append(" => ");
                stringBuffer.append(SleepUtils.describeEntries(list, scalar3));
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        if (scalar.getActualValue().getType() == NullValue.class) {
            return "$null";
        }
        if (scalar.getActualValue().getType() == StringValue.class) {
            return "'" + scalar.toString() + "'";
        }
        if (SleepUtils.isFunctionScalar(scalar)) {
            return scalar.toString();
        }
        if (scalar.objectValue() instanceof KeyValuePair) {
            KeyValuePair keyValuePair = (KeyValuePair)scalar.objectValue();
            return keyValuePair.getKey().toString() + " => " + SleepUtils.describe(keyValuePair.getValue());
        }
        if (scalar.getActualValue().getType() == ObjectValue.class) {
            if (Proxy.isProxyClass(scalar.objectValue().getClass())) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[");
                stringBuffer.append(Proxy.getInvocationHandler(scalar.objectValue()).toString());
                stringBuffer.append(" as ");
                Class<?>[] classArray = scalar.objectValue().getClass().getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(classArray[i].getName());
                }
                stringBuffer.append("]");
                return stringBuffer.toString();
            }
            return scalar.toString();
        }
        if (scalar.getActualValue().getType() == LongValue.class) {
            return scalar.toString() + "L";
        }
        return scalar.toString();
    }

    public static String describe(Scalar scalar) {
        return SleepUtils.describeEntries(new LinkedList(), scalar);
    }

    public static Scalar getHashScalar() {
        Scalar scalar = new Scalar();
        scalar.setValue(new HashContainer());
        return scalar;
    }

    public static Scalar getOrderedHashScalar() {
        Scalar scalar = new Scalar();
        scalar.setValue(new OrderedHashContainer(11, 0.75f, false));
        return scalar;
    }

    public static Scalar getAccessOrderedHashScalar() {
        Scalar scalar = new Scalar();
        scalar.setValue(new OrderedHashContainer(11, 0.75f, true));
        return scalar;
    }

    public static Scalar getScalar(int n) {
        Scalar scalar = new Scalar();
        scalar.setValue(new IntValue(n));
        return scalar;
    }

    public static Scalar getScalar(short s) {
        Scalar scalar = new Scalar();
        scalar.setValue(new IntValue(s));
        return scalar;
    }

    public static Scalar getScalar(float f) {
        Scalar scalar = new Scalar();
        scalar.setValue(new DoubleValue(f));
        return scalar;
    }

    public static Scalar getScalar(double d) {
        Scalar scalar = new Scalar();
        scalar.setValue(new DoubleValue(d));
        return scalar;
    }

    public static Scalar getScalar(Scalar scalar) {
        Scalar scalar2 = new Scalar();
        scalar2.setValue(scalar);
        return scalar2;
    }

    public static Scalar getScalar(long l) {
        Scalar scalar = new Scalar();
        scalar.setValue(new LongValue(l));
        return scalar;
    }

    public static Scalar getScalar(byte[] byArray) {
        return SleepUtils.getScalar(byArray, byArray.length);
    }

    public static Scalar getScalar(byte[] byArray, int n) {
        Scalar scalar = new Scalar();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            stringBuffer.append(c);
        }
        scalar.setValue(new StringValue(stringBuffer.toString()));
        return scalar;
    }

    public static Scalar getScalar(String string) {
        if (string == null) {
            return SleepUtils.getEmptyScalar();
        }
        Scalar scalar = new Scalar();
        scalar.setValue(new StringValue(string));
        return scalar;
    }

    public static Scalar getScalar(Object object) {
        if (object == null) {
            return SleepUtils.getEmptyScalar();
        }
        Scalar scalar = new Scalar();
        scalar.setValue(new ObjectValue(object));
        return scalar;
    }

    public static Scalar getScalar(boolean bl) {
        if (bl) {
            return SleepUtils.getScalar(1);
        }
        return SleepUtils.getEmptyScalar();
    }

    public static boolean isTrueScalar(Scalar scalar) {
        return scalar.getArray() != null || scalar.getHash() != null || scalar.getActualValue().toString().length() != 0 && !"0".equals(scalar.getActualValue().toString());
    }
}

