/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintedValue;

public class WatchScalar
extends Scalar {
    protected ScriptEnvironment owner;
    protected String name;

    public WatchScalar(String string, ScriptEnvironment scriptEnvironment) {
        this.name = string;
        this.owner = scriptEnvironment;
    }

    public void flagChange(Scalar scalar) {
        if (this.owner != null && (this.value != null || this.array != null || this.hash != null)) {
            this.owner.showDebugMessage("watch(): " + this.name + " = " + SleepUtils.describe(scalar));
        }
    }

    public void setValue(ScalarType scalarType) {
        if (scalarType.getClass() != TaintedValue.class || ((TaintedValue)scalarType).untaint() != this.value) {
            Scalar scalar = new Scalar();
            scalar.setValue(scalarType);
            this.flagChange(scalar);
        }
        super.setValue(scalarType);
    }

    public void setValue(ScalarArray scalarArray) {
        Scalar scalar = new Scalar();
        scalar.setValue(scalarArray);
        this.flagChange(scalar);
        super.setValue(scalarArray);
    }

    public void setValue(ScalarHash scalarHash) {
        Scalar scalar = new Scalar();
        scalar.setValue(scalarHash);
        this.flagChange(scalar);
        super.setValue(scalarHash);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (SleepUtils.isEmptyScalar(this)) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(this.value);
        }
        objectOutputStream.writeObject(this.array);
        objectOutputStream.writeObject(this.hash);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.value = (ScalarType)objectInputStream.readObject();
        this.array = (ScalarArray)objectInputStream.readObject();
        this.hash = (ScalarHash)objectInputStream.readObject();
        if (this.value == null && this.array == null && this.hash == null) {
            this.setValue(SleepUtils.getEmptyScalar());
        }
    }
}

