/*
 * Decompiled with CFR 0.152.
 */
package sleep.taint;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.engine.types.ObjectValue;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.MapWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import sleep.taint.Sanitizer;
import sleep.taint.Sensitive;
import sleep.taint.TaintArray;
import sleep.taint.TaintHash;
import sleep.taint.TaintedValue;
import sleep.taint.Tainter;

public class TaintUtils {
    private static boolean isTaintMode = System.getProperty("sleep.taint", "false").equals("true");

    public static boolean isTaintMode() {
        return isTaintMode;
    }

    public static Scalar taint(Scalar scalar) {
        if (TaintUtils.isTaintMode() && scalar.getActualValue() != null) {
            scalar.setValue(new TaintedValue(scalar.getActualValue()));
        }
        return scalar;
    }

    public static Stack taint(Stack stack) {
        if (TaintUtils.isTaintMode()) {
            Iterator iterator = stack.iterator();
            while (iterator.hasNext()) {
                TaintUtils.taintAll((Scalar)iterator.next());
            }
        }
        return stack;
    }

    public static Scalar taintAll(Scalar scalar) {
        if (scalar.getArray() != null && scalar.getArray().getClass() == CollectionWrapper.class) {
            scalar.setValue(new TaintArray(scalar.getArray()));
        } else if (scalar.getArray() != null) {
            Iterator iterator = scalar.getArray().scalarIterator();
            while (iterator.hasNext()) {
                TaintUtils.taintAll((Scalar)iterator.next());
            }
        } else if (scalar.getHash() != null && scalar.getHash().getClass() == MapWrapper.class) {
            scalar.setValue(new TaintHash(scalar.getHash()));
        } else if (scalar.getHash() != null) {
            Iterator iterator = scalar.getHash().getData().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TaintUtils.taintAll((Scalar)entry.getValue());
            }
        } else if (scalar.getActualValue().getType() == ObjectValue.class && scalar.objectValue().getClass() == KeyValuePair.class) {
            KeyValuePair keyValuePair = (KeyValuePair)scalar.objectValue();
            scalar.setValue(SleepUtils.getScalar(new KeyValuePair(keyValuePair.getKey(), TaintUtils.taintAll(keyValuePair.getValue()))));
        } else if (scalar.getActualValue() != null) {
            scalar.setValue(new TaintedValue(scalar.getActualValue()));
        }
        return scalar;
    }

    public static Scalar untaint(Scalar scalar) {
        if (scalar.getActualValue() != null && scalar.getActualValue().getClass() == TaintedValue.class) {
            scalar.setValue(((TaintedValue)scalar.getActualValue()).untaint());
        }
        return scalar;
    }

    private static boolean isTainted(Set set, Scalar scalar) {
        if (scalar.getHash() != null) {
            if (!set.contains(scalar.getHash())) {
                set.add(scalar.getHash());
                Iterator iterator = scalar.getHash().getData().values().iterator();
                while (iterator.hasNext()) {
                    if (!TaintUtils.isTainted(set, (Scalar)iterator.next())) continue;
                    return true;
                }
            }
            return false;
        }
        if (scalar.getArray() != null) {
            if (!set.contains(scalar.getArray())) {
                set.add(scalar.getArray());
                Iterator iterator = scalar.getArray().scalarIterator();
                while (iterator.hasNext()) {
                    if (!TaintUtils.isTainted(set, (Scalar)iterator.next())) continue;
                    return true;
                }
            }
            return false;
        }
        return scalar.getActualValue().getClass() == TaintedValue.class && !SleepUtils.isEmptyScalar(scalar);
    }

    public static boolean isTainted(Scalar scalar) {
        if (scalar.getActualValue() == null) {
            return TaintUtils.isTainted(new HashSet(), scalar);
        }
        return TaintUtils.isTainted(null, scalar);
    }

    public static Object Sanitizer(Object object) {
        if (TaintUtils.isTaintMode()) {
            return new Sanitizer(object);
        }
        return object;
    }

    public static Object Tainter(Object object) {
        if (TaintUtils.isTaintMode()) {
            return new Tainter(object);
        }
        return object;
    }

    public static Object Sensitive(Object object) {
        if (TaintUtils.isTaintMode()) {
            return new Sensitive(object);
        }
        return object;
    }

    public static String checkArguments(Stack stack) {
        Stack<Scalar> stack2 = new Stack<Scalar>();
        String string = null;
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = (Scalar)iterator.next();
            if (!TaintUtils.isTainted(scalar)) continue;
            stack2.push(scalar);
        }
        if (!stack2.isEmpty()) {
            string = SleepUtils.describe(stack2);
        }
        return string;
    }
}

