#include "assets.h"

const char* avatar_mono[]=
{
	" ___________ \n"
	" \\_________/ \n"
	" (___ -+-__) \n"
	" |||\\_____\\| \n"
	" (:---0-0--) \n"
	" |::  /.\\ :| \n"
	"  \\:   - :/  \n"
	"   |\\__,_/|  ",
	"             \n"
	"   \\\\\\\\///   \n"
	"  \\\\% :: %/  \n"
	" ||| __ __ | \n"
	" (:  -- -- ) \n"
	" |::   j  :| \n"
	"  \\:  \\_/:/  \n"
	"   |\\____/|  ",
	"    _____    \n"
	"  >>-    \\   \n"
	" _/_______\\_ \n"
	" ||  __ __ | \n"
	" (:   v v  ) \n"
	" |::   |  :| \n"
	"  \\:  (-):/  \n"
	"   |\\____/|  ",
	"             \n"
	"  ,((((()),  \n"
	" ,((   )  ), \n"
	" ((  __ __ ) \n"
	" (--(__X__)- \n"
	" |::   .  :| \n"
	"  \\:  /|\\:/  \n"
	"   |\\__,_/|  ",
	"    ______   \n"
	"  ,\'   #  \\  \n"
	" (_________) \n"
	" ||| __ __ | \n"
	" (:   , ,  ) \n"
	" |:: \\_^_/:| \n"
	"  \\:   o :/  \n"
	"   |\\____/|  ",
	"      __     \n"
	"   ,-\'  \'-,  \n"
	"  /        : \n"
	" |   __ __ ; \n"
	" (:   q p  ) \n"
	" |::   U  :| \n"
	"  \\:   ~ :/  \n"
	"   |\\__,_/|  ",
	0
};

const char* avatar_shade[]=
{
	" ___________ \n"
	" \\_________/ \n"
	" (___ -+-__) \n"
	" |||\\_____\\| \n"
	" (:---0-0--) \n"
	" |::  /.\\ :| \n"
	"  %::  - :/  \n"
	"   |\\:.,./:  ",
	"             \n"
	"   \\\\\\\\///   \n"
	"  \\\\%::::%/  \n"
	" ||| __ __ | \n"
	" (:  -- -- ) \n"
	" |::   j  :| \n"
	"  %:: \\_/:/  \n"
	"   |\\:.../:  ",
	"    _____    \n"
	"  >>-    \\   \n"
	" _/_______\\_ \n"
	" ||| __ __ | \n"
	" (:   v v  ) \n"
	" |::   |  :| \n"
	"  %:: (-):/  \n"
	"   |\\:.../:  ",
	"             \n"
	"  ,((((()),  \n"
	" ,((@::):@), \n"
	" ((@ __ __@) \n"
	" (:--\' -\' -) \n"
	" |::   .  :| \n"
	"  %:: /|\\:/  \n"
	"   |\\:.,./:  ",
	"      ___    \n"
	"  ,%::%#:%,  \n"
	" %_________) \n"
	" ||| __ __ | \n"
	" (:   , ,  ) \n"
	" |:: \\_^_/:| \n"
	"  %::  o :/  \n"
	"   |\\:.../:  ",
	"             \n"
	"   ;%%%%%;   \n"
	"  |%\"   \"%|  \n"
	" ||\' __ __\'| \n"
	" (:   q p  ) \n"
	" |::   U  :| \n"
	"  %::  ~ :/  \n"
	"   |\\:.,./:  ",
	0
};

const unsigned char avatar_colordata[]=
{
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x07,0x00,
	0x07,0x47,0x47,0x47,0x4C,0x4C,0x4B,0x4B,0x4B,0x4C,0x47,0x47,0x07,0x00,
	0x07,0x08,0x08,0x38,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x07,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x07,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x07,0x07,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x07,0x07,0x07,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x07,0x08,0x30,0x30,0x38,0x38,0x30,0x30,0x07,0x07,0x07,0x00,
	0x08,0x08,0x08,0x38,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x00,0x00,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x03,0x03,0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x0C,0x06,0x0C,0x0C,0x0C,0x0C,0x0C,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x08,0x08,0x08,0x38,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x00,0x00,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x03,0x03,0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x08,0x08,0x07,0x30,0x30,0x38,0x30,0x30,0x30,0x08,0x08,0x08,0x00,
	0x08,0x08,0x07,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x00,
	0x03,0x03,0x30,0x30,0x30,0x07,0x07,0x30,0x07,0x07,0x30,0x03,0x03,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x00,0x00,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x03,0x03,0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x08,0x08,0x01,0x01,0x10,0x19,0x19,0x1F,0x19,0x10,0x01,0x01,0x01,0x00,
	0x08,0x01,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x01,0x01,0x00,
	0x08,0x08,0x08,0x38,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x00,0x00,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x03,0x03,0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x01,0x01,0x01,0x08,0x08,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x00,
	0x01,0x01,0x08,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x08,0x00,
	0x08,0x08,0x30,0x38,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x08,0x08,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x00,
	0x00,0x00,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
	0x03,0x03,0x03,0x03,0x30,0x30,0x30,0x30,0x30,0x30,0x03,0x03,0x03,0x00,
};

const char* avatar_color[]=
{
	(const char*)avatar_colordata + 0,
	(const char*)avatar_colordata + 112,
	(const char*)avatar_colordata + 224,
	(const char*)avatar_colordata + 336,
	(const char*)avatar_colordata + 448,
	(const char*)avatar_colordata + 560,
	0
};

ASSET avatar=
{
	avatar_mono,
	avatar_shade,
	avatar_color
};

const char* ball1_mono[]=
{
	"*_*\n"
	"(_)",
	0
};

const char* ball1_shade[]=
{
	"*_*\n"
	"(%)",
	0
};

const unsigned char ball1_colordata[]=
{
	0x70,0x70,0x70,0x00,
	0x70,0x27,0x70,0x00,
};

const char* ball1_color[]=
{
	(const char*)ball1_colordata + 0,
	0
};

ASSET ball1=
{
	ball1_mono,
	ball1_shade,
	ball1_color
};

const char* ball2_mono[]=
{
	"*__*\n"
	"/, \\\n"
	"\\__/",
	"*__*\n"
	"/  \\\n"
	"\\\'_/",
	"*__*\n"
	"/  \\\n"
	"\\_\'/",
	"*__*\n"
	"/ ,\\\n"
	"\\__/",
	0
};

const char* ball2_shade[]=
{
	"*__*\n"
	"/%%\\\n"
	"\\%%/",
	"*__*\n"
	"/%%\\\n"
	"\\%%/",
	"*__*\n"
	"/%%\\\n"
	"\\%% ",
	"*__*\n"
	"/%%\\\n"
	"\\%%/",
	0
};

const unsigned char ball2_colordata[]=
{
	0x70,0x70,0x70,0x70,0x00,
	0x70,0x63,0x27,0x70,0x00,
	0x70,0x63,0x28,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x27,0x28,0x70,0x00,
	0x70,0x63,0x63,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x27,0x63,0x70,0x00,
	0x70,0x28,0x63,0x73,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x63,0x63,0x70,0x00,
	0x70,0x28,0x28,0x70,0x00,
};

const char* ball2_color[]=
{
	(const char*)ball2_colordata + 0,
	(const char*)ball2_colordata + 15,
	(const char*)ball2_colordata + 30,
	(const char*)ball2_colordata + 45,
	0
};

ASSET ball2=
{
	ball2_mono,
	ball2_shade,
	ball2_color
};

const char* ball3_mono[]=
{
	"**____**\n"
	"*/::  \\*\n"
	"(      )\n"
	"*\\__::/*",
	"**____**\n"
	"*/..  \\*\n"
	"(\'\'  ..)\n"
	"*\\__\'\'/*",
	"**____**\n"
	"*/    \\*\n"
	"(::  ::)\n"
	"*\\____/*",
	"**____**\n"
	"*/  ..\\*\n"
	"(..  \'\')\n"
	"*\\\'\'__/*",
	"**____**\n"
	"*/  ::\\*\n"
	"(      )\n"
	"*\\::__/*",
	"**____**\n"
	"*/ :: \\*\n"
	"(      )\n"
	"*\\_::_/*",
	0
};

const char* ball3_shade[]=
{
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	"**____**\n"
	"*/%%%%\\*\n"
	"(%%%%%%)\n"
	"*\\%%%%/*",
	0
};

const unsigned char ball3_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x27,0x27,0x27,0x63,0x70,0x70,0x00,
	0x70,0x27,0x63,0x63,0x63,0x63,0x28,0x70,0x00,
	0x70,0x70,0x63,0x28,0x28,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x27,0x63,0x63,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x63,0x63,0x28,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x63,0x63,0x28,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x27,0x63,0x63,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x63,0x63,0x27,0x27,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x28,0x28,0x63,0x63,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x63,0x27,0x27,0x27,0x70,0x70,0x00,
	0x70,0x27,0x63,0x63,0x63,0x63,0x68,0x70,0x00,
	0x00,0x70,0x28,0x28,0x28,0x63,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x27,0x27,0x27,0x70,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x00,0x70,0x28,0x28,0x28,0x28,0x70,0x70,0x00,
};

const char* ball3_color[]=
{
	(const char*)ball3_colordata + 0,
	(const char*)ball3_colordata + 36,
	(const char*)ball3_colordata + 72,
	(const char*)ball3_colordata + 108,
	(const char*)ball3_colordata + 144,
	(const char*)ball3_colordata + 180,
	0
};

ASSET ball3=
{
	ball3_mono,
	ball3_shade,
	ball3_color
};

const char* ball4_mono[]=
{
	"**_____**\n"
	"*/:::  \\*\n"
	"/::     \\\n"
	"\\     ::/\n"
	"*\\__:::/*",
	"**_____**\n"
	"*/::   \\*\n"
	"/::   ..\\\n"
	"\\\'\'   ::/\n"
	"*\\___::/*",
	"**_____**\n"
	"*/     \\*\n"
	"/::   ::\\\n"
	"\\::   ::/\n"
	"*\\_____/*",
	"**_____**\n"
	"*/   ::\\*\n"
	"/..   ::\\\n"
	"\\::.  \'\'/\n"
	"*\\::___/*",
	"**_____**\n"
	"*/  :::\\*\n"
	"/     ::\\\n"
	"\\::     /\n"
	"*\\:::__/*",
	"**_____**\n"
	"*/ \':::\\*\n"
	"/     \'\'\\\n"
	"\\..     /\n"
	"*\\:::._/*",
	"**_____**\n"
	"*/:::::\\*\n"
	"/       \\\n"
	"\\       /\n"
	"*\\:::::/*",
	"**_____**\n"
	"*/:::\' \\*\n"
	"/\'\'     \\\n"
	"\\     ../\n"
	"*\\_.:::/*",
	0
};

const char* ball4_shade[]=
{
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	"**_____**\n"
	"*/%%%%%\\*\n"
	"/%%%%%%%\\\n"
	"\\%%%%%%%/\n"
	"*\\%%%%%/*",
	0
};

const unsigned char ball4_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x27,0x27,0x27,0x63,0x63,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x70,0x63,0x63,0x28,0x28,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x27,0x63,0x63,0x63,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x63,0x63,0x63,0x28,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x63,0x63,0x63,0x28,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x27,0x63,0x63,0x63,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x63,0x63,0x63,0x27,0x27,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x28,0x28,0x63,0x63,0x63,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x63,0x63,0x27,0x27,0x27,0x70,0x70,0x00,
	0x70,0x27,0x63,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x27,0x28,0x63,0x63,0x63,0x63,0x28,0x70,0x00,
	0x00,0x70,0x28,0x28,0x28,0x63,0x63,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x63,0x27,0x27,0x27,0x27,0x70,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x70,0x28,0x28,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x00,0x70,0x28,0x28,0x28,0x28,0x63,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x27,0x27,0x27,0x27,0x70,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x00,0x70,0x28,0x28,0x28,0x28,0x28,0x70,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x70,0x27,0x27,0x27,0x27,0x63,0x70,0x70,0x00,
	0x70,0x27,0x27,0x63,0x63,0x63,0x63,0x63,0x70,0x00,
	0x70,0x63,0x63,0x63,0x63,0x63,0x28,0x28,0x70,0x00,
	0x00,0x70,0x63,0x28,0x28,0x28,0x28,0x70,0x70,0x00,
};

const char* ball4_color[]=
{
	(const char*)ball4_colordata + 0,
	(const char*)ball4_colordata + 50,
	(const char*)ball4_colordata + 100,
	(const char*)ball4_colordata + 150,
	(const char*)ball4_colordata + 200,
	(const char*)ball4_colordata + 250,
	(const char*)ball4_colordata + 300,
	(const char*)ball4_colordata + 350,
	0
};

ASSET ball4=
{
	ball4_mono,
	ball4_shade,
	ball4_color
};

const char* base_mono[]=
{
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/___  _____\\**************************\n"
	"/____ (O O O \\*************************\n"
	"\\____________/________________________*\n"
	"/                >   -   -   >   -    \\",
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/___  _____\\**************************\n"
	"/____ (O O O \\*************************\n"
	"\\____________/________________________*\n"
	"/                -   >   -   -   >    \\",
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/___  _____\\**************************\n"
	"/____ (O O O \\*************************\n"
	"\\____________/________________________*\n"
	"/                -   -   >   -   -    \\",
	0
};

const char* base_shade[]=
{
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/% %% ____%\\**************************\n"
	"/% %% (O%O%O)\\*************************\n"
	"\\%__%%______%/________________________*\n"
	"/\"\"\"\"\"\"\"\"\"\"\"\"  ::%:: >   > ::%:: >    \\",
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/% %% ____%\\**************************\n"
	"/% %% (O%O%O)\\*************************\n"
	"\\%__%%______%/________________________*\n"
	"/\"\"\"\"\"\"\"\"\"\"\"\"    > ::%:: >   > ::%::  \\",
	"***.***********************************\n"
	"**_|________***************************\n"
	"*/% %% ____%\\**************************\n"
	"/% %% (O%O%O)\\*************************\n"
	"\\%__%%______%/________________________*\n"
	"/\"\"\"\"\"\"\"\"\"\"\"\"    >   > ::%:: >   >    \\",
	0
};

const unsigned char base_colordata[]=
{
	0x70,0x70,0x70,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x70,0x70,0x7F,0x79,0x7F,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x70,0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x10,0x10,0x10,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x1B,0x18,0x1B,0x18,0x1B,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x71,0x9F,0x90,0x90,0x91,0x19,0x10,0x10,0x10,0x10,0x10,0x10,0x17,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x86,0x8E,0x8F,0x8E,0x86,0x86,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x86,0x8E,0x8F,0x8E,0x86,0x86,0x8C,0x8C,0x8C,0x8C,0x8C,0x87,0x00,
	0x09,0x09,0x09,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x09,0x09,0x7F,0x79,0x7F,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x01,0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x10,0x10,0x10,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x1B,0x18,0x1B,0x18,0x1B,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x71,0x9F,0x90,0x90,0x91,0x19,0x10,0x10,0x10,0x10,0x10,0x10,0x17,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x8C,0x8C,0x86,0x8E,0x8F,0x8E,0x86,0x86,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x86,0x8E,0x8F,0x8E,0x86,0x86,0x86,0x87,0x00,
	0x09,0x09,0x09,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x09,0x09,0x7F,0x79,0x7F,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x00,
	0x01,0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x10,0x10,0x10,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x79,0x9F,0x9F,0x91,0x19,0x19,0x10,0x1B,0x18,0x1B,0x18,0x1B,0x17,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
	0x71,0x9F,0x90,0x90,0x91,0x19,0x10,0x10,0x10,0x10,0x10,0x10,0x17,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x86,0x8E,0x8F,0x8E,0x86,0x86,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x87,0x00,
};

const char* base_color[]=
{
	(const char*)base_colordata + 0,
	(const char*)base_colordata + 240,
	(const char*)base_colordata + 480,
	0
};

ASSET base=
{
	base_mono,
	base_shade,
	base_color
};

const char* basher_mono[]=
{
	"***_***\n"
	"**(_)**\n"
	"*_/ \\_*\n"
	"(_)-(_)",
	"*****_*\n"
	"*_**(_)\n"
	"(_)< |*\n"
	"****(_)",
	"*_***_*\n"
	"(_)-(_)\n"
	"**\\_/**\n"
	"**(_)**",
	"*_*****\n"
	"(_)**_*\n"
	"*| >(_)\n"
	"(_)****",
	0
};

const char* basher_shade[]=
{
	"***_***\n"
	"**(_)**\n"
	"*_/ \\_*\n"
	"(_)-(_)",
	"*****_*\n"
	"*_**(_)\n"
	"(_)< |*\n"
	"****(_)",
	"*_***_*\n"
	"(_)-(_)\n"
	"**\\ /**\n"
	"**(_)**",
	"*_*****\n"
	"(_)**_*\n"
	"*| >(_)\n"
	"(_)****",
	0
};

const unsigned char basher_colordata[]=
{
	0x70,0x70,0x70,0x7A,0x7A,0x7A,0x7A,0x00,
	0x70,0x70,0x7A,0x20,0x70,0x70,0x70,0x00,
	0x70,0x7A,0x70,0x70,0x70,0x7A,0x7A,0x00,
	0x7A,0x20,0x70,0x70,0x7A,0x20,0x70,0x00,
	0x0A,0x0A,0x0A,0x0A,0x0A,0x7A,0x7A,0x00,
	0x00,0x7A,0x7A,0x7A,0x7A,0x20,0x70,0x00,
	0x7A,0x20,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x00,0x00,0x00,0x7A,0x20,0x70,0x00,
	0x0A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x00,
	0x7A,0x20,0x70,0x70,0x7A,0x20,0x70,0x00,
	0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x00,0x7A,0x20,0x70,0x70,0x70,0x00,
	0x0A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x00,
	0x7A,0x20,0x70,0x70,0x70,0x7A,0x7A,0x00,
	0x00,0x70,0x70,0x70,0x7A,0x20,0x70,0x00,
	0x7A,0x20,0x70,0x70,0x70,0x70,0x70,0x00,
};

const char* basher_color[]=
{
	(const char*)basher_colordata + 0,
	(const char*)basher_colordata + 32,
	(const char*)basher_colordata + 64,
	(const char*)basher_colordata + 96,
	0
};

ASSET basher=
{
	basher_mono,
	basher_shade,
	basher_color
};

const char* book_mono[]=
{
	"********************* ____________________ \n"
	"*********************|                    |\n"
	"******************** |    ______________  |\n"
	"******************* (__)                  |\n"
	"******************** |     ASCII PATROL   |\n"
	"******************* (__)  ______________  |\n"
	"******************** |     __.______      |\n"
	"******************* (__)  / _____ \\_\\_    |\n"
	"******************** |    \\__  __   __\\   |\n"
	"******************* (__)  /__\\/\\ \\_/ /\\   |\n"
	"******************** |    \\__/\\_\\/ \\/_/   |\n"
	"******************* (__)                  |\n"
	"******************** |    :: OWNERS ::::  |\n"
	"******************* (__)  :::: MANUAL ::  |\n"
	"******************** |                    |\n"
	"*********************|____________________|\n"
	"*********************                      ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|                    |                    |\n"
	"|                  (___)                 _|\n"
	"|                    |    ASCII PATROL  |**\n"
	"|                  (___) ______________ |**\n"
	"|                    |                  |**\n"
	"|                  (___)    Alpha  1    |**\n"
	"|                    |                  |**\n"
	"|                  (___)                |**\n"
	"|                    |                  |**\n"
	"|                  (___)                |**\n"
	"|                    |   :: OWNERS :::: |**\n"
	"|                  (___) :::: MANUAL :: |**\n"
	"|                    |                  |**\n"
	"|____________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|       Quick        |   YOUR CHECK LIST  |\n"
	"|_    Reference    (___)  safety first!   |\n"
	"**|                  |                   @|\n"
	"**|  Right / \'D\' > (___) [ ] Accel.  2s  _|\n"
	"**|                  |                  |**\n"
	"**|   Left / \'A\' > (___) [ ] Brake   2s |**\n"
	"**|                  |                  |**\n"
	"**|     Up / \'W\' > (___) [ ] Jump    x3 |**\n"
	"**|                  |                  |**\n"
	"**|   Down / \'S\' > (___) [ ] Crouch  2s |**\n"
	"**|                  |                  |**\n"
	"**|  Enter / \'L\' > (___) [ ] Fire    x5 |**\n"
	"**|                  |                  |**\n"
	"**|__________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|                    |     DESTROY BIG    |\n"
	"|_  You need to    (___)    OBSTACLES     |\n"
	"**| slow down if     |                    |\n"
	"**| there are many (___)                  |\n"
	"**| objects in       |     [ ]  ___      A|\n"
	"**| front of you.  (___)   x5 _/:::\\     _|\n"
	"**|                  |       /::::::\\   |**\n"
	"**| FIRE:          (___)   ~~~~~~~~~~~  |**\n"
	"**|  Enter / \'L\'     |   [ ]  _   __    |**\n"
	"**|                (___) x5 _/:\\_/::\\   |**\n"
	"**| BRAKE:           |     /::::\\::::\\  |**\n"
	"**|   Left / \'A\'   (___)  /:::::::::::\\ |**\n"
	"**|                  |   ~~~~~~~~~~~~~~~|**\n"
	"**|__________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|                    |    DESTROY SMALL   |\n"
	"|   Small objects  (___)    OBSTACLES     |\n"
	"|   can be easily    |                    |\n"
	"|   destroyed when (___)                  |\n"
	"|   shooting while   |                    |\n"
	"|_  crouching.     (___)   [ ] __         |\n"
	"**|                  |     x5 /::\\       B|\n"
	"**| FIRE:          (___)  ~~~~~~~~~      _|\n"
	"**|  Enter / \'L\'     |                  |**\n"
	"**|                (___)      [ ] _     |**\n"
	"**| CROUCH:          |        x5 (_)    |**\n"
	"**|   Down / \'S\'   (___)     ~~~~~~~~   |**\n"
	"**|                  |                  |**\n"
	"**|__________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|                    |      JUMP OVER     |\n"
	"|   Jumping over   (___)     DITCHES      |\n"
	"|   wide ditches     |                    |\n"
	"|   is easier at   (___) _     [ ]     _  |\n"
	"|   the higher       |    \\           /:  |\n"
	"|   speed.         (___)   \\_       _/::  |\n"
	"|                    |   x3  \\_____/:::   |\n"
	"|_  JUMP:          (___)                  |\n"
	"**|     Up / \'W\'     |                   C|\n"
	"**|                (___)   __  [ ]  __   _|\n"
	"**| ACCELERATE:      |       \\     /::  |**\n"
	"**|  Right / \'D\'   (___)   x3 \\___/:::  |**\n"
	"**|                  |                  |**\n"
	"**|__________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|   Accelerate or    |       DESTROY      |\n"
	"|   brake in order (___)   ALIEN SHIPS    |\n"
	"|   to let your      |                    |\n"
	"|   bullets go to  (___)                  |\n"
	"|   the left or      |           __       |\n"
	"|   right.         (___)  [ ]  _/__\\_     |\n"
	"|                    |    x5  (______)    |\n"
	"|   FIRE:          (___)                  |\n"
	"|    Enter / \'L\'     |                    |\n"
	"|_                 (___)  [ ]  _\\__/_     |\n"
	"**| ACCEL. BRAKE:    |    x5  (______)   D|\n"
	"**|  Right / \'D\'   (___)        \'  \'     _|\n"
	"**|   Left / \'A\'     |                  |**\n"
	"**|__________________|__________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                    |                    |\n"
	"|                    |   You passed the   |\n"
	"|  Gumix ABC       (___) tutorial part!   |\n"
	"|  ~~~~~~~~~~~~~~~   |                    |\n"
	"|  Name            (___) Feel free to     |\n"
	"|                    |   practice here    |\n"
	"|  2016-06-10      (___) if you need so.  |\n"
	"|  ~~~~~~~~~~~~~~~   |   _______________  |\n"
	"|  Date            (___)                  |\n"
	"|     __________     |   Retun to menu    |\n"
	"|   ,           |  (___) to begin your    |\n"
	"|   |= P A S S =|.   |   mission.         |\n"
	"|_  |___________|  (___)                  |\n"
	"**|                  |   EXIT Esc / \'Q\'  E|\n"
	"**|__________________|____________________|\n"
	"                                           ",
	" ____________________ *********************\n"
	"|                    |*********************\n"
	"|                    | ********************\n"
	"|                  (__) *******************\n"
	"|                    | ********************\n"
	"|                  (__) *******************\n"
	"|                    | ********************\n"
	"|                  (__) *******************\n"
	"|                    | ********************\n"
	"|                  (__) *******************\n"
	"|                    | ********************\n"
	"|                  (__) *******************\n"
	"|                    | ********************\n"
	"|  (C) 2016 Gumix  (__) *******************\n"
	"|                    | ********************\n"
	"|____________________|*********************\n"
	"                      *********************",
	0
};

const char* book_shade[]=
{
	"********************* ____________________ \n"
	"*********************                     |\n"
	"******************** _ _  ______________  |\n"
	"******************* (__)                  |\n"
	"******************** _ _   ASCII PATROL   |\n"
	"******************* (__)  ______________  |\n"
	"******************** _ _   __.______      |\n"
	"******************* (__)  / _____ \\_\\_    |\n"
	"******************** _ _  \\__  __   __\\   |\n"
	"******************* (__)  /__\\/\\ \\_/ /\\   |\n"
	"******************** _ _  \\__/\\_\\/ \\/_/   |\n"
	"******************* (__)                  |\n"
	"******************** _ _  :: OWNERS ::::  |\n"
	"******************* (__)  :::: MANUAL ::  |\n"
	"********************                      |\n"
	"********************* ____________________|\n"
	"*********************                      ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|                  _ _ _                  |\n"
	"|                  (___)                 _|\n"
	"|                  _ _ _  ASCII PATROL  |**\n"
	"|                  (___) ______________ |**\n"
	"|                  _ _ _                |**\n"
	"|                  (___)    Alpha  1    |**\n"
	"|                  _ _ _                |**\n"
	"|                  (___)                |**\n"
	"|                  _ _ _                |**\n"
	"|                  (___)                |**\n"
	"|                  _ _ _ :: OWNERS :::: |**\n"
	"|                  (___) :::: MANUAL :: |**\n"
	"|                                       |**\n"
	"|____________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|       Quick      _ _ _ YOUR CHECK LIST  |\n"
	"|_    Reference    (___)  safety first!   |\n"
	"**|                _ _ _                 @|\n"
	"**|  Right / \'D\' > (___) [ ] Accel.  2s  _|\n"
	"**|                _ _ _                |**\n"
	"**|   Left / \'A\' > (___) [ ] Brake   2s |**\n"
	"**|                _ _ _                |**\n"
	"**|     Up / \'W\' > (___) [ ] Jump    x3 |**\n"
	"**|                _ _ _                |**\n"
	"**|   Down / \'S\' > (___) [ ] Crouch  2s |**\n"
	"**|                _ _ _                |**\n"
	"**|  Enter / \'L\' > (___) [ ] Fire    x5 |**\n"
	"**|                                     |**\n"
	"**|__________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|                  _ _ _   DESTROY BIG    |\n"
	"|   You need to    (___)    OBSTACLES     |\n"
	"|   slow down if   _ _ _                  |\n"
	"|_  there are many (___)                  |\n"
	"**| objects in     _ _ _   [ ]  ___      A|\n"
	"**| front of you.  (___)   x5 _/:::\\     _|\n"
	"**|                _ _ _     /::::::\\   |**\n"
	"**| FIRE:          (___)   ~~~~~~~~~~~  |**\n"
	"**|  Enter / \'L\'   _ _ _ [ ]  _   __    |**\n"
	"**|                (___) x5 _/:\\_/::\\   |**\n"
	"**| BRAKE:         _ _ _   /::::\\::::\\  |**\n"
	"**|   Left / \'A\'   (___)  /:::::::::::\\ |**\n"
	"**|                      ~~~~~~~~~~~~~~~|**\n"
	"**|__________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|                  _ _ _  DESTROY SMALL   |\n"
	"|   Small objects  (___)    OBSTACLES     |\n"
	"|   can be easily  _ _ _                  |\n"
	"|   destroyed when (___)                  |\n"
	"|   shooting while _ _ _                  |\n"
	"|_  crouching.     (___)   [ ] __         |\n"
	"**|                _ _ _   x5 /::\\       B|\n"
	"**| FIRE:          (___)  ~~~~~~~~~      _|\n"
	"**|  Enter / \'L\'   _ _ _                |**\n"
	"**|                (___)      [ ] _     |**\n"
	"**| CROUCH:        _ _ _      x5 (_)    |**\n"
	"**|   Down / \'S\'   (___)     ~~~~~~~~   |**\n"
	"**|                                     |**\n"
	"**|__________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|                  _ _ _    JUMP OVER     |\n"
	"|   Jumping over   (___)     DITCHES      |\n"
	"|   wide ditches   _ _ _                  |\n"
	"|   is easier at   (___) _     [ ]     _  |\n"
	"|   the higher     _ _ _  \\    x3     /:  |\n"
	"|   speed.         (___)   \\_       _/::  |\n"
	"|                  _ _ _     \\_____/:::   |\n"
	"|_  JUMP:          (___)                  |\n"
	"**|     Up / \'W\'   _ _ _                 C|\n"
	"**|                (___)   __  [ ]  __   _|\n"
	"**| ACCELERATE:    _ _ _     \\ x3  /::  |**\n"
	"**|  Right / \'D\'   (___)      \\___/:::  |**\n"
	"**|                                     |**\n"
	"**|__________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|   Accelerate or  _ _ _     DESTROY      |\n"
	"|   brake in order (___)   ALIEN SHIPS    |\n"
	"|   to let your    _ _ _                  |\n"
	"|   bullets go to  (___)                  |\n"
	"|   the left or    _ _ _         __       |\n"
	"|   right.         (___)  [ ]  _/__\\_     |\n"
	"|                  _ _ _  x5  (______)    |\n"
	"|   FIRE:          (___)                  |\n"
	"|    Enter / \'L\'   _ _ _                  |\n"
	"|_                 (___)  [ ]  _\\__/_     |\n"
	"**| ACCEL. BRAKE:  _ _ _  x5  (______)   D|\n"
	"**|  Right / \'D\'   (___)        \'  \'     _|\n"
	"**|   Left / \'A\'                        |**\n"
	"**|__________________ __________________|**\n"
	"                                           ",
	" ____________________ ____________________ \n"
	"|                                         |\n"
	"|                  _ _ _  You passed the  |\n"
	"|  Gumix ABC       (___)  tutorial part!  |\n"
	"|  ~~~~~~~~~~~~~~~ _ _ _                  |\n"
	"|  Name            (___)  Feel free to    |\n"
	"|                  _ _ _  practice here   |\n"
	"|  2016-06-10      (___)  if you need so. |\n"
	"|  ~~~~~~~~~~~~~~~ _ _ _  _______________ |\n"
	"|  Date            (___)                  |\n"
	"|     __________   _ _ _  Retun to menu   |\n"
	"|   ,           |  (___)  to begin your   |\n"
	"|   |= P A S S =|. _ _ _  mission.        |\n"
	"|_  |___________|  (___)                  |\n"
	"**|                       EXIT Esc / \'Q\' E|\n"
	"**|__________________ ____________________|\n"
	"                                           ",
	" ____________________ *********************\n"
	"|                     *********************\n"
	"|                  _ _ ********************\n"
	"|                  (__) *******************\n"
	"|                  _ _ ********************\n"
	"|                  (__) *******************\n"
	"|                  _ _ ********************\n"
	"|                  (__) *******************\n"
	"|                  _ _ ********************\n"
	"|                  (__) *******************\n"
	"|                  _ _ ********************\n"
	"|                  (__) *******************\n"
	"|                  _ _ ********************\n"
	"|  (C) 2016 Gumix  (__) *******************\n"
	"|                      ********************\n"
	"|____________________ *********************\n"
	"                      *********************",
	0
};

const unsigned char book_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x80,0x81,0x81,0x81,0x81,0x81,0x81,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x83,0x80,0x80,0x80,0x83,0x83,0x83,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x83,0x83,0x83,0x83,0x83,0x83,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x73,0x73,0x83,0x73,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x83,0x83,0x83,0x83,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF5,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xD5,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF7,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xD1,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF8,0xF7,0xF7,0xF7,0xF7,0xF8,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF0,0xF0,0xF0,0xF7,0xF8,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF0,0xF8,0xF7,0xF7,0xF8,0xF0,0xF8,0xF7,0xF7,0xF8,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF0,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF8,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x91,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x93,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF7,0xF7,0xF7,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xB3,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xB2,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF0,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF7,0xF7,0xF7,0xF7,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xA2,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xA6,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x78,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0x78,0x00,
	0x78,0xF8,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x00,
	0x78,0xF8,0xF8,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF7,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF1,0xF1,0xF1,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF1,0xF1,0xF1,0xF1,0xF9,0xF9,0xF8,0xF8,0x73,0xF3,0xF8,0xF8,0xF8,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0x78,0x00,
	0x78,0xF8,0xF8,0xF8,0xF9,0xF9,0xF9,0xF9,0xF9,0xF1,0xF1,0xF1,0xF1,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x73,0xF3,0x73,0xF3,0x73,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF1,0xF1,0xF1,0xF1,0xF1,0xF8,0xF8,0xF8,0xF8,0xF7,0xF7,0xF8,0xF8,0xF8,0xF8,0xE4,0x78,0x00,
	0x08,0x08,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xE8,0x78,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x73,0x83,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x78,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
};

const char* book_color[]=
{
	(const char*)book_colordata + 0,
	(const char*)book_colordata + 748,
	(const char*)book_colordata + 1496,
	(const char*)book_colordata + 2244,
	(const char*)book_colordata + 2992,
	(const char*)book_colordata + 3740,
	(const char*)book_colordata + 4488,
	(const char*)book_colordata + 5236,
	(const char*)book_colordata + 5984,
	0
};

ASSET book=
{
	book_mono,
	book_shade,
	book_color
};

const char* boom_mono[]=
{
	"***************\n"
	"*****\\*_*/*****\n"
	"****-( _ )-****\n"
	"***************",
	"****\\**_**/****\n"
	"_**-       ,***\n"
	"**(         )*_\n"
	"***************",
	"***************\n"
	"****-**********\n"
	"***( (  _) )***\n"
	"*********-*****",
	"***************\n"
	"***************\n"
	"*****( - )*****\n"
	"***************",
	0
};

const char* boom_shade[]=
{
	"***************\n"
	"****%%%%%%%****\n"
	"***%%%   %%%***\n"
	"****%%%%%%%****",
	"***************\n"
	"**%%%%%%%%%%%**\n"
	"*%%%%%%%%%%%%%*\n"
	"**%%%%%%%%%%%**",
	"***************\n"
	"*:%%:::::::%%:*\n"
	"%%:::::::::::%%\n"
	"*:%%:::::::%%:*",
	"***** *** *****\n"
	"*.*-*\'*-*\'*-*.*\n"
	":*:*-*****-*:*:\n"
	"*+*.*.*\'*.*.*+*",
	0
};

const unsigned char boom_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x79,0x9B,0x7F,0x9B,0x7F,0x9B,0x79,0x79,0x79,0x79,0x79,0x00,
	0x70,0x70,0x70,0x9B,0xB9,0xB9,0xF9,0xF9,0xF9,0xB9,0xB9,0x1B,0x1B,0x1B,0x1B,0x00,
	0x70,0x70,0x70,0x70,0x79,0x9B,0x8F,0x1B,0x8F,0x9B,0x79,0x79,0x79,0x79,0x79,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x09,0x09,0x79,0x79,0x7B,0x7B,0x9B,0x9B,0x9B,0x7B,0x7B,0x79,0x79,0x79,0x79,0x00,
	0x0B,0x7B,0x79,0xB9,0xB9,0x9B,0x9B,0x9B,0x9B,0x9B,0xB9,0xB9,0x79,0x7B,0x7B,0x00,
	0x09,0x09,0x79,0x79,0x7B,0x7B,0x9B,0x9B,0x9B,0x7B,0x7B,0x79,0x79,0x79,0x79,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x09,0x79,0x79,0x79,0x7B,0x71,0x79,0x79,0x79,0x71,0x7B,0x79,0x79,0x79,0x79,0x00,
	0x79,0x79,0x7B,0x79,0x7B,0x7B,0x79,0x79,0x79,0x7B,0x7B,0x79,0x7B,0x79,0x79,0x00,
	0x09,0x79,0x79,0x79,0x7B,0x71,0x79,0x79,0x79,0x71,0x7B,0x79,0x79,0x79,0x79,0x00,
	0x00,0x00,0x00,0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x09,0x79,0x79,0x70,0x70,0x7B,0x7B,0x78,0x78,0x7B,0x7B,0x70,0x70,0x79,0x79,0x00,
	0x71,0x71,0x7B,0x7B,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x79,0x7B,0x7B,0x71,0x00,
	0x09,0x79,0x79,0x70,0x70,0x78,0x78,0x7B,0x7B,0x78,0x78,0x70,0x70,0x79,0x79,0x00,
};

const char* boom_color[]=
{
	(const char*)boom_colordata + 0,
	(const char*)boom_colordata + 64,
	(const char*)boom_colordata + 128,
	(const char*)boom_colordata + 192,
	0
};

ASSET boom=
{
	boom_mono,
	boom_shade,
	boom_color
};

const char* cannon_mono[]=
{
	"*******\n"
	"**%%)**\n"
	"*******",
	"***__**\n"
	"**(__)*\n"
	"*******",
	"**,--,*\n"
	"*(*()*)\n"
	"**\'--\'*",
	0
};

const char* cannon_shade[]=
{
	"*******\n"
	"**%%)**\n"
	"*******",
	"***..**\n"
	"**%%%%*\n"
	"***\'\'**",
	"**,::,*\n"
	"*(:%%:)\n"
	"**\'::\'*",
	0
};

const unsigned char cannon_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x9B,0x7B,0x7B,0x7B,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x00,0x00,0x00,0x7B,0x7B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x9B,0xB9,0xB9,0x9B,0x9B,0x00,
	0x00,0x00,0x00,0x7B,0x7B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x70,0x79,0x79,0x70,0x70,0x00,
	0x0B,0x7B,0x9B,0x9B,0x9B,0x9B,0x7B,0x00,
	0x0B,0x0B,0x70,0x79,0x79,0x70,0x70,0x00,
};

const char* cannon_color[]=
{
	(const char*)cannon_colordata + 0,
	(const char*)cannon_colordata + 24,
	(const char*)cannon_colordata + 48,
	0
};

ASSET cannon=
{
	cannon_mono,
	cannon_shade,
	cannon_color
};

const char* character_mono[]=
{
	" ___________ \n"
	" \\_________/ \n"
	" (__+++____) \n"
	" //_____/ \\\\ \n"
	" \\\\ _ _,  )/ \n"
	" //  <    \\\\ \n"
	" \\\\  -   /// \n"
	"   \\____/|   ",
	"             \n"
	"  \\_\\___/_/  \n"
	"  {:_   _:}  \n"
	". {:%\\_/%:} .\n"
	":  \\:/%\\:/  :\n"
	"%.  \\%%%/  .%\n"
	"%%._/ :%\\_.%%\n"
	"%%%%%%%%%%%%%",
	0
};

const char* character_shade[]=
{
	" ___________ \n"
	" \\_________/ \n"
	" (__+++____) \n"
	" //_____/%\\\\ \n"
	" \\\\ _ _,  )/ \n"
	" //  <    \\\\ \n"
	" \\\\  -   /// \n"
	"   \\____/|   ",
	"             \n"
	"  \\_\\___/_/  \n"
	"  {:_.%%_%}  \n"
	". {:.\\_/.%} .\n"
	":  \\:/^\\%/  :\n"
	"%.  \\___/  .%\n"
	"%%._/ %%\\_.%%\n"
	"%%%%%%%%%%%%%",
	0
};

const unsigned char character_colordata[]=
{
	0x00,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x00,
	0x00,0x09,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x09,0x09,0x00,
	0x00,0x09,0x19,0x19,0x1B,0x1B,0x1B,0x19,0x19,0x19,0x19,0x09,0x09,0x00,
	0x00,0x0C,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x38,0x0C,0x0C,0x0C,0x00,
	0x00,0x04,0x30,0x30,0x50,0x30,0x50,0x30,0x30,0x30,0x30,0x04,0x04,0x00,
	0x00,0x0C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x0C,0x0C,0x00,
	0x00,0x04,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x04,0x04,0x00,
	0x07,0x07,0x07,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x00,
	0x09,0x09,0x01,0x0D,0x01,0x0D,0x0D,0x01,0x01,0x0D,0x01,0x01,0x01,0x00,
	0x09,0x09,0x0D,0x8D,0x87,0x8D,0x80,0x08,0x07,0x08,0x05,0x05,0x05,0x00,
	0x06,0x06,0x0D,0x8D,0x0E,0x07,0x87,0x07,0x0E,0x08,0x05,0x05,0x06,0x00,
	0x0E,0x0E,0x0E,0x0D,0x8D,0x07,0x08,0x07,0x08,0x05,0x05,0x05,0x0E,0x00,
	0x0E,0x06,0x06,0x06,0x0D,0x07,0x07,0x07,0x05,0x05,0x05,0x06,0x0E,0x00,
	0x0E,0x0E,0x06,0x0D,0x0D,0x8D,0x80,0x08,0x05,0x05,0x06,0x0E,0x0E,0x00,
	0x06,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x06,0x00,
};

const char* character_color[]=
{
	(const char*)character_colordata + 0,
	(const char*)character_colordata + 112,
	0
};

ASSET character=
{
	character_mono,
	character_shade,
	character_color
};

const char* chassis_mono[]=
{
	"***************\n"
	"**__.______****\n"
	"*/_x_x_x_\\_\\_**\n"
	"*\\__  __   __\\*\n"
	"****\\/**\\_/****",
	0
};

const char* chassis_shade[]=
{
	"***************\n"
	"**__.______****\n"
	"*/%x%x%x%\\%\\_**\n"
	"*\\%%%%%%%%%%%\\*\n"
	"****\\/**\\%/****",
	0
};

const unsigned char chassis_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x71,0x97,0x9E,0x97,0x9E,0x97,0x9E,0x97,0x17,0x07,0x70,0x70,0x70,0x70,0x00,
	0x70,0x71,0x97,0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x97,0x71,0x71,0x00,
	0x70,0x70,0x70,0x70,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x00,
};

const char* chassis_color[]=
{
	(const char*)chassis_colordata + 0,
	0
};

ASSET chassis=
{
	chassis_mono,
	chassis_shade,
	chassis_color
};

const char* city_mono[]=
{
	"******************_____******************************************_______*********************_____**************************************************************\n"
	"****************_|_____|_*******___****************************_|_______|_*****************_|_____|_********************_***************************************\n"
	"***************/         \\****_|___|_****___|_______**********/           \\***************/         \\******************/ \\***********.**************************\n"
	"***************\\_________/***(_______)**/___________\\*********\\___________/****_____|_****\\_________/*****_______*****/  .\\**********|**************************\n"
	"****************|  .....|*****_|___|_**/             \\*********|_________|***_|_______|_***| ......|****_|_______|_***|  .|*****_____|_*******___***************\n"
	"********.*******|_______|****(_______)*\\_____________/*****_****\\_______/***/           \\**|_______|***/           \\**|  .|***_|_______|_***_|___|_*************\n"
	"****.***|*******/_______\\******|...|****\\___________/*****/ \\***__|___|__***\\___________/**/_______\\***\\___________/**|  .|**/           \\*(_______)***.***.****\n"
	"***_|___|_*****/         \\****_|___|_***| ......____|****/  .\\*(_________)***|_________|**/         \\***|_________|***|  .|**\\___________/**_|___|_****|___|****\n"
	"*_|_______|_***\\_________/***(_______)**|   .../_____\\***|  .|**__|___|__***/           \\*\\_________/****\\_______/****|  .|***| ........|**(_______)**/_____\\***\n"
	"/           \\***\\_______/*****_|___|_***|    ./       \\**|  .|*(_________)**\\___________/**\\_______/*****__|___|__****|  .|***|   ......|****|...|***/       \\**\n"
	"\\___________/***|   ....|****(_______)**|     \\_______/**|  .|****| ..|******| ........|***|   ....|****(_________)***|  .|***|       ..|****| ..|***\\_______/**\n"
	"*: ........:****:    ...:******: ..:****:      \\_____/***:  .:****:  .:******:   ......|***:    ...:*******: ..:******:  .:***:        .:****:  .:****: ....:***\n"
	"*:  .......:****:      .:******:  .:****:        ...:****.  .:****:  .:******:        .:***:      .:*******:  .:******:  .:***:        .:****:  .:****:  ...:***\n"
	"*.        .:****.      .:******.  .:****.         ..:****.  .:****.  .:******.        .:***.      .:*******.  .:******.  .:***.        .:****.  .:****.   ..:***\n"
	"*          :****        :******    :****            :****    .****    :******          :***        :*******    :******    :***          :****    :****      :***\n"
	"*          .****        .******    .****            .****    .****    .******          .***        .*******    .******    .***          .****    .****      .***",
	0
};

const char* city_shade[]=
{
	"******************_____******************************************_______*********************_____**************************************************************\n"
	"****************_|_____|_*******___****************************_|_______|_*****************_|_____|_********************_***************************************\n"
	"***************/..       \\****_|___|_****___|_______**********/..         \\***************/:.       \\******************/ \\***********.**************************\n"
	"***************\\_________/***(_______)**/___________\\*********\\___________/****_____|_****\\_________/*****_______*****/.  \\**********|**************************\n"
	"****************|..  ...|*****_|___|_**/...          \\*********|_________|***_|_______|_***|..  ...|****_|_______|_***|:  |*****_____|_*******___***************\n"
	"********.*******|_______|****(_______)*\\_____________/*****_****\\_______/***/..         \\**|_______|***/..         \\**|:  |***_|_______|_***_|___|_*************\n"
	"****.***|*******/_______\\******|...|****\\___________/*****/ \\***__|___|__***\\___________/**/_______\\***\\___________/**|:  |**/..         \\*(_______)***.***.****\n"
	"***_|___|_*****/...      \\****_|___|_***|..  ...____|****/.  \\*(_________)***|_________|**/...      \\***|_________|***|:  |**\\___________/**_|___|_****|___|****\n"
	"*_|_______|_***\\_________/***(_______)**|...  ./__ __\\***|.  |**__|___|__***/...        \\*\\_________/****\\_______/****|:  |***|..  .....|**(_______)**/_____\\***\n"
	"/..         \\***\\_______/*****_|___|_***|.... /...    \\**|.  |*(_________)**\\___________/**\\_______/*****__|___|__****|:  |***|..  .....| ***|. .|***/...    \\**\n"
	"\\___________/***|..  ...|****(_______)**|.....\\_______/**|.  |****|. .|******|...  ....|***|..  ...|****(_________)***|:  |***|..       | ***|. .|***\\_______/**\n"
	"*:..  .....|****:...  ..|******: ..|****:...   \\_____/***:.  :****:. .|******:....  ...|***:...  ..|*******: ..|******:.  |***:.        |****:.  | ***: ....|***\n"
	"*:...  ....:****:       :******:   :****:        ...:****:   :****:   :******:         :***:       :*******:  .:******:   :***:         :****:   :****:  ...:***\n"
	"*.         :****.       :******.   :****.         ..:****.   :****.   :******.         :***.       :*******.   :******.   :***.         :****.   :****.   ..:***\n"
	"*          :****        :******    :****            :****    :****    :******          :***        :*******    :******    :***          :****    :****      :***\n"
	"*          .****        .******    .****            .****    .****    .******          .***        .*******    .******    .***          .****    .****      .***",
	0
};

const unsigned char city_colordata[]=
{
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x74,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x70,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x78,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x74,0x74,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x00,
	0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x78,0x78,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x74,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x00,
	0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x00,
	0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x78,0x78,0x78,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
};

const char* city_color[]=
{
	(const char*)city_colordata + 0,
	0
};

ASSET city=
{
	city_mono,
	city_shade,
	city_color
};

const char* co_boom_mono[]=
{
	"***_***\n"
	"**(_)**\n"
	"****** ",
	"**,-,**\n"
	"*(   )*\n"
	"**\'-\'**",
	"*\'* *\'*\n"
	"(     )\n"
	"*,* *,*",
	"**,-,**\n"
	"*(   )*\n"
	"**\'-\'**",
	"*******\n"
	"**;*;**\n"
	"*******",
	0
};

const char* co_boom_shade[]=
{
	"***.***\n"
	"**%%%**\n"
	"***\'***",
	"**%:%**\n"
	"*(:%:)*\n"
	"**%:%**",
	"**%%%**\n"
	"%%:%:%%\n"
	"**%%%**",
	"**,:,**\n"
	":::::::\n"
	"**\':\'**",
	"***:***\n"
	"*-***-*\n"
	"***:***",
	0
};

const unsigned char co_boom_colordata[]=
{
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x00,
	0x70,0x70,0x1B,0xB1,0x1B,0x1B,0x1B,0x00,
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x73,0x71,0x73,0x73,0x73,0x00,
	0x0B,0x7B,0x1B,0x9B,0x1B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x73,0x71,0x73,0x73,0x73,0x00,
	0x03,0x03,0x7F,0x1B,0x7F,0x7F,0x7F,0x00,
	0x7B,0xB1,0x9B,0x1B,0x9B,0xB1,0x7B,0x00,
	0x03,0x03,0x7F,0x1B,0x7F,0x7F,0x7F,0x00,
	0x0F,0x0F,0x71,0x79,0x71,0x71,0x71,0x00,
	0x7B,0x79,0x70,0x71,0x70,0x79,0x7B,0x00,
	0x0F,0x0F,0x71,0x79,0x71,0x71,0x71,0x00,
	0x01,0x01,0x01,0x70,0x70,0x70,0x70,0x00,
	0x0B,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x01,0x01,0x01,0x70,0x70,0x70,0x70,0x00,
};

const char* co_boom_color[]=
{
	(const char*)co_boom_colordata + 0,
	(const char*)co_boom_colordata + 24,
	(const char*)co_boom_colordata + 48,
	(const char*)co_boom_colordata + 72,
	(const char*)co_boom_colordata + 96,
	0
};

ASSET co_boom=
{
	co_boom_mono,
	co_boom_shade,
	co_boom_color
};

const char* creature_mono[]=
{
	"*********\n"
	"*********\n"
	"\\_\\___/_/\n"
	"{:..    }\n"
	"*\\_.. _/*\n"
	"__/   \\__",
	"*********\n"
	"\\_\\___/_/\n"
	"{:..    }\n"
	"*\\:.   /*\n"
	"**\\:. /**\n"
	"__/   \\__",
	"\\_\\___/_/\n"
	"{:..    }\n"
	"{::.    }\n"
	"*\\:.   /*\n"
	"**\\:. /**\n"
	"__/   \\__",
	"*********\n"
	"*********\n"
	"*********\n"
	"**_.%._**\n"
	"**\\:. /**\n"
	"__/   \\__",
	0
};

const char* creature_shade[]=
{
	"*********\n"
	"*********\n"
	"\\_\\___/_/\n"
	"{%%% %%%}\n"
	"*\\%%%%%/*\n"
	"__/%%%\\__",
	"*********\n"
	"\\_\\___/_/\n"
	"{%%% %%%}\n"
	"*\\%% %%/*\n"
	"**\\%%%/**\n"
	"__/%%%\\__",
	"\\_\\___/_/\n"
	"{%%% %%%}\n"
	"{%%% %%%}\n"
	"*\\%.%%%/*\n"
	"**\\%%%/**\n"
	"__/%%%\\__",
	"*********\n"
	"*********\n"
	"*********\n"
	"**_.%._**\n"
	"**\\%%%/**\n"
	"__/%%%\\__",
	0
};

const unsigned char creature_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x71,0x7D,0x71,0x7D,0x7D,0x7D,0x71,0x7D,0x71,0x00,
	0x7D,0x6D,0x6D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x00,
	0x70,0x7D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x75,0x00,
	0x7D,0x7D,0x7D,0x6D,0x65,0x63,0x75,0x73,0x73,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x71,0x7D,0x71,0x7D,0x7D,0x7D,0x71,0x7D,0x71,0x00,
	0x7D,0x6D,0x6D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x00,
	0x05,0x7D,0x6D,0x6D,0x6D,0x65,0x65,0x75,0x75,0x00,
	0x05,0x05,0x7D,0x6D,0x65,0x65,0x75,0x75,0x75,0x00,
	0x7D,0x7D,0x7D,0x6D,0x65,0x63,0x75,0x75,0x75,0x00,
	0x71,0x7D,0x71,0x7D,0x7D,0x71,0x71,0x7D,0x71,0x00,
	0x7D,0x6D,0x6D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x00,
	0x7D,0x6D,0x6D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x00,
	0x05,0x7D,0x6D,0x6D,0x65,0x65,0x65,0x75,0x75,0x00,
	0x05,0x05,0x7D,0x6D,0x65,0x65,0x75,0x75,0x75,0x00,
	0x7D,0x7D,0x7D,0x6D,0x65,0x65,0x75,0x75,0x75,0x00,
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x00,
	0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x00,
	0x05,0x05,0x71,0x79,0x71,0x79,0x71,0x71,0x71,0x00,
	0x05,0x05,0x7D,0x6D,0x65,0x65,0x70,0x70,0x70,0x00,
	0x7D,0x7D,0x7D,0x6D,0x65,0x65,0x75,0x75,0x75,0x00,
};

const char* creature_color[]=
{
	(const char*)creature_colordata + 0,
	(const char*)creature_colordata + 60,
	(const char*)creature_colordata + 120,
	(const char*)creature_colordata + 180,
	0
};

ASSET creature=
{
	creature_mono,
	creature_shade,
	creature_color
};

const char* dialog_left_mono[]=
{
	"*___________________________________**************************************\n"
	"|  _____________                    |*************************************\n"
	"| |             |                   |____________________________________ \n"
	"| |             | _____________________________________________________  |\n"
	"| |             ||                                                   _ | |\n"
	"| |             ||                                                  | || |\n"
	"| |             ||                                                  | || |\n"
	"| |             ||                                                  | || |\n"
	"| |             ||                                                  | || |\n"
	"| |             ||                                                  |_|| |\n"
	"| |_____________||_____________________________________________________| |\n"
	"|____________________________________                                    |\n"
	"*************************************|  ---------------|---------------  |\n"
	"*************************************|___________________________________|",
	0
};

const char* dialog_left_shade[]=
{
	"*___________________________________**************************************\n"
	"*  _____________  ________________  **************************************\n"
	"*                                   _____________________________________*\n"
	"*                 _____________________________________________________  *\n"
	"*                                                                    _   *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                                    _   *\n"
	"*  _____________  _____________________________________________________  *\n"
	"*_____________________________________  _______________________________  *\n"
	"**************************************   --------------|--------------   *\n"
	"**************************************___________________________________*",
	0
};

const unsigned char dialog_left_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x7F,0x7F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x70,0x80,0x70,0x70,0x70,0x00,
	0x0F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x77,0x77,0x77,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
};

const char* dialog_left_color[]=
{
	(const char*)dialog_left_colordata + 0,
	0
};

ASSET dialog_left=
{
	dialog_left_mono,
	dialog_left_shade,
	dialog_left_color
};

const char* dialog_right_mono[]=
{
	"*___________________________________**************************************\n"
	"|                                   |*************************************\n"
	"|  ---------------|---------------  |____________________________________*\n"
	"|  _____________________________________________________  _____________  |\n"
	"| |                                                   _ ||             | |\n"
	"| |                                                  | |||             | |\n"
	"| |                                                  | |||             | |\n"
	"| |                                                  | |||             | |\n"
	"| |                                                  | |||             | |\n"
	"| |                                                  |_|||             | |\n"
	"| |_____________________________________________________||             | |\n"
	"|____________________________________                    |             | |\n"
	"*************************************|                   |_____________| |\n"
	"*************************************|___________________________________|",
	0
};

const char* dialog_right_shade[]=
{
	"*___________________________________**************************************\n"
	"*  _______________________________  **************************************\n"
	"*   --------------|--------------   _____________________________________*\n"
	"*  _____________________________________________________  _____________  *\n"
	"*                                                     _                  *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                                        *\n"
	"*                                                     _                  *\n"
	"*  _____________________________________________________                 *\n"
	"*_____________________________________  ________________                 *\n"
	"**************************************                    _____________  *\n"
	"**************************************___________________________________*",
	0
};

const unsigned char dialog_right_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x7F,0x7F,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x0F,0x7F,0x7F,0x8F,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x77,0x77,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x7F,0x7F,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x70,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x70,0x70,0x00,
	0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x7A,0x7A,0x7A,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x00,
};

const char* dialog_right_color[]=
{
	(const char*)dialog_right_colordata + 0,
	0
};

ASSET dialog_right=
{
	dialog_right_mono,
	dialog_right_shade,
	dialog_right_color
};

const char* digits_large_mono[]=
{
	"**__**\n"
	"*_%%_*\n"
	" %  % \n"
	" %  % \n"
	" %__% \n"
	"* %% *",
	"***_**\n"
	"**_% *\n"
	"* %% *\n"
	"** % *\n"
	"** % *\n"
	"** % *",
	"*___**\n"
	" %%%_*\n"
	"**__% \n"
	"*_%% *\n"
	" %___*\n"
	" %%%% ",
	"*___**\n"
	" %%%_*\n"
	"**__% \n"
	"* %% *\n"
	"*___% \n"
	" %%% *",
	"***_**\n"
	"**_% *\n"
	"*_%*_*\n"
	" %__% \n"
	" %%%% \n"
	"*** % ",
	"*___**\n"
	" %%% *\n"
	" %__**\n"
	" %%%_*\n"
	"*___% \n"
	" %%% *",
	"**__**\n"
	"*_%% *\n"
	" %__**\n"
	" %%%_*\n"
	" %__% \n"
	"* %% *",
	"*____*\n"
	" %%%% \n"
	"***_% \n"
	"**_% *\n"
	"* % **\n"
	"* % **",
	"**__**\n"
	"*_%%_*\n"
	" %__% \n"
	"*_%%_*\n"
	" %__% \n"
	"* %% *",
	"**__**\n"
	"*_%%_*\n"
	" %__% \n"
	"**%%% \n"
	"**__% \n"
	"* %% *",
	"******\n"
	"**__**\n"
	"* %% *\n"
	"**__**\n"
	"* %% *\n"
	"******",
	"******\n"
	"******\n"
	"******\n"
	"******\n"
	"**__**\n"
	"* %% *",
	"******\n"
	"*_**_*\n"
	" % _% \n"
	"**_% *\n"
	"*_%*_*\n"
	" %  % ",
	0
};

const char* digits_large_shade[]=
{
	"**__**\n"
	"*_  _*\n"
	"      \n"
	"      \n"
	" ____ \n"
	"* __ *",
	"***_**\n"
	"**_  *\n"
	"* _  *\n"
	"**   *\n"
	"**   *\n"
	"** _ *",
	"*___**\n"
	" ____*\n"
	"**___ \n"
	"*___ *\n"
	"  ___*\n"
	" ____ ",
	"*___**\n"
	" ____*\n"
	"**___ \n"
	"* __ *\n"
	"*____ \n"
	" ___ *",
	"***_**\n"
	"**__ *\n"
	"*__*_*\n"
	"  __  \n"
	" ___  \n"
	"*** _ ",
	"*___**\n"
	"  __ *\n"
	"  __**\n"
	" ____*\n"
	"*____ \n"
	" ___ *",
	"**__**\n"
	"*___**\n"
	"  __**\n"
	"  ___*\n"
	" ____ \n"
	"* __ *",
	"*____*\n"
	" ___  \n"
	"***__ \n"
	"**_ **\n"
	"*   **\n"
	"* _ **",
	"**__**\n"
	"*____*\n"
	" ____ \n"
	"*____*\n"
	" ____ \n"
	"* __ *",
	"**__**\n"
	"*____*\n"
	" ___  \n"
	"* __  \n"
	"**___ \n"
	"* __ *",
	"******\n"
	"**__**\n"
	"* __ *\n"
	"**__**\n"
	"* __ *\n"
	"******",
	"******\n"
	"******\n"
	"******\n"
	"******\n"
	"**__**\n"
	"* __ *",
	"******\n"
	"*_**_*\n"
	" _ __ \n"
	"**__ *\n"
	"*__ _*\n"
	" _  _ ",
	0
};

const unsigned char digits_large_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0xFF,0xFF,0x0F,0x0F,0x00,
	0x0F,0xFF,0x0F,0x0F,0xFF,0x0F,0x00,
	0x0F,0xFF,0x0F,0x0F,0xFF,0x0F,0x00,
	0x0F,0xF8,0x0F,0x0F,0xF8,0x08,0x00,
	0x0F,0x0F,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0xFF,0x0F,0x0F,0x00,
	0x0F,0x0F,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0xFF,0x0F,0x0F,0x00,
	0x08,0x08,0x08,0xF8,0x08,0x08,0x00,
	0x08,0x08,0x08,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0xF8,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0x08,0x0F,0x0F,0xF8,0x08,0x00,
	0x0F,0x0F,0xF8,0xF8,0x08,0x08,0x00,
	0x08,0xF8,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0xF8,0xF8,0xF8,0xF8,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0xF8,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0x08,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0xF8,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0xF8,0x08,0x08,0x00,
	0x08,0x0F,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0xF8,0x0F,0x0F,0xFF,0x0F,0x00,
	0x08,0xF8,0xF8,0xF8,0xF8,0x08,0x00,
	0x08,0x08,0x08,0x08,0xF8,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0xF8,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0xFF,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0xF8,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0x0F,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0xF8,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x0F,0xF8,0xF8,0xF8,0xF8,0x00,
	0x0F,0xFF,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0xFF,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0xF8,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0xF8,0xF8,0xF8,0xF8,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0xF8,0x08,0x00,
	0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0x00,
	0x08,0x08,0xF8,0x08,0x08,0x08,0x00,
	0x08,0x08,0xF8,0x08,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x0F,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0xF8,0x0F,0x0F,0xF8,0x08,0x00,
	0x0F,0x0F,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0xF8,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0xF8,0xF8,0x0F,0x0F,0x00,
	0x08,0xF8,0x0F,0x0F,0xFF,0x0F,0x00,
	0x0F,0x0F,0xF8,0xF8,0xF8,0x08,0x00,
	0x08,0x08,0x0F,0x0F,0xF8,0x08,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0xF8,0xF8,0x08,0x08,0x00,
	0x08,0x08,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x08,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x08,0xF8,0x08,0x0F,0xF8,0x08,0x00,
	0x0F,0x0F,0x0F,0xF8,0x08,0x08,0x00,
	0x0F,0x0F,0xF8,0x08,0x0F,0x0F,0x00,
	0x08,0xF8,0x08,0x08,0xF8,0x08,0x00,
};

const char* digits_large_color[]=
{
	(const char*)digits_large_colordata + 0,
	(const char*)digits_large_colordata + 42,
	(const char*)digits_large_colordata + 84,
	(const char*)digits_large_colordata + 126,
	(const char*)digits_large_colordata + 168,
	(const char*)digits_large_colordata + 210,
	(const char*)digits_large_colordata + 252,
	(const char*)digits_large_colordata + 294,
	(const char*)digits_large_colordata + 336,
	(const char*)digits_large_colordata + 378,
	(const char*)digits_large_colordata + 420,
	(const char*)digits_large_colordata + 462,
	(const char*)digits_large_colordata + 504,
	0
};

ASSET digits_large=
{
	digits_large_mono,
	digits_large_shade,
	digits_large_color
};

const char* drone_mono[]=
{
	"*_\\__/_*\n"
	"(______)\n"
	"**\'**\'**",
	0
};

const char* drone_shade[]=
{
	"*_\\__/_*\n"
	"(%____%)\n"
	"**\'**\'**",
	0
};

const unsigned char drone_colordata[]=
{
	0x70,0x7F,0x70,0x7F,0x7F,0x70,0x7F,0x7F,0x00,
	0x7F,0xD7,0xD0,0xD0,0xD0,0xD0,0xD8,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
};

const char* drone_color[]=
{
	(const char*)drone_colordata + 0,
	0
};

ASSET drone=
{
	drone_mono,
	drone_shade,
	drone_color
};

const char* dunes_mono[]=
{
	"********************_*******************************************************************************************************************************************\n"
	"**********_________/.\\___***************************************************************************************************************************************\n"
	"***______/:. .       . .:\\___*****************************************************************************************________**********************************\n"
	"__/:. .                  . .:\\_____*****************_**************************************************************__/:.    .:\\__***************************____\n"
	"                               . .:\\____***********/.\\________***************************************************_/:.        . .:\\__***************________/:. .\n"
	"                                    . .:\\_________/.    . . .:\\____***********************__________**********__/:. .           . .:\\_____________/:. . . .     \n"
	"                                        . . ..... .            . .:\\_____**************__/:.      .:\\________/:. .                  . . ....... . .             \n"
	"                                             . .                     . .:\\____________/:. .         . ....... .                          . ... .                \n"
	"                                                                             . . .                     . . .                                                    \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                ",
	0
};

const char* dunes_shade[]=
{
	"********************_*******************************************************************************************************************************************\n"
	"**********_________/.\\___***************************************************************************************************************************************\n"
	"***______/:. .       . .:\\___*****************************************************************************************________**********************************\n"
	"__/:. .                  . .:\\_____*****************_**************************************************************__/:.    .:\\__***************************____\n"
	"                               . .:\\____***********/.\\________***************************************************_/:.        . .:\\__***************________/:. .\n"
	"                                    . .:\\_________/.    . . .:\\____***********************__________**********__/:. .           . .:\\_____________/:. . . .     \n"
	"                                        . . ..... .            . .:\\_____**************__/:.      .:\\________/:. .                  . . ....... . .             \n"
	"                                             . .                     . .:\\____________/:. .         . ....... .                          . ... .                \n"
	"                                                                             . . .                     . . .                                                    \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                \n"
	"                                                                                                                                                                ",
	0
};

const unsigned char dunes_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
};

const char* dunes_color[]=
{
	(const char*)dunes_colordata + 0,
	0
};

ASSET dunes=
{
	dunes_mono,
	dunes_shade,
	dunes_color
};

const char* flame1_mono[]=
{
	"**::**\n"
	"**: :*\n"
	"**   :\n"
	"**:::*\n"
	"*::***\n"
	"*: :**\n"
	"*:  :*\n"
	"*:::**\n"
	"::****\n"
	": :***\n"
	"   :**\n"
	"*::***\n"
	"*::***\n"
	"*: :**\n"
	"*   :*\n"
	"**::**",
	0
};

const char* flame1_shade[]=
{
	"**%%**\n"
	"**%%%*\n"
	"**% %%\n"
	"**%%%*\n"
	"*%%***\n"
	"*%%%**\n"
	"*% %%*\n"
	"*%%%**\n"
	"%%****\n"
	"%%%***\n"
	"% %%**\n"
	"*%%***\n"
	"*%%***\n"
	"*%%%**\n"
	"*% %%*\n"
	"**%%**",
	0
};

const unsigned char flame1_colordata[]=
{
	0x07,0x07,0x01,0x1B,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0x1B,0x10,0x10,0x00,
	0x07,0x07,0x1B,0xBB,0x1B,0x1B,0x00,
	0x07,0x07,0x10,0x1B,0x1B,0x1B,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0x1B,0x10,0x10,0x10,0x00,
	0x07,0x01,0xB1,0x1B,0x1B,0x1B,0x00,
	0x07,0x10,0x1B,0x1B,0x1B,0x1B,0x00,
	0x01,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,
	0x1B,0x1B,0x10,0x10,0x10,0x10,0x00,
	0x1B,0xBB,0x1B,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0x1B,0x10,0x10,0x10,0x00,
	0x07,0x1B,0xBB,0x1B,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0x1B,0x1B,0x1B,0x00,
};

const char* flame1_color[]=
{
	(const char*)flame1_colordata + 0,
	0
};

ASSET flame1=
{
	flame1_mono,
	flame1_shade,
	flame1_color
};

const char* flame1_mask_mono[]=
{
	"*%**\n"
	"%%%*\n"
	"%#%%\n"
	"####\n"
	"####\n"
	"*##*",
	0
};

ASSET flame1_mask=
{
	flame1_mask_mono,
	flame1_mask_mono,
	0
};

const char* flame2_mono[]=
{
	"*:  *\n"
	"*:::*\n"
	"***:*\n"
	"**:::\n"
	"**:  \n"
	"**::*\n"
	"**:**\n"
	"*:::*\n"
	"*:  *\n"
	"*::**\n"
	"*:***\n"
	":::**\n"
	":  **\n"
	":::**\n"
	"**:**\n"
	"*:::*",
	0
};

const char* flame2_shade[]=
{
	"*%% *\n"
	"*%%%*\n"
	"***%*\n"
	"**%%%\n"
	"**%% \n"
	"**%%*\n"
	"**%**\n"
	"*%%%*\n"
	"*%% *\n"
	"*%%**\n"
	"*%***\n"
	"%%%**\n"
	"%% **\n"
	"%%%**\n"
	"**%**\n"
	"*%%%*",
	0
};

const unsigned char flame2_colordata[]=
{
	0x07,0xB1,0x1B,0x1B,0x1B,0x00,
	0x07,0x0B,0x1B,0x01,0x01,0x00,
	0x07,0x07,0x07,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0xB1,0x10,0x00,
	0x07,0x07,0xB1,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0xB1,0x10,0x10,0x00,
	0x07,0xB1,0x1B,0x1B,0x1B,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0x1B,0x1B,0x1B,0x00,
	0x1B,0xB1,0x10,0x10,0x10,0x00,
	0xB1,0x1B,0x1B,0x1B,0x1B,0x00,
	0x0B,0x1B,0x01,0x01,0x01,0x00,
	0x07,0x07,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0xB1,0x10,0x10,0x00,
};

const char* flame2_color[]=
{
	(const char*)flame2_colordata + 0,
	0
};

ASSET flame2=
{
	flame2_mono,
	flame2_shade,
	flame2_color
};

const char* flame2_mask_mono[]=
{
	"*%*\n"
	"%%%\n"
	"%#%\n"
	"###\n"
	"##%",
	0
};

ASSET flame2_mask=
{
	flame2_mask_mono,
	flame2_mask_mono,
	0
};

const char* flame3_mono[]=
{
	"**::*\n"
	"**: :\n"
	"*** :\n"
	"**::*\n"
	"*::**\n"
	"*: :*\n"
	"** :*\n"
	"*::**\n"
	"::***\n"
	": :**\n"
	"* :**\n"
	"*::**\n"
	"*::**\n"
	"*: :*\n"
	"** :*\n"
	"**::*",
	0
};

const char* flame3_shade[]=
{
	"**%%*\n"
	"**%%%\n"
	"**% %\n"
	"**%%*\n"
	"*%%**\n"
	"*%%%*\n"
	"*% %*\n"
	"*%%**\n"
	"%%***\n"
	"%%%**\n"
	"% %**\n"
	"*%%**\n"
	"*%%**\n"
	"*%%%*\n"
	"*% %*\n"
	"**%%*",
	0
};

const unsigned char flame3_colordata[]=
{
	0x07,0x07,0x01,0x1B,0x1B,0x00,
	0x07,0x07,0x0B,0x1B,0x01,0x00,
	0x07,0x07,0x1B,0xBB,0x1B,0x00,
	0x07,0x07,0x01,0x1B,0x1B,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x00,
	0x07,0x0B,0x1B,0x01,0x01,0x00,
	0x07,0x1B,0xBB,0x1B,0x1B,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x00,
	0x01,0x1B,0x1B,0x1B,0x1B,0x00,
	0x0B,0x1B,0x01,0x01,0x01,0x00,
	0x1B,0xBB,0x1B,0x1B,0x1B,0x00,
	0x07,0x1B,0x01,0x01,0x01,0x00,
	0x07,0x01,0x1B,0x1B,0x1B,0x00,
	0x07,0x0B,0x1B,0x01,0x01,0x00,
	0x07,0x1B,0xBB,0x1B,0x1B,0x00,
	0x07,0x07,0x1B,0x01,0x01,0x00,
};

const char* flame3_color[]=
{
	(const char*)flame3_colordata + 0,
	0
};

ASSET flame3=
{
	flame3_mono,
	flame3_shade,
	flame3_color
};

const char* flame3_mask_mono[]=
{
	"*%*\n"
	"%%%\n"
	"%#%\n"
	"%#%",
	0
};

ASSET flame3_mask=
{
	flame3_mask_mono,
	flame3_mask_mono,
	0
};

const char* fly_boom1_mono[]=
{
	"*******\n"
	"***_***\n"
	"**(_)**\n"
	"*******",
	"*******\n"
	"*\\,-,/*\n"
	")*   *(\n"
	"*/\'-\'\\*",
	"***_***\n"
	"*(   )*\n"
	"(     )\n"
	"*( _ )*",
	"*******\n"
	"**,-,**\n"
	"*(   )*\n"
	"**\'-\'**",
	0
};

const char* fly_boom1_shade[]=
{
	"*******\n"
	"***.***\n"
	"**%%%**\n"
	"***\'***",
	"*******\n"
	"**%:%**\n"
	"*(:%:)*\n"
	"**%:%**",
	"*******\n"
	"**%%%**\n"
	"%%:%:%%\n"
	"**%%%**",
	"*******\n"
	"**,:,**\n"
	":::::::\n"
	"**\':\'**",
	0
};

const unsigned char fly_boom1_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x00,
	0x70,0x70,0x1B,0xB1,0x1B,0x1B,0x1B,0x00,
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0B,0x0B,0x73,0x71,0x73,0x73,0x73,0x00,
	0x0B,0x7B,0x1B,0x9B,0x1B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x73,0x71,0x73,0x73,0x73,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x03,0x03,0x7F,0x1B,0x7F,0x7F,0x7F,0x00,
	0x7B,0xB1,0x9B,0x1B,0x9B,0xB1,0x7B,0x00,
	0x03,0x03,0x7F,0x1B,0x7F,0x7F,0x7F,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0F,0x0F,0x71,0x79,0x71,0x71,0x71,0x00,
	0x7B,0x79,0x70,0x71,0x70,0x79,0x7B,0x00,
	0x0F,0x0F,0x71,0x79,0x71,0x71,0x71,0x00,
};

const char* fly_boom1_color[]=
{
	(const char*)fly_boom1_colordata + 0,
	(const char*)fly_boom1_colordata + 32,
	(const char*)fly_boom1_colordata + 64,
	(const char*)fly_boom1_colordata + 96,
	0
};

ASSET fly_boom1=
{
	fly_boom1_mono,
	fly_boom1_shade,
	fly_boom1_color
};

const char* fly_boom2_mono[]=
{
	"***__***\n"
	"**(__)**\n"
	"********",
	"**\\  /**\n"
	"*)    (*\n"
	"**/  \\**",
	"*_(  )_*\n"
	"(_    _)\n"
	"* (  ) *",
	"**,--,**\n"
	"*(    )*\n"
	"**\'--\'**",
	0
};

const char* fly_boom2_shade[]=
{
	"***..***\n"
	"***%%***\n"
	"***\'\'***",
	"**%::%**\n"
	"*(:%%:)*\n"
	"**%::%**",
	"**%%%%**\n"
	"%%:%%:%%\n"
	"**%%%%**",
	"**,::,**\n"
	"::::::::\n"
	"**\'::\'**",
	0
};

const unsigned char fly_boom2_colordata[]=
{
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x7B,0x00,
	0x70,0x70,0x70,0xB1,0xB1,0xB1,0xB1,0xB1,0x00,
	0x70,0x70,0x70,0x7B,0x7B,0x7B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x73,0x71,0x71,0x73,0x73,0x73,0x00,
	0x01,0x7B,0x1B,0x9B,0x9B,0x1B,0x7B,0x7B,0x00,
	0x0B,0x0B,0x73,0x71,0x71,0x73,0x73,0x73,0x00,
	0x03,0x03,0x7F,0x1B,0x9B,0x7F,0x7F,0x7F,0x00,
	0x7B,0xB1,0x9B,0x1B,0x1B,0x9B,0xB1,0x7B,0x00,
	0x03,0x03,0x7F,0x9B,0x1B,0x7F,0x7F,0x7F,0x00,
	0x0F,0x0F,0x71,0x70,0x79,0x71,0x71,0x71,0x00,
	0x7B,0x79,0x70,0x71,0x71,0x70,0x79,0x7B,0x00,
	0x0F,0x0F,0x71,0x79,0x70,0x71,0x71,0x71,0x00,
};

const char* fly_boom2_color[]=
{
	(const char*)fly_boom2_colordata + 0,
	(const char*)fly_boom2_colordata + 27,
	(const char*)fly_boom2_colordata + 54,
	(const char*)fly_boom2_colordata + 81,
	0
};

ASSET fly_boom2=
{
	fly_boom2_mono,
	fly_boom2_shade,
	fly_boom2_color
};

const char* game_over_bk_mono[]=
{
	"*************.*.*.*.*.*.*.***********************************************************************************.*.*.*.*.*.*.*.*.**********************************\n"
	"******.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*************************************************.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*********\n"
	"*.*.*.*.*.*.*.*. . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.***********.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*. . . . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.\n"
	".*.*.*.*. . . . . . . . . . . . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*.*.*.*.*\n"
	"*.*. . . . . . . . . . . . . . . . . . . . . . .*.*.*.*.*.*.*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*.\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . .           . . . . . . . . . . . . . . . . . . .         . . . . . . . .       . . . . . . . . . . . . . .               . . .     . \n"
	" . . . . . . .         . . . . . .             . . . . . .         . . .             . . . .                 . . . . . . . . . . .           . . . . . . . . . .\n"
	". . .                 . . . . . . . .             . . .                       . .     . .                       . . . . . . .         . . . . . . . . . . . . . \n"
	"                                                     .       . . .         . . .     . .     . . . . .               . .                       . . . . . . .    \n"
	".       . . . . . . .                   . . .             . . . . . . . . . . . .   . . . . . . . . . .       . .               . . .               .         . \n"
	" .   . . . . . . . . . . .         . . . . . . . .         . . . . . . . . . . . .     . . . . . .       . . . . . . . . . . . . . . . . . . .           . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . .     . . . . . .       . . . . . .                 . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . .   . . . . . . . . . . . . . . . . .     . . . . . .         . . . . . . . .         . . . . . . . . . . .             . . . . . . . . . . . . . . .\n"
	". . . . .           . . . . . . . . . . .   . . . . . . . . . . .         . . . . . . . . . . . . . . . . . . . . . . .                 . . . . .       . . . . \n"
	" . . . .               . . . . . . . .     .   . . . . . . . . . .         . . . . . . . . . . . . . . . . . . . . . . . .             . . . . .           . . .\n"
	". . . .               . . . . . .               . . . . . . . .             . . . . .   . . . . . .   . . . . . . . . . . .               . . .         . . . . \n"
	" . .                         . . .           . . . .       . .                 . . .         . .               . . . . . .                               . . . .\n"
	".                                                                                                                 . . .                                     . . ",
	0
};

const char* game_over_bk_shade[]=
{
	"*************.*.*.*.*.*.*.***********************************************************************************.*.*.*.*.*.*.*.*.**********************************\n"
	"******.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*************************************************.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*********\n"
	"*.*.*.*.*.*.*.*. . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.***********.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*. . . . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.\n"
	".*.*.*.*. . . . . . . . . . . . . . .*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*.*.*.*.*\n"
	"*.*. . . . . . . . . . . . . . . . . . . . . . .*.*.*.*.*.*.*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*.\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . .*.*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . .   . . . . . . . . . . . . . . . . . . . . . . . . .         . . . . . . . . . . . . . . . . . . . . . . .             . . . . . . . . . . . . . . .\n"
	". . . . .           . . . . . . . . . . .   . . . . . . . . . . .         . . . . . . . . . . . . . . . . . . . . . . .                 . . . . .       . . . . \n"
	" . . . .               . . . . . . . .     .   . . . . . . . . . .         . . . . . . . . . . . . . . . . . . . . . . . .             . . . . .           . . .\n"
	". . . .               . . . . . .               . . . . . . . .             . . . . .   . . . . . .   . . . . . . . . . . .               . . .         . . . . \n"
	" . .                         . . .           . . . .       . .                 . . .         . .               . . . . . .                               . . . .\n"
	".                                                                                                                 . . .                                     . . ",
	0
};

const unsigned char game_over_bk_colordata[]=
{
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
};

const char* game_over_bk_color[]=
{
	(const char*)game_over_bk_colordata + 0,
	0
};

ASSET game_over_bk=
{
	game_over_bk_mono,
	game_over_bk_shade,
	game_over_bk_color
};

const char* game_over_fg_mono[]=
{
	"                                                           _____                     _____                                                                      \n"
	"                                                          / /:::\\   ___           _ / /:::\\ __                                                                  \n"
	"                                                         /________ /%%%\\__   ____/%/ /:/-\\:\\ %\\__                                                               \n"
	"                                                         //  \\\\_\\_\\_::  _():/\\_\\_\\_\\ \\:\\-/:/   _()                                                              \n"
	"                                              _____     / \\__//     \\__/:%::\\/____/_\\_\\___/_ _/:%:_                                                             \n"
	"_______________________                      /:::\\%\\__ /__/___\\_____/\\______%/____/%\\_____/%\\____/%\\____                                                    ____\n"
	":::::::::::::::::::::::\\____________________/:/-\\:\\%:...%%%   \\_____\\:%%%%%%%%%%%%%\\_\\_\\_\\_\\_\\_\\_\\_\\\\:::\\_________                    _____________________/::::\n"
	"::::::::::::::::::::::::::::::::::::::::::::\\:\\-/::/.::::::::::::%%%%\\:%%%%%%%%%%%:/%/_/%/%/::::::::::::::::/ /:::\\__________________/::::::::::::::::::::::::::\n"
	"::::::;;;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: /:/-\\:\\.::::::::::::::::::::::::::::..........:::::\n"
	"::::::::::::::::::;;;;;;;;;;;;;;::::::::::::::::::;;;;;;;;;;;;;:::::::::::::::::::::;;;;;;;;;;;;;;:::::::::.:::\\-/:/.:::::::;;;;;;;;;;;;;;;;;;;;;::::::::.......\n"
	":::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;:::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::;;;;;;;;;;;;;:::::::::::::;;;;;;;;:::::::::::::::::::::::::::::::::\n"
	";;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;:::::::::::::::;;;;;;;;;;;;;;;;;::::::\n"
	":::::::::;;;;;;;;;;;;;;;;;;::::::::::;;;;;;;;;;;;;;;;;::::::::::::::::::::::;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	":::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	"::::::;;;;;;;;:::::::::::::::::;;;;;;;;;;;;;;::::::::;;;;;;;;;;;;;;;;;;::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::;;;;;\n"
	":;:;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::\n"
	";;;;;;::::::::::::::;;;;;;;;;;;;::::::::::::::::::;;;;;;;;;;;;;;;;;;;:;;;;;;;;;;;;::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;::::::::::::::\n"
	"::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::::;;;;;;;;;;;;::::::::;;;;;;;;;;;:::\n"
	"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::\n"
	"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::",
	0
};

const char* game_over_fg_shade[]=
{
	"                                                           _____                     _____                                                                      \n"
	"                                                          / /:::\\   ___           _ / /:::\\ __                                                                  \n"
	"                                                         /________ /%%%\\__   ____/%/ /:/-\\:\\ %\\__                                                               \n"
	"                                                         //  \\\\_\\_\\_::  _():/\\_\\_\\_\\ \\:\\-/:/   _()                                                              \n"
	"                                              _____     / \\__//     \\__/:%::\\/____/_\\_\\:::/_ _/:%:_                                                             \n"
	"_______________________                      /:::\\%\\ _ /__/___\\_____/\\______%/____/%\\_____/%\\____/%\\ ___                                                    ____\n"
	":::::::::::::::::::::::\\___________________ /:/-\\:\\% .. %%%\\\\\\\\_____\\:%%%%%%%%%%%%%\\_\\_\\_\\_\\_\\_\\_\\_\\\\ ::\\_________                    _____________________/::::\n"
	"::::::::::::::::::::::::::::::::::::::::::::..      .::          %%%%\\:%%%%%%%%%%%:/%/_/%/%/         :::::: / /:::\\ _________________/::::::::::::::::::::::::::\n"
	"::::::;;;;;;;;;;;;;;:::::::::::::::::::::::::::...:::::::...                                  ...:::::::::   /:/-\\:\\.::::::::::::::::::::::::::::;;;;;;;;;;:::::\n"
	"::::::::::::::::::;;;;;;;;;;;;;;::::::::::::::::::;;;;;;::::::::::::::::::...........::::::::::::::::::::::..      ..:::::::;;;;;;;;;;;;;;;;;;;;;::::::::;;;;;;;\n"
	":::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;:::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::;;;;;;;;;;;;;::::....:::::;;;;;;;;:::::::::::::::::::::::::::::::::\n"
	";;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;:::::::::::::::;;;;;;;;;;;;;;;;;::::::\n"
	":::::::::;;;;;;;;;;;;;;;;;;::::::::::;;;;;;;;;;;;;;;;;::::::::::::::::::::::;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	":::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	"::::::;;;;;;;;:::::::::::::::::;;;;;;;;;;;;;;::::::::;;;;;;;;;;;;;;;;;;::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::;;;;;\n"
	":;:;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;:::::::::::::::::::::::::::::::::::::\n"
	";;;;;;::::::::::::::;;;;;;;;;;;;::::::::::::::::::;;;;;;;;;;;;;;;;;;;:;;;;;;;;;;;;::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;::::::::::::::\n"
	"::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;:::::::::::;;;;;;;;;;;;::::::::;;;;;;;;;;;:::\n"
	"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;;;;;;;;;;;;;;;;;;;;;;;;;::::::::::::::::::::::::::::::\n"
	"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::",
	0
};

const unsigned char game_over_fg_colordata[]=
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x0F,0x07,0x07,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x01,0x09,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x01,0x01,0x01,0x09,0x01,0x09,0x01,0x09,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x08,0x08,0x08,0x01,0x01,0x01,0x08,0x01,0x01,0x09,0x09,0x09,0x09,0x01,0x09,0x08,0x08,0x08,0x07,0x0F,0x07,0x07,0x09,0x09,0x08,0x08,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x07,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x09,0x09,0x09,0x09,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x01,0x01,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
};

const char* game_over_fg_color[]=
{
	(const char*)game_over_fg_colordata + 0,
	0
};

ASSET game_over_fg=
{
	game_over_fg_mono,
	game_over_fg_shade,
	game_over_fg_color
};

const char* game_over_tx_mono[]=
{
	"**____*****_****_*****_*______*****____***__***__*______*______*\n"
	"*_::::_***_:_***:_***_:*::::::****_::::_**::***::*::::::*::::::_\n"
	"_::**::**_:::_**::_*_::*::*******_::**::_*::***::*::*****::***::\n"
	"::**___*_::*::_*:::_:::*::___****::****::*::***::*::___**::___::\n"
	"::**:::*::___::*:::::::*:::::****::****::*::_*_::*:::::**::::::*\n"
	"::_**::*:::::::*::*:*::*::*******::_**_::**::_::**::*****::*::_*\n"
	"*::__::*::***::*::***::*::____****::__::****:::***::____*::**::_\n"
	"**::::**::***::*::***::*::::::*****::::******:****::::::*::***::",
	0
};

const char* game_over_tx_shade[]=
{
	"**____*****_****_*****_*______*****____***__***__*______*______*\n"
	"*_    _***_ _*** _***_ *      ****_    _**  ***  *      *      _\n"
	"_  **  **_   _**  _*_  *  *******_  **  _*  ***  *  *****  ***  \n"
	"  **___*_  *  _*   _   *  ___****  ****  *  ***  *  ___**  ___  \n"
	"  **   *  ___  *       *     ****  ****  *  _*_  *     **      *\n"
	"  _**  *       *  * *  *  *******  _**_  **  _  **  *****  *  _*\n"
	"*  __  *  ***  *  ***  *  ____****  __  ****   ***  ____*  **  _\n"
	"**    **  ***  *  ***  *      *****    ****** ****      *  ***  ",
	0
};

const unsigned char game_over_tx_colordata[]=
{
	0x07,0x07,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,
	0x07,0x0C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x0C,0x0C,0x0C,0x0C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x00,
	0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x4C,0x4C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x00,
	0x47,0x47,0x47,0x47,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x4C,0x4C,0x4C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x0C,0x0C,0x0C,0x4C,0x4C,0x00,
	0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x00,
	0x47,0x47,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x00,
	0x07,0x47,0x47,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x0C,0x0C,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x00,
	0x07,0x07,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x00,
};

const char* game_over_tx_color[]=
{
	(const char*)game_over_tx_colordata + 0,
	0
};

ASSET game_over_tx=
{
	game_over_tx_mono,
	game_over_tx_shade,
	game_over_tx_color
};

const char* ground_boom_mono[]=
{
	"*********\n"
	"****_****\n"
	"***(_)***",
	"***._.***\n"
	"**(   )**\n"
	"*(_____)*",
	"**.- -.**\n"
	"*(     )*\n"
	"(_______)",
	"*********\n"
	"**.*-*.**\n"
	"*(_(_)_)*",
	0
};

const char* ground_boom_shade[]=
{
	"*********\n"
	"*********\n"
	"***%%%***",
	"**..*..**\n"
	"*.( %.).*\n"
	".(:% %%).",
	"*..-*.*.*\n"
	".(.% %.).\n"
	"(.%%%%%.)",
	"*********\n"
	"**..*..**\n"
	".%.:%:.%.",
	0
};

const unsigned char ground_boom_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x70,0x70,0x70,0xB9,0xFB,0xB9,0xB9,0xB9,0xB9,0x00,
	0x00,0x00,0x70,0x79,0x79,0x79,0x70,0x70,0x70,0x00,
	0x00,0x70,0x7B,0x9B,0xB1,0x19,0x7B,0x70,0x70,0x00,
	0x71,0x7B,0x1B,0xB1,0xF1,0xB1,0x1B,0x7B,0x71,0x00,
	0x00,0x70,0x78,0x71,0x71,0x78,0x78,0x70,0x70,0x00,
	0x70,0x71,0x7B,0x79,0x79,0x71,0x7B,0x71,0x70,0x00,
	0x71,0x7B,0x71,0x3B,0xB1,0x3B,0x79,0x7B,0x71,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x71,0x70,0x70,0x70,0x71,0x71,0x71,0x00,
	0x70,0x71,0x70,0x79,0x70,0x79,0x70,0x71,0x70,0x00,
};

const char* ground_boom_color[]=
{
	(const char*)ground_boom_colordata + 0,
	(const char*)ground_boom_colordata + 30,
	(const char*)ground_boom_colordata + 60,
	(const char*)ground_boom_colordata + 90,
	0
};

ASSET ground_boom=
{
	ground_boom_mono,
	ground_boom_shade,
	ground_boom_color
};

const char* heap1_mono[]=
{
	"*__*\n"
	"/::\\\n"
	"\\::/",
	"****\n"
	"____\n"
	"\\::/",
	0
};

const char* heap1_shade[]=
{
	"*__*\n"
	"/%%\\\n"
	"%%%%",
	"****\n"
	"____\n"
	"%%%%",
	0
};

const unsigned char heap1_colordata[]=
{
	0x70,0x73,0x73,0x73,0x00,
	0x73,0x3B,0x87,0x70,0x00,
	0x73,0x73,0x73,0x73,0x00,
	0x03,0x03,0x03,0x03,0x00,
	0x73,0x73,0x73,0x73,0x00,
	0x73,0x73,0x73,0x73,0x00,
};

const char* heap1_color[]=
{
	(const char*)heap1_colordata + 0,
	(const char*)heap1_colordata + 15,
	0
};

ASSET heap1=
{
	heap1_mono,
	heap1_shade,
	heap1_color
};

const char* heap2_mono[]=
{
	"***___**\n"
	"*_/:::\\*\n"
	"/::::::\\\n"
	"\\::::::/",
	"********\n"
	"********\n"
	"________\n"
	"\\::::::/",
	0
};

const char* heap2_shade[]=
{
	"***___**\n"
	"*_/%%%\\*\n"
	"/%%%%%%\\\n"
	"%%%%%%%%",
	"********\n"
	"********\n"
	"________\n"
	"%%%%%%%%",
	0
};

const unsigned char heap2_colordata[]=
{
	0x70,0x70,0x70,0x73,0x73,0x73,0x73,0x73,0x00,
	0x70,0x73,0x73,0x3B,0x37,0x87,0x70,0x70,0x00,
	0x73,0x3B,0x3B,0x30,0x30,0x37,0x87,0x70,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
};

const char* heap2_color[]=
{
	(const char*)heap2_colordata + 0,
	(const char*)heap2_colordata + 36,
	0
};

ASSET heap2=
{
	heap2_mono,
	heap2_shade,
	heap2_color
};

const char* heap3_mono[]=
{
	"****_***__***\n"
	"**_/:\\_/::\\**\n"
	"*/::::\\::::\\*\n"
	"/:::::::::::\\\n"
	"\\:::::::::::/",
	"********__***\n"
	"*******/::\\**\n"
	"******/::::\\*\n"
	"_____/::::::\\\n"
	"\\:::::::::::/",
	"*************\n"
	"*************\n"
	"*************\n"
	"_____________\n"
	"\\:::::::::::/",
	0
};

const char* heap3_shade[]=
{
	"****_***__***\n"
	"**_/%\\_/%%\\**\n"
	"*/%%%%\\%%%%\\*\n"
	"/%%%%%%%%%%%\\\n"
	"%%%%%%%%%%%%%",
	"********__***\n"
	"*******/%%\\**\n"
	"******/%%%%\\*\n"
	"_____/%%%%%%\\\n"
	"%%%%%%%%%%%%%",
	"*************\n"
	"*************\n"
	"*************\n"
	"_____________\n"
	"%%%%%%%%%%%%%",
	0
};

const unsigned char heap3_colordata[]=
{
	0x70,0x70,0x70,0x70,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x70,0x70,0x73,0x73,0x3B,0x70,0x70,0x73,0x3B,0x87,0x70,0x70,0x70,0x00,
	0x70,0x73,0x3B,0x3B,0x30,0x38,0x80,0x38,0x38,0x30,0x87,0x70,0x70,0x00,
	0x73,0x3B,0x38,0x30,0x30,0x80,0x80,0x38,0x30,0x80,0x80,0x87,0x70,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x73,0x73,0x73,0x73,0x73,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x73,0x3B,0x87,0x70,0x70,0x70,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x73,0x3B,0x38,0x30,0x87,0x70,0x70,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x3B,0x38,0x30,0x80,0x80,0x87,0x70,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
	0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x73,0x00,
};

const char* heap3_color[]=
{
	(const char*)heap3_colordata + 0,
	(const char*)heap3_colordata + 70,
	(const char*)heap3_colordata + 140,
	0
};

ASSET heap3=
{
	heap3_mono,
	heap3_shade,
	heap3_color
};

const char* keyb_mono[]=
{
	" *____________________________________________________________________       \n"
	" |                                                                    | \\ /  \n"
	" |                                                                    |  X   \n"
	" |____________________________________________________________________| / \\  \n"
	"  .... .... .... .... .... .... .... .... .... .... .... .... .... ........  \n"
	" |    : !  : @  : #  : $  : %  : ^  : &  : *  : (  : )  : .  : +  :        | \n"
	" | ~  : 1  : 2  : 3  : 4  : 5  : 6  : 7  : 8  : 9  : 0  : -  : =  : < BkSp | \n"
	" |....:....:....:....:....:....:....:....:....:....:....:....:....:........| \n"
	" `....... .... .... .... .... .... .... .... .... .... .... .... .... .....\' \n"
	" |       :    :    :    :    :    :    :    :    :    :    : {  : }  : |   | \n"
	" | Tab   : Q  : W  : E  : R  : T  : Y  : U  : I  : O  : P  : [  : ]  : \\   | \n"
	" |.......:....:....:....:....:....:....:....:....:....:....:....:....:.....| \n"
	" `......... .... .... .... .... .... .... .... .... .... .... .... ........\' \n"
	" |         :    :    :    :    :    :    :    :    :    : :  : \"  :        | \n"
	" | CapsLk  : A  : S  : D  : F  : G  : H  : J  : K  : L  : ;  : \'  :  Enter | \n"
	" |.........:....:....:....:....:....:....:....:....:....:....:....:........| \n"
	" `........... .... .... .... .... .... .... .... .... .... .... ...........\' \n"
	" |           :    :    :    :    :    :    :    : <  : >  : ?  :           | \n"
	" | Shift ^   : Z  : X  : C  : V  : B  : N  : M  : ,  : .  : /  :   ^ Shift | \n"
	" |...........:....:....:....:....:....:....:....:....:....:....:...........| \n"
	" `....... ..... ..... ........................... ..... ..... ..... .......\' \n"
	" |       :     :     :                           :     :     :     :       | \n"
	" | Ctrl  : Win : Alt :                           : Alt : Win : App :  Ctrl | \n"
	" |.......:.....:.....:...........................:.....:.....:.....:.......| \n"
	" `.      `.    `.    `.                         .\'    .\'    .\'    .\'      .\' ",
	" *____________________________________________________________________       \n"
	" |                                                                    | \\ /  \n"
	" |                                                                    |  X   \n"
	" |____________________________________________________________________| / \\  \n"
	"  ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________  \n"
	" |    | !  | @  | #  | $  | %  | ^  | &  | *  | (  | )  | _  | +  |        | \n"
	" | ~  | 1  | 2  | 3  | 4  | 5  | 6  | 7  | 8  | 9  | 0  | -  | =  | < BkSp | \n"
	" |____|____|____|____|____|____|____|____|____|____|____|____|____|________| \n"
	" `_______ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ _____\' \n"
	" |       |    |    |    |    |    |    |    |    |    |    | {  | }  | |   | \n"
	" | Tab   | Q  | W  | E  | R  | T  | Y  | U  | I  | O  | P  | [  | ]  | \\   | \n"
	" |_______|____|____|____|____|____|____|____|____|____|____|____|____|_____| \n"
	" `_________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________\' \n"
	" |         |    |    |    |    |    |    |    |    |    | :  | \"  |        | \n"
	" | CapsLk  | A  | S  | D  | F  | G  | H  | J  | K  | L  | ;  | \'  |  Enter | \n"
	" |_________|____|____|____|____|____|____|____|____|____|____|____|________| \n"
	" `___________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ___________\' \n"
	" |           |    |    |    |    |    |    |    | <  | >  | ?  |           | \n"
	" | Shift ^   | Z  | X  | C  | V  | B  | N  | M  | ,  | .  | /  |   ^ Shift | \n"
	" |___________|____|____|____|____|____|____|____|____|____|____|___________| \n"
	" `_______ _____ _____ ___________________________ _____ _____ _____ _______\' \n"
	" |       |     |     |                           |     |     |     |       | \n"
	" | Ctrl  | Win | Alt |                           | Alt | Win | App |  Ctrl | \n"
	" |_______|_____|_____|___________________________|_____|_____|_____|_______| \n"
	" `.      `.    `.    `.                         .\'    .\'    .\'    .\'      .\' ",
	0
};

const char* keyb_shade[]=
{
	"  ____________________________________________________________________       \n"
	" |                                                                    | \\ /  \n"
	" |                                                                    |  X   \n"
	" |____________________________________________________________________| / \\  \n"
	"  ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________  \n"
	" | ~  \\ !  \\ @  \\ #  \\ $  \\ %  U ^  U &  U *  U (  / )  / _  / +  /        | \n"
	" | `    1    2    3    4    5  | 6  | 7  | 8  | 9    0    -    =    < BkSp | \n"
	" |____ ____ ____ ____ ____ ____|____|____|____|____ ____ ____ ____ ________| \n"
	" `_______ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ _____\' \n"
	" |       \\    \\    \\    \\    U    U    U    U    U    /    / {  / }  / |   | \n"
	" | Tab     Q    W    E    R  | T  | Y  | U  | I  | O    P    [    ]    \\   | \n"
	" |_______ ____ ____ ____ ____|____|____|____|____|____ ____ ____ ____ _____| \n"
	" `_________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________\' \n"
	" |         \\    \\    \\    \\    U    U    U    U    /    / :  / \"  /        | \n"
	" | CapsLk    A    S    D    F  | G  | H  | J  | K    L    ;    \'     Enter | \n"
	" |_________ ____ ____ ____ ____|____|____|____|____ ____ ____ ____ ________| \n"
	" `___________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ___________\' \n"
	" |           \\    \\    \\    U    U    U    U    U <  / >  / ?  /           | \n"
	" | Shift ^     Z    X    C  | V  | B  | N  | M  | ,    .    /      ^ Shift | \n"
	" |___________ ____ ____ ____|____|____|____|____|____ ____ ____ ___________| \n"
	" `_______ _____ _____ ___________________________ _____ _____ _____ _______\' \n"
	" |       \\     \\     \\                           /     /     /     /       | \n"
	" | Ctrl    Win   Alt                               Alt   Win   App    Ctrl | \n"
	" |_______ _____ _____ ___________________________ _____ _____ _____ _______| \n"
	" `.______\\.____\\.____\\._________________________./____./____./____./______.\' ",
	"  ____________________________________________________________________       \n"
	" |                                                                    | \\ /  \n"
	" |                                                                    |  X   \n"
	" |____________________________________________________________________| / \\  \n"
	"  ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________  \n"
	" | ~  \\ !  \\ @  \\ #  \\ $  \\ %  U ^  U &  U *  U (  / )  / _  / +  /        | \n"
	" | `    1    2    3    4    5  | 6  | 7  | 8  | 9    0    -    =    < BkSp | \n"
	" |____ ____ ____ ____ ____ ____|____|____|____|____ ____ ____ ____ ________| \n"
	" `_______ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ _____\' \n"
	" |       \\    \\    \\    \\    U    U    U    U    U    /    / {  / }  / |   | \n"
	" | Tab     Q    W    E    R  | T  | Y  | U  | I  | O    P    [    ]    \\   | \n"
	" |_______ ____ ____ ____ ____|____|____|____|____|____ ____ ____ ____ _____| \n"
	" `_________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ________\' \n"
	" |         \\    \\    \\    \\    U    U    U    U    /    / :  / \"  /        | \n"
	" | CapsLk    A    S    D    F  | G  | H  | J  | K    L    ;    \'     Enter | \n"
	" |_________ ____ ____ ____ ____|____|____|____|____ ____ ____ ____ ________| \n"
	" `___________ ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ ___________\' \n"
	" |           \\    \\    \\    U    U    U    U    U <  / >  / ?  /           | \n"
	" | Shift ^     Z    X    C  | V  | B  | N  | M  | ,    .    /      ^ Shift | \n"
	" |___________ ____ ____ ____|____|____|____|____|____ ____ ____ ___________| \n"
	" `_______ _____ _____ ___________________________ _____ _____ _____ _______\' \n"
	" |       \\     \\     \\                           /     /     /     /       | \n"
	" | Ctrl    Win   Alt                               Alt   Win   App    Ctrl | \n"
	" |_______ _____ _____ ___________________________ _____ _____ _____ _______| \n"
	" `.______\\.____\\.____\\._________________________./____./____./____./______.\' ",
	0
};

const unsigned char keyb_colordata[]=
{
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x09,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x09,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x08,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x08,0x00,
	0x08,0x08,0x88,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x08,0x08,0x00,
	0x08,0x08,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x87,0x08,0x08,0x00,
	0x08,0x08,0x88,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x8B,0x08,0x08,0x00,
	0x08,0x08,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x08,0x00,
	0x08,0x08,0x88,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x07,0x87,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x87,0x87,0x87,0x87,0x87,0x87,0x08,0x08,0x00,
	0x08,0x08,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x87,0x87,0x87,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x08,0x00,
	0x08,0x08,0x88,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x07,0x87,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x08,0x88,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x8B,0x0B,0x8B,0x8B,0x8B,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x08,0x08,0x00,
	0x08,0x08,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x08,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x08,0x08,0x00,
	0x08,0x08,0x88,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x08,0x08,0x00,
	0x08,0x08,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x09,0x00,
	0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x00,
	0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x09,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x78,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x7B,0x08,0x08,0x00,
	0x08,0x08,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x08,0x78,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x7B,0x0B,0x7B,0x7B,0x7B,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x08,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x00,
	0x08,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x08,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x08,0x08,0x00,
	0x08,0x08,0x78,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x08,0x08,0x00,
	0x08,0x08,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
};

const char* keyb_color[]=
{
	(const char*)keyb_colordata + 0,
	(const char*)keyb_colordata + 1950,
	0
};

ASSET keyb=
{
	keyb_mono,
	keyb_shade,
	keyb_color
};

const char* land_mine_mono[]=
{
	"*__*\n"
	"(__)",
	"*__*\n"
	"(MM)",
	0
};

const char* land_mine_shade[]=
{
	"*__*\n"
	"(  )",
	"*__*\n"
	"(  )",
	0
};

const unsigned char land_mine_colordata[]=
{
	0x70,0x70,0x70,0x70,0x00,
	0x70,0xC0,0xC0,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0xF0,0xF0,0x70,0x00,
};

const char* land_mine_color[]=
{
	(const char*)land_mine_colordata + 0,
	(const char*)land_mine_colordata + 10,
	0
};

ASSET land_mine=
{
	land_mine_mono,
	land_mine_shade,
	land_mine_color
};

const char* map_mono[]=
{
	"---=====-=========-=====---=======------=====================-=-=-=-=-------------------------=======-=-===\n"
	"-----=====--------=-==------=====-------=-============-=-===-------====---------------------===============\n"
	"-=--==-======----==-====---=====--------==========PEAKS-=====-------==----____._--------------=====---====-\n"
	"=======-=-========-===-----------------==-=======-P-408---====------==---/    Y \\------------==-------====-\n"
	"-=----====-=-=-=-==-==-------------------========--------------------=-- \\------ \\------------------====---\n"
	"----==-=-=-=-===-==---- ____.___ --------=========------____---W.___----- \\------/-------------------==----\n"
	"-----==============--- /    G   \\_____ ----=---=====---/    \\___/   \\----./----- \\--------------------=----\n"
	"-----------========-- / --------      \\_.___ --====----\\----     --- \\__/X----Z._/ -------------------==- -\n"
	"------------POLYGON-- \\____ ----------  H   \\ --=-=----/-------------    -----   --------------------------\n"
	"------------PL-100C===     \\ -----DUST-------\\ -----V./---DESERT-D-80A---____-------____._------------=----\n"
	"---- _____ --------==-====- \\___ -LANDS------/ ------ \\-----------------/    \\-----/    S \\--ROCKS-R-8==---\n"
	"--- /     \\____.E---======--    \\ -L-9A-----/  ------  \\-------_____.__/ ----/----/ ---___/-----------==---\n"
	"-D./ -----     \\--=====--_._ -- / ----- __./  --------- \\_____/     U  ----- \\----\\---/   ----______--==---\n"
	"-- \\ --- - --- /-=====--/ F \\__/ ----- /  I ------------       -------------- \\_._/ - \\-----_/      \\--==--\n"
	"--- \\__------ /--====--/ ---    ----- / ------  ------------------------------  T  --- \\_._/ ---_.__/--==--\n"
	"----   \\- - - \\--====- \\------------- \\ ------J.____-----------------------------------  R  ---/ Q   --==--\n"
	"------- \\-- -- \\--==--_/ ------------- \\__-----/    \\-----------MINE--------__----------------/ -----=-==--\n"
	"------- /- -  - \\____/ -- -- __.__ ----   \\___/ ---- \\-MINE-----FIELD-MF-4-/  \\__.O---------- \\------=-=---\n"
	"------ /--   -        -- -- /  A  \\ ------     ------/-FIELD----__._------ \\--   \\------------ \\--======---\n"
	"------ \\._---  --- -- ----- \\ ---- \\----------- ____/ -MF-3----/ -M \\----- -\\---- \\___---------/--ROCKS===-\n"
	"=------ C \\- - ----_._----- / ---- /-@.___ --- /     -----_.__/ ---- \\------/----     \\----_._/ --R-11-=-=-\n"
	"====----- /-------/ B \\____/ ----- \\__/Z  \\ --/ ---------/ L---------/-----/ -CANYON-- \\__/ P  --=======---\n"
	"======--- \\______/ ---      -------    --- \\  \\_.__------\\__--------/---_./ --CA-27=--     ------==-==-----\n"
	"======----        ------------------------ / -  K  \\--------\\------ \\__/ N -----======-=--=-=-=======------\n"
	"==--==---------------------=------------- / ------- \\_______/ ------    ---------==-============-=-=-------\n"
	"--==------------===-------==------------- \\ --------        ----===--------------------==-=-===------------\n"
	"---=---==---=--=-==-======-=X._____ ------ \\ -=U.___ ------------=-===---  -- -----------------------------\n"
	"---------------------------- /     \\_____._/ -- /   \\ --==--=----POLYGON PL-100A---------------------------\n"
	"-----=-=-==---------------- / -----      Y  --- \\ == \\ --===============-----------------------------------\n"
	"------=-=-========--------- \\ ----------------- / -=- \\ --==----------=======------------------------------\n"
	"-------------=-=-====------ / ---------_._---- / -=-- / --=--T.______ -------==------------------------=--=\n"
	"----------=-=-=-=====------ \\__.W-----/ V \\___/ ===- / --=----/      \\_____ --------------------------=====\n"
	"---------=-=-=--------------   \\_____/ --=     -=-=--\\_______/ --==--      \\_._____ -----------------====--\n"
	"-------------------------------       ----=---===----         -----====----  S     \\__ -----------=======--\n"
	"-----------------------J.__ --------------===-=-===----------- ____ ----=----------   \\ --------======-=---\n"
	"----DESERT----- ________/  \\ --- ___.K---===MINE-------- ___._/    \\ -SULFUR---------- \\ --------=====-----\n"
	"----D-70C-- ___/         -- \\___/   \\ --=-==FIELD------ /   O  --- / -LAYER=SL-207----- \\ --------====-----\n"
	"---------- /    ------------     -- / -===--MF-1------ / - _______/ ----=-==========---- \\ ---------===----\n"
	"--------I./ ------------------ ____/ -== _._ ---- __._/ - /        ----===========--=---- \\.--------====---\n"
	"==-----=- \\___ -------------L./     --- / M \\____/  N  -- \\_.__ -----------=======------- /R--------====---\n"
	"=-==--=-==    \\_______.H----- \\ ---- __/ ---      --------  P  \\ -----------=---===----- / ---------====---\n"
	"====-====-===-        \\ ------ \\____/   ------------------=---- \\_______.Q ------------ / -----------====--\n"
	"======- ____ ======----\\ ------      -----DUST-----------=-=-=--        \\______________/ ------------====--\n"
	"====== /    \\__________/ -----------------DUNES-L-0B---=-=--=-=---------                ------------=====--\n"
	"====G./ ----            -------E._____---------------=-===========-=-=----------------------------======-=-\n"
	"===== \\ -------__.F-----________/     \\____-----------=--=--____-=-=-=---------------------------======----\n"
	"====== \\______/  \\_____/         -----     \\--------__.B---/    \\-===-=SULFUR-------------------======-----\n"
	"=======        --       ------------------- \\------/  \\___/ --- /----==LAYER--------------------======-----\n"
	"====-===-=-=-------------------POLYGON----- /-----/ --     ---- \\__.A-=SL-208---------------========-------\n"
	"=====-===-==-------------------PL-089A---- /------\\ ------------   \\ ------------------------======--------\n"
	"====-==--=------------------------------D./--------\\ ------.@------ \\ ---------------------==========------\n"
	"==-==-=---------------------------------- \\---------\\.C---- \\_______/ ----------------------======---------\n"
	"==---------------------------------------- \\________/ ------         ------------------------=====---------\n"
	"=------------------------------------------          -----------------------------------------==-----------\n"
	"=--------------------------------------------------------------------------------------------===-----------",
	0
};

const char* map_shade[]=
{
	"-------------------------------------------------------------------------------------------------------- --\n"
	"-----------------------------------------------------------------------------------------------------------\n"
	"--------------------------------------------------PEAKS------------------ ____._ --------------------------\n"
	"--------------------------------------------------P-408----------------- /    Y \\ -------------------------\n"
	"------------------------------------------------------------------------ \\ ----- \\ ------------------------\n"
	"----------------------- ____.___ ---------------------- ____ --W.___----- \\ ---  / ------------------------\n"
	"---------------------- /   -G   \\_____ --------------- /    \\___/   \\ -  ./  --- \\ ------------------------\n"
	"--------------------- / --------      \\_.___ --------- \\ ----   ---- \\__/X----Z._/ - ------------------ - -\n"
	"------------POLYGON-- \\____------------ H   \\ -------- / ------------     ---------------------------------\n"
	"------------PL-100C---     \\------DUST------ \\ -----V./ --DESERT-D-80A-  ____ ----  ____._  ---------------\n"
	"---- _____ ---------------- \\___--LANDS----- / ------ \\ -------------   /    \\ --  /    S \\ -ROCKS-R-8-----\n"
	"--  /     \\____.E-----------    \\--L-9A---- / -------- \\   --  _____.__/ -   / -- / -  ___/ ---------------\n"
	"-D./------ -   \\ ------- _._ -- / ----- __./  --------- \\_____/     U   ---  \\    \\ - /   --- ______  -----\n"
	"-- \\---------  / ------ / F \\__/ ----- /  I  -----------        ------------  \\_._/ - \\ --- _/ -    \\  ----\n"
	"--- \\__------ / ------ /  --    ----- /  -----  ------------------------------  T   -- \\_._/ -- _.__/  ----\n"
	"----   \\----- \\ ------ \\ ------------ \\-------J.____ ----------------------------------  R  ---/ Q    -----\n"
	"------- \\----- \\ ---- _/ ------------- \\__-----/    \\ ----------MINE-----   __  ------------- /  ----------\n"
	"------- /------ \\____/  -----__.__-----   \\___/  --  \\ MINE-----FIELD-MF-4 /  \\__.O---------- \\  ----------\n"
	"------ /-------       ------/  A- \\--------     ---  / FIELD--  __._ ------\\     \\ ----------- \\ ----------\n"
	"------ \\._------------------\\ ---- \\----------- ____/ -MF-3-   /  M \\ ----- \\  -- \\___  ------ / -ROCKS----\n"
	"------ -C \\--------_._------/ ---- /-@.___ --- /   -----  _.__/  --  \\ ---- /  ----   \\   -_._/ --R-11-----\n"
	"--------- /-------/ B \\____/ ----- \\__/Z  \\ --/  ------- / L    ---  / --- /  CANYON-  \\__/ P  ------------\n"
	"--------- \\______/  --      -------    --- \\- \\_.__  --  \\__  ----  /   _./  -CA-27----     ---------------\n"
	"----------        ------------------------ / -  K  \\  ---   \\  ---  \\__/ N  -------------------------------\n"
	"----------------------------------------- / ------  \\_______/ -----     -----------------------------------\n"
	"----------------------------------------- \\ ---------       -----------------------------------------------\n"
	"----------------------------X._____ ------ \\ --U.___-------------------------------------------------------\n"
	"---------------------------- /     \\_____._/ -- /   \\ -----------POLYGON PL-100A---------------------------\n"
	"--------------------------- / -----      Y  --- \\ -- \\ ----------------------------------------------------\n"
	"--------------------------  \\ ----------------- / --- \\ ---------------------------------------------------\n"
	"--------------------------- / -------- _._ --- / ---- / -----T.______ -------------------------------------\n"
	"--------------------------- \\__.W --- / V \\___/ ---- / -------/      \\_____ -------------------------------\n"
	"----------------------------   \\_____/ ---     ----- \\_______/ ------      \\_._____ -----------------------\n"
	"-------------------------------       ---------------         -------------  S     \\__ --------------------\n"
	"-----------------------J.__ ---------------------------------- ____ ---------------   \\ -------------------\n"
	"----DESERT----- ________/  \\ --- ___.K------MINE-------- ___._/    \\ -SULFUR---------- \\ ------------------\n"
	"----D-70C-- ___/         -- \\___/   \\ ------FIELD------ /   O  --- / -LAYER-SL-207----- \\ -----------------\n"
	"---------- /    ------------     -- / ------MF-1------ / - _______/ -------------------- \\ ----------------\n"
	"--------I./ ------------------ ____/ --- _._ ---- __._/ - /        ---------------------- \\.---------------\n"
	"--------- \\___ -------------L./     --- / M \\____/  N  -- \\_.__ ------------------------- /R---------------\n"
	"----------    \\_______.H----- \\ ---- __/ ---      --------  P  \\ ----------------------- / ----------------\n"
	"--------------        \\ ------ \\____/   ----------------------- \\_______.Q ------------ / -----------------\n"
	"------- ____ --------- \\ ------      -----DUST------------------        \\______________/ ------------------\n"
	"------ /    \\__________/ -----------------DUNES-L-0B--------------------                -------------------\n"
	"----G./ ----            -------E._____ --------------------------------------------------------------------\n"
	"----- \\ -------__.F-----________/     \\____ --------------- ____ ------------------------------------------\n"
	"------ \\______/  \\_____/         -----     \\ ------ __.B-- /    \\ -----SULFUR------------------------------\n"
	"-------        --       ------------------- \\ ---- /  \\___/ --- / -----LAYER-------------------------------\n"
	"-------------------------------POLYGON----- / --- / --     ---- \\__.A--SL-208------------------------------\n"
	"-------------------------------PL-089A---- / ---- \\ ------------   \\ --------------------------------------\n"
	"----------------------------------------D./ ------ \\ ------.@ ----- \\ -------------------------------------\n"
	"----------------------------------------- \\ ------- \\.C---- \\_______/ -------------------------------------\n"
	"------------------------------------------ \\________/ ------         --------------------------------------\n"
	"-------------------------------------------          ------------------------------------------------------\n"
	"-----------------------------------------------------------------------------------------------------------",
	0
};

const unsigned char map_colordata[]=
{
	0x0F,0x07,0x0F,0x07,0x07,0x07,0x07,0x07,0x02,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x02,0x03,0x03,0x03,0x03,0x03,0x04,0x03,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x0C,0x04,0x07,0x07,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x03,0x08,0x08,0x03,0x08,0x03,0x08,0x08,0x03,0x08,0x08,0x03,0x08,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x0F,0x08,0x08,0x0F,0x0F,0x00,
	0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x08,0x02,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x02,0x04,0x03,0x04,0x0C,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x0C,0x04,0x04,0x04,0x07,0x04,0x07,0x0F,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x03,0x08,0x08,0x03,0x08,0x03,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x08,0x01,0x08,0x03,0x01,0x01,0x01,0x01,0x08,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x07,0x0F,0x0F,0x07,0x07,0x0F,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x02,0x03,0x02,0x03,0x03,0x02,0x03,0x03,0x03,0x03,0x04,0x03,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x0C,0x04,0x07,0x04,0x07,0x04,0x0F,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x03,0x08,0x03,0x08,0x03,0x08,0x07,0x07,0x03,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x0B,0x05,0x05,0x03,0x03,0x03,0x01,0x01,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x0F,0x0F,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x02,0x07,0x02,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x02,0x03,0x03,0x03,0x08,0x04,0x03,0x04,0x03,0x04,0x03,0x04,0x04,0x08,0x04,0x07,0x04,0x0F,0x07,0x07,0x0F,0x07,0x07,0x0F,0x07,0x07,0x07,0x0F,0x0F,0x07,0x07,0x08,0x06,0x06,0x06,0x06,0x06,0x08,0x03,0x08,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x03,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x0B,0x0B,0x05,0x05,0x08,0x03,0x01,0x03,0x03,0x01,0x01,0x01,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x03,0x00,
	0x0F,0x07,0x08,0x08,0x08,0x02,0x07,0x07,0x07,0x07,0x02,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x02,0x03,0x03,0x08,0x03,0x08,0x03,0x08,0x03,0x08,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x07,0x07,0x08,0x08,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x08,0x08,0x08,0x03,0x07,0x03,0x08,0x08,0x05,0x05,0x08,0x08,0x03,0x03,0x08,0x08,0x05,0x05,0x08,0x08,0x03,0x01,0x01,0x08,0x03,0x08,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x03,0x07,0x00,
	0x08,0x08,0x07,0x07,0x03,0x03,0x02,0x03,0x02,0x03,0x07,0x03,0x02,0x03,0x03,0x03,0x02,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x0B,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x0F,0x07,0x07,0x07,0x07,0x03,0x08,0x03,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x08,0x08,0x0B,0x0B,0x05,0x05,0x05,0x08,0x08,0x03,0x03,0x08,0x08,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x08,0x08,0x03,0x01,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x07,0x03,0x07,0x03,0x00,
	0x0C,0x04,0x04,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x08,0x0B,0x0B,0x0B,0x0B,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x0F,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x08,0x08,0x08,0x0B,0x05,0x05,0x05,0x01,0x01,0x08,0x08,0x05,0x05,0x03,0x01,0x01,0x03,0x03,0x01,0x01,0x01,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x0F,0x03,0x03,0x03,0x07,0x00,
	0x0C,0x04,0x04,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x0B,0x01,0x01,0x01,0x01,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x05,0x05,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x0B,0x04,0x03,0x01,0x01,0x0B,0x0B,0x05,0x05,0x05,0x01,0x01,0x03,0x08,0x08,0x03,0x08,0x03,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x07,0x03,0x07,0x0F,0x0F,0x03,0x03,0x03,0x00,
	0x0C,0x0C,0x04,0x04,0x04,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0B,0x0B,0x0B,0x0B,0x01,0x01,0x07,0x08,0x07,0x03,0x07,0x03,0x08,0x08,0x08,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x07,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x00,
	0x0C,0x0C,0x0C,0x04,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x07,0x03,0x07,0x03,0x03,0x0B,0x0B,0x05,0x05,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x06,0x06,0x06,0x06,0x06,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x01,0x01,0x01,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x0B,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x03,0x07,0x03,0x07,0x03,0x03,0x00,
	0x0C,0x0C,0x08,0x08,0x08,0x06,0x06,0x06,0x06,0x06,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x08,0x03,0x03,0x03,0x03,0x08,0x08,0x01,0x01,0x01,0x01,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x08,0x07,0x03,0x07,0x03,0x08,0x08,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x01,0x01,0x01,0x01,0x04,0x04,0x04,0x04,0x04,0x0B,0x0B,0x04,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x06,0x06,0x06,0x07,0x07,0x03,0x03,0x03,0x00,
	0x08,0x08,0x08,0x08,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0B,0x0B,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x06,0x06,0x06,0x06,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x08,0x07,0x07,0x08,0x08,0x03,0x07,0x08,0x08,0x05,0x05,0x05,0x05,0x03,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x0B,0x05,0x05,0x05,0x05,0x08,0x08,0x08,0x08,0x05,0x05,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x07,0x07,0x03,0x03,0x03,0x00,
	0x08,0x0B,0x0B,0x06,0x04,0x04,0x04,0x04,0x08,0x04,0x04,0x04,0x04,0x04,0x04,0x01,0x01,0x08,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x01,0x0B,0x01,0x01,0x08,0x08,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x0B,0x01,0x01,0x01,0x08,0x07,0x07,0x07,0x07,0x08,0x07,0x03,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x0B,0x0B,0x0B,0x0B,0x03,0x03,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x04,0x04,0x08,0x08,0x04,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x07,0x07,0x03,0x03,0x03,0x00,
	0x08,0x08,0x08,0x06,0x04,0x04,0x04,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x01,0x01,0x0B,0x0B,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x03,0x07,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x05,0x05,0x0B,0x04,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x07,0x07,0x03,0x03,0x00,
	0x0C,0x0C,0x04,0x04,0x06,0x06,0x06,0x08,0x0C,0x0C,0x04,0x08,0x08,0x08,0x01,0x01,0x08,0x03,0x03,0x03,0x03,0x08,0x08,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x03,0x08,0x03,0x03,0x03,0x0B,0x0B,0x0B,0x0B,0x07,0x08,0x08,0x04,0x04,0x0B,0x04,0x04,0x04,0x08,0x08,0x08,0x04,0x0B,0x04,0x04,0x04,0x04,0x04,0x07,0x07,0x03,0x03,0x00,
	0x0C,0x0C,0x04,0x0C,0x0C,0x0C,0x0C,0x06,0x08,0x0C,0x04,0x04,0x04,0x04,0x01,0x01,0x08,0x03,0x03,0x03,0x03,0x08,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0B,0x0B,0x02,0x02,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x0F,0x07,0x07,0x07,0x07,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x04,0x04,0x0B,0x0B,0x0B,0x0B,0x0B,0x08,0x07,0x07,0x03,0x03,0x00,
	0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x06,0x08,0x08,0x04,0x04,0x08,0x08,0x01,0x01,0x08,0x03,0x03,0x08,0x08,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x07,0x01,0x01,0x01,0x01,0x01,0x02,0x02,0x08,0x08,0x08,0x03,0x08,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x07,0x0F,0x0F,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x07,0x03,0x03,0x00,
	0x0C,0x04,0x04,0x08,0x0C,0x0C,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x0B,0x06,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x02,0x02,0x07,0x07,0x07,0x07,0x03,0x08,0x03,0x03,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x06,0x06,0x06,0x06,0x06,0x02,0x02,0x02,0x02,0x02,0x02,0x0B,0x0B,0x08,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x03,0x03,0x03,0x00,
	0x0C,0x04,0x08,0x0C,0x0C,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x0C,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x06,0x0B,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x02,0x02,0x0B,0x02,0x02,0x08,0x08,0x03,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x02,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x0F,0x0F,0x08,0x08,0x04,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x00,
	0x04,0x04,0x04,0x0C,0x0C,0x08,0x08,0x06,0x0B,0x06,0x08,0x08,0x04,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x08,0x07,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x02,0x08,0x06,0x06,0x06,0x06,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x0B,0x0B,0x02,0x02,0x08,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x00,
	0x07,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x0B,0x0B,0x06,0x08,0x08,0x0C,0x0C,0x08,0x08,0x08,0x08,0x06,0x0B,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x08,0x07,0x07,0x08,0x08,0x06,0x08,0x0B,0x0B,0x05,0x05,0x05,0x05,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x02,0x0B,0x02,0x02,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x02,0x02,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x08,0x04,0x0B,0x04,0x04,0x04,0x08,0x08,0x06,0x06,0x06,0x06,0x08,0x07,0x03,0x07,0x03,0x00,
	0x07,0x07,0x07,0x07,0x04,0x04,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x0C,0x0C,0x08,0x08,0x06,0x06,0x0B,0x0B,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x08,0x07,0x07,0x07,0x08,0x08,0x06,0x06,0x06,0x06,0x0B,0x0B,0x0B,0x05,0x05,0x08,0x08,0x02,0x02,0x02,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x02,0x02,0x0B,0x0B,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x07,0x07,0x07,0x07,0x07,0x07,0x01,0x01,0x01,0x04,0x04,0x04,0x04,0x04,0x0B,0x0B,0x0B,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x04,0x08,0x08,0x08,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x05,0x08,0x08,0x02,0x02,0x0B,0x02,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x0B,0x02,0x02,0x02,0x08,0x06,0x06,0x06,0x06,0x06,0x07,0x08,0x08,0x01,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x07,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x07,0x01,0x01,0x07,0x07,0x01,0x07,0x08,0x09,0x09,0x08,0x08,0x01,0x01,0x01,0x05,0x05,0x08,0x08,0x08,0x0B,0x0B,0x0B,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x0B,0x0B,0x0B,0x08,0x07,0x07,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x07,0x07,0x03,0x03,0x00,
	0x07,0x07,0x01,0x01,0x07,0x07,0x08,0x07,0x07,0x08,0x07,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x08,0x07,0x07,0x01,0x07,0x01,0x07,0x09,0x07,0x01,0x01,0x09,0x09,0x09,0x01,0x01,0x01,0x01,0x05,0x05,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x08,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x03,0x07,0x07,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x07,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x07,0x07,0x01,0x01,0x07,0x01,0x01,0x07,0x01,0x07,0x07,0x01,0x07,0x01,0x07,0x01,0x01,0x07,0x01,0x07,0x09,0x09,0x07,0x09,0x09,0x09,0x07,0x07,0x09,0x01,0x01,0x07,0x07,0x07,0x05,0x05,0x01,0x01,0x07,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x09,0x09,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x03,0x07,0x03,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x09,0x09,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x07,0x01,0x01,0x01,0x07,0x01,0x01,0x01,0x01,0x07,0x09,0x09,0x09,0x09,0x07,0x07,0x01,0x01,0x01,0x0B,0x0B,0x05,0x05,0x05,0x05,0x05,0x05,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x05,0x05,0x01,0x09,0x0B,0x0B,0x05,0x05,0x05,0x01,0x07,0x01,0x09,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x07,0x09,0x07,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x09,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x0B,0x05,0x05,0x05,0x09,0x09,0x09,0x05,0x05,0x05,0x05,0x05,0x05,0x01,0x01,0x09,0x09,0x01,0x01,0x09,0x01,0x07,0x01,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x03,0x03,0x01,0x03,0x03,0x03,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,
	0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x09,0x09,0x05,0x05,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0B,0x0B,0x0B,0x09,0x09,0x09,0x09,0x05,0x05,0x09,0x09,0x09,0x05,0x05,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x08,0x01,0x01,0x01,0x03,0x01,0x03,0x03,0x01,0x03,0x01,0x03,0x01,0x03,0x03,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x03,0x08,0x08,0x08,0x00,
	0x0C,0x0C,0x0C,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x01,0x01,0x01,0x01,0x09,0x01,0x09,0x09,0x09,0x09,0x05,0x05,0x01,0x09,0x01,0x09,0x01,0x09,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x05,0x05,0x01,0x09,0x01,0x01,0x05,0x05,0x01,0x01,0x09,0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x03,0x01,0x01,0x03,0x01,0x03,0x01,0x03,0x08,0x01,0x03,0x03,0x03,0x01,0x03,0x03,0x03,0x08,0x03,0x08,0x03,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x01,0x01,0x01,0x09,0x09,0x01,0x01,0x05,0x05,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x01,0x05,0x0B,0x05,0x05,0x09,0x09,0x09,0x09,0x05,0x05,0x01,0x09,0x01,0x01,0x01,0x05,0x05,0x01,0x01,0x09,0x01,0x03,0x0B,0x0B,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x03,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x08,0x07,0x07,0x07,0x0F,0x07,0x07,0x0F,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x01,0x09,0x01,0x09,0x01,0x01,0x01,0x05,0x05,0x05,0x0B,0x0B,0x0B,0x01,0x01,0x01,0x01,0x05,0x05,0x0B,0x0B,0x05,0x05,0x05,0x05,0x05,0x05,0x09,0x09,0x09,0x01,0x01,0x05,0x05,0x01,0x01,0x09,0x01,0x01,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x03,0x01,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x03,0x08,0x03,0x03,0x08,0x03,0x03,0x03,0x08,0x08,0x03,0x08,0x08,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0C,0x0C,0x0C,0x0C,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x09,0x01,0x09,0x01,0x01,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x08,0x07,0x0B,0x0B,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x04,0x04,0x0B,0x04,0x04,0x04,0x04,0x04,0x04,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x03,0x08,0x08,0x03,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x08,0x07,0x00,
	0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x09,0x01,0x01,0x01,0x09,0x09,0x09,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x0B,0x0B,0x0B,0x0B,0x07,0x08,0x07,0x08,0x08,0x08,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x04,0x04,0x04,0x04,0x03,0x03,0x08,0x08,0x07,0x03,0x07,0x07,0x07,0x07,0x08,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x00,
	0x07,0x07,0x08,0x07,0x08,0x07,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0B,0x0B,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x09,0x09,0x09,0x07,0x09,0x07,0x09,0x09,0x09,0x01,0x03,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x07,0x08,0x0B,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x03,0x03,0x04,0x04,0x03,0x08,0x08,0x03,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x0F,0x07,0x07,0x07,0x00,
	0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x02,0x02,0x03,0x03,0x03,0x03,0x02,0x02,0x02,0x0B,0x0B,0x03,0x03,0x01,0x09,0x09,0x09,0x07,0x07,0x07,0x07,0x07,0x09,0x09,0x09,0x03,0x01,0x03,0x03,0x03,0x02,0x02,0x02,0x0B,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x08,0x07,0x08,0x08,0x04,0x04,0x03,0x08,0x08,0x07,0x08,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x00,
	0x03,0x03,0x03,0x03,0x06,0x06,0x06,0x06,0x06,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x01,0x01,0x09,0x01,0x09,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x09,0x01,0x01,0x03,0x03,0x03,0x02,0x02,0x02,0x02,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x07,0x07,0x07,0x07,0x07,0x0B,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0x08,0x07,0x08,0x07,0x07,0x04,0x04,0x03,0x03,0x08,0x08,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x00,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x02,0x01,0x09,0x09,0x09,0x03,0x01,0x06,0x06,0x06,0x06,0x07,0x03,0x01,0x03,0x03,0x03,0x03,0x02,0x02,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x08,0x07,0x0B,0x07,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x08,0x07,0x08,0x07,0x07,0x04,0x04,0x03,0x03,0x03,0x08,0x07,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x00,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x0B,0x0B,0x01,0x01,0x03,0x0C,0x0C,0x03,0x03,0x03,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x01,0x09,0x09,0x09,0x02,0x0B,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x02,0x02,0x0B,0x02,0x02,0x02,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x08,0x07,0x08,0x07,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x07,0x08,0x0B,0x08,0x07,0x08,0x08,0x08,0x04,0x0B,0x03,0x03,0x08,0x03,0x07,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x00,
	0x0C,0x0C,0x03,0x03,0x03,0x03,0x03,0x0C,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x0B,0x0B,0x02,0x02,0x02,0x02,0x02,0x02,0x01,0x01,0x01,0x01,0x02,0x02,0x0B,0x0B,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x0B,0x0B,0x0B,0x01,0x03,0x03,0x04,0x04,0x0B,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x08,0x04,0x0B,0x03,0x03,0x08,0x08,0x0F,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x00,
	0x0C,0x03,0x0C,0x0C,0x03,0x03,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x0B,0x0B,0x0C,0x03,0x03,0x03,0x03,0x03,0x02,0x02,0x03,0x01,0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x0B,0x0B,0x0B,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x0B,0x08,0x07,0x08,0x0B,0x0B,0x0B,0x08,0x07,0x08,0x07,0x08,0x08,0x04,0x04,0x03,0x03,0x03,0x08,0x03,0x03,0x08,0x08,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x00,
	0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x0C,0x0C,0x03,0x03,0x03,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x0B,0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0B,0x0B,0x0B,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x03,0x03,0x04,0x04,0x03,0x03,0x03,0x03,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x01,0x01,0x03,0x0C,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x0B,0x08,0x0B,0x03,0x0B,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x0C,0x0C,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x08,0x06,0x06,0x06,0x06,0x08,0x08,0x08,0x0B,0x08,0x0B,0x03,0x03,0x0B,0x08,0x0B,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x0F,0x0F,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0B,0x0B,0x01,0x01,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x03,0x03,0x0C,0x03,0x0B,0x0B,0x05,0x05,0x05,0x05,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x03,0x08,0x03,0x08,0x08,0x08,0x0B,0x08,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x03,0x0B,0x03,0x0B,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x07,0x08,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x0F,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x0B,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x05,0x05,0x05,0x05,0x05,0x05,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0B,0x08,0x08,0x0B,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x0B,0x08,0x0B,0x03,0x0B,0x03,0x03,0x07,0x03,0x03,0x03,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x0C,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x0C,0x03,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x0B,0x0B,0x08,0x08,0x08,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x0B,0x0B,0x0B,0x03,0x0B,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x03,0x08,0x03,0x08,0x03,0x08,0x03,0x08,0x08,0x07,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x0C,0x07,0x0C,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x03,0x08,0x08,0x08,0x05,0x05,0x08,0x08,0x08,0x0B,0x0B,0x07,0x07,0x07,0x07,0x07,0x03,0x08,0x03,0x08,0x03,0x08,0x08,0x03,0x08,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x07,0x0C,0x0C,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x0C,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x0C,0x03,0x03,0x0C,0x0C,0x05,0x05,0x03,0x03,0x03,0x03,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x05,0x05,0x05,0x0B,0x0B,0x08,0x0B,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x08,0x08,0x08,0x07,0x08,0x08,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x0C,0x07,0x0C,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x0C,0x0C,0x08,0x08,0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x0C,0x0C,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x0C,0x03,0x0C,0x0C,0x05,0x05,0x0C,0x03,0x03,0x03,0x03,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x05,0x08,0x08,0x08,0x08,0x08,0x03,0x03,0x08,0x08,0x03,0x08,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x08,0x07,0x0C,0x07,0x0C,0x0C,0x0C,0x0C,0x00,
	0x0C,0x0C,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x0C,0x08,0x08,0x08,0x0C,0x08,0x08,0x0C,0x08,0x0C,0x0C,0x08,0x08,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0B,0x0B,0x05,0x05,0x0C,0x03,0x0C,0x0C,0x03,0x03,0x03,0x05,0x05,0x03,0x03,0x03,0x03,0x03,0x03,0x0B,0x0B,0x0B,0x03,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x08,0x03,0x08,0x03,0x08,0x03,0x03,0x08,0x03,0x03,0x08,0x08,0x03,0x08,0x03,0x08,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x0C,0x0C,0x0C,0x04,0x00,
	0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x08,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x05,0x05,0x0C,0x0C,0x03,0x0C,0x03,0x0C,0x0C,0x0C,0x05,0x0B,0x0B,0x03,0x03,0x03,0x03,0x03,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x03,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x08,0x07,0x07,0x07,0x0C,0x07,0x0C,0x04,0x04,0x00,
	0x0C,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x08,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x0C,0x0C,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x03,0x08,0x03,0x08,0x07,0x03,0x07,0x08,0x08,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x0C,0x07,0x0C,0x0C,0x04,0x04,0x04,0x00,
	0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x08,0x0C,0x08,0x08,0x0C,0x08,0x08,0x0C,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x08,0x0F,0x08,0x07,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x0C,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x03,0x0C,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x08,0x03,0x08,0x03,0x03,0x03,0x03,0x08,0x07,0x08,0x07,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
};

const char* map_color[]=
{
	(const char*)map_colordata + 0,
	0
};

ASSET map=
{
	map_mono,
	map_shade,
	map_color
};

const char* menu_bkg_mono[]=
{
	".. . . . . . . . . . . . . . . . ... . . . . .  . . . . . . . .. . . . ... . . . . . . . ............... . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . ..... ... . . .. . . . . . . . .. ....... . . . . . . ................... ..... . ... . . . . . . . . ..._..._... . . . . . . . \n"
	" .   .   .   .   .   . . . . . . . . . . . . . :\\ . . . . . . /: . . . . . . . . . . ................. . . ... ... . . . . . . . .   ./ . . . . \\.   .   .   . .\n"
	". . . . . . . . . . . ... . . . ... ... . . ...::. . . . . . .::....... ... ... ......................................... . . . . .  . . . . . . .. . . . . . . \n"
	"   .   .   .   .   .   .   .   . . . . . . . . .::\\ . . . . /::..... . . . . . . . . ............... ... ....... . ... .   . . .   ./ . . . . . . \\.   .   .   .\n"
	". . . . . . . . . . . . . ..._..._... ... . .....::. _ . _ .::..............._..._............................... ... . . ..._..._ . . . . . . . . .._..._... . \n"
	" .   .   .   .   . . . . ./ . . . . \\. . . . . ...:::::::::::......... . ./ . . . . \\............. . . . ....... . . . . ./ . . . . . . . . . . . . . . . . \\. .\n"
	". . . . . . . . . . . . .. . . . . . .. .................................. . . . . . .................. ....... ... . . .. . . . . . . . . . . . . . . . . . .. \n"
	"   .   .   .   .   .   ./ . . . . . . \\. . . ....... .................../ . . . . . . \\........... ..... . . . . . .   ./ . . . . . . . . . . . . . . . . . . \\.\n"
	". . . . . . . . . . . .. . . . . . . . ................................. . . . . . . . .._..._........... . . . . . . .. . . . . . . . . . . . . . . . . . . . .\n"
	" .   . . .   .   . . . :\\ . . . . . . /: . . ..........................:\\ . . . . . . . . . . . \\. . . . . . . . . . . :\\ . . . . . . . . . . . . . . . . . . /:\n"
	". . . . . . . . . . . .::. . . . . . .::...............................::. . . . . . . . . . . . ...... ... . . . . . .::. . . . . . . . . . . . . . . . . . .::\n"
	"   .   .   .   .   . . .::\\ . . . . /::. . . ...........................::\\ . . . . . . . . . . . \\. . . . .   .   .   .::\\ . . . . . . . . . . . . . . . . /::.\n"
	". . . . . . . . . .......::. _ . _ .::... ..........._..._...............::. _ . _ . . . . . . . . ...... . . . . . . . .::. _ . _ . . . . . . . . . _ . _ .::. \n"
	" .   . . . . . . ....... .:::::::::::..... ......./ . . . . \\.............::::::::::\\ . . . . . . /:...... . . . . . . . .::::::::::\\ . . . . . . /::::::::::. .\n"
	". . . . . . ............... . . .................. . . . . . ......................::. . . . . . .::....... ... . . . . . . . . . .::. . . . . . .::. . . . . . \n"
	"   .   .   . ..... . . ... . . . . . ... . . . ./ . . . . . . \\.....................::\\ . . . . /::. ..... . . . . . . . . .   .   .::\\ . . . ../::.   .   .   .\n"
	". . . . . ..._..._... . . ..............._..._.. . . . . . . . ......................::. _ . _ .::..............._..._... ... . . . .::. _ . _ .::. . . . . . . \n"
	" .   . . ./ . . . . \\. ... ....... .../ . . . . . . . . . . . /:......................:::::::::::......... . ./ . . . . \\. . . . . . .:::::::::::.   .   .   . .\n"
	". . . . .. . . . . . ................. . . . . . . . . . . . .::.............................................. . . . . . .. . . . . . . . . . . . . . . . . . . \n"
	"   .   ./ . . . . . . \\. .........../.. . . . . . . . . . . /::......................................... .../ . . . . . . \\. ... . . . .   .   .   .   .   .   .\n"
	". . . .. . . . . . . . ............. . . . . . . . . . . . .::..............._..._..................._..._ . . . . . . . . ...... . . . . . . . . ..._..._... . \n"
	" .   . :\\ . . . . . . /:...........:\\ . . . . . . . . . . . \\............./ . . . . \\............./ . . . . . . . . . . . /:.. . . . . . . . . . ./ . . . . \\. .\n"
	". . . .::. . . . . . .::...........::. . . . . . . . . . . . ............. . . . . . ............. . . . . . . . . . . . .::... . . ....... . . .. . . . . . .. \n"
	"   .   .::\\ . . . . /::.............::\\ . . . . . . . . . . ..\\........./ . . . . . . \\........./ . . . . . . . . . . . /::. . . . . . .   .   ./ . . . . . . \\.\n"
	". . . . .::.._ . _ .::...............::. _ . _ . . . . . . . . ......... . . . . . . . ......... . . . . . . . . . . . .::... ... ... ..._..._.. . . . . . . . .\n"
	" . . . . .:::::::::::.................::::::::::\\ . . . . . . /:.......:\\ . . . . . . /:.......:\\ . . . . . . . . . . . \\. . . . . . ./ . . . . . . . . . . . /:\n"
	". . ... ... ...................................::. . . . . . .::.......::. . . . . . .::.......::. . . . . . . . . . . . .. ... ... .. . . . . . . . . . . . .::\n"
	"   . . . . . . . ................... ... . . . .::\\ . . . . /::. .......::\\ . . . . /::.........::\\ . . . . . . . . . . . \\. . . . ./ . . . . . . . . . . . /::.\n"
	". . . . . . . ....................... ... .......::. _ . _ .::...........::. . . . .::...........::. . . . . . . . . . . . . _..._.. . . . . . . . . . ..  .::..\n"
	" . . . . . . . . . . ................. ... ... ...:::::::::::. ... ... .../ . . . . \\............./ . . . . . . . . . . . . . . . . . . . . . . . . . .  . .\\. .\n"
	". . . . . . . . ... ........................... ....... .................. . . . . . ............. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .. \n"
	"   .   .   . . . . . ....... ............. . . . ... . . . . . . ......./ . . . . . . \\. . . .../ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \\.\n"
	". . . . . . . . . ......................._..._........... ......._..._.. . . . . . . . ......... . . . . . . . . _ . _ . . . . . . . . . _ . _ . . . . . . . . .\n"
	" .   .   . . . . . ..... . . . ... .../ . . . . \\. . . . . . ./ . . . . . . . . . . . /:.......:\\ . . . . . . /:::::::::\\ . . . . . . /:::::::::\\ . . . . . . /:\n"
	". . . . . . . . ...................... . . . . . ...... ...... . . . . . . . . . . . .::.......::. . . . . . .::.......::. . . . . . .::.......::. . . . . . .::\n"
	"   .   .   . . . . . . . ... . . .../ . . . . . . \\. . . . ./ . . . . . . . . . . . /::.........::\\ . . . . /::.........::\\ . . . . /::. . . . .::\\ . . . . /::.\n"
	". . . . . . . . . ... ......._..._.. . . . . . . . .. ...... . . . . . . . . _ . _ .::...........::. _ . _ .::...........::. . . . .::... . . . .::. _ . _ .::..\n"
	" .   . . . . . . . . . .../ . . . . . . . . . . . /:.. ... :\\ . . . . . . /::::::::::.............:::::::::::............./ . . . . \\. . . . . . .:::::::::::. .\n"
	". . . . . . .............. . . . . . . . . . . . .::.......::. . . . . . .::.............................................. . . . . . .......... ... . . . . . . \n"
	"   .   . . . . . . . . ./ . . . . . . . . . . . /::. . . ...::\\ . . . . /::. ....... ... ... ....... . ... . . . ......./.. . . . .  .\\....... . . . . .   .   .\n"
	". . . . . . . ... . . .. . . . . . . . . _ . _ .::...........::. _ . _ .::..............._ . _.......................... . . . . . . . . _.. _........... . . . \n"
	" .   . . . ... . . . . :\\ . . . . . . /::::::::::. . . . . ...:::::::::::. .........../ . . . . \\............. ... ....:\\ . . . . . . . . . . . \\......... . . .\n"
	". . . . . . . . ... ...::. . . . . . .::.............................................. . . . . . ......................::. . . . . . . . . . . . .......... . . \n"
	"   .   . . . . . . . ...::\\ . . . . /::. . . ... ... . . . . . . . . . . . . ... .../ . . . . . . \\......... . . . . ...::\\ . . . . . . . . . . . \\..... . .   .\n"
	". . . . . . . . . ... . .::. _ . _ .::. . ... ... ..._..._... ... .................. . . . . . . . .._ . _...............::. _ . _ . . . . . . . . ...... . . . \n"
	" .   .   . . . . . . . . .:::::::::::. . . . . . ./ . . . . \\. . . . . ... ... ....:\\ . . . . . . . . . . . \\.............::::::::::\\ . . . . . . /: . . .   . .\n"
	". . . . . . . . . . . . . . . ............. . . .. . . . . . .. ... ...............::. . . . . . . . . . . . ......................::. . . . . . .::. . . . . . \n"
	"   .   .   .   .   . . . . . . . . . . . . . . ./ . . . . . . \\. . . . . . ... .....::\\ . . . . . . . . . . . \\.....................::\\ . . . . /::.   .   .   .\n"
	". . . . . ... ... ... .......................... . . . . . . . ......................::. . . . . . . . . . . . ......................::. . . . .::... . . . . ..",
	0
};

const char* menu_bkg_shade[]=
{
	".. . . . . . . . . . . . . . . . ... . . . . .  . . . . . . . .. . . . ... . . . . . . . ............... . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . ..... ... . . .. . . . . . . . .. ....... . . . . . . ................... ..... . ... . . . . . . . . ..._..._... . . . . . . . \n"
	" .   .   .   .   .   . . . . . . . . . . . . .  \\ . . . . . . /  . . . . . . . . . . ................. . . ... ... . . . . . . . .   ./ . . . . \\.   .   .   . .\n"
	". . . . . . . . . . . ... . . . ... ... . . ...  . . . . . . .  ....... ... ... ......................................... . . . . .  . . . . . . .. . . . . . . \n"
	"   .   .   .   .   .   .   .   . . . . . . . . .  \\ . . . . /  ..... . . . . . . . . ............... ... ....... . ... .   . . .   ./ . . . . . . \\.   .   .   .\n"
	". . . . . . . . . . . . . ..._..._... ... . .....  . _ . _ .  ..............._..._............................... ... . . ..._..._ . . . . . . . . .._..._... . \n"
	" .   .   .   .   . . . . ./ . . . . \\. . . . . ...           ......... . ./ . . . . \\............. . . . ....... . . . . ./ . . . . . . . . . . . . . . . . \\. .\n"
	". . . . . . . . . . . . .. . . . . . .. .................................. . . . . . .................. ....... ... . . .. . . . . . . . . . . . . . . . . . .. \n"
	"   .   .   .   .   .   ./ . . . . . . \\. . . ....... .................../ . . . . . . \\........... ..... . . . . . .   ./ . . . . . . . . . . . . . . . . . . \\.\n"
	". . . . . . . . . . . .. . . . . . . . ................................. . . . . . . . .._..._........... . . . . . . .. . . . . . . . . . . . . . . . . . . . .\n"
	" .   . . .   .   . . .  \\ . . . . . . /  . . .......................... \\ . . . . . . . . . . . \\. . . . . . . . . . .  \\ . . . . . . . . . . . . . . . . . . / \n"
	". . . . . . . . . . . .  . . . . . . .  ...............................  . . . . . . . . . . . . ...... ... . . . . . .  . . . . . . . . . . . . . . . . . . .  \n"
	"   .   .   .   .   . . .  \\ . . . . /  . . . ...........................  \\ . . . . . . . . . . . \\. . . . .   .   .   .  \\ . . . . . . . . . . . . . . . . /  .\n"
	". . . . . . . . . .......  . _ . _ .  ... ..........._..._...............  . _ . _ . . . . . . . . ...... . . . . . . . .  . _ . _ . . . . . . . . . _ . _ .  . \n"
	" .   . . . . . . ....... .           ..... ......./ . . . . \\.............          \\ . . . . . . / ...... . . . . . . . .          \\ . . . . . . /          . .\n"
	". . . . . . ............... . . .................. . . . . . ......................  . . . . . . .  ....... ... . . . . . . . . . .  . . . . . . .  . . . . . . \n"
	"   .   .   . ..... . . ... . . . . . ... . . . ./ . . . . . . \\.....................  \\ . . . . /  . ..... . . . . . . . . .   .   .  \\ . . . ../  .   .   .   .\n"
	". . . . . ..._..._... . . ..............._..._.. . . . . . . . ......................  . _ . _ .  ..............._..._... ... . . . .  . _ . _ .  . . . . . . . \n"
	" .   . . ./ . . . . \\. ... ....... .../ . . . . . . . . . . . / ......................           ......... . ./ . . . . \\. . . . . . .           .   .   .   . .\n"
	". . . . .. . . . . . ................. . . . . . . . . . . . .  .............................................. . . . . . .. . . . . . . . . . . . . . . . . . . \n"
	"   .   ./ . . . . . . \\. .........../.. . . . . . . . . . . /  ......................................... .../ . . . . . . \\. ... . . . .   .   .   .   .   .   .\n"
	". . . .. . . . . . . . ............. . . . . . . . . . . . .  ..............._..._..................._..._ . . . . . . . . ...... . . . . . . . . ..._..._... . \n"
	" .   .  \\ . . . . . . / ........... \\ . . . . . . . . . . . \\............./ . . . . \\............./ . . . . . . . . . . . / .. . . . . . . . . . ./ . . . . \\. .\n"
	". . . .  . . . . . . .  ...........  . . . . . . . . . . . . ............. . . . . . ............. . . . . . . . . . . . .  ... . . ....... . . .. . . . . . .. \n"
	"   .   .  \\ . . . . /  .............  \\ . . . . . . . . . . ..\\........./ . . . . . . \\........./ . . . . . . . . . . . /  . . . . . . .   .   ./ . . . . . . \\.\n"
	". . . . .  .._ . _ .  ...............  . _ . _ . . . . . . . . ......... . . . . . . . ......... . . . . . . . . . . . .  ... ... ... ..._..._.. . . . . . . . .\n"
	" . . . . .           .................          \\ . . . . . . / ....... \\ . . . . . . / ....... \\ . . . . . . . . . . . \\. . . . . . ./ . . . . . . . . . . . / \n"
	". . ... ... ...................................  . . . . . . .  .......  . . . . . . .  .......  . . . . . . . . . . . . .. ... ... .. . . . . . . . . . . . .  \n"
	"   . . . . . . . ................... ... . . . .  \\ . . . . /  . .......  \\ . . . . /  .........  \\ . . . . . . . . . . . \\. . . . ./ . . . . . . . . . . . /  .\n"
	". . . . . . . ....................... ... .......  . _ . _ .  ...........  . . . . .  ...........  . . . . . . . . . . . . . _..._.. . . . . . . . . . ..  .  ..\n"
	" . . . . . . . . . . ................. ... ... ...           . ... ... .../ . . . . \\............./ . . . . . . . . . . . . . . . . . . . . . . . . . .  . .\\. .\n"
	". . . . . . . . ... ........................... ....... .................. . . . . . ............. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .. \n"
	"   .   .   . . . . . ....... ............. . . . ... . . . . . . ......./ . . . . . . \\. . . .../ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \\.\n"
	". . . . . . . . . ......................._..._........... ......._..._.. . . . . . . . ......... . . . . . . . . _ . _ . . . . . . . . . _ . _ . . . . . . . . .\n"
	" .   .   . . . . . ..... . . . ... .../ . . . . \\. . . . . . ./ . . . . . . . . . . . / ....... \\ . . . . . . /         \\ . . . . . . /         \\ . . . . . . / \n"
	". . . . . . . . ...................... . . . . . ...... ...... . . . . . . . . . . . .  .......  . . . . . . .  .......  . . . . . . .  .......  . . . . . . .  \n"
	"   .   .   . . . . . . . ... . . .../ . . . . . . \\. . . . ./ . . . . . . . . . . . /  .........  \\ . . . . /  .........  \\ . . . . /  . . . . .  \\ . . . . /  .\n"
	". . . . . . . . . ... ......._..._.. . . . . . . . .. ...... . . . . . . . . _ . _ .  ...........  . _ . _ .  ...........  . . . . .  ... . . . .  . _ . _ .  ..\n"
	" .   . . . . . . . . . .../ . . . . . . . . . . . / .. ...  \\ . . . . . . /          .............           ............./ . . . . \\. . . . . . .           . .\n"
	". . . . . . .............. . . . . . . . . . . . .  .......  . . . . . . .  .............................................. . . . . . .......... ... . . . . . . \n"
	"   .   . . . . . . . . ./ . . . . . . . . . . . /  . . . ...  \\ . . . . /  . ....... ... ... ....... . ... . . . ......./.. . . . .  .\\....... . . . . .   .   .\n"
	". . . . . . . ... . . .. . . . . . . . . _ . _ .  ...........  . _ . _ .  ..............._ . _.......................... . . . . . . . . _.. _........... . . . \n"
	" .   . . . ... . . . .  \\ . . . . . . /          . . . . . ...           . .........../ . . . . \\............. ... .... \\ . . . . . . . . . . . \\......... . . .\n"
	". . . . . . . . ... ...  . . . . . . .  .............................................. . . . . . ......................  . . . . . . . . . . . . .......... . . \n"
	"   .   . . . . . . . ...  \\ . . . . /  . . . ... ... . . . . . . . . . . . . ... .../ . . . . . . \\......... . . . . ...  \\ . . . . . . . . . . . \\..... . .   .\n"
	". . . . . . . . . ... . .  . _ . _ .  . . ... ... ..._..._... ... .................. . . . . . . . .._ . _...............  . _ . _ . . . . . . . . ...... . . . \n"
	" .   .   . . . . . . . . .           . . . . . . ./ . . . . \\. . . . . ... ... .... \\ . . . . . . . . . . . \\.............          \\ . . . . . . /  . . .   . .\n"
	". . . . . . . . . . . . . . . ............. . . .. . . . . . .. ... ...............  . . . . . . . . . . . . ......................  . . . . . . .  . . . . . . \n"
	"   .   .   .   .   . . . . . . . . . . . . . . ./ . . . . . . \\. . . . . . ... .....  \\ . . . . . . . . . . . \\...................... \\ . . . . /  .   .   .   .\n"
	". . . . . ... ... ... .......................... . . . . . . . ......................  . . . . . . . . . . . . ....................... . . . . .  ... . . . . ..",
	0
};

const unsigned char menu_bkg_colordata[]=
{
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x09,0x05,0x09,0x08,0x03,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x09,0x09,0x07,0x07,0x0F,0x07,0x07,0x08,0x08,0x05,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x09,0x09,0x07,0x09,0x07,0x09,0x08,0x08,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x03,0x01,0x08,0x08,0x08,0x05,0x09,0x08,0x09,0x08,0x09,0x09,0x07,0x05,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x09,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x03,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x03,0x01,0x08,0x01,0x08,0x05,0x03,0x05,0x03,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x09,0x09,0x05,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x01,0x03,0x08,0x09,0x09,0x09,0x08,0x08,0x01,0x09,0x09,0x09,0x05,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x07,0x07,0x09,0x05,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x09,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x03,0x08,0x09,0x01,0x09,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x09,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x03,0x08,0x09,0x08,0x09,0x09,0x07,0x09,0x09,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x09,0x09,0x09,0x09,0x08,0x09,0x03,0x09,0x08,0x03,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x01,0x09,0x08,0x09,0x01,0x09,0x09,0x09,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x03,0x01,0x08,0x01,0x08,0x05,0x03,0x01,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x05,0x03,0x08,0x09,0x08,0x09,0x09,0x09,0x09,0x09,0x03,0x09,0x01,0x08,0x08,0x08,0x08,0x03,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x08,0x03,0x07,0x03,0x08,0x08,0x07,0x03,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x09,0x01,0x03,0x05,0x09,0x08,0x09,0x09,0x09,0x09,0x09,0x09,0x07,0x09,0x09,0x08,0x03,0x01,0x08,0x01,0x08,0x01,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x09,0x0B,0x09,0x07,0x09,0x09,0x09,0x07,0x07,0x0B,0x09,0x09,0x09,0x07,0x09,0x09,0x09,0x09,0x08,0x03,0x08,0x09,0x08,0x03,0x03,0x03,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x09,0x08,0x07,0x09,0x09,0x08,0x09,0x09,0x09,0x08,0x09,0x08,0x09,0x05,0x08,0x05,0x09,0x01,0x08,0x08,0x09,0x05,0x09,0x08,0x03,0x03,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x09,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x08,0x07,0x09,0x07,0x07,0x09,0x08,0x07,0x07,0x07,0x08,0x0B,0x07,0x07,0x09,0x09,0x08,0x09,0x08,0x09,0x03,0x09,0x09,0x07,0x09,0x09,0x09,0x09,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x09,0x07,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x05,0x03,0x01,0x08,0x09,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x01,0x08,0x08,0x09,0x08,0x09,0x08,0x09,0x03,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x03,0x03,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x09,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x09,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x08,0x03,0x08,0x09,0x08,0x09,0x09,0x07,0x09,0x07,0x09,0x07,0x09,0x0B,0x09,0x07,0x09,0x0B,0x09,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x01,0x08,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x09,0x07,0x09,0x09,0x03,0x09,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x03,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x03,0x08,0x09,0x03,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x03,0x09,0x09,0x07,0x07,0x07,0x07,0x07,0x09,0x09,0x09,0x09,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x09,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x09,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x09,0x07,0x03,0x07,0x08,0x07,0x07,0x0B,0x07,0x07,0x08,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x08,0x03,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x03,0x08,0x09,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x07,0x09,0x07,0x09,0x07,0x09,0x07,0x07,0x0B,0x07,0x07,0x09,0x07,0x09,0x07,0x08,0x07,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x07,0x09,0x07,0x08,0x09,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x05,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x08,0x03,0x08,0x03,0x05,0x08,0x08,0x09,0x08,0x09,0x03,0x07,0x08,0x07,0x09,0x07,0x09,0x07,0x03,0x07,0x08,0x09,0x08,0x07,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x08,0x08,0x08,0x05,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x03,0x08,0x03,0x08,0x08,0x08,0x08,0x09,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x09,0x07,0x08,0x07,0x08,0x03,0x08,0x09,0x07,0x07,0x09,0x07,0x07,0x07,0x08,0x0B,0x07,0x07,0x08,0x07,0x07,0x07,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x09,0x08,0x09,0x07,0x03,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x01,0x08,0x05,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x08,0x09,0x08,0x07,0x08,0x07,0x08,0x03,0x08,0x07,0x09,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x07,0x09,0x07,0x07,0x07,0x09,0x07,0x08,0x07,0x08,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x09,0x08,0x09,0x08,0x09,0x08,0x07,0x08,0x09,0x09,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x03,0x08,0x09,0x08,0x07,0x09,0x07,0x09,0x07,0x09,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x08,0x09,0x05,0x09,0x08,0x09,0x08,0x08,0x08,0x09,0x09,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x08,0x09,0x08,0x03,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x09,0x07,0x08,0x07,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x03,0x08,0x09,0x08,0x07,0x09,0x07,0x08,0x07,0x08,0x09,0x08,0x09,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x03,0x08,0x09,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x07,0x09,0x07,0x08,0x03,0x08,0x08,0x01,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x03,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x08,0x07,0x09,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x08,0x08,0x08,0x08,0x08,0x09,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x03,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x09,0x07,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x08,0x09,0x05,0x08,0x08,0x07,0x05,0x09,0x08,0x07,0x05,0x08,0x05,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x09,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x07,0x08,0x07,0x08,0x07,0x06,0x07,0x07,0x07,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x08,0x07,0x05,0x08,0x08,0x07,0x05,0x08,0x08,0x08,0x05,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x07,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x05,0x08,0x08,0x07,0x05,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x07,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x06,0x08,0x08,0x08,0x06,0x08,0x06,0x06,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x06,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x06,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x06,0x08,0x0C,0x0C,0x0C,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x06,0x08,0x06,0x08,0x06,0x08,0x06,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x08,0x08,0x0C,0x08,0x0C,0x08,0x0C,0x08,0x07,0x08,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x0C,0x08,0x06,0x08,0x06,0x08,0x06,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x06,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x06,0x08,0x06,0x08,0x07,0x06,0x07,0x08,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x07,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x06,0x08,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x0C,0x08,0x0C,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x04,0x08,0x08,0x0C,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x06,0x08,0x06,0x08,0x06,0x08,0x07,0x0C,0x06,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x07,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x04,0x08,0x08,0x06,0x08,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x07,0x0C,0x08,0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x06,0x08,0x08,0x07,0x07,0x0A,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x06,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x06,0x06,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x06,0x07,0x0C,0x06,0x08,0x07,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x06,0x08,0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x07,0x08,0x06,0x08,0x06,0x08,0x06,0x08,0x07,0x08,0x06,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
};

const char* menu_bkg_color[]=
{
	(const char*)menu_bkg_colordata + 0,
	0
};

ASSET menu_bkg=
{
	menu_bkg_mono,
	menu_bkg_shade,
	menu_bkg_color
};

const char* menu_car_mono[]=
{
	" ,___ \n"
	"{__`_>\n"
	"\'oo\"o`",
	" ___, \n"
	"<_\'__}\n"
	"\'o\"oo`",
	0
};

const char* menu_car_shade[]=
{
	" ,__  \n"
	"{__`_>\n"
	"\'oo\"o`",
	"  __, \n"
	"<_\'__}\n"
	"\'o\"oo`",
	0
};

const unsigned char menu_car_colordata[]=
{
	0x0F,0x07,0x09,0x09,0x09,0x09,0x00,
	0x09,0x17,0x17,0x10,0x17,0x09,0x00,
	0x07,0x08,0x08,0x07,0x08,0x07,0x00,
	0x09,0x09,0x09,0x09,0x07,0x07,0x00,
	0x09,0x17,0x10,0x17,0x17,0x09,0x00,
	0x07,0x08,0x07,0x08,0x08,0x07,0x00,
};

const char* menu_car_color[]=
{
	(const char*)menu_car_colordata + 0,
	(const char*)menu_car_colordata + 21,
	0
};

ASSET menu_car=
{
	menu_car_mono,
	menu_car_shade,
	menu_car_color
};

const char* menu_frm_mono[]=
{
	". . . . . . . . .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	". . . . . . . . .",
	" _______________ \n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|               |\n"
	"|_______________|",
	0
};

const char* menu_frm_shade[]=
{
	". . . . . . . . .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	".               .\n"
	". . . . . . . . .",
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	"                 \n"
	" _______________ ",
	0
};

const unsigned char menu_frm_colordata[]=
{
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x00,
	0x88,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x87,0x00,
};

const char* menu_frm_color[]=
{
	(const char*)menu_frm_colordata + 0,
	(const char*)menu_frm_colordata + 180,
	0
};

ASSET menu_frm=
{
	menu_frm_mono,
	menu_frm_shade,
	menu_frm_color
};

const char* menu_map_mono[]=
{
	"      \n"
	"      \n"
	"      \n"
	"      ",
	" ____ \n"
	"|    |\n"
	"|    |\n"
	"|____|",
	0
};

const char* menu_map_shade[]=
{
	"      \n"
	"      \n"
	"      \n"
	"      ",
	" ____ \n"
	"      \n"
	"      \n"
	" ____ ",
	0
};

const unsigned char menu_map_colordata[]=
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x80,0x87,0x87,0x87,0x87,0x87,0x00,
	0x80,0x00,0x00,0x00,0x00,0x80,0x00,
	0x80,0x00,0x00,0x00,0x00,0x80,0x00,
	0x80,0x07,0x07,0x07,0x07,0x87,0x00,
};

const char* menu_map_color[]=
{
	(const char*)menu_map_colordata + 0,
	(const char*)menu_map_colordata + 28,
	0
};

ASSET menu_map=
{
	menu_map_mono,
	menu_map_shade,
	menu_map_color
};

const char* menu_mod_mono[]=
{
	" ___________ \n"
	"|           |\n"
	"|     A     |\n"
	"|___________|\n"
	"|         . |\n"
	"|         _ |\n"
	"|     0  | ||\n"
	"|     1  | ||\n"
	"|     2  |_||\n"
	"|         . |\n"
	"|___________|",
	" ___________ \n"
	"|           |\n"
	"|  :: A ::  |\n"
	"|___________|\n"
	"|         . |\n"
	"|         _ |\n"
	"|     0  | ||\n"
	"|     1  | ||\n"
	"|     2  |_||\n"
	"|         . |\n"
	"|___________|",
	" ___________ \n"
	"|           |\n"
	"|  >> A <<  |\n"
	"|___________|\n"
	"|         . |\n"
	"|         _ |\n"
	"|     0  | ||\n"
	"|     1  | ||\n"
	"|     2  |_||\n"
	"|         . |\n"
	"|___________|",
	0
};

const char* menu_mod_shade[]=
{
	" ___________ \n"
	"             \n"
	"      A      \n"
	"             \n"
	"          .  \n"
	"          _  \n"
	"      0      \n"
	"      1      \n"
	"      2      \n"
	"          .  \n"
	" ___________ ",
	" ___________ \n"
	"             \n"
	"   :: A ::   \n"
	"             \n"
	"          .  \n"
	"          _  \n"
	"      0      \n"
	"      1      \n"
	"      2      \n"
	"          .  \n"
	" ___________ ",
	" ___________ \n"
	"             \n"
	"   :> A <:   \n"
	" ___________ \n"
	"          .  \n"
	"          _  \n"
	"      0      \n"
	"      1      \n"
	"      2   _  \n"
	"          .  \n"
	" ___________ ",
	0
};

const unsigned char menu_mod_colordata[]=
{
	0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
	0x00,0x80,0x80,0x80,0x80,0x80,0x87,0x87,0x87,0x87,0x87,0x87,0x07,0x00,
	0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x88,0x08,0x08,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x87,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x87,0x07,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x00,
	0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
	0x07,0x87,0x87,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x0F,0x00,
	0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0x08,0x08,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x87,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x87,0x07,0x07,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x00,
	0x0F,0x7F,0x7F,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x00,
	0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,0x00,
	0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x87,0x87,0x07,0x00,
	0x07,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x8F,0x8F,0x0F,0x00,
	0x08,0x88,0x88,0x88,0x88,0x88,0x87,0x87,0x87,0x87,0x77,0x87,0x07,0x00,
	0x07,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x77,0x87,0x07,0x00,
	0x07,0x87,0x87,0x87,0x87,0x87,0x8F,0x8F,0x8F,0x8F,0x70,0x80,0x00,0x00,
	0x08,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x87,0x87,0x07,0x00,
	0x07,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x07,0x00,
};

const char* menu_mod_color[]=
{
	(const char*)menu_mod_colordata + 0,
	(const char*)menu_mod_colordata + 154,
	(const char*)menu_mod_colordata + 308,
	0
};

ASSET menu_mod=
{
	menu_mod_mono,
	menu_mod_shade,
	menu_mod_color
};

const char* menu_sld_mono[]=
{
	" ______ \n"
	"(::[]  )",
	" ______ \n"
	"(  []  )",
	0
};

const char* menu_sld_shade[]=
{
	" ______ \n"
	"(______)",
	" ______ \n"
	"(______)",
	0
};

const unsigned char menu_sld_colordata[]=
{
	0x80,0x84,0x84,0x8F,0x8F,0x80,0x80,0x80,0x00,
	0x80,0x6E,0x6E,0x70,0x70,0x87,0x87,0x87,0x00,
	0x00,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x78,0x78,0x08,0x08,0x08,0x00,
};

const char* menu_sld_color[]=
{
	(const char*)menu_sld_colordata + 0,
	(const char*)menu_sld_colordata + 18,
	0
};

ASSET menu_sld=
{
	menu_sld_mono,
	menu_sld_shade,
	menu_sld_color
};

const char* menu_swt_mono[]=
{
	" ______ \n"
	"(::[]  )",
	" ______ \n"
	"(  []  )",
	0
};

const char* menu_swt_shade[]=
{
	" ______ \n"
	"(______)",
	" ______ \n"
	"(______)",
	0
};

const unsigned char menu_swt_colordata[]=
{
	0x80,0x84,0x84,0x8F,0x8F,0x80,0x80,0x80,0x00,
	0x80,0xC7,0xC7,0x70,0x70,0x4C,0x4C,0x87,0x00,
	0x00,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x78,0x78,0x08,0x08,0x08,0x00,
};

const char* menu_swt_color[]=
{
	(const char*)menu_swt_colordata + 0,
	(const char*)menu_swt_colordata + 18,
	0
};

ASSET menu_swt=
{
	menu_swt_mono,
	menu_swt_shade,
	menu_swt_color
};

const char* menu_tag_mono[]=
{
	"  \n"
	"[]",
	"  \n"
	"[]",
	"  \n"
	"[]",
	"  \n"
	"[]",
	0
};

const char* menu_tag_shade[]=
{
	"__\n"
	"__",
	"__\n"
	"__",
	"__\n"
	"__",
	"__\n"
	"__",
	0
};

const unsigned char menu_tag_colordata[]=
{
	0x89,0x89,0x00,
	0x10,0x10,0x00,
	0x09,0x09,0x00,
	0x10,0x10,0x00,
	0x8A,0x8A,0x00,
	0x20,0x20,0x00,
	0x0A,0x0A,0x00,
	0x20,0x20,0x00,
};

const char* menu_tag_color[]=
{
	(const char*)menu_tag_colordata + 0,
	(const char*)menu_tag_colordata + 6,
	(const char*)menu_tag_colordata + 12,
	(const char*)menu_tag_colordata + 18,
	0
};

ASSET menu_tag=
{
	menu_tag_mono,
	menu_tag_shade,
	menu_tag_color
};

const char* menu_wnd_mono[]=
{
	"   _____________   \n"
	"  |  _________  |  \n"
	"  | |       . | |  \n"
	"  | |       _ | |  \n"
	"  | |      | || |  \n"
	"  | |      | || |  \n"
	"  | |      |_|| |  \n"
	"  | |       . | |  \n"
	"  | |_________| |  \n"
	"  |_____________|  \n"
	"                   ",
	0
};

const char* menu_wnd_shade[]=
{
	"   _____________   \n"
	"     _________     \n"
	"            .      \n"
	"            _      \n"
	"                   \n"
	"                   \n"
	"                   \n"
	"            .      \n"
	"     _________     \n"
	"   _____________   \n"
	"                   ",
	0
};

const unsigned char menu_wnd_colordata[]=
{
	0x80,0x80,0x80,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x00,
	0x80,0x80,0x80,0x70,0x70,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x88,0x88,0x88,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x78,0x78,0x88,0x88,0x88,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x77,0x77,0x87,0x87,0x87,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x70,0x70,0x80,0x80,0x80,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x70,0x70,0x80,0x80,0x80,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x70,0x70,0x80,0x80,0x80,0x00,
	0x80,0x80,0x80,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x78,0x78,0x88,0x88,0x88,0x00,
	0x80,0x80,0x80,0x70,0x70,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x8F,0x8F,0x8F,0x00,
	0x80,0x80,0x80,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x80,0x80,0x80,0x00,
	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
};

const char* menu_wnd_color[]=
{
	(const char*)menu_wnd_colordata + 0,
	0
};

ASSET menu_wnd=
{
	menu_wnd_mono,
	menu_wnd_shade,
	menu_wnd_color
};

const char* mountains_mono[]=
{
	"****************_**********************/\\***********************************************************************************************************************\n"
	"***************/ \\_*****************__/  \\*************_***********************************************_********************************************************\n"
	"**************/    \\**************_/      \\***********/ \\*******************************_*************/ \\__*****************************************************\n"
	"***********__/      \\***********_/         \\__*******/   \\***********_*****************/ \\__*********/     \\***************************_************************\n"
	"**********/ /.      .\\******___/..         ...\\*****/.   .\\*********/ \\__************_/     \\*******/       \\*************************/ \\***********************\n"
	"*********/..\\ .    ...\\____/.....           ...\\___/.     .\\_******/     \\*********_/.      .\\*****/        .\\__*********_***********/   \\*************_********\n"
	"********/. ./\\ . ........./... . . .      ........ . . ......\\____/.     .\\*****__/.         .\\***/..          .\\******_/ \\*********/.   .\\***********/ \\*******\n"
	"***____/. ./. . . ......./\\_. . . . .   . ......... . ........\\ . . .    ..\\***/. . . .  .  ...\\*/. ..        ...\\____/.   \\*****__/..     \\******___/   \\_*****\n"
	"__/... .   . . . ......./. . . . . .   . . ....... .   .  .....\\ . . . . ...\\_/. . ... .   . ...\\. . . .   . ......... . . .\\___/. . . .  ..\\____/.  . ....\\____\n"
	"..... . . . . . . ...../\\ . . . . . . . . . ..... . . . ......./\\ . . . . ..... . . . . . . .....\\. . . . . . ....... . . . .../..... . ......._/\\. . . ........\n"
	".... . . . . . . . . _/. \\ . . . . . . . . . . ... . . . . ... . . . . . ..... . . . . . . ..... /\\_ . . . . . ... . . . . . _/\\ . . . . ..... . .\\_ . . .......\n"
	". . . . . . . . . . . . . . . . . . . . . . . ... . . . . . . . . . . . . ... . . . . . . . ... / . . . . . . . . . . . . . . . \\ . . . . ... . . . . . . ..... \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
	0
};

const char* mountains_shade[]=
{
	"****************_**********************/\\***********************************************************************************************************************\n"
	"***************/.\\_*****************__/..\\*************_***********************************************_********************************************************\n"
	"**************/... \\**************_/......\\***********/.\\****************************** _*************/.\\__*****************************************************\n"
	"***********__/......\\***********_/.........\\__*******/...\\***********_*****************/.\\__*********/.....\\ **************************_************************\n"
	"**********/./........\\******___/.. ...........\\**** /.....\\******** /.\\__************_/.....\\ ******/.......\\*************************/.\\***********************\n"
	"*********/..\\ ........\\____/..... ......... ...\\___/..... .\\_******/.....\\*********_/........\\*****/.........\\__*********_***********/...\\*************_********\n"
	"********/. ./\\ . ........./... . . . ............. . ........\\____/.......\\*****__/. ....... .\\***/........... .\\******_/.\\*********/.....\\***********/.\\*******\n"
	"***____/. ./. . . ......./\\_. . . . . ... ......... . ........\\ . . . .....\\***/. . . . ... ...\\*/. ......... ...\\____/....\\*****__/.......\\******___/...\\_*****\n"
	"__/... . . . . . ......./. . . . . . . . . ....... .   .  .....\\ . . . . ...\\_/. . ... . . . ...\\. . . ... . ......... . ...\\___/. . . .....\\____/.  . ....\\____\n"
	"..... . . . . . . ...../\\ . . . . . . . . . ..... . . . ......./\\ . . . . ..... . . . . . . .....\\. . . . . . ....... . . . . ./..... . ......._/\\. . . ........\n"
	".... . . . . . . . . _/. \\ . . . . . . . . . . ... . . . . ... . . . . . ..... . . . . . . ..... /\\_ . . . . . ... . . . . . _/\\ . . . . ..... . .\\_ . . .......\n"
	". . . . . . . . . . . . . . . . . . . . . . . ... . . . . . . . . . . . . ... . . . . . . . ... / . . . . . . . . . . . . . . . \\ . . . . ... . . . . . . ..... \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . \n"
	" . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .\n"
	". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
	0
};

const unsigned char mountains_colordata[]=
{
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x74,0x74,0x7C,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x70,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x74,0x74,0x7F,0x7F,0x7F,0x7F,0x7F,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7F,0x7F,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x7F,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7F,0x7C,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7F,0x7F,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x00,
	0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x7C,0x7C,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,0x74,0x00,
	0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
	0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,
};

const char* mountains_color[]=
{
	(const char*)mountains_colordata + 0,
	0
};

ASSET mountains=
{
	mountains_mono,
	mountains_shade,
	mountains_color
};

const char* perf_horz_mono[]=
{
	"___________________",
	"___________________",
	0
};

const char* perf_horz_shade[]=
{
	"___________________",
	"___________________",
	0
};

const unsigned char perf_horz_colordata[]=
{
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x00,
};

const char* perf_horz_color[]=
{
	(const char*)perf_horz_colordata + 0,
	(const char*)perf_horz_colordata + 20,
	0
};

ASSET perf_horz=
{
	perf_horz_mono,
	perf_horz_shade,
	perf_horz_color
};

const char* perf_icon_mono[]=
{
	"* __.______ ***\n"
	" /_x_x_x_\\_\\_**\n"
	" \\__  __   __\\*\n"
	" /\\ \\/__\\_/ /\\ \n"
	" \\_\\/\\__/ \\/_/ ",
	0
};

const char* perf_icon_shade[]=
{
	"**__.______****\n"
	" /%x%x%x%\\%\\ **\n"
	" \\%%%%%%%%%%%\\ \n"
	" /\\ \\/__\\%/ /\\ \n"
	" \\_\\/\\__/ \\/_/ ",
	0
};

const unsigned char perf_icon_colordata[]=
{
	0x0F,0x0F,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0F,0x09,0x19,0x1E,0x19,0x1E,0x19,0x1E,0x19,0x18,0x08,0x07,0x07,0x07,0x07,0x00,
	0x0F,0x09,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x01,0x01,0x00,
	0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x01,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
};

const char* perf_icon_color[]=
{
	(const char*)perf_icon_colordata + 0,
	0
};

ASSET perf_icon=
{
	perf_icon_mono,
	perf_icon_shade,
	perf_icon_color
};

const char* perf_line_mono[]=
{
	"  *****\n"
	"* \\ ***\n"
	"** \\ **\n"
	"*** \\ *\n"
	"**** \\_\n"
	"*******\n"
	"*******",
	"  *****\n"
	"* \\ ***\n"
	" x100 *\n"
	"*** \\ *\n"
	"**** \\_\n"
	"*******\n"
	"*******",
	"**   **\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"**   **",
	"**   **\n"
	"** | **\n"
	" x100 *\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"**   **",
	"****   \n"
	"*** / *\n"
	"** / **\n"
	"* / ***\n"
	"_/ ****\n"
	"*******\n"
	"*******",
	"****   \n"
	"*** / *\n"
	" x1000 \n"
	"* / ***\n"
	"_/ ****\n"
	"*******\n"
	"*******",
	0
};

const char* perf_line_shade[]=
{
	"   ****\n"
	"* \\ ***\n"
	" x100 *\n"
	"*** \\ *\n"
	"**** \\_\n"
	"*******\n"
	"*******",
	"   ****\n"
	"* \\****\n"
	" x100 *\n"
	"*** \\ *\n"
	"**** \\_\n"
	"*******\n"
	"*******",
	"**   **\n"
	"** | **\n"
	" x100 *\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"**   **",
	"**   **\n"
	"** | **\n"
	" x100 *\n"
	"** | **\n"
	"** | **\n"
	"** | **\n"
	"**   **",
	"****   \n"
	"*** / *\n"
	" x1000 \n"
	"* / ***\n"
	"_/ ****\n"
	"*******\n"
	"*******",
	"****   \n"
	"*** / *\n"
	" x1000 \n"
	"* / ***\n"
	"_/ ****\n"
	"*******\n"
	"*******",
	0
};

const unsigned char perf_line_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x0B,0x00,
	0x08,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x87,0x87,0x87,0x07,0x0B,0x0B,0x0B,0x00,
	0x87,0x87,0x87,0x87,0x07,0x0B,0x0B,0x00,
	0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x00,
	0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x00,
	0x8F,0x8F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x8B,0x8B,0x0B,0x07,0x07,0x07,0x07,0x00,
	0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x8B,0x8B,0x0B,0x07,0x07,0x07,0x07,0x00,
	0x8B,0x8B,0x0B,0x07,0x07,0x07,0x07,0x00,
	0x8F,0x8F,0x0F,0x07,0x07,0x07,0x07,0x00,
	0x8F,0x8F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x8F,0x8F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x87,0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x00,
	0x08,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x87,0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x00,
	0x87,0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x00,
	0x87,0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x00,
	0x8F,0x8F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x8F,0x8F,0x8F,0x8F,0x0F,0x0F,0x0F,0x00,
	0x8B,0x8B,0x8B,0x0B,0x07,0x07,0x07,0x00,
	0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x8B,0x0B,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x00,
	0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x00,
	0x8F,0x8F,0x8F,0x8F,0x0F,0x0F,0x0F,0x00,
	0x87,0x87,0x87,0x07,0x0B,0x0B,0x0B,0x00,
	0x08,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x87,0x07,0x0B,0x0B,0x0B,0x0B,0x0B,0x00,
	0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x00,
	0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x00,
	0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x00,
};

const char* perf_line_color[]=
{
	(const char*)perf_line_colordata + 0,
	(const char*)perf_line_colordata + 56,
	(const char*)perf_line_colordata + 112,
	(const char*)perf_line_colordata + 168,
	(const char*)perf_line_colordata + 224,
	(const char*)perf_line_colordata + 280,
	0
};

ASSET perf_line=
{
	perf_line_mono,
	perf_line_shade,
	perf_line_color
};

const char* perf_prgs_mono[]=
{
	"* _______________________ *\n"
	" (%%%%%%%%%%%%%%%%%%%%%%%) \n"
	"* ~~~~~~~~~~~~~~~~~~~~~~~ *",
	"* _______________________ *\n"
	" (:::::::::::::::::::::::) \n"
	"* ~~~~~~~~~~~~~~~~~~~~~~~ *",
	"* _______________________ *\n"
	" (.......................) \n"
	"* ~~~~~~~~~~~~~~~~~~~~~~~ *",
	0
};

const char* perf_prgs_shade[]=
{
	"**_______________________**\n"
	" (                       ) \n"
	"***************************",
	"**_______________________**\n"
	" (                       ) \n"
	"***************************",
	"**_______________________**\n"
	" (                       ) \n"
	"***************************",
	0
};

const unsigned char perf_prgs_colordata[]=
{
	0x07,0x07,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x00,
	0x0F,0x09,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x09,0x09,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x09,0x09,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,
	0x09,0x0C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x0C,0x0C,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0C,0x0C,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0C,0x07,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x07,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
};

const char* perf_prgs_color[]=
{
	(const char*)perf_prgs_colordata + 0,
	(const char*)perf_prgs_colordata + 84,
	(const char*)perf_prgs_colordata + 168,
	0
};

ASSET perf_prgs=
{
	perf_prgs_mono,
	perf_prgs_shade,
	perf_prgs_color
};

const char* perf_tick_mono[]=
{
	"_\n"
	"|",
	0
};

const char* perf_tick_shade[]=
{
	"_\n"
	"|",
	0
};

const unsigned char perf_tick_colordata[]=
{
	0x0A,0x00,
	0x20,0x00,
};

const char* perf_tick_color[]=
{
	(const char*)perf_tick_colordata + 0,
	0
};

ASSET perf_tick=
{
	perf_tick_mono,
	perf_tick_shade,
	perf_tick_color
};

const char* rocket_mono[]=
{
	"********_____*\n"
	"--**=**) _ \\_\\\n"
	"**=**->)_____/",
	"********_____*\n"
	"-**=**>) _ \\_\\\n"
	"*-**-=*)_____/",
	"********_____*\n"
	"**=**=>) _ \\_\\\n"
	"-**-=**)_____/",
	"********_____*\n"
	"*-**-=*) _ \\_\\\n"
	"**-=**>)_____/",
	"********_____*\n"
	"-**-=**) _ \\_\\\n"
	"*-=**=*)_____/",
	"********_____*\n"
	"**-=**>) _ \\_\\\n"
	"--**=**)_____/",
	"********_____*\n"
	"*-=**=*) _ \\_\\\n"
	"-**=**>)_____/",
	0
};

const char* rocket_shade[]=
{
	"********_____*\n"
	"%)**)**)%%%\\%\\\n"
	"**)**%))____%/",
	"********_____*\n"
	")**)**%)%%%\\%\\\n"
	"*)**%)*)____%/",
	"********_____*\n"
	"**)**%))%%%\\%\\\n"
	")**%=**)____%/",
	"********_____*\n"
	"*)**%)*)%%%\\%\\\n"
	"**%)**))____%/",
	"********_____*\n"
	")**%)**)%%%\\%\\\n"
	"*%)**%*)____%/",
	"********_____*\n"
	"**%)**))%%%\\%\\\n"
	"%)**=**)____%/",
	"********_____*\n"
	"*%)**)*)%%%\\%\\\n"
	")**)**%)____%/",
	0
};

const unsigned char rocket_colordata[]=
{
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x71,0x79,0x79,0x79,0x7B,0x7B,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x71,0x71,0x79,0x79,0x79,0x7B,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x71,0x71,0x71,0x79,0x79,0x79,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x05,0x79,0x79,0x79,0x7B,0x7B,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x00,0x00,0x79,0x79,0x79,0x7B,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x71,0x71,0x71,0x79,0x7B,0x7B,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x00,0x79,0x79,0x79,0x7B,0x7B,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x05,0x05,0x79,0x79,0x79,0x79,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x71,0x71,0x71,0x79,0x7B,0x7B,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x05,0x79,0x79,0x79,0x79,0x7B,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x00,0x00,0x79,0x79,0x79,0x79,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x71,0x79,0x79,0x79,0x7B,0x7B,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,
	0x00,0x79,0x79,0x79,0x79,0x7B,0x7B,0x71,0x5D,0x5D,0x5D,0x07,0x70,0x70,0x00,
	0x71,0x71,0x71,0x79,0x79,0x79,0x7B,0x71,0x50,0x50,0x50,0x50,0x57,0x75,0x00,
};

const char* rocket_color[]=
{
	(const char*)rocket_colordata + 0,
	(const char*)rocket_colordata + 45,
	(const char*)rocket_colordata + 90,
	(const char*)rocket_colordata + 135,
	(const char*)rocket_colordata + 180,
	(const char*)rocket_colordata + 225,
	(const char*)rocket_colordata + 270,
	0
};

ASSET rocket=
{
	rocket_mono,
	rocket_shade,
	rocket_color
};

const char* scene_ascii_mono[]=
{
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"*______*\n"
	"(______)",
	"***__***\n"
	"**_%%_**\n"
	"*_%%%%_*\n"
	"_%%**%%_\n"
	"%%____%%\n"
	"%%%%%%%%\n"
	"%%****%%\n"
	"%%****%%",
	"*______*\n"
	"_%%%%%%_\n"
	"%%****%%\n"
	"%%_____*\n"
	"*%%%%%%_\n"
	"__****%%\n"
	"%%____%%\n"
	"*%%%%%%*",
	"*______*\n"
	"_%%%%%%_\n"
	"%%****%%\n"
	"%%******\n"
	"%%******\n"
	"%%****__\n"
	"%%____%%\n"
	"*%%%%%%*",
	"*______*\n"
	"*%%%%%%*\n"
	"***%%***\n"
	"***%%***\n"
	"***%%***\n"
	"***%%***\n"
	"*__%%__*\n"
	"*%%%%%%*",
	0
};

const char* scene_ascii_shade[]=
{
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"********\n"
	"        ",
	"***__***\n"
	"**_%%_**\n"
	"*_%%%%_*\n"
	"_%%**%%_\n"
	"%%____%%\n"
	"%%%%%%%%\n"
	"%%****%%\n"
	"%%****%%",
	"*______*\n"
	"_%%%%%%_\n"
	"%%****%%\n"
	"%%_____*\n"
	"*%%%%%%_\n"
	"__****%%\n"
	"%%____%%\n"
	"*%%%%%%*",
	"*______*\n"
	"_%%%%%%_\n"
	"%%****%%\n"
	"%%******\n"
	"%%******\n"
	"%%****__\n"
	"%%____%%\n"
	"*%%%%%%*",
	"*______*\n"
	"*%%%%%%*\n"
	"***%%***\n"
	"***%%***\n"
	"***%%***\n"
	"***%%***\n"
	"*__%%__*\n"
	"*%%%%%%*",
	0
};

const unsigned char scene_ascii_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x00,
	0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x00,
	0x0F,0x0F,0x07,0x09,0x01,0x07,0x07,0x07,0x00,
	0x0F,0x07,0x09,0x09,0x09,0x01,0x07,0x07,0x00,
	0x07,0x09,0x01,0x01,0x01,0x09,0x01,0x07,0x00,
	0x09,0x01,0x07,0x07,0x07,0x07,0x09,0x01,0x00,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x09,0x09,0x09,0x09,0x09,0x01,0x07,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x00,
	0x09,0x01,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x07,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x09,0x01,0x00,
	0x09,0x01,0x07,0x07,0x07,0x07,0x09,0x01,0x00,
	0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x09,0x09,0x09,0x09,0x09,0x01,0x07,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x09,0x01,0x01,0x01,0x01,0x01,0x07,0x07,0x00,
	0x09,0x01,0x07,0x07,0x07,0x07,0x09,0x01,0x00,
	0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x00,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
	0x07,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x00,
	0x01,0x01,0x01,0x09,0x01,0x01,0x01,0x01,0x00,
	0x01,0x01,0x01,0x09,0x01,0x01,0x01,0x01,0x00,
	0x01,0x01,0x01,0x09,0x01,0x01,0x01,0x01,0x00,
	0x07,0x07,0x07,0x09,0x01,0x01,0x01,0x01,0x00,
	0x01,0x07,0x07,0x09,0x01,0x07,0x07,0x07,0x00,
	0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x00,
};

const char* scene_ascii_color[]=
{
	(const char*)scene_ascii_colordata + 0,
	(const char*)scene_ascii_colordata + 72,
	(const char*)scene_ascii_colordata + 144,
	(const char*)scene_ascii_colordata + 216,
	(const char*)scene_ascii_colordata + 288,
	0
};

ASSET scene_ascii=
{
	scene_ascii_mono,
	scene_ascii_shade,
	scene_ascii_color
};

const char* scene_bk_wheel_mono[]=
{
	"**_____**\n"
	"*/:: \\ \\*\n"
	"/     \\*\\\n"
	"\\     / /\n"
	"*\\_::/_/*",
	"**_____**\n"
	"*/ : \\ \\*\n"
	"/     \\*\\\n"
	"\\     / /\n"
	"*\\_:_/_/*",
	"**_____**\n"
	"*/ ::\\ \\*\n"
	"/     \\*\\\n"
	"\\     / /\n"
	"*\\::_/_/*",
	"**_____**\n"
	"*/  :\\ \\*\n"
	"/    :\\*\\\n"
	"\\:    / /\n"
	"*\\:__/_/*",
	"**_____**\n"
	"*/   \\ \\*\n"
	"/:   :\\*\\\n"
	"\\:   :/ /\n"
	"*\\___/_/*",
	"**_____**\n"
	"*/:  \\ \\*\n"
	"/:    \\*\\\n"
	"\\    :/ /\n"
	"*\\__:/_/*",
	0
};

const char* scene_bk_wheel_shade[]=
{
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:::::\\ \\\n"
	"\\:::::/ /\n"
	"*\\:::/_/*",
	0
};

const unsigned char scene_bk_wheel_colordata[]=
{
	0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x00,
	0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x00,
	0x08,0x07,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x00,
	0x08,0x08,0x08,0x08,0x07,0x08,0x08,0x08,0x08,0x00,
};

const char* scene_bk_wheel_color[]=
{
	(const char*)scene_bk_wheel_colordata + 0,
	(const char*)scene_bk_wheel_colordata + 50,
	(const char*)scene_bk_wheel_colordata + 100,
	(const char*)scene_bk_wheel_colordata + 150,
	(const char*)scene_bk_wheel_colordata + 200,
	(const char*)scene_bk_wheel_colordata + 250,
	0
};

ASSET scene_bk_wheel=
{
	scene_bk_wheel_mono,
	scene_bk_wheel_shade,
	scene_bk_wheel_color
};

const char* scene_chassis_mono[]=
{
	"***************_*******************************\n"
	"**************(*)******************************\n"
	"***__________/_|_\\_________________************\n"
	"**/  ____  ____  ____\\  ___________\\______*****\n"
	"*/  /\\_ / /\\_ / /\\_ /*\\//    \\\\           \\****\n"
	"/__/ / /_/ / /_/ / /__//______\\\\___________\\_**\n"
	"\\./___/./___/./___/. . . . . . .\\______ . ___\\*\n"
	"*\\\\_\\_\\_\\_\\_\\_\\_\\_\\._____. _____.\\_____\\\\\\\\ __\\\n"
	"**\\_/****\\__/****\\ /____/./*****\\/*::%:\\___/%:/\n"
	"******************\\/____//*******\\_____//  \\_/*\n"
	"********************\\_\\_\\**********\\_\\_\\\\__//**",
	0
};

const char* scene_chassis_shade[]=
{
	"***************_*******************************\n"
	"**************(%)******************************\n"
	"***__________/%|_\\_________________************\n"
	"* /%%%%%%%%%%%%%%%%%%\\  ___________\\______*****\n"
	"*/%%/\\__/%/\\__/%/\\__/:\\//    \\\\           \\****\n"
	"/%%/ /%/%/ /%/%/ /%/__//______\\\\___________\\_**\n"
	"\\%/_/%/%/_/%/%/_/%/:%%%%%%%%%%%:\\%%%%%%%%%%%%\\*\n"
	"*\\\\_\\_\\_\\_\\_\\_\\_\\_\\%%%%%%%%%%%%%:\\_____\\\\\\\\ __\\\n"
	"**\\%/****\\%/*****\\%/____/%/*****\\/ ::%:\\___/%:/\n"
	"******************\\/____//*******\\_____//  \\_/*\n"
	"********************\\_\\_\\**********\\_\\_\\\\__//**",
	0
};

const unsigned char scene_chassis_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x09,0x01,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x09,0x01,0x01,0x07,0x08,0x07,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x0F,0x0F,0x07,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x0F,0x07,0x09,0x09,0x07,0x08,0x02,0x02,0x07,0x09,0x07,0x08,0x02,0x02,0x07,0x09,0x07,0x08,0x02,0x02,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x00,
	0x07,0x09,0x09,0x07,0x07,0x02,0x0A,0x07,0x09,0x07,0x07,0x02,0x0A,0x07,0x09,0x07,0x07,0x02,0x0A,0x07,0x01,0x01,0x01,0x01,0x08,0x08,0x08,0x07,0x08,0x08,0x01,0x01,0x08,0x08,0x07,0x0F,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x09,0x09,0x09,0x09,0x00,
	0x01,0x01,0x07,0x09,0x02,0x0A,0x07,0x01,0x07,0x09,0x02,0x0A,0x07,0x01,0x07,0x09,0x02,0x0A,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
	0x0F,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x09,0x01,0x09,0x09,0x01,0x01,0x09,0x09,0x01,0x00,
	0x0F,0x0F,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x0C,0x0E,0x0F,0x0E,0x01,0x01,0x09,0x09,0x01,0x0F,0x0E,0x01,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x01,0x01,0x09,0x09,0x09,0x09,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x09,0x09,0x09,0x01,0x01,0x01,0x01,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
};

const char* scene_chassis_color[]=
{
	(const char*)scene_chassis_colordata + 0,
	0
};

ASSET scene_chassis=
{
	scene_chassis_mono,
	scene_chassis_shade,
	scene_chassis_color
};

const char* scene_fr_wheel_mono[]=
{
	"**_____**\n"
	"*/\\  \\ \\*\n"
	"/ /-\\ \\ \\\n"
	"\\ \\-/ / /\n"
	"*\\__\\/_/*",
	"**_____**\n"
	"*/ | \\ \\*\n"
	"/ /-\\ \\ \\\n"
	"\\ \\-/ / /\n"
	"*\\_|_/_/*",
	"**_____**\n"
	"*/  /\\ \\*\n"
	"/ /-\\ \\ \\\n"
	"\\ \\-/ / /\n"
	"*\\/__/_/*",
	"**_____**\n"
	"*/   \\ \\*\n"
	"/ /-\\\'\\ \\\n"
	"\\,\\-/ / /\n"
	"*\\___/_/*",
	"**_____**\n"
	"*/   \\ \\*\n"
	"/_/-\\_\\ \\\n"
	"\\ \\-/ / /\n"
	"*\\___/_/*",
	"**_____**\n"
	"*/   \\ \\*\n"
	"/\'/-\\ \\ \\\n"
	"\\ \\-/,/ /\n"
	"*\\___/_/*",
	0
};

const char* scene_fr_wheel_shade[]=
{
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	"**_____**\n"
	"*/:::\\ \\*\n"
	"/:/-\\:\\ \\\n"
	"\\:\\-/:/ /\n"
	"*\\:::/_/*",
	0
};

const unsigned char scene_fr_wheel_colordata[]=
{
	0x0F,0x0F,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x0F,0x0E,0x0F,0x0F,0x06,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x06,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x00,
	0x07,0x06,0x08,0x07,0x0E,0x06,0x08,0x08,0x08,0x00,
	0x0F,0x07,0x06,0x0F,0x0F,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x08,0x0E,0x06,0x0F,0x06,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x06,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x00,
	0x07,0x06,0x08,0x07,0x0E,0x06,0x08,0x08,0x08,0x00,
	0x08,0x07,0x06,0x0F,0x06,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x08,0x0E,0x06,0x0F,0x0F,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x06,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x00,
	0x07,0x06,0x08,0x07,0x0E,0x06,0x08,0x08,0x08,0x00,
	0x08,0x07,0x0F,0x0F,0x06,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x08,0x0E,0x06,0x06,0x0F,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x06,0x08,0x08,0x08,0x0F,0x07,0x07,0x08,0x00,
	0x07,0x0F,0x08,0x07,0x0E,0x06,0x08,0x08,0x08,0x00,
	0x08,0x07,0x0F,0x06,0x06,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x08,0x0E,0x06,0x06,0x06,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x0F,0x08,0x08,0x08,0x0F,0x07,0x07,0x08,0x00,
	0x07,0x0F,0x08,0x07,0x0E,0x0F,0x08,0x08,0x08,0x00,
	0x08,0x07,0x06,0x06,0x06,0x08,0x08,0x08,0x08,0x00,
	0x08,0x08,0x0E,0x0E,0x0E,0x08,0x08,0x08,0x08,0x00,
	0x08,0x0E,0x0F,0x06,0x06,0x07,0x07,0x08,0x08,0x00,
	0x0E,0x0F,0x08,0x08,0x08,0x06,0x07,0x07,0x08,0x00,
	0x07,0x06,0x08,0x07,0x0E,0x0F,0x08,0x08,0x08,0x00,
	0x08,0x07,0x06,0x06,0x0F,0x08,0x08,0x08,0x08,0x00,
};

const char* scene_fr_wheel_color[]=
{
	(const char*)scene_fr_wheel_colordata + 0,
	(const char*)scene_fr_wheel_colordata + 50,
	(const char*)scene_fr_wheel_colordata + 100,
	(const char*)scene_fr_wheel_colordata + 150,
	(const char*)scene_fr_wheel_colordata + 200,
	(const char*)scene_fr_wheel_colordata + 250,
	0
};

ASSET scene_fr_wheel=
{
	scene_fr_wheel_mono,
	scene_fr_wheel_shade,
	scene_fr_wheel_color
};

const char* scene_patrol_mono[]=
{
	"***__________*******_*****____________*__________******_________*****___****\n"
	"**/%%%%%%%%%%\\*****/%****/%%%%%%%%%%%%/%%%%%%%%%%\\****/%%%%%%%%%\\***/%%/****\n"
	"****__******\\%\\***/%%\\*********__*******__******\\%\\**___*******\\%%**%%/*****\n"
	"***/%%******/%%**/%%%%********/%%******/%%******/%%*/%%/*******/%%*/%%******\n"
	"***%%/******%%/*/%%/%%\\*******%%/******%%/******%%/*%%/********%%/*%%/******\n"
	"**/%%*****_/%%*/%%/*\\%%******/%%******/%%*****_/%%*/%%********/%%*/%%*******\n"
	"**%%/____/%%/*/%%/___%%\\*****%%/******%%/____/%%/**%%/********%%/*%%/*******\n"
	"*/%%%%%%%%/**/%%%%%%%%%%****/%%******/%%%%%%%%%/**/%%********/%%*/%%********\n"
	"*%%/********___******\\%%\\***%%/******%%/***\\%%\\***%%\\_______/%%/*___________\n"
	"/%%********/%%/*******\\%%**/%%******/%%*****\\%%\\**\\%%%%%%%%%%/**/%%%%%%%%%%/",
	0
};

const char* scene_patrol_shade[]=
{
	"***__________*******_*****____________ __________******_________*****___****\n"
	"**/%%%%%%%%%%\\*****/%****/%%%%%%%%%%%%/%%%%%%%%%%\\****/%%%%%%%%%\\** /%%/****\n"
	"****__******\\%\\***/%%\\*********__*******__******\\%\\**___*******\\%%**%%/*****\n"
	"***/%%******/%%**/%%%%********/%%******/%%******/%%*/%%/*******/%%*/%%******\n"
	"***%%/******%%/*/%%/%%\\*******%%/******%%/******%%/*%%/********%%/*%%/******\n"
	"**/%%*****_/%%*/%%/*\\%%******/%%******/%%*****_/%%*/%%********/%%*/%%*******\n"
	"**%%/____/%%/*/%%/___%%\\*****%%/******%%/____/%%/**%%/********%%/*%%/*******\n"
	"*/%%%%%%%%/**/%%%%%%%%%%****/%%******/%%%%%%%%%/**/%%********/%%*/%%********\n"
	"*%%/********___******\\%%\\***%%/******%%/***\\%%\\***%%\\_______/%%/*___________\n"
	"/%%********/%%/*******\\%%**/%%******/%%*****\\%%\\**\\%%%%%%%%%%/**/%%%%%%%%%%/",
	0
};

const unsigned char scene_patrol_colordata[]=
{
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0C,0x04,0x04,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,
	0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x04,0x04,0x04,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0C,0x04,0x04,0x04,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,
	0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x0F,0x0C,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x00,
};

const char* scene_patrol_color[]=
{
	(const char*)scene_patrol_colordata + 0,
	0
};

ASSET scene_patrol=
{
	scene_patrol_mono,
	scene_patrol_shade,
	scene_patrol_color
};

const char* tank_mono[]=
{
	"***_v_**\n"
	"==(___)*\n"
	"**_/_\\_*\n"
	"*(O(O)O)",
	"**_v_***\n"
	"*(___)==\n"
	"*_/_\\_**\n"
	"(O(O)O)*",
	0
};

const char* tank_shade[]=
{
	"***_v_**\n"
	"==(%%%)*\n"
	"**_/%\\_*\n"
	"*(O(O)O)",
	"**_v_***\n"
	"*(%%%)==\n"
	"*_/%\\_**\n"
	"(O(O)O)*",
	0
};

const unsigned char tank_colordata[]=
{
	0x70,0x70,0x70,0x7A,0x7A,0x7A,0x7A,0x7A,0x00,
	0x70,0x70,0x7A,0x2A,0x23,0x82,0x70,0x70,0x00,
	0x70,0x70,0x7A,0x7A,0x3A,0x70,0x70,0x70,0x00,
	0x70,0x72,0x70,0x72,0x70,0x70,0x70,0x70,0x00,
	0x0A,0x0A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x00,
	0x00,0x7A,0x2A,0x23,0x82,0x70,0x70,0x70,0x00,
	0x00,0x7A,0x7A,0x3A,0x70,0x70,0x70,0x70,0x00,
	0x72,0x70,0x72,0x70,0x70,0x70,0x70,0x70,0x00,
};

const char* tank_color[]=
{
	(const char*)tank_colordata + 0,
	(const char*)tank_colordata + 36,
	0
};

ASSET tank=
{
	tank_mono,
	tank_shade,
	tank_color
};

const char* tank_bullet_mono[]=
{
	"(%%",
	0
};

const char* tank_bullet_shade[]=
{
	"(%%",
	0
};

const unsigned char tank_bullet_colordata[]=
{
	0x7B,0x1B,0x70,0x00,
};

const char* tank_bullet_color[]=
{
	(const char*)tank_bullet_colordata + 0,
	0
};

ASSET tank_bullet=
{
	tank_bullet_mono,
	tank_bullet_shade,
	tank_bullet_color
};

const char* ufo_mono[]=
{
	"***__***\n"
	"*_/__\\_*\n"
	"(______)",
	0
};

const char* ufo_shade[]=
{
	"***__***\n"
	"*_/%%\\_*\n"
	"(%_____)",
	0
};

const unsigned char ufo_colordata[]=
{
	0x70,0x70,0x70,0x7E,0x7E,0x7E,0x7E,0x7E,0x00,
	0x70,0x7E,0x7E,0x7E,0x70,0x70,0x76,0x76,0x00,
	0x7E,0x6E,0x60,0x60,0x60,0x60,0x60,0x70,0x00,
};

const char* ufo_color[]=
{
	(const char*)ufo_colordata + 0,
	0
};

ASSET ufo=
{
	ufo_mono,
	ufo_shade,
	ufo_color
};

const char* wheel_mono[]=
{
	"*__*\n"
	"/ /\\\n"
	"\\/_/",
	"*__*\n"
	"/__\\\n"
	"\\__/",
	"*__*\n"
	"/\\ \\\n"
	"\\_\\/",
	"*__*\n"
	"/ /\\\n"
	"\\/_/",
	"*__*\n"
	"/__\\\n"
	"\\__/",
	"*__*\n"
	"/\\ \\\n"
	"\\_\\/",
	0
};

const char* wheel_shade[]=
{
	"*__*\n"
	"/ /\\\n"
	"\\/_/",
	"*__*\n"
	"/__\\\n"
	"\\__/",
	"*__*\n"
	"/\\ \\\n"
	"\\_\\/",
	"*__*\n"
	"/ /\\\n"
	"\\/_/",
	"*__*\n"
	"/__\\\n"
	"\\__/",
	"*__*\n"
	"/\\ \\\n"
	"\\_\\/",
	0
};

const unsigned char wheel_colordata[]=
{
	0x70,0x70,0x70,0x70,0x00,
	0x70,0x60,0x68,0x70,0x00,
	0x70,0x68,0x60,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x68,0x68,0x70,0x00,
	0x70,0x60,0x60,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x68,0x68,0x70,0x00,
	0x70,0x60,0x68,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x60,0x68,0x70,0x00,
	0x70,0x68,0x60,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x68,0x68,0x70,0x00,
	0x70,0x60,0x60,0x70,0x00,
	0x00,0x70,0x70,0x70,0x00,
	0x70,0x68,0x68,0x70,0x00,
	0x70,0x60,0x68,0x70,0x00,
};

const char* wheel_color[]=
{
	(const char*)wheel_colordata + 0,
	(const char*)wheel_colordata + 15,
	(const char*)wheel_colordata + 30,
	(const char*)wheel_colordata + 45,
	(const char*)wheel_colordata + 60,
	(const char*)wheel_colordata + 75,
	0
};

ASSET wheel=
{
	wheel_mono,
	wheel_shade,
	wheel_color
};

