'''
Created on Nov 11, 2018

@author: gsnyder

Given a CVE (or BDSA) identifier, find all affected project-versions and print out
their names, version(s), development phase, distribution, and last BOM update date
'''
import argparse
# pip install terminaltables
from terminaltables import AsciiTable

from blackduck.HubRestApi import HubInstance
from pprint import pprint

hub = HubInstance()

parser = argparse.ArgumentParser()
parser.add_argument("vulnerability", help="A CVE or BDSA number, e.g. CVE-2016-4009")
args = parser.parse_args()

affected_projects = hub.get_vulnerability_affected_projects(args.vulnerability.upper()).get('items', [])

if affected_projects:
	ttable = [[
		"project-name", 
		"version", 
		"phase", 
		"distribution", 
		"scan-info", 
		"Owner Name", 
		"Owner email"]]

	for affected_project in affected_projects:
		# Get the Owner info for the project
		# project_json = hub.get_project_by_id(affected_project['project']['id'])
		project_url = affected_project['project']
		custom_headers = {'Accept': 'application/vnd.blackducksoftware.project-detail-4+json'}
		project_details = hub.execute_get(project_url, custom_headers=custom_headers).json()
		if 'projectOwner' in project_details:
			custom_headers = {'Accept': 'application/vnd.blackducksoftware.user-4+json'}
			owner_response = hub.execute_get(project_details['projectOwner'], custom_headers=custom_headers)
			owner_json = owner_response.json()

			if 'firstName' in owner_json and 'lastName' in owner_json:
				owner_name = owner_json['firstName'] + ' ' + owner_json['lastName']
			else:
				owner_name = "None supplied"
			if 'email' in owner_json:
				owner_email = owner_json['email']
			else:
				owner_email = "None supplied"
		else:
			owner_name = owner_email = "None supplied"

		project_name = affected_project['projectName']
		version = affected_project['projectVersionName']

		# Development phase does not appear to be in the payload returned by the affected projects
		# endpoint so we need to fetch it from the project-version endpoint
		version_url = affected_project['projectVersion']
		custom_headers = {'Accept': 'application/vnd.blackducksoftware.project-detail-5+json'}
		project_version_info = hub.execute_get(version_url, custom_headers=custom_headers).json()

		phase = project_version_info['phase']
		distribution = project_version_info['distribution']
		scan_info = hub.get_version_scan_info(project_version_info)
		separator = "\n"
		scan_info_str = separator.join("{}: {}".format(k,v) for k,v in scan_info.items())
		# last_bom_update = project_version_info['lastBomUpdateDate']

		ttable.append([
			project_name, 
			version, 
			phase, 
			distribution, 
			scan_info_str, 
			owner_name, 
			owner_email])
	print(AsciiTable(ttable).table)
else:
	print("No affected projects found for this vulnerability {}".format(args.vulnerability.upper()))