// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

const CommunityIcon = (props: any) => (
    <svg
        version='1.0'
        xmlns='http://www.w3.org/2000/svg'
        width={props.width}
        height={props.height}
        viewBox='0 0 756.000000 582.000000'
        preserveAspectRatio='xMidYMid meet'
        style={props.style}>
        <title>{props.title}</title>
        <g transform='translate(0.000000,582.000000) scale(0.100000,-0.100000)' fill={props.fill} stroke='none'>
            <path d='M138 5733 l-56 -58 -33 -189 -33 -189 25 -154 c24 -147 25 -154 8 -169 -32 -29 -42 -77 -25 -117 15 -36 58 -67 94 -67 14 0 36 -27 74 -91 53 -88 54 -93 43 -127 -15 -42 -5 -86 25 -117 16 -16 34 -20 80 -20 l60 0 250 -199 c247 -196 250 -198 250 -236 0 -47 29 -85 75 -100 31 -10 41 -9 81 10 l45 22 117 -37 c64 -21 131 -42 149 -47 24 -6 33 -16 38 -38 4 -17 17 -38 29 -47 l22 -17 -33 -230 c-18 -127 -32 -234 -33 -238 0 -3 -15 -15 -34 -26 -66 -39 -65 -140 2 -179 28 -16 29 -19 41 -146 l13 -129 -26 -27 c-34 -35 -42 -81 -23 -120 15 -31 14 -34 -62 -194 -77 -160 -79 -163 -117 -172 -52 -13 -88 -65 -80 -115 5 -35 2 -39 -144 -185 l-149 -149 -44 3 c-52 3 -90 -23 -107 -74 -10 -31 -9 -41 10 -81 l23 -46 -63 -207 -63 -206 -39 -17 c-73 -32 -85 -128 -21 -178 14 -11 38 -20 53 -20 26 0 37 -17 158 -232 129 -230 130 -232 115 -261 -34 -67 20 -147 99 -147 31 0 46 7 71 32 l32 31 285 -2 c279 -2 286 -2 305 19 18 20 18 22 -9 108 -27 84 -28 90 -12 120 31 60 14 123 -41 151 -27 14 -68 14 -93 1 -14 -7 -49 7 -164 66 -138 72 -146 77 -146 105 0 18 -9 39 -24 54 l-25 25 29 152 c40 205 36 195 65 202 34 9 66 62 63 104 -2 32 6 40 167 178 164 139 171 144 208 139 84 -12 149 53 129 128 -9 31 -5 38 104 167 158 187 148 189 266 -38 81 -155 89 -176 79 -198 -16 -35 -14 -81 6 -114 16 -27 15 -32 -42 -183 -53 -144 -60 -157 -86 -162 -99 -22 -104 -178 -6 -203 30 -8 32 -12 140 -322 l109 -313 -17 -38 c-14 -31 -15 -43 -6 -72 17 -50 45 -71 98 -73 43 -2 50 -7 172 -122 118 -112 127 -123 123 -151 -10 -67 39 -121 109 -121 22 0 41 10 66 35 l35 35 202 0 203 0 13 25 c12 23 10 33 -23 106 -35 79 -36 81 -20 114 24 49 9 102 -36 132 -39 27 -65 29 -104 8 -27 -14 -33 -12 -112 27 -73 36 -85 46 -91 73 -8 38 -31 64 -71 81 -31 13 -34 22 -122 291 -110 341 -107 330 -88 351 25 27 30 66 13 105 l-15 36 112 215 c106 203 114 215 144 221 52 10 84 44 90 96 4 39 1 50 -22 78 l-28 32 32 197 c18 108 35 205 37 215 3 9 19 24 35 32 28 15 34 13 331 -129 278 -133 303 -147 309 -173 3 -15 11 -37 18 -48 11 -17 0 -55 -85 -283 -63 -172 -102 -262 -111 -262 -27 0 -69 -29 -81 -55 -20 -43 -14 -82 17 -117 l28 -33 -38 -290 c-21 -159 -38 -297 -39 -305 0 -8 -14 -23 -30 -32 -42 -24 -64 -79 -50 -123 14 -43 37 -63 86 -73 38 -8 41 -10 157 -212 105 -184 116 -208 109 -235 -11 -37 2 -86 27 -109 11 -10 41 -21 66 -23 42 -5 48 -3 79 31 l35 36 304 0 305 0 11 28 c11 26 7 37 -49 135 -51 88 -59 110 -51 126 37 68 -12 151 -88 151 -23 0 -50 -5 -60 -12 -17 -10 -39 -3 -147 48 -120 56 -128 62 -136 94 -5 19 -21 45 -35 58 l-26 23 18 260 19 260 27 15 c15 7 35 24 43 36 18 25 21 80 6 108 -8 14 14 51 123 200 128 177 133 183 170 185 40 2 71 24 93 66 20 40 78 46 116 14 16 -14 35 -25 42 -25 18 0 52 -168 37 -189 -32 -44 -42 -82 -31 -117 13 -39 53 -74 85 -74 20 0 35 -36 158 -367 132 -352 136 -367 119 -386 -11 -12 -17 -35 -17 -64 0 -38 5 -49 34 -75 28 -25 40 -29 74 -26 l40 4 136 -149 c116 -127 135 -152 133 -177 -4 -34 21 -85 47 -100 11 -5 38 -10 61 -10 33 0 48 6 71 30 l30 30 292 2 292 3 9 26 c8 24 -1 41 -92 169 -100 143 -101 143 -95 191 5 45 3 51 -30 84 -40 40 -86 47 -126 19 -21 -15 -28 -14 -135 31 -110 45 -114 47 -125 86 -11 35 -45 68 -84 82 -5 1 -49 168 -98 370 l-89 368 20 26 c11 14 20 32 20 39 0 18 13 24 104 50 79 22 80 23 107 3 31 -21 85 -25 124 -7 23 10 36 7 115 -32 50 -24 90 -49 90 -55 0 -6 8 -27 19 -47 l18 -36 -60 -146 c-52 -125 -64 -146 -83 -146 -31 0 -71 -35 -84 -74 -22 -68 33 -136 109 -136 28 0 46 -19 190 -198 l159 -199 -5 -46 c-7 -57 13 -92 64 -113 86 -36 164 42 134 134 -12 36 -11 40 54 155 36 64 70 117 75 117 4 0 23 -61 40 -136 l32 -136 -21 -38 c-25 -44 -27 -80 -7 -119 27 -51 103 -67 149 -31 14 11 31 20 39 20 7 0 104 -24 216 -53 197 -52 203 -55 236 -93 30 -35 38 -39 81 -39 40 0 51 4 77 34 28 31 30 38 24 84 -5 48 -3 54 47 133 47 76 55 84 83 84 40 0 80 31 94 74 17 52 -7 101 -62 126 l-43 19 -69 187 c-66 182 -68 188 -52 215 24 41 20 92 -9 127 -14 17 -23 36 -21 44 2 7 7 25 10 39 4 17 17 31 36 39 74 31 80 149 9 186 -16 8 -38 14 -51 14 -19 1 -61 58 -241 328 -205 308 -217 328 -206 354 27 65 -28 138 -105 138 -43 0 -44 1 -245 210 -189 196 -202 212 -196 239 8 37 -16 95 -47 112 -12 7 -44 13 -69 14 -46 0 -49 2 -212 154 -153 142 -165 156 -160 183 13 67 -39 121 -112 117 -44 -3 -46 -1 -174 117 l-130 119 0 48 c-1 66 -40 107 -101 107 -22 0 -51 -7 -63 -15 -22 -14 -50 -3 -467 173 l-444 189 -18 42 c-30 71 -111 90 -166 38 l-22 -21 -413 63 c-243 38 -414 68 -416 75 -2 6 -19 26 -37 44 -46 46 -93 45 -141 -3 l-35 -35 -243 0 -243 0 -35 35 c-48 48 -95 49 -143 1 -19 -19 -34 -40 -34 -48 0 -9 -68 -29 -223 -64 l-222 -51 -28 23 c-48 40 -130 24 -155 -30 -6 -14 -20 -26 -29 -26 -10 -1 -81 -7 -158 -14 l-139 -14 -27 29 c-22 23 -35 29 -71 29 -24 0 -53 -7 -65 -15 -21 -15 -34 -11 -200 57 -168 69 -179 75 -189 106 -5 18 -22 45 -37 59 -21 22 -34 26 -75 25 l-48 -1 -141 142 -140 142 -52 120 c-52 117 -53 119 -37 152 29 60 12 128 -37 150 -22 10 -24 18 -30 119 -4 59 -7 161 -7 226 0 118 0 119 -26 128 -37 14 -34 15 -96 -47z m42 -437 c-19 -19 -21 -19 -56 -3 -31 15 -35 21 -30 45 4 15 17 90 31 166 16 91 31 146 42 159 17 18 18 12 25 -164 7 -175 7 -185 -12 -203z m-56 -52 c9 -4 16 -18 16 -34 0 -15 9 -39 20 -53 l20 -26 -22 -58 -22 -58 -12 65 c-18 92 -27 170 -21 170 3 0 12 -3 21 -6z m170 -239 c25 -58 46 -109 46 -114 0 -8 -93 3 -110 14 -5 3 -10 12 -10 19 0 7 -9 25 -21 40 l-21 27 22 59 c12 33 28 60 35 60 7 0 33 -47 59 -105z m22 -166 c58 -10 60 -12 202 -152 78 -78 142 -146 142 -151 0 -8 -62 -4 -182 10 -33 4 -48 10 -48 21 0 27 -56 73 -89 73 -27 0 -35 8 -85 91 -30 51 -52 98 -49 105 6 17 30 17 109 3z m304 -355 c27 -4 39 -13 51 -37 12 -24 27 -36 65 -48 49 -16 49 -16 112 -138 35 -68 61 -125 58 -128 -4 -5 -412 313 -456 355 -13 12 -5 13 60 8 41 -4 91 -9 110 -12z m2465 -74 c4 -11 20 -27 36 -35 l29 -16 0 -184 c0 -154 -2 -185 -14 -185 -21 0 -54 -46 -62 -85 -5 -31 -11 -34 -147 -88 -125 -50 -143 -55 -157 -42 -9 8 -30 19 -46 25 -29 10 -32 18 -112 290 l-83 279 20 20 c12 12 21 26 21 31 0 6 91 10 254 10 246 0 255 -1 261 -20z m-2064 -61 c96 -39 177 -74 181 -77 4 -4 8 -19 10 -33 2 -21 -10 -36 -69 -88 -72 -62 -73 -62 -108 -51 -19 6 -39 9 -45 5 -9 -5 -160 282 -160 305 0 5 4 10 9 10 4 0 86 -32 182 -71z m2663 1 c214 -33 391 -61 392 -63 2 -2 -177 -77 -398 -166 l-402 -163 -35 21 -36 20 -3 180 -2 180 30 16 c16 8 30 20 30 25 0 15 6 14 424 -50z m-1287 39 c6 -6 28 -16 49 -24 l39 -13 81 -273 81 -274 -29 -26 c-15 -15 -29 -38 -30 -51 0 -12 -2 -29 -2 -37 -1 -8 -93 -50 -228 -104 -217 -86 -228 -90 -247 -73 -28 25 -82 31 -119 12 l-31 -16 -178 141 c-175 139 -178 142 -175 176 2 19 -2 48 -8 63 -12 28 -8 36 89 175 101 144 102 145 140 145 43 0 83 26 103 68 12 24 27 30 208 73 209 50 240 55 257 38z m-651 -134 c4 -11 -109 -188 -196 -306 -3 -3 -19 -4 -37 -2 -29 5 -35 13 -83 120 -48 106 -51 115 -36 132 9 10 16 23 16 29 0 7 6 12 13 13 6 0 68 6 137 13 171 18 180 18 186 1z m2385 -31 c11 -14 -5 -69 -106 -375 -118 -354 -120 -359 -147 -359 -15 0 -30 -5 -33 -11 -4 -6 -13 -8 -21 -5 -8 3 -133 89 -279 192 -254 179 -264 188 -261 216 3 30 8 32 407 194 222 90 409 163 415 164 6 0 18 -7 25 -16z m615 -187 l431 -181 12 -44 11 -43 -188 -262 -189 -262 -39 0 -38 0 -237 485 c-130 267 -235 489 -232 493 6 11 -29 25 469 -186z m-282 -322 c211 -431 235 -486 224 -505 -7 -11 -20 -18 -28 -15 -8 2 -160 45 -337 96 -304 86 -323 93 -323 115 0 13 -11 35 -24 50 l-23 28 115 345 c101 307 128 371 152 371 4 0 113 -218 244 -485z m-3158 448 c30 -5 36 -13 83 -120 49 -111 54 -133 28 -133 -6 0 -78 21 -159 46 -127 41 -147 50 -153 71 -4 18 2 30 32 56 21 17 53 47 73 64 20 19 41 30 50 27 8 -3 29 -8 46 -11z m1813 -354 c29 -21 81 -23 121 -5 11 4 101 -54 284 -182 l268 -189 2 -50 3 -50 -353 -302 c-347 -296 -354 -302 -389 -295 -19 3 -38 10 -41 15 -9 16 -254 843 -254 860 0 9 7 22 15 29 8 7 17 27 21 45 5 31 11 34 142 88 76 30 141 56 145 56 4 1 21 -9 36 -20z m-1359 -201 c174 -138 180 -144 180 -179 0 -40 29 -84 62 -95 l21 -6 -8 -412 c-3 -226 -10 -415 -15 -419 -8 -9 -21 5 -299 346 l-202 248 11 35 c14 41 -1 96 -31 118 -19 13 -19 16 12 247 32 235 39 259 76 259 8 0 95 -64 193 -142z m3711 18 c128 -119 129 -120 129 -164 0 -37 6 -50 33 -77 l34 -34 -18 -153 c-27 -227 -29 -238 -44 -238 -7 0 -26 -11 -42 -23 l-28 -24 -330 108 -330 108 -11 37 -12 37 195 271 195 271 50 1 50 1 129 -121z m-2790 -26 c26 0 30 -5 50 -72 11 -40 67 -228 124 -418 116 -389 114 -378 100 -380 -5 -1 -193 144 -416 321 l-406 322 12 41 12 41 224 91 c223 91 224 91 248 73 13 -11 36 -19 52 -19z m3245 -399 c145 -135 165 -158 161 -180 -6 -32 8 -69 38 -101 l24 -25 -35 -215 c-38 -236 -45 -260 -72 -260 -11 0 -75 70 -171 186 -149 181 -153 186 -141 214 17 40 4 85 -32 115 l-30 25 23 193 c12 105 27 195 33 199 6 5 17 7 23 5 7 -1 87 -71 179 -156z m-3412 -192 c232 -184 406 -329 406 -338 0 -9 -4 -21 -8 -27 -4 -6 -182 -54 -395 -106 -312 -77 -390 -93 -394 -81 -3 7 -18 20 -34 29 l-29 15 0 413 c0 424 1 432 37 421 6 -2 194 -149 417 -326z m2142 137 c1 0 4 -15 7 -33 6 -30 -1 -38 -215 -235 l-221 -203 -46 3 c-25 2 -47 5 -49 7 -2 2 -44 139 -93 306 l-89 303 20 21 21 22 332 -95 c183 -52 332 -95 333 -96z m-771 137 c17 -4 34 -53 112 -316 87 -295 91 -313 75 -330 -11 -12 -17 -36 -17 -67 0 -54 -2 -57 -105 -150 -73 -66 -80 -70 -106 -60 -22 9 -38 7 -71 -5 l-43 -17 -299 143 c-293 139 -300 143 -306 176 -5 28 -2 37 27 62 368 321 684 581 697 575 9 -4 25 -9 36 -11z m1320 -311 l320 -107 0 -28 c0 -26 -18 -42 -156 -142 -132 -96 -159 -111 -175 -102 -10 6 -34 13 -52 16 -31 6 -41 19 -167 231 -73 124 -131 228 -128 233 8 14 38 5 358 -101z m-3490 -221 c142 -175 228 -289 226 -300 -2 -9 -4 -39 -5 -67 -1 -50 -3 -54 -114 -188 -63 -75 -119 -136 -125 -136 -7 0 -17 4 -24 8 -6 4 -45 125 -87 269 l-76 262 25 27 c45 49 25 150 -34 169 -15 4 -20 24 -30 118 -6 62 -11 122 -11 133 1 17 2 17 13 3 7 -9 116 -143 242 -298z m3064 281 c23 3 35 -12 124 -162 177 -298 171 -285 152 -314 -12 -18 -16 -38 -12 -68 l5 -43 -191 -186 c-181 -176 -192 -185 -217 -176 -47 18 -102 -9 -135 -67 -5 -9 -27 -21 -47 -25 -30 -7 -40 -5 -54 10 -9 10 -32 23 -50 29 -37 13 -27 -13 -122 306 l-39 132 35 30 c32 29 34 34 30 84 l-3 54 224 206 c209 193 226 206 249 197 14 -6 37 -9 51 -7z m1661 -341 l202 -210 1 -59 2 -60 -307 -301 c-168 -165 -311 -301 -318 -301 -8 0 -10 9 -7 23 3 12 20 113 38 225 l32 203 32 13 c72 30 88 114 34 169 l-31 31 37 220 c44 265 42 256 65 256 11 0 101 -86 220 -209z m-800 65 l45 1 140 -169 c180 -217 167 -198 153 -234 -15 -40 -4 -81 31 -113 l27 -26 -36 -217 -35 -218 -38 -19 -38 -20 -95 46 c-79 38 -94 49 -94 69 0 13 -13 38 -29 56 -23 25 -37 32 -72 33 l-44 2 -163 239 c-126 184 -161 244 -156 259 4 11 8 38 9 60 2 39 4 42 156 153 121 89 158 112 174 106 11 -4 40 -8 65 -8z m-4099 -434 l77 -267 -26 -28 c-20 -21 -27 -38 -27 -69 0 -40 -1 -42 -155 -171 -85 -72 -164 -138 -175 -148 -39 -35 -43 -15 -29 176 7 99 13 199 13 223 1 31 5 42 17 42 8 0 29 13 45 29 23 24 29 38 29 75 0 24 -4 48 -10 51 -5 3 -10 14 -10 23 0 25 152 332 164 332 6 0 45 -120 87 -268z m1403 243 l25 -25 -37 -215 -37 -216 -36 -21 -36 -20 -342 153 c-187 84 -341 159 -341 165 0 7 62 27 153 49 113 27 608 150 624 154 1 1 13 -10 27 -24z m1265 -313 l63 -218 -26 -38 c-28 -41 -33 -75 -16 -107 9 -16 -9 -47 -122 -204 -73 -101 -140 -184 -148 -185 -12 0 -24 63 -62 327 l-48 327 33 27 c29 24 32 32 32 84 l0 58 89 82 c129 119 124 123 205 -153z m974 145 c4 -1 81 -110 171 -242 l164 -240 -18 -35 c-16 -32 -25 -37 -104 -59 l-85 -23 -27 21 c-35 28 -93 28 -128 0 l-27 -21 -207 83 c-206 84 -206 84 -214 119 l-8 35 190 186 190 187 48 -5 c26 -3 51 -5 55 -6z m-2713 -222 c179 -80 329 -151 335 -156 16 -16 -1 -21 -202 -68 l-190 -44 -26 27 c-16 16 -37 26 -56 26 -28 0 -34 8 -120 174 -90 173 -103 203 -78 193 6 -3 158 -71 337 -152z m4226 138 c-3 -10 -32 -157 -66 -328 -34 -170 -63 -318 -66 -327 -3 -10 -16 -21 -30 -24 -39 -10 -74 -59 -74 -106 0 -31 7 -46 30 -69 l29 -30 -24 -122 c-14 -67 -27 -132 -30 -144 -3 -13 -16 -25 -30 -29 -57 -14 -92 -94 -64 -145 9 -17 -1 -40 -57 -140 -37 -65 -74 -119 -81 -119 -7 0 -13 2 -13 3 0 2 -45 190 -100 417 l-101 413 21 22 c29 31 43 77 31 106 -9 22 13 46 297 332 169 169 313 307 320 307 8 0 11 -7 8 -17z m291 -313 c117 -173 212 -320 212 -326 1 -5 -5 -18 -12 -28 -11 -15 -56 -23 -264 -47 l-252 -29 -31 32 -32 32 68 343 c56 278 72 343 84 341 8 -2 110 -145 227 -318z m-3133 -200 l45 -305 -23 -23 -23 -23 -99 39 c-71 29 -100 45 -102 58 -2 11 -10 35 -18 55 -16 36 -15 38 54 225 106 287 116 310 119 294 2 -8 23 -152 47 -320z m-2691 108 c-6 -95 -12 -195 -12 -221 -1 -36 -5 -49 -18 -54 -10 -3 -25 -12 -34 -20 -15 -13 -30 -8 -125 40 l-109 55 -2 38 c-2 38 3 44 149 191 84 84 154 150 158 148 3 -2 0 -81 -7 -177z m1663 32 c8 -8 -24 -78 -103 -229 -109 -210 -115 -219 -147 -225 -35 -7 -86 -49 -86 -72 0 -13 -34 -18 -181 -28 -73 -5 -76 -5 -96 22 l-20 27 57 154 c57 152 58 153 99 171 29 14 46 30 58 57 10 21 18 39 19 41 2 4 354 89 375 91 8 1 20 -4 25 -9z m2090 -107 l191 -77 11 -43 c11 -39 43 -71 85 -86 4 -1 46 -160 93 -352 46 -193 87 -357 90 -365 7 -22 -43 31 -339 354 -257 279 -265 289 -255 317 13 39 -16 99 -58 119 -29 14 -33 22 -49 102 -15 72 -15 90 -5 103 7 9 20 13 29 10 9 -3 102 -40 207 -82z m-3856 -309 c0 -20 10 -44 24 -61 l24 -28 -33 -170 c-18 -93 -38 -171 -44 -173 -6 -2 -26 -16 -43 -30 l-31 -26 -91 24 c-187 48 -178 44 -205 101 l-23 52 62 206 63 206 41 21 41 20 108 -55 c102 -53 107 -57 107 -87z m6142 22 c38 -47 30 -100 -19 -128 -33 -20 -63 -63 -63 -91 0 -8 -24 -21 -59 -32 -59 -17 -60 -17 -86 3 -33 26 -75 35 -106 23 -22 -8 -34 0 -118 78 -71 66 -91 90 -86 104 4 9 8 17 9 18 2 2 461 57 481 58 12 1 31 -13 47 -33z m-1135 -378 c51 -209 93 -387 93 -395 0 -8 -67 69 -149 171 -145 180 -150 187 -139 216 8 24 6 38 -9 69 l-19 39 60 146 c33 80 62 143 65 141 2 -3 47 -177 98 -387z m-2325 275 c100 -39 97 -35 110 -105 3 -15 -349 -494 -357 -486 -2 2 14 133 34 291 38 288 38 289 67 313 16 13 34 24 39 24 6 0 54 -16 107 -37z m1333 -279 c236 -259 279 -311 277 -333 -2 -14 -8 -31 -12 -36 -5 -6 -55 -22 -110 -35 -92 -22 -101 -22 -113 -7 -6 9 -28 23 -47 31 -36 14 -37 16 -162 350 -69 185 -123 336 -119 336 3 0 132 -138 286 -306z m1599 239 c136 -120 135 -120 125 -155 -7 -25 -4 -41 12 -75 l20 -42 -112 -236 c-61 -129 -115 -235 -118 -235 -4 0 -22 63 -40 140 l-32 140 20 26 c32 41 28 95 -10 138 l-30 35 28 143 c27 132 31 143 53 149 40 11 41 11 84 -28z m-4161 -87 c15 -19 27 -41 27 -48 -1 -20 -128 -599 -133 -604 -3 -3 -14 21 -25 53 -11 32 -58 168 -105 303 l-84 245 22 35 c22 34 23 35 106 41 171 11 161 12 192 -25z m1362 -293 l-18 -248 -39 -37 -40 -37 -96 15 c-138 21 -136 20 -149 54 -11 29 -7 35 170 269 100 132 183 238 186 236 2 -3 -4 -116 -14 -252z m3281 222 c15 -14 37 -25 49 -25 19 0 30 -21 89 -182 36 -99 65 -182 64 -184 -3 -2 -296 260 -342 305 -14 15 -16 25 -9 46 7 22 20 32 63 45 30 10 56 18 57 19 1 1 14 -10 29 -24z m-4468 -279 c51 -157 92 -291 92 -299 0 -8 -7 -20 -15 -27 -8 -7 -15 -20 -15 -30 0 -14 -17 -19 -110 -28 l-111 -11 -37 37 -37 37 65 302 c36 167 67 303 70 303 3 0 47 -128 98 -284z m4482 -12 c153 -138 165 -152 165 -184 0 -19 4 -49 8 -67 7 -28 2 -42 -43 -112 -44 -68 -56 -81 -78 -81 -26 0 -31 10 -141 303 -63 166 -116 309 -119 317 -6 18 -9 21 208 -176z m-255 156 c3 -5 57 -145 120 -310 108 -284 113 -303 99 -325 l-15 -23 -207 54 c-114 29 -210 54 -214 54 -5 0 -8 6 -8 14 0 7 -9 25 -20 39 l-20 25 99 210 c55 116 107 224 116 241 15 31 38 40 50 21z m-6141 -74 c50 -14 110 -30 132 -36 33 -8 43 -16 49 -38 3 -15 17 -38 30 -52 l24 -25 -38 -150 c-23 -95 -42 -150 -50 -150 -15 0 -273 454 -265 467 8 12 17 11 118 -16z m501 -204 c97 -50 131 -72 133 -88 3 -18 -23 -33 -194 -113 -165 -77 -199 -90 -213 -79 -9 7 -17 13 -19 14 -2 1 13 72 34 156 36 152 38 155 68 165 50 17 55 15 191 -55z m4100 -112 c10 -11 27 -22 38 -26 19 -6 20 -12 13 -172 -4 -92 -10 -170 -14 -174 -4 -4 -67 57 -140 137 -107 116 -132 149 -132 173 0 29 2 30 98 55 121 31 115 31 137 7z m269 -48 c103 -44 110 -49 119 -82 10 -39 22 -25 -159 -181 -74 -63 -84 -68 -108 -59 l-26 10 0 162 0 163 28 17 c15 9 29 16 32 16 3 0 54 -21 114 -46z m-1961 -3 c85 -12 88 -13 101 -44 8 -18 24 -40 37 -49 27 -18 87 -21 122 -5 20 9 42 2 150 -49 175 -84 176 -80 -50 -204 -162 -88 -179 -95 -197 -82 -11 8 -36 14 -56 14 l-35 1 -116 203 c-92 160 -114 207 -107 221 7 12 18 16 37 12 15 -3 66 -11 114 -18z m-2183 -39 c13 0 23 -14 36 -52 9 -29 19 -59 22 -65 3 -10 -40 -13 -194 -12 -110 0 -219 4 -243 7 l-45 7 175 81 174 81 28 -23 c16 -13 37 -24 47 -24z m1264 -115 c24 -36 83 -51 129 -32 36 16 38 15 122 -24 118 -55 115 -64 -35 -147 -96 -53 -124 -64 -166 -65 l-51 -1 -125 118 c-168 158 -165 167 58 174 45 2 54 -1 68 -23z m3111 -5 c27 0 38 -12 105 -107 41 -59 77 -110 78 -115 5 -11 -495 -10 -503 1 -3 5 52 60 122 121 96 83 133 109 148 105 11 -2 34 -5 50 -5z m-1544 -170 c11 0 34 -29 62 -77 l45 -78 -134 -3 c-74 -1 -195 -1 -270 0 l-137 3 174 95 174 95 35 -17 c19 -10 42 -18 51 -18z m-1187 -25 c11 -8 30 -15 43 -15 17 0 29 -12 48 -50 14 -27 25 -54 25 -60 0 -6 -61 -10 -174 -10 -156 0 -175 2 -181 17 -3 10 -3 19 2 21 4 1 51 27 103 57 52 29 100 54 105 54 6 0 19 -6 29 -14z' />
        </g>
    </svg>
);

export default CommunityIcon;
