# Release 0.2.0

## Announcement

This release signifies end of initial development cycle of `eksctl`.
We have built many new features since first minor release (0.1.0)
in August 2018, and are switching to a [new release cadence][].
Albeit we have originally planned to do a number of things in 0.2.0,
the plan has evolved. From now on, please refer to [our roadmap][].

[new release cadence]: https://eksctl.io/community/roadmap/
[our roadmap]: https://github.com/eksctl-io/eksctl/projects/2

## Bug Fixes Since 0.1.40

- remove support for Kubernetes version 1.10, as [deprecated by AWS from 22nd July 2019 onwards](https://docs.aws.amazon.com/eks/latest/userguide/kubernetes-versions.html) [#1026]
  - remove `eksctl utils install-coredns` command that was only relevant to Kubernetes version 1.10
  - remove `--strorage-class` flag that was only relevant to Kubernetes version 1.10
- fix long-standing issue with EBS and security groups blocking VPC deletion [#103]
- add support for `aws eks get-token` as fallback when `aws-iam-authenticator` is missing [#788]
- add `volumeIOPS` field to enable use of EBS root volumes of type `io1` [#1006]

## New Features Since 0.1.0

### General features

- create and manage clusters using configuration files
- Kubernetes versions: 1.11, 1.12 and 1.13
- cluster upgrades
- support for all EKS regions

### VPC

- allow re-using existing VPCs
- public and private subnet topologies
- NAT Gateway support (HA, single or disable)

### nodegroup

- nodegroup management (create, get, scale, delete)
- spot instances and mixed instance types
- extra kubelet configuration parameters
- custom EC2 tags and Kubernetes labels
- custom bootstrap logic
- single-AZ nodegroups
- public or private networking options
- use existing security groups
- root EBS volume size, type and encryption
- various options for SSH access

### IAM

- use custom service role for cluster
- use custom roles or policies for nodegroups
- canned policies for popular add-ons:
  - External DNS
  - Cluster Autoscaler
  - Cert Manager
  - ALB Ingress
  - AppMesh & XRay
  - EBS, EFS and xFS CSI
- execute CloudFormation actions using dedicated role

### utilities

- describe and troubleshoot CloudFormation stacks, with CloudTrail support
- update default add-ons during cluster upgrades (`coredns`, `kube-proxy` and `aws-node`)
- delete stale entries in `~/.kube/config`

## Acknowledgment

Weaveworks team would like to sencirely thank all of the who have
contributed to the project, your work is highly appreciated and
the project would get thus far without you!

We have received many very useful contributions from so many of
you, some of which came as code, and some as issue or participation
on Slack, we thank all of you!

<details>
  <summary><i>List of most active contributors in the last 12 month</i></summary>

  @richardcase
  @christopherhein
  @mumoshu
  @adamjohnson01
  @archisgore
  @Lazyshot
  @kschumy
  @toricls
  @cristian-radu
  @tedmiston
  @karinnainiguez
  @Chabane
  @tiffanyfay
  @yutachaos
  @gruebel
  @jstrachan
  @PaulMaddox
  @ozzieba
  @mukaibot
  @jmcarp
  @gotjosh
  @philoserf
  @pawelprazak
  @nckturner
  @af12066
  @mgalgs
  @Jeffwan
  @paulbsch
  @arbourd
  @cbluth
  @knorby
  @gchaincl
  @mcfedr
  @overdrive3000
  @prageethw
  @patstrom
  @sdarwin
  @unguiculus
  @Yannig
  @IPyandy
  @bowlesns
  @derwasp
  @mikeroyal
  @superseb
  @zironycho
  @dcherman
  @silviogutierrez
  @sixth
  @dresnick-sf
  @jonk
  @danielfm
  @denwwer
  @thapakazi
  @lucioveloso
  @callmeradical
  @manabusakai
  @justincormack
  @austbot
  @pdavies011010
  @mreferre
  @flou
  @polothy
  @Tyil
  @cpaika
  @arun-gupta
  @cdenneen
  @danielchalef
  @mrichman
  @whereisaaron
  @StevenACoffman
  @procyclinsur
  @braderhart
  @aparamon
  @JasonSwindle
  @jicowan
  @olipachi
  @trondhindenes
  @milkowski
  @dingn1
  @jamesalbert
  @stevepe-1
  @ArseniiPetrovich
  @jvanzyl
  @redborian
  @tkang007
  @elirankon
  @alexclifford
  @arielvinas
  @bnutt
  @voxxit

</details>
