// acgdisabler.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "acgdisabler.h"


#include <windows.h>
#include <tlhelp32.h>
#include <tchar.h>
#include <set>

//offset from MicrosoftEdgeCP.exe base to global variables used in IEIsF12Host
//this must be changed according to the MicrosoftEdgeCP.exe version
#define offset 0x23090

std::set<DWORD> pids;

BYTE* GetModuleAddress(DWORD dwPID)
{
	BYTE * ret = NULL;
	HANDLE hModuleSnap = INVALID_HANDLE_VALUE;
	MODULEENTRY32 me32;

	// Take a snapshot of all modules in the specified process.
	hModuleSnap = CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
	if (hModuleSnap == INVALID_HANDLE_VALUE)
	{
		printf("CreateToolhelp32Snapshot returned error\n");
		return(ret);
	}

	// Set the size of the structure before using it.
	me32.dwSize = sizeof(MODULEENTRY32);

	// Retrieve information about the first module,
	// and exit if unsuccessful
	if (!Module32First(hModuleSnap, &me32))
	{
		printf("Module32First returned error\n");
		CloseHandle(hModuleSnap);           // clean the snapshot object
		return(ret);
	}

	// Now walk the module list of the process,
	// and display information about each module
	do
	{
		if (!wcscmp(me32.szModule, L"MicrosoftEdgeCP.exe")) {
			ret = me32.modBaseAddr;
		}
	} while (Module32Next(hModuleSnap, &me32));

	CloseHandle(hModuleSnap);
	return(ret);
}

BOOL GetProcessList()
{
	HANDLE hProcessSnap;
	HANDLE hProcess;
	PROCESSENTRY32 pe32;

	// Take a snapshot of all processes in the system.
	hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	if (hProcessSnap == INVALID_HANDLE_VALUE)
	{
		printf("CreateToolhelp32Snapshot returned an error\n");
		return(FALSE);
	}

	// Set the size of the structure before using it.
	pe32.dwSize = sizeof(PROCESSENTRY32);

	// Retrieve information about the first process,
	// and exit if unsuccessful
	if (!Process32First(hProcessSnap, &pe32))
	{
		printf("Process32First returned an error\n");
		CloseHandle(hProcessSnap);          // clean the snapshot object
		return(FALSE);
	}

	// Now walk the snapshot of processes, and
	// display information about each process in turn
	do
	{
		if (wcscmp(pe32.szExeFile, L"MicrosoftEdgeCP.exe")) continue;

		if (pids.find(pe32.th32ProcessID) != pids.end()) continue;

		printf("New process found, %d\n", pe32.th32ProcessID);

		pids.insert(pe32.th32ProcessID);

	} while (Process32Next(hProcessSnap, &pe32));

	CloseHandle(hProcessSnap);

	if (pids.empty()) {
		printf("no running Edge Content Processes\n");
		return(FALSE);
	}

	BYTE *baseaddress = 0;
	std::set<DWORD>::iterator iter;
	for (iter = pids.begin(); iter != pids.end(); iter++) {
		DWORD pid = *iter;
		baseaddress = GetModuleAddress(pid);
		if (baseaddress) break;
	}
	if (!baseaddress) {
		printf("Couldn't extract MicrosoftEdgeCP base address\n");
		return(FALSE);
	}

	printf("MicrosoftEdgeCP.exe address: %p\n", baseaddress);

	unsigned char patch[] = { 0x01, 0x00, 0x01 };

	while (1) {

		//printf("scanning\n");

		// Take a snapshot of all processes in the system.
		hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hProcessSnap == INVALID_HANDLE_VALUE)
		{
			printf("CreateToolhelp32Snapshot returned an error\n");
			return(FALSE);
		}

		// Set the size of the structure before using it.
		pe32.dwSize = sizeof(PROCESSENTRY32);

		// Retrieve information about the first process,
		// and exit if unsuccessful
		if (!Process32First(hProcessSnap, &pe32))
		{
			printf("Process32First returned an error\n");
			CloseHandle(hProcessSnap);          // clean the snapshot object
			return(FALSE);
		}

		// Now walk the snapshot of processes, and
		// display information about each process in turn
		do
		{
			if (wcscmp(pe32.szExeFile, L"MicrosoftEdgeCP.exe")) continue;

			if (pids.find(pe32.th32ProcessID) != pids.end()) continue;

			printf("New process found, %d\n", pe32.th32ProcessID);

			pids.insert(pe32.th32ProcessID);

			hProcess = OpenProcess(PROCESS_VM_WRITE | PROCESS_VM_OPERATION, false, pe32.th32ProcessID);
			if (!hProcess) {
				printf("Error opening process\n");
				continue;
			}

			if (WriteProcessMemory(hProcess, baseaddress + offset, patch, 3, NULL)) {
				printf("Patched\n");
			}
			else {
				printf("Patching failed\n");
			}

			CloseHandle(hProcess);

		} while (Process32Next(hProcessSnap, &pe32));

		CloseHandle(hProcessSnap);
	}

	return(TRUE);
}

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
	GetProcessList();
	return 0;
}
