#ifndef MACF_H
#define MACF_H

#include <stdint.h>             // uint32_t, uint64_t

#define addr_t uint64_t

typedef struct
{
    addr_t mpo_audit_check_postselect;
    addr_t mpo_audit_check_preselect;
    addr_t mpo_bpfdesc_label_associate;
    addr_t mpo_bpfdesc_label_destroy;
    addr_t mpo_bpfdesc_label_init;
    addr_t mpo_bpfdesc_check_receive;
    addr_t mpo_cred_check_label_update_execve;
    addr_t mpo_cred_check_label_update;
    addr_t mpo_cred_check_visible;
    addr_t mpo_cred_label_associate_fork;
    addr_t mpo_cred_label_associate_kernel;
    addr_t mpo_cred_label_associate;
    addr_t mpo_cred_label_associate_user;
    addr_t mpo_cred_label_destroy;
    addr_t mpo_cred_label_externalize_audit;
    addr_t mpo_cred_label_externalize;
    addr_t mpo_cred_label_init;
    addr_t mpo_cred_label_internalize;
    addr_t mpo_cred_label_update_execve;
    addr_t mpo_cred_label_update;
    addr_t mpo_devfs_label_associate_device;
    addr_t mpo_devfs_label_associate_directory;
    addr_t mpo_devfs_label_copy;
    addr_t mpo_devfs_label_destroy;
    addr_t mpo_devfs_label_init;
    addr_t mpo_devfs_label_update;
    addr_t mpo_file_check_change_offset;
    addr_t mpo_file_check_create;
    addr_t mpo_file_check_dup;
    addr_t mpo_file_check_fcntl;
    addr_t mpo_file_check_get_offset;
    addr_t mpo_file_check_get;
    addr_t mpo_file_check_inherit;
    addr_t mpo_file_check_ioctl;
    addr_t mpo_file_check_lock;
    addr_t mpo_file_check_mmap_downgrade;
    addr_t mpo_file_check_mmap;
    addr_t mpo_file_check_receive;
    addr_t mpo_file_check_set;
    addr_t mpo_file_label_init;
    addr_t mpo_file_label_destroy;
    addr_t mpo_file_label_associate;
    addr_t mpo_ifnet_check_label_update;
    addr_t mpo_ifnet_check_transmit;
    addr_t mpo_ifnet_label_associate;
    addr_t mpo_ifnet_label_copy;
    addr_t mpo_ifnet_label_destroy;
    addr_t mpo_ifnet_label_externalize;
    addr_t mpo_ifnet_label_init;
    addr_t mpo_ifnet_label_internalize;
    addr_t mpo_ifnet_label_update;
    addr_t mpo_ifnet_label_recycle;
    addr_t mpo_inpcb_check_deliver;
    addr_t mpo_inpcb_label_associate;
    addr_t mpo_inpcb_label_destroy;
    addr_t mpo_inpcb_label_init;
    addr_t mpo_inpcb_label_recycle;
    addr_t mpo_inpcb_label_update;
    addr_t mpo_iokit_check_device;
    addr_t mpo_ipq_label_associate;
    addr_t mpo_ipq_label_compare;
    addr_t mpo_ipq_label_destroy;
    addr_t mpo_ipq_label_init;
    addr_t mpo_ipq_label_update;
    addr_t mpo_file_check_library_validation;
    addr_t mpo_vnode_notify_setacl;
    addr_t mpo_vnode_notify_setattrlist;
    addr_t mpo_vnode_notify_setextattr;
    addr_t mpo_vnode_notify_setflags;
    addr_t mpo_vnode_notify_setmode;
    addr_t mpo_vnode_notify_setowner;
    addr_t mpo_vnode_notify_setutimes;
    addr_t mpo_vnode_notify_truncate;
    addr_t mpo_mbuf_label_associate_bpfdesc;
    addr_t mpo_mbuf_label_associate_ifnet;
    addr_t mpo_mbuf_label_associate_inpcb;
    addr_t mpo_mbuf_label_associate_ipq;
    addr_t mpo_mbuf_label_associate_linklayer;
    addr_t mpo_mbuf_label_associate_multicast_encap;
    addr_t mpo_mbuf_label_associate_netlayer;
    addr_t mpo_mbuf_label_associate_socket;
    addr_t mpo_mbuf_label_copy;
    addr_t mpo_mbuf_label_destroy;
    addr_t mpo_mbuf_label_init;
    addr_t mpo_mount_check_fsctl;
    addr_t mpo_mount_check_getattr;
    addr_t mpo_mount_check_label_update;
    addr_t mpo_mount_check_mount;
    addr_t mpo_mount_check_remount;
    addr_t mpo_mount_check_setattr;
    addr_t mpo_mount_check_stat;
    addr_t mpo_mount_check_umount;
    addr_t mpo_mount_label_associate;
    addr_t mpo_mount_label_destroy;
    addr_t mpo_mount_label_externalize;
    addr_t mpo_mount_label_init;
    addr_t mpo_mount_label_internalize;
    addr_t mpo_netinet_fragment;
    addr_t mpo_netinet_icmp_reply;
    addr_t mpo_netinet_tcp_reply;
    addr_t mpo_pipe_check_ioctl;
    addr_t mpo_pipe_check_kqfilter;
    addr_t mpo_pipe_check_label_update;
    addr_t mpo_pipe_check_read;
    addr_t mpo_pipe_check_select;
    addr_t mpo_pipe_check_stat;
    addr_t mpo_pipe_check_write;
    addr_t mpo_pipe_label_associate;
    addr_t mpo_pipe_label_copy;
    addr_t mpo_pipe_label_destroy;
    addr_t mpo_pipe_label_externalize;
    addr_t mpo_pipe_label_init;
    addr_t mpo_pipe_label_internalize;
    addr_t mpo_pipe_label_update;
    addr_t mpo_policy_destroy;
    addr_t mpo_policy_init;
    addr_t mpo_policy_initbsd;
    addr_t mpo_policy_syscall;
    addr_t mpo_system_check_sysctlbyname;
    addr_t mpo_proc_check_inherit_ipc_ports;
    addr_t mpo_vnode_check_rename;
    addr_t mpo_kext_check_query;
    addr_t mpo_iokit_check_nvram_get;
    addr_t mpo_iokit_check_nvram_set;
    addr_t mpo_iokit_check_nvram_delete;
    addr_t mpo_proc_check_expose_task;
    addr_t mpo_proc_check_set_host_special_port;
    addr_t mpo_proc_check_set_host_exception_port;
    addr_t mpo_exc_action_check_exception_send;
    addr_t mpo_exc_action_label_associate;
    addr_t mpo_exc_action_label_copy;
    addr_t mpo_exc_action_label_destroy;
    addr_t mpo_exc_action_label_init;
    addr_t mpo_exc_action_label_update;
    addr_t mpo_reserved1;
    addr_t mpo_reserved2;
    addr_t mpo_reserved3;
    addr_t mpo_reserved4;
    addr_t mpo_reserved5;
    addr_t mpo_reserved6;
    addr_t mpo_posixsem_check_create;
    addr_t mpo_posixsem_check_open;
    addr_t mpo_posixsem_check_post;
    addr_t mpo_posixsem_check_unlink;
    addr_t mpo_posixsem_check_wait;
    addr_t mpo_posixsem_label_associate;
    addr_t mpo_posixsem_label_destroy;
    addr_t mpo_posixsem_label_init;
    addr_t mpo_posixshm_check_create;
    addr_t mpo_posixshm_check_mmap;
    addr_t mpo_posixshm_check_open;
    addr_t mpo_posixshm_check_stat;
    addr_t mpo_posixshm_check_truncate;
    addr_t mpo_posixshm_check_unlink;
    addr_t mpo_posixshm_label_associate;
    addr_t mpo_posixshm_label_destroy;
    addr_t mpo_posixshm_label_init;
    addr_t mpo_proc_check_debug;
    addr_t mpo_proc_check_fork;
    addr_t mpo_proc_check_get_task_name;
    addr_t mpo_proc_check_get_task;
    addr_t mpo_proc_check_getaudit;
    addr_t mpo_proc_check_getauid;
    addr_t mpo_proc_check_getlcid;
    addr_t mpo_proc_check_mprotect;
    addr_t mpo_proc_check_sched;
    addr_t mpo_proc_check_setaudit;
    addr_t mpo_proc_check_setauid;
    addr_t mpo_proc_check_setlcid;
    addr_t mpo_proc_check_signal;
    addr_t mpo_proc_check_wait;
    addr_t mpo_proc_label_destroy;
    addr_t mpo_proc_label_init;
    addr_t mpo_socket_check_accept;
    addr_t mpo_socket_check_accepted;
    addr_t mpo_socket_check_bind;
    addr_t mpo_socket_check_connect;
    addr_t mpo_socket_check_create;
    addr_t mpo_socket_check_deliver;
    addr_t mpo_socket_check_kqfilter;
    addr_t mpo_socket_check_label_update;
    addr_t mpo_socket_check_listen;
    addr_t mpo_socket_check_receive;
    addr_t mpo_socket_check_received;
    addr_t mpo_socket_check_select;
    addr_t mpo_socket_check_send;
    addr_t mpo_socket_check_stat;
    addr_t mpo_socket_check_setsockopt;
    addr_t mpo_socket_check_getsockopt;
    addr_t mpo_socket_label_associate_accept;
    addr_t mpo_socket_label_associate;
    addr_t mpo_socket_label_copy;
    addr_t mpo_socket_label_destroy;
    addr_t mpo_socket_label_externalize;
    addr_t mpo_socket_label_init;
    addr_t mpo_socket_label_internalize;
    addr_t mpo_socket_label_update;
    addr_t mpo_socketpeer_label_associate_mbuf;
    addr_t mpo_socketpeer_label_associate_socket;
    addr_t mpo_socketpeer_label_destroy;
    addr_t mpo_socketpeer_label_externalize;
    addr_t mpo_socketpeer_label_init;
    addr_t mpo_system_check_acct;
    addr_t mpo_system_check_audit;
    addr_t mpo_system_check_auditctl;
    addr_t mpo_system_check_auditon;
    addr_t mpo_system_check_host_priv;
    addr_t mpo_system_check_nfsd;
    addr_t mpo_system_check_reboot;
    addr_t mpo_system_check_settime;
    addr_t mpo_system_check_swapoff;
    addr_t mpo_system_check_swapon;
    addr_t mpo_reserved7;
    addr_t mpo_sysvmsg_label_associate;
    addr_t mpo_sysvmsg_label_destroy;
    addr_t mpo_sysvmsg_label_init;
    addr_t mpo_sysvmsg_label_recycle;
    addr_t mpo_sysvmsq_check_enqueue;
    addr_t mpo_sysvmsq_check_msgrcv;
    addr_t mpo_sysvmsq_check_msgrmid;
    addr_t mpo_sysvmsq_check_msqctl;
    addr_t mpo_sysvmsq_check_msqget;
    addr_t mpo_sysvmsq_check_msqrcv;
    addr_t mpo_sysvmsq_check_msqsnd;
    addr_t mpo_sysvmsq_label_associate;
    addr_t mpo_sysvmsq_label_destroy;
    addr_t mpo_sysvmsq_label_init;
    addr_t mpo_sysvmsq_label_recycle;
    addr_t mpo_sysvsem_check_semctl;
    addr_t mpo_sysvsem_check_semget;
    addr_t mpo_sysvsem_check_semop;
    addr_t mpo_sysvsem_label_associate;
    addr_t mpo_sysvsem_label_destroy;
    addr_t mpo_sysvsem_label_init;
    addr_t mpo_sysvsem_label_recycle;
    addr_t mpo_sysvshm_check_shmat;
    addr_t mpo_sysvshm_check_shmctl;
    addr_t mpo_sysvshm_check_shmdt;
    addr_t mpo_sysvshm_check_shmget;
    addr_t mpo_sysvshm_label_associate;
    addr_t mpo_sysvshm_label_destroy;
    addr_t mpo_sysvshm_label_init;
    addr_t mpo_sysvshm_label_recycle;
    addr_t mpo_reserved8;
    addr_t mpo_mount_check_snapshot_revert;
    addr_t mpo_vnode_check_getattr;
    addr_t mpo_mount_check_snapshot_create;
    addr_t mpo_mount_check_snapshot_delete;
    addr_t mpo_vnode_check_clone;
    addr_t mpo_proc_check_get_cs_info;
    addr_t mpo_proc_check_set_cs_info;
    addr_t mpo_iokit_check_hid_control;
    addr_t mpo_vnode_check_access;
    addr_t mpo_vnode_check_chdir;
    addr_t mpo_vnode_check_chroot;
    addr_t mpo_vnode_check_create;
    addr_t mpo_vnode_check_deleteextattr;
    addr_t mpo_vnode_check_exchangedata;
    addr_t mpo_vnode_check_exec;
    addr_t mpo_vnode_check_getattrlist;
    addr_t mpo_vnode_check_getextattr;
    addr_t mpo_vnode_check_ioctl;
    addr_t mpo_vnode_check_kqfilter;
    addr_t mpo_vnode_check_label_update;
    addr_t mpo_vnode_check_link;
    addr_t mpo_vnode_check_listextattr;
    addr_t mpo_vnode_check_lookup;
    addr_t mpo_vnode_check_open;
    addr_t mpo_vnode_check_read;
    addr_t mpo_vnode_check_readdir;
    addr_t mpo_vnode_check_readlink;
    addr_t mpo_vnode_check_rename_from;
    addr_t mpo_vnode_check_rename_to;
    addr_t mpo_vnode_check_revoke;
    addr_t mpo_vnode_check_select;
    addr_t mpo_vnode_check_setattrlist;
    addr_t mpo_vnode_check_setextattr;
    addr_t mpo_vnode_check_setflags;
    addr_t mpo_vnode_check_setmode;
    addr_t mpo_vnode_check_setowner;
    addr_t mpo_vnode_check_setutimes;
    addr_t mpo_vnode_check_stat;
    addr_t mpo_vnode_check_truncate;
    addr_t mpo_vnode_check_unlink;
    addr_t mpo_vnode_check_write;
    addr_t mpo_vnode_label_associate_devfs;
    addr_t mpo_vnode_label_associate_extattr;
    addr_t mpo_vnode_label_associate_file;
    addr_t mpo_vnode_label_associate_pipe;
    addr_t mpo_vnode_label_associate_posixsem;
    addr_t mpo_vnode_label_associate_posixshm;
    addr_t mpo_vnode_label_associate_singlelabel;
    addr_t mpo_vnode_label_associate_socket;
    addr_t mpo_vnode_label_copy;
    addr_t mpo_vnode_label_destroy;
    addr_t mpo_vnode_label_externalize_audit;
    addr_t mpo_vnode_label_externalize;
    addr_t mpo_vnode_label_init;
    addr_t mpo_vnode_label_internalize;
    addr_t mpo_vnode_label_recycle;
    addr_t mpo_vnode_label_store;
    addr_t mpo_vnode_label_update_extattr;
    addr_t mpo_vnode_label_update;
    addr_t mpo_vnode_notify_create;
    addr_t mpo_vnode_check_signature;
    addr_t mpo_vnode_check_uipc_bind;
    addr_t mpo_vnode_check_uipc_connect;
    addr_t mpo_proc_check_run_cs_invalid;
    addr_t mpo_proc_check_suspend_resume;
    addr_t mpo_thread_userret;
    addr_t mpo_iokit_check_set_properties;
    addr_t mpo_system_check_chud;
    addr_t mpo_vnode_check_searchfs;
    addr_t mpo_priv_check;
    addr_t mpo_priv_grant;
    addr_t mpo_proc_check_map_anon;
    addr_t mpo_vnode_check_fsgetpath;
    addr_t mpo_iokit_check_open;
    addr_t mpo_proc_check_ledger;
    addr_t mpo_vnode_notify_rename;
    addr_t mpo_vnode_check_setacl;
    addr_t mpo_vnode_notify_deleteextattr;
    addr_t mpo_system_check_kas_info;
    addr_t mpo_proc_check_cpumon;
    addr_t mpo_vnode_notify_open;
    addr_t mpo_system_check_info;
    addr_t mpo_pty_notify_grant;
    addr_t mpo_pty_notify_close;
    addr_t mpo_vnode_find_sigs;
    addr_t mpo_kext_check_load;
    addr_t mpo_kext_check_unload;
    addr_t mpo_proc_check_proc_info;
    addr_t mpo_vnode_notify_link;
    addr_t mpo_iokit_check_filter_properties;
    addr_t mpo_iokit_check_get_property;
} mac_policy_ops_t;

typedef struct
{
    addr_t mpc_name;
    addr_t mpc_fullname;
    addr_t mpc_labelnames;
    uint32_t mpc_labelname_count;
    addr_t mpc_ops;
    uint32_t mpc_loadtime_flags;
    addr_t mpc_field_off;
    uint32_t mpc_runtime_flags;
    addr_t mpc_list;
    addr_t mpc_data;
} mac_policy_conf_t;

typedef struct
{
    addr_t mpc;
} mac_policy_list_entry_t;

typedef struct
{
    uint32_t numloaded;
    uint32_t max;
    uint32_t maxindex;
    uint32_t staticmax;
    uint32_t chunks;
    uint32_t freehint;
    addr_t entries;
} mac_policy_list_t;

#undef addr_t

#endif
