/*
 * python wrapper to some types and functions in Krb5 API
 *
 * functions needed: str2key, encrypt, decrypt for
 * - as_rep encpart and ticket
 * - tgs_rep encpart and ticket
 *
 * types needed: not anymore
 * krb5_keyblock, krb5_data
 *
 * we just need 3des and rc4 enctypes
 * maybe aes someday (20 days after: the day is now :D )
 */

//some notes:
//KRB5KRB_AP_ERR_BAD_INTEGRITY             (-1765328353L)

#include<stdlib.h>
#include<errno.h>
#include<Python.h>
//#include<python2.5/structmember.h>
#include<krb5.h>
#include"krb5crypto.h"

#define DES3_KEY_SZ 24
#define DES3_BLOCK_SZ 8
#define CBC_SHA1_SZ 20
#define RC4_BLOCK_SZ 16
#define RC4_KEY_SZ 16
#define	MD5_SZ 16
#define AES_CTS_BLK_SZ 16
#define AES_CTS_KEY_SZ 32

#define DES3 0x1
#define RC4 0x2
#define AES 0x3


//quite useless in the end

/*every enctype need:
 * 		block_size
 * 		hash_size
 * 		key_size
 */

typedef struct _enctype {
	krb5_enctype enctype_id;
	int block_size;
	int key_size;
	int hash_size;
} enctype;

const enctype enctypes[] = {
		{0x0,0x0,0x0,0x0},		//placeholder, i don't like 0
		{
		ENCTYPE_DES3_CBC_SHA1,
		DES3_BLOCK_SZ,
		DES3_KEY_SZ,
		CBC_SHA1_SZ
		},
		{
		ENCTYPE_ARCFOUR_HMAC,
		RC4_BLOCK_SZ,
		RC4_KEY_SZ,
		MD5_SZ
		},
		{ENCTYPE_AES256_CTS_HMAC_SHA1_96,
		AES_CTS_BLK_SZ,
		AES_CTS_KEY_SZ,
		0
		}
};

/*return keylen for a crypto*/
static PyObject * krb5_keylen(PyObject *self, PyObject *args){
	int etypeid;

	if (!PyArg_ParseTuple(args, "i", &etypeid))
			return NULL;

	if (etypeid > 3 || etypeid < 1)
		return NULL;

	return Py_BuildValue("i", enctypes[etypeid].key_size);
}

/*
 *convert string to 3des key
 */
static PyObject * krb5_str2key(PyObject *self, PyObject *args){

	krb5_data string, salt;
	krb5_keyblock keyb;
	krb5_principal pr;
	krb5_context con;
	char *princ,*str;
	int ret, etypeid;

	//todo: passing object reference in format
	if (!PyArg_ParseTuple(args, "ssi", &princ, &str, &etypeid))
		return NULL;

	krb5_init_context(&con);

	keyb.enctype = enctypes[etypeid].enctype_id;
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);

	krb5_parse_name(con, princ, &pr);

	string.data = malloc(strlen(str)* sizeof(char));
	memcpy(string.data, str, strlen(str));
	string.length = strlen(str);

	//krb5_principal2salt_internal(pr, &salt, 1);
	krb5_principal2salt(con, pr, &salt);

	if (ret = krb5_c_string_to_key(con, keyb.enctype, &string, &salt, &keyb)){
		fprintf(stderr,"error str2key: %d, exiting\n", ret);
		return NULL;
	}

	krb5_free_principal(con, pr);
	krb5_free_context(con);

	return Py_BuildValue("s#", keyb.contents, keyb.length);
}

static PyObject * krb5_encryptASREPEncPart(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_AS_REP_ENCPART;
	krb5_keyblock keyb;
	krb5_enc_data output;
	char* key, *plain;
	int ret, klen, plen, etypeid;

	//we need a key, his length, a plaintext and his len
	//the length is because both could contain NULL bytes
	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &plain, &plen, &etypeid)){
		return NULL;
	}

	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	if (encrypt(&keyb,plen, plain, usage, &output))
		return NULL;

	return Py_BuildValue("s#", output.ciphertext.data, output.ciphertext.length);
}

static PyObject * krb5_encryptTGSREPEncPart(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_TGS_REP_ENCPART_SESSKEY;
	krb5_keyblock keyb;
	krb5_enc_data output;
	char* key, *plain;
	int ret, klen, plen, etypeid;

	//we need a key, his length, a plaintext and his len
	//the lenght is because both could contain NULL bytes
	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &plain, &plen, &etypeid)){
		return NULL;
	}

	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	if (encrypt(&keyb,plen, plain, usage, &output))
		return NULL;

	return Py_BuildValue("s#", output.ciphertext.data, output.ciphertext.length);
}

static PyObject * krb5_encryptKDCREPTicket(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_KDC_REP_TICKET;
	krb5_keyblock keyb;
	/*krb5_context con;
	krb5_data input;*/
	krb5_enc_data output;
	char* key, *plain;
	int ret, klen, plen, etypeid;

	//we need a key, his length, a plaintext and his len
	//the lenght is because both could contain NULL bytes
	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &plain, &plen, &etypeid)){
		return NULL;
	}

	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	/*input.length = plen;
	input.data = malloc(plen);
	memcpy(input.data, plain, input.length);

	krb5_init_context(&con);
	output.enctype = enctypes[etypeid];
	krb5_c_encrypt_length(con, keyb.enctype, input.length, &(output.ciphertext.length));
	output.ciphertext.data = malloc(output.ciphertext.length);

	if (ret = krb5_c_encrypt(con, &keyb, usage, 0, &input, &output)){
		fprintf(stderr,"error krb5_encryptKDCREPTicket: %d\n", ret);
		return NULL;
	}

	krb5_free_context(con);
	*/

	if (encrypt(&keyb,plen, plain, usage, &output))
		return NULL;

	return Py_BuildValue("s#", output.ciphertext.data, output.ciphertext.length);
}

static PyObject* krb5_decryptASREPEncPart(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_AS_REP_ENCPART;
	krb5_keyblock keyb;
	krb5_data output;
	/*
	krb5_context con;
	krb5_enc_data input;
	*/
	char* key, *ctext;
	int ret, klen, clen, etypeid;

	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &ctext, &clen, &etypeid)){
		return NULL;
	}

	//printf("%d\n%d\n",etypeid, enctypes[etypeid].enctype_id);
	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	output.length = clen;
	//output.length = clen - enctypes[etypeid].hash_size - enctypes[etypeid].block_size;
	output.data = malloc(output.length);

	//printf("%d,%d\n",output.length, clen);

	/*
	krb5_init_context(&con);
	input.enctype = keyb.enctype;
	input.ciphertext.length = clen;
	input.ciphertext.data = malloc(clen);
	memcpy(input.ciphertext.data, ctext, clen);
	if (ret = krb5_c_decrypt(con, &keyb, usage, 0, &input, &output)){
		fprintf(stderr,"error decrypting AS_REP, %d\n", ret);
		return NULL;
	}

	krb5_free_context(con);*/
	if (decrypt(&keyb, usage, clen, ctext, &output) != 0)
		return NULL;

	return Py_BuildValue("s#", output.data, output.length);
}

/*static PyObject* krb5_decryptASREPEncPartRC4(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_AS_REP_ENCPART;
	krb5_keyblock keyb;
	krb5_data output;
	char* key, *ctext;
	int ret, klen, clen;

	if (!PyArg_ParseTuple(args, "s#s#", &key, &klen, &ctext, &clen)){
		return NULL;
	}

	//printf("%d\n",klen);
	keyb.length = klen;
	keyb.contents = malloc(klen);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = ENCTYPE_ARCFOUR_HMAC;

	output.length = clen - CBC_SHA1_SZ - MD5_SZ;
	output.data = malloc(output.length);

	if (decrypt(&keyb, usage, clen, ctext, &output) != 0)
		return NULL;

	return Py_BuildValue("s#", output.data, output.length);
}*/

static PyObject* krb5_decryptTGSREPEncPart(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_TGS_REP_ENCPART_SESSKEY;
	krb5_keyblock keyb;
	krb5_data output;
	char* key, *ctext;
	int ret, klen, clen, etypeid;

	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &ctext, &clen, &etypeid)){
		return NULL;
	}

	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	output.length = clen;
	//output.length = clen - enctypes[etypeid].hash_size - enctypes[etypeid].block_size;
	output.data = malloc(output.length);

	if (decrypt(&keyb, usage, clen, ctext, &output) != 0)
		return NULL;

	return Py_BuildValue("s#", output.data, output.length);
}

static PyObject* krb5_decryptKDCREPTicket(PyObject* self, PyObject* args ){
	krb5_keyusage usage = KRB5_KEYUSAGE_KDC_REP_TICKET;
	krb5_keyblock keyb;
	krb5_data output;
	char* key, *ctext;
	int ret, klen, clen, etypeid;

	if (!PyArg_ParseTuple(args, "s#s#i", &key, &klen, &ctext, &clen, &etypeid)){
		return NULL;
	}

	if ( klen < enctypes[etypeid].key_size){
		fprintf(stderr, "invalid key length\n");
		return NULL;
	}
	keyb.length = enctypes[etypeid].key_size;
	keyb.contents = malloc(keyb.length);
	memcpy(keyb.contents, key, keyb.length);
	keyb.enctype = enctypes[etypeid].enctype_id;

	output.length = clen;
	//output.length = clen - enctypes[etypeid].hash_size - enctypes[etypeid].block_size;
	output.data = malloc(output.length);

	if (decrypt(&keyb, usage, clen, ctext, &output) != 0)
		return NULL;

	return Py_BuildValue("s#", output.data, output.length);
}

static PyMethodDef krb5_Methods[] = {
		{"keylen", krb5_keylen, METH_VARARGS, "keylen func"},
		{"str2key", krb5_str2key, METH_VARARGS, "krb5 str2key func"},
		{"encryptASREPEncPart",krb5_encryptASREPEncPart, METH_VARARGS, ""},
		{"encryptTGSREPEncPart",krb5_encryptTGSREPEncPart, METH_VARARGS, ""},
		{"encryptKDCREPTicket", krb5_encryptKDCREPTicket, METH_VARARGS, ""},
		{"decryptASREPEncPart", krb5_decryptASREPEncPart, METH_VARARGS, ""},
//		{"decryptASREPEncPartRC4", krb5_decryptASREPEncPartRC4, METH_VARARGS, ""},
		{"decryptTGSREPEncPart", krb5_decryptTGSREPEncPart, METH_VARARGS, ""},
		{"decryptKDCREPTicket", krb5_decryptKDCREPTicket, METH_VARARGS, ""}
};

PyMODINIT_FUNC initKrb5Crypto(void){
	PyObject* m;

	//init types
	/*krb5_KeyBlockType.tp_new = PyType_GenericNew;
	if (PyType_Ready(&krb5_KeyBlockType) < 0)
		return;
	*/

	//init methods
	m = Py_InitModule("Krb5Crypto", krb5_Methods);
	//m = Py_InitModule3("krb5", krb5_Methods, "krb5 wrapper");

	/*EncError = PyErr_NewException("Krb5Crypto.error", NULL, NULL);
	Py_IncRef(EncError);
	PyModule_AddObject(m, "error", EncError);*/

	/*Py_INCREF(&krb5_KeyBlockType);
	PyModule_AddObject(m, "KeyBlock", (PyObject*) &krb5_KeyBlockType);
	*/
	//if (PyErr_Occurred())
	//        PyErr_SetString(PyExc_ImportError, "kerberos: init failed");
}

