/*
**
** symbol.c
**
** Made by (Guillaume PELAT)
** Login   <pelat_g@epita.fr>
**
** System.map symbols loading.
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "symbol.h"

typedef struct      s_symbol
{
    char *  sym;
    void *  addr;
    char    type;
    struct s_symbol *fg;
    struct s_symbol *fd;
}                  t_symbol;

void    show_symbol(t_symbol *sym);

static t_symbol    *symbols = 0;

void    *get_symbol_addr(char *sym)
{
   t_symbol *s;
   
   if (!symbols)
    return 0;
   s = symbols;
   while (s)
   {
    int ret = strcmp(s->sym, sym);
    if (!ret)
    {
#ifdef DEBUG
    show_symbol(s);
#endif
        return s->addr;
    }
    else if (ret < 0)
        s = s->fg;
    else
        s = s->fd;
   }
   return 0;
}

char    *xstrdup(char *s)
{
    char *ptr = strdup(s);
    if (ptr)
        return ptr;
    printf("Memory Error\n");
    exit(2);    
}

void    *xmalloc(unsigned int size)
{
    void *ptr = malloc(size);
    if (ptr)
        return ptr;
    printf("Memory Error\n");
    exit(1);
}

struct s_symbol *new_symbol(char *sym, void *addr, char type)
{
    struct s_symbol *new = xmalloc(sizeof (struct s_symbol));
    new->sym = xstrdup(sym);
    new->addr = addr;
    new->type = type;
    new->fg = 0;
    new->fd = 0;
    return new;
}

void    free_symbol(t_symbol *sym)
{
    if (sym)
    {
        free(sym->sym);
        free(sym);
    }
}

void    show_symbol(t_symbol *sym)
{
    assert(sym != 0);
    printf("[%s] -> [%p]\n", sym->sym, sym->addr);
}

int    add_symbol(t_symbol *sym)
{
    t_symbol *s;
    int      ret;
    
    if (!symbols)
    {
        symbols = sym;
        return 0;
    }
    s = symbols;
   
    while (1)
    {
        if ((ret = strcmp(s->sym, sym->sym))) {
            if (ret < 0) {
                if (s->fg)
                    s = s->fg;
                else {
                    s->fg = sym;
                    return 0;
                }
            }
            else {
                if (s->fd)
                    s = s->fd;
                else {
                    s->fd = sym;
                    return 0;
                }
            }
        }
        else
            return 1;
    }
}

void    load_symbols(char *filename)
{
    FILE *f;
    char  buf[BUFSIZ];
    
    assert(filename != 0);
    f = fopen(filename, "r");
    if (!f)
    {
        printf("Cannot open file %s\n", filename);
        exit(1);
    }
    while (fgets(buf, sizeof buf, f))
    {
        char *addr;
        char *type;
        char *s;
        unsigned long   a;
        t_symbol    *sym;
        
        addr = strtok(buf, " ");
        if (!addr)
            continue;
        type = strtok(NULL, " ");
        if (!type)
            continue;
        s = strtok(NULL, "\n");
        if (!s)
            continue;
        a = strtoul(addr, 0, 16);
        if (!a)
            continue;
        sym = new_symbol(s, (void*)a, *type);
        if (add_symbol(sym) < 0)
            free_symbol(sym);
    }
}

#ifdef DEBUG
int main(int ac, char **av)
{
    if (ac < 2)
        return 1;
    load_symbols(av[1]);
    printf("%p\n", SYM("free_irq"));
    return 0;
}
#endif
