#include <netinet/in.h>

/* we keep all FTP state in this structure */
struct ftp_conn {
	int host;
	int sock;
	int data;

	int verbose;

	/* server reply code and an array containing each line */
	int reply_code;
	char* reply;
};

#define FTP_ASCII	1
#define FTP_BINARY	2

#define ISDIGIT(x) ((x >= 0x30) && (x <= 0x39))

/* FTP functions */

in_addr_t resolve_host(char* host);
struct ftp_conn* ftp_connect_host(in_addr_t host, int port, int verbose);
void ftp_close(struct ftp_conn* ftp);
int ftp_read_reply(struct ftp_conn* ftp);
void ftp_send_cmd(struct ftp_conn* ftp, char* format, ...);

void ftp_login(struct ftp_conn* ftp, char* username, char* password);
void ftp_cwd(struct ftp_conn* ftp, char* directory);
void ftp_del(struct ftp_conn* ftp, char* filename);
void ftp_put(struct ftp_conn* ftp, char* filename, int mode, unsigned char* buf, int len);
int ftp_get(struct ftp_conn* ftp, char* filename, int ascii, unsigned char** buf);

/* EOF */
