/*

Show_dump 0.1

    Copyright 2004 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

function to show the hex dump of a buffer

Usage:

    to show the hex dump on the screen:
        show_dump(buffer, buffer_length, stdout);

    to write the hex dump in a file or other streams:
        show_dump(buffer, buffer_length, fd);

    (if you know C you know what FILE *stream means 8-)
*/



void show_dump(unsigned char *buff, unsigned long buffsz, FILE *stream) {
    const char      *hex = "0123456789abcdef";
    unsigned char   buffout[68],
                    *pout,
                    *p1,
                    *p2,
                    i,
                    rest;


    p1 = buff;
    p2 = buff;

    while(buffsz) {

        pout = buffout;
        if(buffsz < 16) rest = buffsz;
            else rest = 16;

        for(i = 0; i < rest; i++, p1++) {
            *pout++ = hex[*p1 >> 4];
            *pout++ = hex[*p1 & 0xf];
            *pout++ = 0x20;
        }

        for(i = pout - buffout; i < 50; i++, pout++) *pout = 0x20;

        for(i = 0; i < rest; i++, p2++, pout++) {
            if(*p2 >= 0x20) *pout = *p2;
                else *pout = 0x2e;
        }

        *pout++ = 0x0a;
        *pout   = 0x00;

        fputs(buffout, stream);
        buffsz -= rest;
    }
}

