#ifndef _XIMAGE_H_
#define _XIMAGE_H_

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>

#define OUTFILE "evil"
#define BS 0x10000

#define bye(x) do{ fprintf(stderr, "%s\n", (x)); exit(EXIT_FAILURE); }while(0)
#define die(x) do{ perror((x)); exit(EXIT_FAILURE);}while(0)


/* a dlmalloc chunk descriptor */
#define CHUNKSZ sizeof(mchunk_t)
typedef struct _mchunk {
    size_t  prevsz;
    size_t  sz;
    long    fd;
    long    bk;
} mchunk_t;


/* a generic image exploit */
typedef struct _ximage_t {
    u_long  retaddr, retloc, buflen;
    u_char  *buf, *payload;
    char    *filename, *filetype;
    int     align;
    void    *priv;

    int     (*init)(struct _ximage_t *);
    int     (*clean)(struct _ximage_t *);
    int     (*set_payload)(struct _ximage_t *, u_char *);
    int     (*fill)(struct _ximage_t *);
    int     (*write)(struct _ximage_t *);
} ximage_t;


/* common functions */
ximage_t * ximage_parse_args(int, char **);
int ximage_write(ximage_t *);
int ximage_set_payload(ximage_t *, u_char *);


/* custom image type exploitation methods    */
int ximage_png_fill(ximage_t *);
int ximage_png_init(ximage_t *);
int ximage_png_clean(ximage_t *);

int ximage_pcx_fill(ximage_t *);
int ximage_pcx_init(ximage_t *);
int ximage_pcx_clean(ximage_t *);

int ximage_tiff_fill(ximage_t *);
int ximage_tiff_init(ximage_t *);
int ximage_tiff_clean(ximage_t *);

int ximage_mrf_fill(ximage_t *);
int ximage_mrf_init(ximage_t *);
int ximage_mrf_clean(ximage_t *);

int ximage_prf_fill(ximage_t *);
int ximage_prf_init(ximage_t *);
int ximage_prf_clean(ximage_t *);

int ximage_pnm_fill(ximage_t *);
int ximage_pnm_init(ximage_t *);
int ximage_pnm_clean(ximage_t *);

int ximage_gif_fill(ximage_t *);
int ximage_gif_init(ximage_t *);
int ximage_gif_clean(ximage_t *);

int ximage_other_gif_fill(ximage_t *);
int ximage_other_gif_init(ximage_t *);
int ximage_other_gif_clean(ximage_t *);

int ximage_xpm_fill(ximage_t *);
int ximage_xpm_init(ximage_t *);
int ximage_xpm_clean(ximage_t *);

int ximage_other_xpm_fill(ximage_t *);
int ximage_other_xpm_init(ximage_t *);
int ximage_other_xpm_clean(ximage_t *);

int ximage_bmp_fill(ximage_t *);
int ximage_bmp_init(ximage_t *);
int ximage_bmp_clean(ximage_t *);

/* heap manipulation */
u_long * get_chunks(int, long, long);

#endif
