import struct

class cstruct:
    '''
    Utility class used to easily encode C structs
    '''

    def __init__(self, decl):
        self.data = [(name, dtype, None) for name, dtype in decl]

    def __getitem__(self, key):
        for name,dtype,value in self.data:
            if name == key:
                return value
        raise AttributeError("No such key: %s" % key)

    def __setitem__(self, key, value):
        for idx, (name,dtype,_) in enumerate(self.data):
            if name == key:
                self.data[idx] = (name, dtype, value)
                return
        raise AttributeError("No such key: %s" % key)

    def encode(self, endianess=">"):
        return "".join([struct.pack(endianess + dtype, value) for (_,dtype,value) in self.data])

    def size(self):
        return sum([struct.calcsize(dtype) for (_,dtype,_) in self.data])
