#include <Windows.h>
#include <cstdio>

// For native 32-bit execution.
extern "C"
ULONG CDECL SystemCall32(DWORD ApiNumber, ...) {
  __asm{mov eax, ApiNumber};
  __asm{lea edx, ApiNumber + 4};
  __asm{int 0x2e};
}

VOID PrintHex(PBYTE Data, ULONG dwBytes) {
  for (ULONG i = 0; i < dwBytes; i += 16) {
    printf("%.8x: ", i);

    for (ULONG j = 0; j < 16; j++) {
      if (i + j < dwBytes) {
        printf("%.2x ", Data[i + j]);
      }
      else {
        printf("?? ");
      }
    }

    for (ULONG j = 0; j < 16; j++) {
      if (i + j < dwBytes && Data[i + j] >= 0x20 && Data[i + j] <= 0x7e) {
        printf("%c", Data[i + j]);
      }
      else {
        printf(".");
      }
    }

    printf("\n");
  }
}
  
int main() {
  // Windows 7 32-bit.
  CONST ULONG __NR_NtGdiEnumFonts = 0x108a;

  // Initialize thread as GUI.
  LoadLibrary(L"user32.dll");
  
  // Get the required buffer size.
  WCHAR FaceName[] = L"Consolas";
  DWORD BufferSize = 0;
  if (!SystemCall32(__NR_NtGdiEnumFonts, GetDC(NULL), 3, 0, wcslen(FaceName) + 1, FaceName, VIETNAMESE_CHARSET, &BufferSize, NULL)) {
    printf("NtGdiEnumFonts#1 failed.\n");
    return 1;
  }

  // Allocate memory for the output data and read it in full.
  LPVOID lpBuffer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, BufferSize);
  if (!SystemCall32(__NR_NtGdiEnumFonts, GetDC(NULL), 3, 0, wcslen(FaceName) + 1, FaceName, VIETNAMESE_CHARSET, &BufferSize, lpBuffer)) {
    printf("NtGdiEnumFonts#2 failed.\n");
    HeapFree(GetProcessHeap(), 0, lpBuffer);
    return 1;
  }

  // Dump the output data on screen and free resources.
  PrintHex((PBYTE)lpBuffer, BufferSize);
  HeapFree(GetProcessHeap(), 0, lpBuffer);

  return 0;
}
