/*
 * ccm
 * by lars kellogg-stedman <lars@larsshack.org>
 * and ken raeburn <raeburn@raeburn.org>
 *
 * $Id: ccmcmd.h,v 1.22 1999/05/02 14:05:14 lars Exp $
 *
 */

#ifndef _ccmcmd
#define _ccmcmd

#define start_sigint_handling	user_abort=0; trap(SIGINT, sigint_handler);
#define stop_sigint_handling	user_abort=0; trap(SIGINT, SIG_DFL);

#define show_current_target	show_target(current_target, current_target);

#define DEFAULT_COMMAND 	"help"
#define DEFAULT_TARGET		htonl(0xffffffff)
#define DEFAULT_TIMEOUT		5
#define DEFAULT_RETRIES		1

#define DEFAULT_SRC_PORT	7778
#define DEFAULT_DST_PORT	7777

#define SEPERATOR		" "
#define COMMAND_BUFFER_LENGTH	160
#define HEADER_LENGTH		16
#define TRANSID_LENGTH		4
#define PREFIX_LENGTH		sizeof(prefix)

#define SEND_PACKET_LENGTH	1500
#define RESPONSE_PACKET_LENGTH	1500

#define OPTSTRING "S:dhim:r:t:vVf:"

#define WHITESPACE		" 	\r\n"

/* command line options */

#define OPT_INTERACTIVE		'i'
#define OPT_FILE		'f'
#define OPT_VERBOSE		'v'
#define OPT_VERSION		'V'
#define OPT_MODEM		'm'
#define OPT_HELP		'h'
#define OPT_TIMEOUT		't'
#define OPT_RETRIES		'r'
#define OPT_DEBUG		'd'
#define OPT_SPOOF		'S'

/* exit codes */

#ifndef EX_OK
#define EX_OK			0
#endif /* EX_OK */

#define EX_ERROR		1
#define EX_USAGE		2
#define EX_BUG			3

/* status codes */

#define STATUS_OKAY		0
#define STATUS_SEND_FAILED	100
#define STATUS_SELECT_FAILED	101
#define	STATUS_RECEIVE_FAILED	102
#define STATUS_RETRIES_EXCEEDED	103

/* local commands */

#define COMMAND_CHAR	"/"
#define CMD_QUIT	"quit"
#define CMD_TARGET	"target"
#define CMD_HELP	"help"
#define CMD_REMOTEHELP	"remotehelp"
#define CMD_TIMEOUT	"timeout"
#define CMD_RETRIES	"retries"
#define CMD_NEXT	"next"
#define CMD_PREV	"prev"
#define CMD_LIST	"list"
#define CMD_APPLY	"apply"
#define CMD_VERBOSE	"verbose"
#define CMD_DEBUG	"debug"
#define CMD_VERSION	"version"
#define	CMD_DROP	"drop"
#define CMD_LOAD	"load"
#define CMD_MARK	"mark"
#define CMD_UNMARK	"unmark"
#define CMD_SPOOF	"spoof"

#ifndef INADDR_NONE
#define INADDR_NONE	(in_addr_t)-1
#endif

#ifndef TRUE
#define TRUE		1
#endif

#define	DO_NOT_QUIT	0
#define QUIT		1

#ifndef FALSE
#define FALSE		0
#endif

#define INTERACTIVE_BANNER "\
Client Cable Modem Interactive Client\n\
Lars Kellogg-Stedman <lars@larsshack.org> and\n\
Ken Raeburn <raeburn@raeburn.org>\n\
\n\
Type /help for a list of local commands.\n\
\n\
"

/*
 * TYPES AND WHATNOT
 */

/* a target is a single cable modem */
struct	_target {
	char	*	name;
	struct	in_addr	addr;
	int		last_status,
			id,
			deleted,
			marked;
	struct	_target *next;
	struct	_target *prev;
};

/* for providing target lists to commands */
struct _tlist {
	struct	_target	*t;
	struct	_tlist	*next;
};

/* for generating help and completions for readline */
struct _command {
	char	*	name;
	char	*	description;
};

/* received header format */
struct _recv_header {
	ccm_int32_t	transid;		/* 0 - 3	*/
	ccm_int8_t	fragments_follow;	/* 4		*/
	ccm_int8_t	sequence;		/* 5		*/
	ccm_int16_t	status;			/* 6 - 7 	*/
	ccm_int16_t	length;			/* 8 - 9	*/
};

/* sent header format.  someone fill in the missing parts, please! */
struct _send_header {
	ccm_int32_t	transid;	/* 0 - 3	*/
	ccm_int8_t	unknown_1[7];	/* 4 - 10	*/
	ccm_int8_t	sequence;	/* 11		*/
	ccm_int8_t	unknown_2[8];	/* 12 - 19	*/
	ccm_int16_t	length;		/* 20 - 21	*/
	ccm_int8_t	unknown_3[6];	/* 22 - 27	*/
};

/*
 * PROTOTYPES
 */

int main (int argc, char *argv[]);
void ccm_shell(void);

void show_usage(FILE *);
void show_version(void);

char *build_command(int argc, char *argv[]);
int parse_command(char *cmd, int (*handle_command)(int, char *[], struct _target *), struct _target *ct);
int handle_remote_command(int, char *[], struct _target *t);
int handle_local_command(int, char *[], struct _target *);
int dispatch (char *);

void show_target(struct _target *, struct _target *);
struct _target *add_target(struct in_addr, char *name);
struct _target *pick_target(int);
void delete_target(struct _target *);
void delete_many_targets(int, int);

int process_file (char *);
void initialize_globals(int argc, char *argv[]);
void sigint_handler(int);
int resolve_address(char *, struct in_addr *);
void hexdump(unsigned char *, int);
char *status_to_string(int s);

int is_all_whitespace(char *text, int len);
int is_all_numbers(char *text, int len);

struct _target *find_first_undeleted(void);
struct _target *find_next_undeleted(struct _target *);
struct _target *find_prev_undeleted(struct _target *);

void add_to_list(struct _tlist **, struct _target *);
struct _tlist *build_list(int argc, char *argv[]);


#ifdef HAVE_LIBREADLINE
char *local_command_completion_function(char *text, int state);
char *remote_command_completion_function(char *text, int state);
char **local_or_remote_completion(char *text, int start, int end);
#endif /* HAVE_LIBREADLINE */

#endif /* _ccmcmd */

