/*
 * ccm
 * Lars Kellogg-Stedman <lars@larsshack.org>
 * Ken Raeburn <raeburn@raeburn.org>
 *
 * $Id: trap.c,v 1.3 1999/08/31 21:15:48 lars Exp $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>

#include <trap.h>

/*
 * Like sh's 'trap' command -- a simple way to
 * assign a function to a signal.
 */
void	trap(int sig, void (*signal_handler)(int))
{
	struct	sigaction	act;
				
	sigemptyset(&act.sa_mask);
	act.sa_flags=0;
	act.sa_handler=signal_handler;

	/*
	 * If we can't set the signal action, print
	 * an error without exiting.
	 */
	if (sigaction(sig,&act,NULL) < 0)
		print_err("sigaction failed: %s", strerror(errno));
}

