#! /usr/bin/python2

import base64
import cherrypy
import hashlib
import os
import sys

hostname = sys.argv[1]

index = '''<!doctype HTML>
<html>
  <head>
    <title>SDCH test</title>
  </head>
  <body>
    <h3>Hello there!</h3>
    <iframe src='/sdch'></iframe>
  </body>
</html>'''

with open('dictionary', 'rb') as tmp:
  dictionary_payload = tmp.read()

with open('delta', 'rb') as tmp:
  delta_payload = tmp.read()

dictionary_headers = 'Domain: {}\n'.format(hostname)
dictionary_headers += 'Path: /sdch\n'
dictionary_headers += '\n'

dictionary = dictionary_headers + dictionary_payload

dictionary_hash = hashlib.sha256()
dictionary_hash.update(dictionary)
dictionary_hash = dictionary_hash.digest()

client_id = base64.urlsafe_b64encode(dictionary_hash[:6])
server_id = base64.urlsafe_b64encode(dictionary_hash[6:12])

def gzip(data):
  print data
  print data.encode('hex')
  with open('tmp', 'wb') as tmp:
    tmp.write(data)
  os.system('gzip tmp')
  with open('tmp.gz', 'rb') as tmp:
    data = tmp.read()
  os.system('rm tmp.gz')
  return data
  
class PocServer(object):
  
  def no_cache(self):
    cherrypy.response.headers['Cache-Control'] = 'no-store'

  @cherrypy.expose
  def index(self):
    self.no_cache()
    if 'sdch' in cherrypy.request.headers['Accept-Encoding']:
      cherrypy.response.headers['Get-Dictionary'] = '/dictionary'
      cherrypy.response.headers['X-Sdch-Encode'] = '0'
      return index
    else:
      raise cherrypy.HTTPError(status=500, message='SDCH not supported by user-agent!')
  
  @cherrypy.expose
  def sdch(self):
    self.no_cache()
    cherrypy.response.headers['Content-Type'] = 'text/html'
    if 'Avail-Dictionary' in cherrypy.request.headers:
      cherrypy.response.headers['Content-Encoding'] = 'sdch,gzip'
      return gzip(server_id + '\x00' + delta_payload)
    else:
      cherrypy.response.headers['X-Sdch-Encode'] = '0'
      return '<html><pre>:-(</pre></html>'

  @cherrypy.expose
  def dictionary(self):
    cherrypy.response.headers['Cache-Control'] = 'max-age=10000'
    cherrypy.response.headers['Content-Type'] = 'application/x-sdch-dictionary'
    return dictionary

def main():
  cherrypy.config.update({'server.socket_port':80, 'server.socket_host':'0.0.0.0'})
  cherrypy.quickstart(PocServer())

if __name__ == '__main__':
  main()
