// HijackDll.cpp : Defines the exported functions for the DLL application.
//

#include "stdafx.h"
#include <string>
#include <map>
#include <Shlwapi.h>
#include "ScopedHandle.h"

#pragma comment(lib, "shlwapi.lib")

static int operator<(REFCLSID left, REFCLSID right)
{
    return memcmp(&left, &right, sizeof(CLSID));
}

static std::map<CLSID, LPFNGETCLASSOBJECT> g_clsid_to_func;

static std::wstring GuidToString(REFGUID rguid)
{
    std::wstring ret;
    LPOLESTR guid_str;
    if (SUCCEEDED(StringFromIID(rguid, &guid_str)))
    {
        ret = guid_str;
        CoTaskMemFree(guid_str);
    }
    return ret;
}

static std::wstring GetInProcServer(REFCLSID rclsid)
{
    std::wstring path = L"Software\\Classes\\CLSID\\" + GuidToString(rclsid) + L"\\InprocServer32";
    WCHAR buffer[MAX_PATH];
    DWORD size = sizeof(buffer);

    LSTATUS status = RegGetValue(HKEY_LOCAL_MACHINE, path.c_str(), nullptr, 
        RRF_RT_REG_EXPAND_SZ | RRF_RT_REG_SZ, nullptr, buffer, &size);
    if (status != ERROR_SUCCESS)
    {
        return L"";
    }

    return buffer;
}

static LPFNGETCLASSOBJECT LoadInProcDll(REFCLSID rclsid)
{
    auto dll = GetInProcServer(rclsid);
    if (dll.empty())
    {
        return nullptr;
    }

    HMODULE mod = LoadLibrary(dll.c_str());
    if (!mod)
    {
        return nullptr;
    }
    return reinterpret_cast<LPFNGETCLASSOBJECT>(GetProcAddress(mod, "DllGetClassObject"));
}

static bool IsInVMX()
{
    WCHAR buffer[MAX_PATH];
    DWORD size = MAX_PATH;

    if (!QueryFullProcessImageName(GetCurrentProcess(), 0, buffer, &size))
    {
        return false;
    }

    PathStripPath(buffer);
    return _wcsicmp(buffer, L"vmware-vmx.exe") == 0;
}

LPFNGETCLASSOBJECT GetDllGetClassObject(REFCLSID rclsid)
{
    auto it = g_clsid_to_func.find(rclsid);
    if (it == g_clsid_to_func.end())
    {
        LPFNGETCLASSOBJECT func = LoadInProcDll(rclsid);
        if (func == nullptr)
        {
            if (IsInVMX())
            {
                std::wstring msg = L"Didn't find DllGetClassObject for " + GuidToString(rclsid);
                MessageBox(nullptr, msg.c_str(), L"Error", MB_OK | MB_ICONERROR);
            }
            return nullptr;
        }
        else
        {
            if (IsInVMX())
            {
                std::wstring msg = L"Found DllGetClassObject for " + GuidToString(rclsid);
                MessageBox(nullptr, msg.c_str(), L"Success", MB_OK | MB_ICONINFORMATION);
            }
            g_clsid_to_func[rclsid] = func;
        }
    }
    return g_clsid_to_func[rclsid];
}