#include <fcntl.h>
#include <stdio.h>
#include <sys/syscall.h>
#include <unistd.h>
#include <err.h>
#include <stdint.h>

/* ===== COPIED FROM stackshot.h ===== */
#define STACKSHOT_CONFIG_TYPE 1

typedef struct stackshot_config {
	/* Input options */
	int		sc_pid;			/* PID to trace, or -1 for the entire system */
	uint32_t	sc_flags;		/* Stackshot flags */
	uint64_t	sc_since_timestamp;	/* Get traces of threads that have run since this time (NOT YET SUPPORTED) */

	/* Stackshot results */
	uint64_t	sc_buffer;		/* Pointer to stackshot buffer */
	uint32_t	sc_size;		/* Length of the stackshot buffer */

	/* Internals */
	uint64_t	sc_out_buffer_addr;	/* Location where the kernel should copy the address of the newly mapped buffer in user space */
	uint64_t	sc_out_size_addr;	/* Location where the kernel should copy the size of the stackshot buffer */
} stackshot_config_t;
/* =================================== */

#define STACKSHOT_KCDATA_FORMAT 0x10000

int main(void) {
  #define OUTSIZE (1024*1024*50)
  char *out = NULL;
  uint32_t out_len = 0;
  stackshot_config_t conf = {
    .sc_pid = -1,
    .sc_flags = STACKSHOT_KCDATA_FORMAT,
    .sc_since_timestamp = 0,
    .sc_out_buffer_addr = (uint64_t)&out,
    .sc_out_size_addr = (uint64_t)&out_len
  };
  int res = syscall(SYS_stack_snapshot_with_config, STACKSHOT_CONFIG_TYPE, &conf, sizeof(conf));
  if (res == -1)
    err(1, "stack snapshot");
  printf("got stackshot, %u bytes\n", out_len);

  int fd = open("stackshot_data.bin", O_WRONLY|O_CREAT|O_TRUNC, 0644);
  if (fd == -1)
    err(1, "open");
  if (write(fd, out, out_len) != out_len)
    errx(1, "write failed");
}
