#include <stdio.h>
#include <stdarg.h>
#include <errno.h>

static char buf[512];

void error(const char *fmt, ...)
{
    char *p;
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, BUFSIZ - 1, fmt, ap);
    va_end(ap);

    p = buf;
    while ((p = (char *)strpbrk(++p, "\n\r")))
        *p = ' ';
    fprintf(stderr, "%s\n", buf);
}

void error_die(const char *fmt, ...)
{
    char *p;
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, BUFSIZ - 1, fmt, ap);
    va_end(ap);

    p = buf;
    while ((p = (char *)strpbrk(++p, "\n\r")))
        *p = ' ';
    fprintf(stderr, "%s\n", buf);
    exit(1);
}

void error_errno(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, BUFSIZ - 1, fmt, ap);
    va_end(ap);

    fprintf(stderr, "%s: %s\n", buf, strerror(errno));
}
