
NSData* data = [NSData dataWithContentsOfFile:pathToImage];
if (!data) {
    NSLog(@"Failed to load image data");
    return;
}

UIImage* img = [UIImage imageWithData:data];
if (!img) {
    NSLog(@"Failed to create UIImage");
    return;
}
CGImageRef cgImg = [img CGImage];
if (!cgImg) {
    NSLog(@"Failed to create CGImagge");
    return;
}

size_t width = CGImageGetWidth(cgImg);
size_t height = CGImageGetHeight(cgImg);
NSLog(@"width: %lu height: %lu", width, height);
CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
CGContextRef ctx = CGBitmapContextCreate(0, width, height, 8, 0, colorspace, 1);
CGRect rect = CGRectMake(0, 0, width, height);

CGContextDrawImage(ctx, rect, cgImg);

CGColorSpaceRelease(colorspace);
CGContextRelease(ctx);
CGImageRelease(cgImg);

