// Compile with clang -o tester tester.m -framework Foundation -fsanitize=address -framework CoreGraphics -framework AppKit
#include <Foundation/Foundation.h>
#include <Foundation/NSURL.h>
#include <dlfcn.h>
#include <stdint.h>
#include <sys/shm.h>
#include <dirent.h>

#import <Cocoa/Cocoa.h>
#import <ImageIO/ImageIO.h>

int main(int argc, const char * argv[]) {
    if (argc < 2) {
        printf("Usage: %s path/to/image\n", argv[0]);
        return 0;
    }

    NSString* path = [NSString stringWithUTF8String:argv[1]];
    NSData* content = [NSData dataWithContentsOfFile:path];
    NSImage* img = [[NSImage alloc] initWithData:content];
    NSLog(@"Image @ %p: %@\n", img, img);

    CGImageRef cgImg = [img CGImageForProposedRect:nil context:nil hints:nil];
    if (cgImg) {
        size_t width = CGImageGetWidth(cgImg);
        size_t height = CGImageGetHeight(cgImg);
        CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
        CGContextRef ctx = CGBitmapContextCreate(0, width, height, 8, 0, colorspace, 1);
        CGRect rect = CGRectMake(0, 0, width, height);
        CGContextDrawImage(ctx, rect, cgImg);

        CGColorSpaceRelease(colorspace);
        CGContextRelease(ctx);
        CGImageRelease(cgImg);
    }


    [img release];
    [content release];
    [path release];

    return 0;
}
